///	\file	DirMcd.h
///	\brief	DirMcd.h
#ifndef DirMCD_H__
#define DirMCD_H__

#include <string>

#include "define.h"
#include "exception.h"
#include "Mcd.h"
#include "action.h"

namespace MLS {
	///	\brief	DirMcd class
	class DirMcd : public Mcd
	{
		protected:
			bool 	_bHidden;
			int		Rescan(int = 0);
			int		Scan(dir *, int = 1);
			int		DrawEtc(void);
			void	Help();
			int		McdExecute(int nKey);
			void	SetHidden(bool bHidden) { _bHidden = bHidden; }

			void	ViewDirInfo();
		
			std::string m_McdRoot; 
			Action      m_McdFunc[12];
			
		public:
			DirMcd(string = "", const char * = "MCD - Mls Change Directory");
			~DirMcd();
			
			// IConfigurable			
			void    UpdateConfig();
			void    SaveConfig();
		
			int		AddDirectory(const std::string &);
	};
	
}; // namespace

#endif //DirMCD_H__
