///	\file	StringTokenizer.cpp
///	\brief	문자열 분쇄기 소스
#include "StringTokenizer.h"

using namespace std;
using namespace MLS;

///	\brief	생성자
StringTokenizer::StringTokenizer()
	: _delim("\r\n "), _cur(0)
{
}

///	\brief	생성자
///	\param	p		분쇄 대상 문자열
///	\param	d		분쇄할 때 기준이 되는 문자(예. /etc/passwd 를 분쇄할때 ':')
StringTokenizer::StringTokenizer(const string &p, const string &d)
	: _str(p), _delim(d), _cur(0)
{
}

///	\brief	소멸자
StringTokenizer::~StringTokenizer()
{
}

///	\brief	분쇄된 다음 문자열로 이동한다.
///	\return	성공여부
bool StringTokenizer::Next()
{
	// _delim = "a";
	//         0123456789
	// _str = "laneapple";
	//         ss2

	// . 범위가 벗어나면 끝냄
	if (_cur == string::npos) return false;

	// . 기준문자('a') 위치다음를 찾음
	string::size_type s = _str.find_first_not_of(_delim, _cur);

	// . 기준문자('a')가 없으면 끝냄
	if (s == string::npos) return false;

	// . 다음 문자열 위치를 구함
	_cur = _str.find_first_of(_delim, s+1);

	// . 다음 문자열이 없다면 문자끝까지 분쇄문자열로 정함
	if (_cur == string::npos)
		_token = _str.substr(s);
	// . 다음 문자열이 있다면 다음 문자열 전까지 분쇄함
	else
		_token = _str.substr(s, _cur-s);
	
	return true;	
}
