///	\file	action.h		
///	\brief	action.h
#ifndef action_h_
#define action_h_

#include <string>
#include <vector>

namespace MLS {

///	\brief	Action class
class Action
{
protected:
	std::string name;				///< 화면에 출력할 펑선키 명령 name
	std::vector<std::string> cmd;	///< 명령 vector
	
	std::string nocmd;				///< command가 없음에 해당되는 쓸모없는 변수
	
public:

	///	\brief	생성자
	Action(){}
	
	///	\brief	명령어 개수를 알아내는 함수
	///	\return	저장된 명령어 개수
	unsigned int  size() {return cmd.size();}	

	///	\brief	엔트리 추가 함수
	///	\param	추가할 엔트리 
	void addEntry(const std::string &);

	///	\brief	명령어를 추가한다.
	///	\param	c	추가할 명령어
	void addCommand(std::string c) {cmd.push_back(c);}

	///	\brief	명령어를 모두 제거한다.
	void clear() {cmd.clear();}

	///	\brief	화면에 출력할 명령어 이름을 바꾼다.
	void setName(std::string &a) {name=a;}
	
	///	\brief	[] 연산자 제정의
	///	\param	t	index
	///	\return	명령어 이름
	std::string &operator [](unsigned int t){if (cmd.size() > t) return cmd[t]; return nocmd;}
	
	///	\brief	getname
	///	\return	name
	const char *getName() {if (cmd.empty()) return " "; return name.c_str();}

	///	\brief	getCmd
	///	\return	cmd 1번째 것만 가져간다.
	std::string GetCmd()
	{
		if (cmd.size() != 0) 
			return cmd[0];
		else 
			return nocmd;
	}
};
	
}; // namespace 

#endif // action
