#ifndef MLSCOLORSET_H
#define MLSCOLORSET_H

#include <map>
#include <string>
#include "drawutil.h"

using namespace std;

namespace MLS {

class ColorSet
{
	ColorSet();
	~ColorSet();
	
public:	
	static ColorSet &GetInstance();
	
	bool      Init();
	bool      Load(const char *);

	string    _sVersion;
	
	ColorEntry
		MCD,
		MCDLine,
		MCDstat,
		Dir,
		Drive,
		Line,
		Func,
		FuncA,
		Stat,
		StatA,
		Help,
		QCD,
		Dialog,
		Default,
		Back,
		MEdit,
		MEditInfo,
		MEditInfoA;
	
	std::map<std::string, ColorEntry> mapName;
	std::map<std::string, ColorEntry> mapExt;
	std::map<int, ColorEntry> mapMask;
};

#define g_Color ColorSet::GetInstance()

};

#endif
