/// @file	dialog.h
/// @brief	dialog.h
#ifndef dialog_h__
#define dialog_h__

#include "define.h"
#include <ncurses.h>
#include <string>
#include <vector>

///	@brief	MLS namespace
namespace MLS {

enum {
	YN_Y,	///< Yes
	YN_N	///< No
};

int MsgBox(int color, const char *title, const char *msg,...);
int MsgBox(const char *title, const char *msg, int color=COLOR_RED);
WINDOW*  MsgWaitBox(const char *title, const char *msg, int back_color = COLOR_RED);
int MsgWaitEnd(WINDOW*	win);
int InputBox(const char *title, std::string &str, int color=COLOR_MAGENTA);
int YNBox(const char *title,int YN, int back_color=COLOR_CYAN);

int SelectBox(const char *title, std::vector<std::string> &, int n, int back_color=COLOR_MAGENTA);

class FormWindow
{
	WINDOW *_win;
	bool _shutdown;

protected:
	std::string _title;
	bool _confirm;

	int  _backColor;
	int  _width;
	int  _height;

	virtual void Draw(WINDOW *);
	virtual void Proc(int key) = 0;

	void Shutdown(bool confirm);

public:
	FormWindow(const char *title, int backColor);
	void SetBackColor(int color);
	void SetWidth(int width);
	void SetHeight(int height);
	WINDOW*	GetWindow();

	int  Do();
};

class ListBox : public FormWindow
{
protected:
	std::vector<std::string> _item;
	int  _sel;

	void Draw(WINDOW *);
	void Proc(int key);
	void CalcWidth();

public:
	ListBox(const char *title, int n = 0, int backColor = COLOR_BLUE);
	ListBox(const char *title, int n, int backColor, std::vector<std::string> &);

	void SetItem(std::vector<std::string> &);
	void SetMinWidth(int width);
	void SetDefault(int t);

	int Do();
};

class CheckBox: public FormWindow
{
protected:
	std::vector<std::string> _item;
	std::vector<bool> 	_vCheckItem;
	int  				_sel;
	bool				_bYN;

	void Draw(WINDOW *);
	void Proc(int key);
	void CalcWidth();

public:
	CheckBox(const char* title, int n = 0, int backcolor = COLOR_BLUE);

	void	SetItem(	std::vector<std::string>	&s,
					std::vector<bool>		&vCheckItem);

	void SetMinWidth(int width);
	void SetDefault(int t);

	vector<bool>	Do();
};

///	@brief	 텍스트 박스
class TextBox : public FormWindow
{
protected:
	std::vector<std::string> _text;
	std::string				 _file; // 현재 파일이름
	int		_nCul;		// 현재 가로 위치
	int		_nFirstLine;	// 현재 화면의 처음 위치
	int		_nLastLine;		// 현재 화면의 마지막 위치
	int		_nViewSel;  // 보이는 위치
	int		_nCulLimit;	// 스트링 가로 한계
	int		_nTabSize;
	bool	_bNextLineView; // 한줄넘김 보일지?
	bool	_bLineNumView; // 라인 보이게 것인지?
	int		_nFontColor;
	
	void Draw(WINDOW *);
	void Proc(int key);
	void CalcWidth();

public:
	TextBox(const char * title);
	TextBox(const char * title, int height, int width, int backColor = COLOR_BLUE);

	bool Load(const char* file, int nTabSize = 8);
	void SetText(std::vector<std::string> &s);
	void SetMinWidth(int width);
	void SetFontColor(int nColor) { _nFontColor = nColor; }
	
	int Do(bool bLineNumView = false, bool bNextLineView = false);
};

///	@brief	 상태출력 박스
class ProgressBox
{
protected:
	WINDOW *win;		///< 상태를 출력할 window
	const char *title,	///< title message
		  		*msg;	///<  Message
	int back_color;		///< 배경 색상

	std::string sLeftString, sRightString;
	int m_nCounter;  		///< 카운터 60 기준

public:
	ProgressBox(const char *_title, const char *_msg, int back_color=COLOR_MAGENTA);
	~ProgressBox();

	void setLeftStr(const char *p)  { sLeftString=p; }
	void setRightStr(const char *p) { sRightString=p; }

	void show();
	void redraw();

	void setCount(int nCount);
};

///	@brief	 상태출력 박스
class StatBox
{
protected:
	WINDOW *win;		///< 상태를 출력할 window
	const char *title,	///< title message
		  		*msg;	///<  Message
	int back_color;		///< 배경 색상

	const char *UL, *UR, *BL, *BR;
	int U, B;  	// 60 기준

public:
	StatBox(const char *,const char *, int back_color=COLOR_MAGENTA);
	~StatBox();

	void setUL(const char *p){UL=p;}
	void setUR(const char *p){UR=p;}
	void setBL(const char *p){BL=p;}
	void setBR(const char *p){BR=p;}

	void setU(int p){U=p; if (U<0) U=0; if (U>60) U=60;}
	void setB(int p){B=p; if (B<0) B=0; if (B>60) B=60;}

	void show();
	void redraw();
};

}; // namespace

#endif//dialog_h__
