///	\file	file.h
///	\brief	file.h
#ifndef file_h_
#define file_h_

#include "define.h"
#include "drawutil.h"

namespace MLS {
	
///	\brief	File class
class File
{
	public:
		std::string name;		///< 화면에 보여줄 file name 
		
		std::string FullName;	///< Full File Name
		std::string TarFullName;///< tar 파일의 Full File Name (TargzUtil 에서만 쓰임)
		
		char date[9];			///< 날짜
		char time[6];			///< time
		char attr[11];			///< 파일 속성 drwxrwxrwx
		uint size;				///< 파일 size
		bool selected;			///< 선택 여부
		
		time_t mtime;			///< 최근 접근 시간?
		
		ColorEntry *color;		///< 화면에 출력될 파일 색상
		
		bool bDir;				///< directory 여부
		
		/// \brief	파일 확장자를 알아내는 함수
		///	\return	파일의 확장자
		std::string ext()
		{
			std::string::size_type p= name.rfind(".");
			if (p == std::string::npos || p==0) 
				return "";
			return name.substr(p+1);		
		}
		
		///	\brief	생성자
		File()
		{
			memset(&date, 0, sizeof(date));
			memset(&time, 0, sizeof(time));
			memset(&attr, 0, sizeof(attr));
		}
		
		///	\brief	File 정보 초기화
		void clear(void)
		{
			memset(&date, 0, sizeof(date));
			memset(&time, 0, sizeof(time));
			memset(&attr, 0, sizeof(attr));
			size = 0;
			selected = false;
			mtime = 0;
			color = NULL;
			bDir = false;
		}
};

}; // namespace

#endif 
