/// @file	mlslocale.h
/// @brief	locale 설정 관련 소스
/// @author 
/// @date 2004-08-21

#ifndef LOCALE_H__
#define LOCALE_H__

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef _ICONV_USE
#include <iconv.h>
#endif
#include <errno.h>
#include <stdlib.h>
#include <string.h>
#include <ncurses.h>
#include <locale.h>
#include <string>
#include <pwd.h>
#include <sys/types.h>
#include <libintl.h>

// 패치용 주석처리
#ifndef ICONV_CONST
    #define ICONV_CONST
#endif

#include "define.h"
#include "strutil.h"

using namespace std;

namespace MLS
{
	extern chtype HLINE;
	extern chtype VLINE;
	extern chtype ULCORNER;
	extern chtype LLCORNER;
	extern chtype URCORNER;
	extern chtype LRCORNER;
	extern chtype LTEE;
	extern chtype RTEE;
	extern chtype BTEE;
	extern chtype TTEE;
	
	/// @brief	locale language enum
	enum ENCODING {
		KO_EUCKR,	///< korean Language - EUC-KR
		KO_UTF8,	///< korean Language - UTF-8
		US,			///< USA Language
		AUTO		///< AUTO 자동으로 바꿔준다.
	};
	
	/// @brief	Line Code
	enum LINECODE { CHARLINE, ACSLINE };

	extern ENCODING	e_nCurLang; // 현재 시스템의 language 를 세팅한다.
	extern ENCODING	e_nBefLang; 
	
	extern LINECODE e_nBoxLineCode;
	
	void Set_Locale(ENCODING e);
	void Set_Line(MLS::LINECODE nCode);

	#ifdef _ICONV_USE	
	char* code_convert(const char *str, 
						const char *to_codeset, 
						const char *from_codeset);
	#endif
	
	string CodeConvert(const string& sSource, const char *to_codeset, const char *from_codeset);
	
	/*
	string 		CodeConvert(const string& orig, 
							const char * const toCodeset,
							const char * const fromCodeset);
	*/
	string 		ChgEngKor(const string& sEnglish, const string& sKorean);
	string 		isKorCode(const string& sSrc, MLS::ENCODING* eEncode = NULL);
};

#endif//LOCALE_H__
