///	@file	strutil.h
///	@brief	strutil.h
#ifndef STRUTIL_H__
#define STRUTIL_H__

#include <stdio.h>
#include <string>

# if (__GNUC__ * 1000 + __GNUC_MINOR__) < 3000
    #include <wchar.h>
    #include <wctype.h>
    typedef basic_string <wchar_t> wstring;
# endif

///	@brief	string 유틸리티
namespace strutil
{
using namespace std;

string tolower(const string &p);
string toupper(const string &p);
string chop(const string &p);
string getbetween(const string &p, const char f, const char r);
string Replace(const string &p, const char*find, const char*replace);
string toregular(unsigned int number);
string itoa(int number);
string addslash(const string &p);
string krstrncpy(	const string &sSrc, int nPoint, int nLength);
int    krstrlen(const string &sStr);
string strmid(int nLength, const string &sStr);

wstring strtowstr(const string& s);
string	wstrtostr(const wstring& s);
int		wstrlen(const wstring& s);

inline string itoa(int number)
{
	char buf[20];
	snprintf(buf, 20, "%d", number);
	return buf;
}

}

#endif//STRUTIL_H__
