/**********************************************************************
 *
 * Copyright(c) 2008 Imagination Technologies Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful but, except
 * as otherwise stated in writing, without any warranty; without even the
 * implied warranty of merchantability or fitness for a particular purpose.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * The full GNU General Public License is included in this distribution in
 * the file called "COPYING".
 *
 * Contact Information:
 * Imagination Technologies Ltd. <gpl-support@imgtec.com>
 * Home Park Estate, Kings Langley, Herts, WD4 8LZ, UK
 *
 ******************************************************************************/

#ifndef __PVR_BRIDGE_H__
#define __PVR_BRIDGE_H__


#include "servicesint.h"


#include <linux/ioctl.h>

#define PVRSRV_IOC_GID      'g'
#define PVRSRV_IO(INDEX) \
	_IO(PVRSRV_IOC_GID, INDEX, struct PVRSRV_BRIDGE_PACKAGE)
#define PVRSRV_IOW(INDEX) \
	_IOW(PVRSRV_IOC_GID, INDEX, struct PVRSRV_BRIDGE_PACKAGE)
#define PVRSRV_IOR(INDEX) \
	_IOR(PVRSRV_IOC_GID, INDEX, struct PVRSRV_BRIDGE_PACKAGE)
#define PVRSRV_IOWR(INDEX) \
	_IOWR(PVRSRV_IOC_GID, INDEX, struct PVRSRV_BRIDGE_PACKAGE)


#define PVRSRV_BRIDGE_CORE_CMD_FIRST				0
#define PVRSRV_BRIDGE_ENUM_DEVICES				\
		PVRSRV_IOWR(PVRSRV_BRIDGE_CORE_CMD_FIRST+0)
#define PVRSRV_BRIDGE_ACQUIRE_DEVICEINFO			\
		PVRSRV_IOWR(PVRSRV_BRIDGE_CORE_CMD_FIRST+1)
#define PVRSRV_BRIDGE_RELEASE_DEVICEINFO			\
		PVRSRV_IOWR(PVRSRV_BRIDGE_CORE_CMD_FIRST+2)
#define PVRSRV_BRIDGE_CREATE_DEVMEMCONTEXT			\
		PVRSRV_IOWR(PVRSRV_BRIDGE_CORE_CMD_FIRST+3)
#define PVRSRV_BRIDGE_DESTROY_DEVMEMCONTEXT			\
		PVRSRV_IOWR(PVRSRV_BRIDGE_CORE_CMD_FIRST+4)
#define PVRSRV_BRIDGE_GET_DEVMEM_HEAPINFO			\
		PVRSRV_IOWR(PVRSRV_BRIDGE_CORE_CMD_FIRST+5)
#define PVRSRV_BRIDGE_ALLOC_DEVICEMEM				\
		PVRSRV_IOWR(PVRSRV_BRIDGE_CORE_CMD_FIRST+6)
#define PVRSRV_BRIDGE_FREE_DEVICEMEM				\
		PVRSRV_IOWR(PVRSRV_BRIDGE_CORE_CMD_FIRST+7)
#define PVRSRV_BRIDGE_GETFREE_DEVICEMEM				\
		PVRSRV_IOWR(PVRSRV_BRIDGE_CORE_CMD_FIRST+8)
#define PVRSRV_BRIDGE_CREATE_COMMANDQUEUE			\
		PVRSRV_IOWR(PVRSRV_BRIDGE_CORE_CMD_FIRST+9)
#define PVRSRV_BRIDGE_DESTROY_COMMANDQUEUE			\
		PVRSRV_IOWR(PVRSRV_BRIDGE_CORE_CMD_FIRST+10)
#define	PVRSRV_BRIDGE_MHANDLE_TO_MMAP_DATA			\
		PVRSRV_IOWR(PVRSRV_BRIDGE_CORE_CMD_FIRST+11)
#define PVRSRV_BRIDGE_CONNECT_SERVICES				\
		PVRSRV_IOWR(PVRSRV_BRIDGE_CORE_CMD_FIRST+12)
#define PVRSRV_BRIDGE_DISCONNECT_SERVICES			\
		PVRSRV_IOWR(PVRSRV_BRIDGE_CORE_CMD_FIRST+13)
#define PVRSRV_BRIDGE_WRAP_DEVICE_MEM				\
		PVRSRV_IOWR(PVRSRV_BRIDGE_CORE_CMD_FIRST+14)
#define PVRSRV_BRIDGE_GET_DEVICEMEMINFO				\
		PVRSRV_IOWR(PVRSRV_BRIDGE_CORE_CMD_FIRST+15)
#define PVRSRV_BRIDGE_RESERVE_DEV_VIRTMEM			\
		PVRSRV_IOWR(PVRSRV_BRIDGE_CORE_CMD_FIRST+16)
#define PVRSRV_BRIDGE_FREE_DEV_VIRTMEM				\
		PVRSRV_IOWR(PVRSRV_BRIDGE_CORE_CMD_FIRST+17)
#define PVRSRV_BRIDGE_MAP_EXT_MEMORY				\
		PVRSRV_IOWR(PVRSRV_BRIDGE_CORE_CMD_FIRST+18)
#define PVRSRV_BRIDGE_UNMAP_EXT_MEMORY				\
		PVRSRV_IOWR(PVRSRV_BRIDGE_CORE_CMD_FIRST+19)
#define PVRSRV_BRIDGE_MAP_DEV_MEMORY				\
		PVRSRV_IOWR(PVRSRV_BRIDGE_CORE_CMD_FIRST+20)
#define PVRSRV_BRIDGE_UNMAP_DEV_MEMORY				\
		PVRSRV_IOWR(PVRSRV_BRIDGE_CORE_CMD_FIRST+21)
#define PVRSRV_BRIDGE_MAP_DEVICECLASS_MEMORY			\
		PVRSRV_IOWR(PVRSRV_BRIDGE_CORE_CMD_FIRST+22)
#define PVRSRV_BRIDGE_UNMAP_DEVICECLASS_MEMORY			\
		PVRSRV_IOWR(PVRSRV_BRIDGE_CORE_CMD_FIRST+23)
#define PVRSRV_BRIDGE_MAP_MEM_INFO_TO_USER			\
		PVRSRV_IOWR(PVRSRV_BRIDGE_CORE_CMD_FIRST+24)
#define PVRSRV_BRIDGE_UNMAP_MEM_INFO_FROM_USER			\
		PVRSRV_IOWR(PVRSRV_BRIDGE_CORE_CMD_FIRST+25)
#define PVRSRV_BRIDGE_EXPORT_DEVICEMEM				\
		PVRSRV_IOWR(PVRSRV_BRIDGE_CORE_CMD_FIRST+26)
#define PVRSRV_BRIDGE_RELEASE_MMAP_DATA				\
		PVRSRV_IOWR(PVRSRV_BRIDGE_CORE_CMD_FIRST+27)
#define PVRSRV_BRIDGE_CACHE_FLUSH_DRM				\
		PVRSRV_IOWR(PVRSRV_BRIDGE_CORE_CMD_FIRST+28)
#define PVRSRV_BRIDGE_CORE_CMD_LAST				\
		(PVRSRV_BRIDGE_CORE_CMD_FIRST+28)

#define PVRSRV_BRIDGE_SIM_CMD_FIRST				\
		(PVRSRV_BRIDGE_CORE_CMD_LAST+1)
#define PVRSRV_BRIDGE_PROCESS_SIMISR_EVENT			\
		PVRSRV_IOWR(PVRSRV_BRIDGE_SIM_CMD_FIRST+0)
#define PVRSRV_BRIDGE_REGISTER_SIM_PROCESS			\
		PVRSRV_IOWR(PVRSRV_BRIDGE_SIM_CMD_FIRST+1)
#define PVRSRV_BRIDGE_UNREGISTER_SIM_PROCESS			\
		PVRSRV_IOWR(PVRSRV_BRIDGE_SIM_CMD_FIRST+2)
#define PVRSRV_BRIDGE_SIM_CMD_LAST				\
		(PVRSRV_BRIDGE_SIM_CMD_FIRST+2)

#define PVRSRV_BRIDGE_MAPPING_CMD_FIRST				\
		(PVRSRV_BRIDGE_SIM_CMD_LAST+1)
#define PVRSRV_BRIDGE_MAPPHYSTOUSERSPACE			\
		PVRSRV_IOWR(PVRSRV_BRIDGE_MAPPING_CMD_FIRST+0)
#define PVRSRV_BRIDGE_UNMAPPHYSTOUSERSPACE			\
		PVRSRV_IOWR(PVRSRV_BRIDGE_MAPPING_CMD_FIRST+1)
#define PVRSRV_BRIDGE_GETPHYSTOUSERSPACEMAP			\
		PVRSRV_IOWR(PVRSRV_BRIDGE_MAPPING_CMD_FIRST+2)
#define PVRSRV_BRIDGE_MAPPING_CMD_LAST				\
		(PVRSRV_BRIDGE_MAPPING_CMD_FIRST+2)

#define PVRSRV_BRIDGE_STATS_CMD_FIRST				\
		(PVRSRV_BRIDGE_MAPPING_CMD_LAST+1)
#define	PVRSRV_BRIDGE_GET_FB_STATS				\
		PVRSRV_IOWR(PVRSRV_BRIDGE_STATS_CMD_FIRST+0)
#define PVRSRV_BRIDGE_STATS_CMD_LAST				\
		(PVRSRV_BRIDGE_STATS_CMD_FIRST+0)

#define PVRSRV_BRIDGE_MISC_CMD_FIRST				\
		(PVRSRV_BRIDGE_STATS_CMD_LAST+1)
#define PVRSRV_BRIDGE_GET_MISC_INFO				\
		PVRSRV_IOWR(PVRSRV_BRIDGE_MISC_CMD_FIRST+0)
#define PVRSRV_BRIDGE_RELEASE_MISC_INFO				\
		PVRSRV_IOWR(PVRSRV_BRIDGE_MISC_CMD_FIRST+1)
#define PVRSRV_BRIDGE_MISC_CMD_LAST				\
		(PVRSRV_BRIDGE_MISC_CMD_FIRST+1)

#define PVRSRV_BRIDGE_OVERLAY_CMD_FIRST				\
		(PVRSRV_BRIDGE_MISC_CMD_LAST+1)
#define PVRSRV_BRIDGE_OVERLAY_CMD_LAST				\
		(PVRSRV_BRIDGE_OVERLAY_CMD_FIRST+1)

#if defined(PDUMP)
#define PVRSRV_BRIDGE_PDUMP_CMD_FIRST				\
		(PVRSRV_BRIDGE_OVERLAY_CMD_FIRST+1)
#define PVRSRV_BRIDGE_PDUMP_INIT				\
		PVRSRV_IOWR(PVRSRV_BRIDGE_PDUMP_CMD_FIRST+0)
#define PVRSRV_BRIDGE_PDUMP_MEMPOL				\
		PVRSRV_IOWR(PVRSRV_BRIDGE_PDUMP_CMD_FIRST+1)
#define PVRSRV_BRIDGE_PDUMP_DUMPMEM				\
		PVRSRV_IOWR(PVRSRV_BRIDGE_PDUMP_CMD_FIRST+2)
#define PVRSRV_BRIDGE_PDUMP_REG					\
		PVRSRV_IOWR(PVRSRV_BRIDGE_PDUMP_CMD_FIRST+3)
#define PVRSRV_BRIDGE_PDUMP_REGPOL				\
		PVRSRV_IOWR(PVRSRV_BRIDGE_PDUMP_CMD_FIRST+4)
#define PVRSRV_BRIDGE_PDUMP_COMMENT				\
		PVRSRV_IOWR(PVRSRV_BRIDGE_PDUMP_CMD_FIRST+5)
#define PVRSRV_BRIDGE_PDUMP_SETFRAME				\
		PVRSRV_IOWR(PVRSRV_BRIDGE_PDUMP_CMD_FIRST+6)
#define PVRSRV_BRIDGE_PDUMP_ISCAPTURING				\
		PVRSRV_IOWR(PVRSRV_BRIDGE_PDUMP_CMD_FIRST+7)
#define PVRSRV_BRIDGE_PDUMP_DUMPBITMAP				\
		PVRSRV_IOWR(PVRSRV_BRIDGE_PDUMP_CMD_FIRST+8)
#define PVRSRV_BRIDGE_PDUMP_DUMPREADREG				\
		PVRSRV_IOWR(PVRSRV_BRIDGE_PDUMP_CMD_FIRST+9)
#define PVRSRV_BRIDGE_PDUMP_SYNCPOL				\
		PVRSRV_IOWR(PVRSRV_BRIDGE_PDUMP_CMD_FIRST+10)
#define PVRSRV_BRIDGE_PDUMP_DUMPSYNC				\
		PVRSRV_IOWR(PVRSRV_BRIDGE_PDUMP_CMD_FIRST+11)
#define PVRSRV_BRIDGE_PDUMP_MEMPAGES				\
		PVRSRV_IOWR(PVRSRV_BRIDGE_PDUMP_CMD_FIRST+12)
#define PVRSRV_BRIDGE_PDUMP_DRIVERINFO				\
		PVRSRV_IOWR(PVRSRV_BRIDGE_PDUMP_CMD_FIRST+13)
#define PVRSRV_BRIDGE_PDUMP_PDREG				\
		PVRSRV_IOWR(PVRSRV_BRIDGE_PDUMP_CMD_FIRST+14)
#define PVRSRV_BRIDGE_PDUMP_DUMPPDDEVPADDR			\
		PVRSRV_IOWR(PVRSRV_BRIDGE_PDUMP_CMD_FIRST+15)
#define PVRSRV_BRIDGE_PDUMP_CYCLE_COUNT_REG_READ		\
		PVRSRV_IOWR(PVRSRV_BRIDGE_PDUMP_CMD_FIRST+16)
#define PVRSRV_BRIDGE_PDUMP_STARTINITPHASE			\
		PVRSRV_IOWR(PVRSRV_BRIDGE_PDUMP_CMD_FIRST+17)
#define PVRSRV_BRIDGE_PDUMP_STOPINITPHASE			\
		PVRSRV_IOWR(PVRSRV_BRIDGE_PDUMP_CMD_FIRST+18)
#define PVRSRV_BRIDGE_PDUMP_CMD_LAST				\
		(PVRSRV_BRIDGE_PDUMP_CMD_FIRST+18)
#else
#define PVRSRV_BRIDGE_PDUMP_CMD_LAST	PVRSRV_BRIDGE_OVERLAY_CMD_LAST
#endif

#define PVRSRV_BRIDGE_OEM_CMD_FIRST				\
		(PVRSRV_BRIDGE_PDUMP_CMD_LAST+1)
#define PVRSRV_BRIDGE_GET_OEMJTABLE				\
		PVRSRV_IOWR(PVRSRV_BRIDGE_OEM_CMD_FIRST+0)
#define PVRSRV_BRIDGE_OEM_CMD_LAST				\
		(PVRSRV_BRIDGE_OEM_CMD_FIRST+0)

#define PVRSRV_BRIDGE_DEVCLASS_CMD_FIRST			\
		(PVRSRV_BRIDGE_OEM_CMD_LAST+1)
#define PVRSRV_BRIDGE_ENUM_CLASS				\
		PVRSRV_IOWR(PVRSRV_BRIDGE_DEVCLASS_CMD_FIRST+0)
#define PVRSRV_BRIDGE_DEVCLASS_CMD_LAST				\
		(PVRSRV_BRIDGE_DEVCLASS_CMD_FIRST+0)

#define PVRSRV_BRIDGE_DISPCLASS_CMD_FIRST			\
		(PVRSRV_BRIDGE_DEVCLASS_CMD_LAST+1)
#define PVRSRV_BRIDGE_OPEN_DISPCLASS_DEVICE			\
		PVRSRV_IOWR(PVRSRV_BRIDGE_DISPCLASS_CMD_FIRST+0)
#define PVRSRV_BRIDGE_CLOSE_DISPCLASS_DEVICE			\
		PVRSRV_IOWR(PVRSRV_BRIDGE_DISPCLASS_CMD_FIRST+1)
#define PVRSRV_BRIDGE_ENUM_DISPCLASS_FORMATS			\
		PVRSRV_IOWR(PVRSRV_BRIDGE_DISPCLASS_CMD_FIRST+2)
#define PVRSRV_BRIDGE_ENUM_DISPCLASS_DIMS			\
		PVRSRV_IOWR(PVRSRV_BRIDGE_DISPCLASS_CMD_FIRST+3)
#define PVRSRV_BRIDGE_GET_DISPCLASS_SYSBUFFER			\
		PVRSRV_IOWR(PVRSRV_BRIDGE_DISPCLASS_CMD_FIRST+4)
#define PVRSRV_BRIDGE_GET_DISPCLASS_INFO			\
		PVRSRV_IOWR(PVRSRV_BRIDGE_DISPCLASS_CMD_FIRST+5)
#define PVRSRV_BRIDGE_CREATE_DISPCLASS_SWAPCHAIN		\
		PVRSRV_IOWR(PVRSRV_BRIDGE_DISPCLASS_CMD_FIRST+6)
#define PVRSRV_BRIDGE_DESTROY_DISPCLASS_SWAPCHAIN		\
		PVRSRV_IOWR(PVRSRV_BRIDGE_DISPCLASS_CMD_FIRST+7)
#define PVRSRV_BRIDGE_SET_DISPCLASS_DSTRECT			\
		PVRSRV_IOWR(PVRSRV_BRIDGE_DISPCLASS_CMD_FIRST+8)
#define PVRSRV_BRIDGE_SET_DISPCLASS_SRCRECT			\
		PVRSRV_IOWR(PVRSRV_BRIDGE_DISPCLASS_CMD_FIRST+9)
#define PVRSRV_BRIDGE_SET_DISPCLASS_DSTCOLOURKEY		\
		PVRSRV_IOWR(PVRSRV_BRIDGE_DISPCLASS_CMD_FIRST+10)
#define PVRSRV_BRIDGE_SET_DISPCLASS_SRCCOLOURKEY		\
		PVRSRV_IOWR(PVRSRV_BRIDGE_DISPCLASS_CMD_FIRST+11)
#define PVRSRV_BRIDGE_GET_DISPCLASS_BUFFERS			\
		PVRSRV_IOWR(PVRSRV_BRIDGE_DISPCLASS_CMD_FIRST+12)
#define PVRSRV_BRIDGE_SWAP_DISPCLASS_TO_BUFFER			\
		PVRSRV_IOWR(PVRSRV_BRIDGE_DISPCLASS_CMD_FIRST+13)
#define PVRSRV_BRIDGE_SWAP_DISPCLASS_TO_SYSTEM			\
		PVRSRV_IOWR(PVRSRV_BRIDGE_DISPCLASS_CMD_FIRST+14)
#define PVRSRV_BRIDGE_DISPCLASS_CMD_LAST			\
		(PVRSRV_BRIDGE_DISPCLASS_CMD_FIRST+14)

#define PVRSRV_BRIDGE_BUFCLASS_CMD_FIRST			\
		(PVRSRV_BRIDGE_DISPCLASS_CMD_LAST+1)
#define PVRSRV_BRIDGE_OPEN_BUFFERCLASS_DEVICE			\
		PVRSRV_IOWR(PVRSRV_BRIDGE_BUFCLASS_CMD_FIRST+0)
#define PVRSRV_BRIDGE_CLOSE_BUFFERCLASS_DEVICE			\
		PVRSRV_IOWR(PVRSRV_BRIDGE_BUFCLASS_CMD_FIRST+1)
#define PVRSRV_BRIDGE_GET_BUFFERCLASS_INFO			\
		PVRSRV_IOWR(PVRSRV_BRIDGE_BUFCLASS_CMD_FIRST+2)
#define PVRSRV_BRIDGE_GET_BUFFERCLASS_BUFFER			\
		PVRSRV_IOWR(PVRSRV_BRIDGE_BUFCLASS_CMD_FIRST+3)
#define PVRSRV_BRIDGE_BUFCLASS_CMD_LAST				\
		(PVRSRV_BRIDGE_BUFCLASS_CMD_FIRST+3)

#define PVRSRV_BRIDGE_WRAP_CMD_FIRST				\
		(PVRSRV_BRIDGE_BUFCLASS_CMD_LAST+1)
#define PVRSRV_BRIDGE_WRAP_EXT_MEMORY				\
		PVRSRV_IOWR(PVRSRV_BRIDGE_WRAP_CMD_FIRST+0)
#define PVRSRV_BRIDGE_UNWRAP_EXT_MEMORY				\
		PVRSRV_IOWR(PVRSRV_BRIDGE_WRAP_CMD_FIRST+1)
#define PVRSRV_BRIDGE_WRAP_CMD_LAST				\
		(PVRSRV_BRIDGE_WRAP_CMD_FIRST+1)

#define PVRSRV_BRIDGE_SHAREDMEM_CMD_FIRST			\
		(PVRSRV_BRIDGE_WRAP_CMD_LAST+1)
#define PVRSRV_BRIDGE_ALLOC_SHARED_SYS_MEM			\
		PVRSRV_IOWR(PVRSRV_BRIDGE_SHAREDMEM_CMD_FIRST+0)
#define PVRSRV_BRIDGE_FREE_SHARED_SYS_MEM			\
		PVRSRV_IOWR(PVRSRV_BRIDGE_SHAREDMEM_CMD_FIRST+1)
#define PVRSRV_BRIDGE_MAP_MEMINFO_MEM				\
		PVRSRV_IOWR(PVRSRV_BRIDGE_SHAREDMEM_CMD_FIRST+2)
#define PVRSRV_BRIDGE_UNMAP_MEMINFO_MEM				\
		PVRSRV_IOWR(PVRSRV_BRIDGE_SHAREDMEM_CMD_FIRST+3)
#define PVRSRV_BRIDGE_SHAREDMEM_CMD_LAST			\
		(PVRSRV_BRIDGE_SHAREDMEM_CMD_FIRST+3)

#define PVRSRV_BRIDGE_SERVICES4_TMP_CMD_FIRST			\
		(PVRSRV_BRIDGE_SHAREDMEM_CMD_LAST+1)
#define PVRSRV_BRIDGE_GETMMU_PD_DEVPADDR			\
		PVRSRV_IOWR(PVRSRV_BRIDGE_SERVICES4_TMP_CMD_FIRST+0)
#define PVRSRV_BRIDGE_SERVICES4_TMP_CMD_LAST			\
		(PVRSRV_BRIDGE_SERVICES4_TMP_CMD_FIRST+0)

#define PVRSRV_BRIDGE_INITSRV_CMD_FIRST				\
		(PVRSRV_BRIDGE_SERVICES4_TMP_CMD_LAST+1)
#define PVRSRV_BRIDGE_INITSRV_CONNECT				\
		PVRSRV_IOWR(PVRSRV_BRIDGE_INITSRV_CMD_FIRST+0)
#define PVRSRV_BRIDGE_INITSRV_DISCONNECT			\
		PVRSRV_IOWR(PVRSRV_BRIDGE_INITSRV_CMD_FIRST+1)
#define PVRSRV_BRIDGE_INITSRV_CMD_LAST				\
		(PVRSRV_BRIDGE_INITSRV_CMD_FIRST+1)

#define PVRSRV_BRIDGE_EVENT_OBJECT_CMD_FIRST			\
		(PVRSRV_BRIDGE_INITSRV_CMD_LAST+1)
#define PVRSRV_BRIDGE_EVENT_OBJECT_WAIT				\
		PVRSRV_IOWR(PVRSRV_BRIDGE_EVENT_OBJECT_CMD_FIRST+0)
#define PVRSRV_BRIDGE_EVENT_OBJECT_OPEN				\
		PVRSRV_IOWR(PVRSRV_BRIDGE_EVENT_OBJECT_CMD_FIRST+1)
#define PVRSRV_BRIDGE_EVENT_OBJECT_CLOSE			\
		PVRSRV_IOWR(PVRSRV_BRIDGE_EVENT_OBJECT_CMD_FIRST+2)
#define PVRSRV_BRIDGE_EVENT_OBJECT_CMD_LAST			\
		(PVRSRV_BRIDGE_EVENT_OBJECT_CMD_FIRST+2)

#define PVRSRV_BRIDGE_SYNC_OPS_CMD_FIRST			\
		(PVRSRV_BRIDGE_EVENT_OBJECT_CMD_LAST+1)
#define PVRSRV_BRIDGE_MODIFY_SYNC_OPS				\
		PVRSRV_IOWR(PVRSRV_BRIDGE_SYNC_OPS_CMD_FIRST+0)
#define PVRSRV_BRIDGE_SYNC_OPS_CMD_LAST				\
		(PVRSRV_BRIDGE_SYNC_OPS_CMD_FIRST+0)

#define PVRSRV_BRIDGE_LAST_NON_DEVICE_CMD			\
		(PVRSRV_BRIDGE_SYNC_OPS_CMD_LAST+1)

#define PVRSRV_KERNEL_MODE_CLIENT				1

struct PVRSRV_BRIDGE_RETURN {
	enum PVRSRV_ERROR eError;
	void *pvData;
};

struct PVRSRV_BRIDGE_PACKAGE {
	u32 ui32BridgeID;
	u32 ui32Size;
	void __user *pvParamIn;
	u32 ui32InBufferSize;
	void __user *pvParamOut;
	u32 ui32OutBufferSize;

	void *hKernelServices;
};

struct PVRSRV_BRIDGE_IN_ACQUIRE_DEVICEINFO {
	u32 ui32BridgeFlags;
	u32 uiDevIndex;
	enum PVRSRV_DEVICE_TYPE eDeviceType;
};

struct PVRSRV_BRIDGE_IN_ENUMCLASS {
	u32 ui32BridgeFlags;
	enum PVRSRV_DEVICE_CLASS sDeviceClass;
};

struct PVRSRV_BRIDGE_IN_CLOSE_DISPCLASS_DEVICE {
	u32 ui32BridgeFlags;
	void *hDeviceKM;
};

struct PVRSRV_BRIDGE_IN_ENUM_DISPCLASS_FORMATS {
	u32 ui32BridgeFlags;
	void *hDeviceKM;
};

struct PVRSRV_BRIDGE_IN_GET_DISPCLASS_SYSBUFFER {
	u32 ui32BridgeFlags;
	void *hDeviceKM;
};

struct PVRSRV_BRIDGE_IN_GET_DISPCLASS_INFO {
	u32 ui32BridgeFlags;
	void *hDeviceKM;
};

struct PVRSRV_BRIDGE_IN_CLOSE_BUFFERCLASS_DEVICE {
	u32 ui32BridgeFlags;
	void *hDeviceKM;
};

struct PVRSRV_BRIDGE_IN_GET_BUFFERCLASS_INFO {
	u32 ui32BridgeFlags;
	void *hDeviceKM;
};

struct PVRSRV_BRIDGE_IN_RELEASE_DEVICEINFO {
	u32 ui32BridgeFlags;
	void *hDevCookie;
};

struct PVRSRV_BRIDGE_IN_FREE_CLASSDEVICEINFO {
	u32 ui32BridgeFlags;
	enum PVRSRV_DEVICE_CLASS DeviceClass;
	void *pvDevInfo;
};

struct PVRSRV_BRIDGE_IN_GET_DEVMEM_HEAPINFO {
	u32 ui32BridgeFlags;
	void *hDevCookie;
	void *hDevMemContext;
};

struct PVRSRV_BRIDGE_IN_CREATE_DEVMEMCONTEXT {
	u32 ui32BridgeFlags;
	void *hDevCookie;
};

struct PVRSRV_BRIDGE_IN_DESTROY_DEVMEMCONTEXT {
	u32 ui32BridgeFlags;
	void *hDevCookie;
	void *hDevMemContext;
};

struct PVRSRV_BRIDGE_IN_ALLOCDEVICEMEM {
	u32 ui32BridgeFlags;
	void *hDevCookie;
	void *hDevMemHeap;
	u32 ui32Attribs;
	u32 ui32Size;
	u32 ui32Alignment;
};

struct PVRSRV_BRIDGE_IN_MAPMEMINFOTOUSER {
	u32 ui32BridgeFlags;
	struct PVRSRV_KERNEL_MEM_INFO *psKernelMemInfo;
};

struct PVRSRV_BRIDGE_IN_UNMAPMEMINFOFROMUSER {
	u32 ui32BridgeFlags;
	struct PVRSRV_KERNEL_MEM_INFO *psKernelMemInfo;
	void *pvLinAddr;
	void *hMappingInfo;
};

#define DRM_PVR2D_CFLUSH_FROM_GPU	1
#define DRM_PVR2D_CFLUSH_TO_GPU		2

struct PVRSRV_BRIDGE_IN_CACHEFLUSHDRMFROMUSER {
	u32 ui32BridgeFlags;
	void *hDevCookie;
	u32 ui32Type;
	u32 ui32Virt;
	u32 ui32Length;
};

struct PVRSRV_BRIDGE_IN_FREEDEVICEMEM {
	u32 ui32BridgeFlags;
	void *hDevCookie;
	struct PVRSRV_KERNEL_MEM_INFO *psKernelMemInfo;
	struct PVRSRV_CLIENT_MEM_INFO sClientMemInfo;

};

struct PVRSRV_BRIDGE_IN_EXPORTDEVICEMEM {
	u32 ui32BridgeFlags;
	void *hDevCookie;
	struct PVRSRV_KERNEL_MEM_INFO *psKernelMemInfo;

};

struct PVRSRV_BRIDGE_IN_GETFREEDEVICEMEM {
	u32 ui32BridgeFlags;
	u32 ui32Flags;
};

struct PVRSRV_BRIDGE_IN_CREATECOMMANDQUEUE {
	u32 ui32BridgeFlags;
	void *hDevCookie;
	u32 ui32QueueSize;
};

struct PVRSRV_BRIDGE_IN_DESTROYCOMMANDQUEUE {
	u32 ui32BridgeFlags;
	void *hDevCookie;
	struct PVRSRV_QUEUE_INFO *psQueueInfo;

};

struct PVRSRV_BRIDGE_IN_MHANDLE_TO_MMAP_DATA {
	u32 ui32BridgeFlags;
	void *hMHandle;
};

struct PVRSRV_BRIDGE_IN_RELEASE_MMAP_DATA {
	u32 ui32BridgeFlags;
	void *hMHandle;
};

struct PVRSRV_BRIDGE_IN_RESERVE_DEV_VIRTMEM {
	u32 ui32BridgeFlags;
	void *hDevMemHeap;
	struct IMG_DEV_VIRTADDR *psDevVAddr;
	u32 ui32Size;
	u32 ui32Alignment;
};

struct PVRSRV_BRIDGE_OUT_CONNECT_SERVICES {
	enum PVRSRV_ERROR eError;
	void *hKernelServices;
};

struct PVRSRV_BRIDGE_OUT_RESERVE_DEV_VIRTMEM {
	enum PVRSRV_ERROR eError;
	struct PVRSRV_KERNEL_MEM_INFO *psKernelMemInfo;
	struct PVRSRV_KERNEL_SYNC_INFO *psKernelSyncInfo;
	struct PVRSRV_CLIENT_MEM_INFO sClientMemInfo;
	struct PVRSRV_CLIENT_SYNC_INFO sClientSyncInfo;
};

struct PVRSRV_BRIDGE_IN_FREE_DEV_VIRTMEM {
	u32 ui32BridgeFlags;
	struct PVRSRV_KERNEL_MEM_INFO *psKernelMemInfo;
	struct PVRSRV_CLIENT_MEM_INFO sClientMemInfo;
	struct PVRSRV_CLIENT_SYNC_INFO sClientSyncInfo;
};

struct PVRSRV_BRIDGE_IN_MAP_DEV_MEMORY {
	u32 ui32BridgeFlags;
	void *hKernelMemInfo;
	void *hDstDevMemHeap;
};

struct PVRSRV_BRIDGE_OUT_MAP_DEV_MEMORY {
	enum PVRSRV_ERROR eError;
	struct PVRSRV_KERNEL_MEM_INFO *psDstKernelMemInfo;
	struct PVRSRV_KERNEL_SYNC_INFO *psDstKernelSyncInfo;
	struct PVRSRV_CLIENT_MEM_INFO sDstClientMemInfo;
	struct PVRSRV_CLIENT_SYNC_INFO sDstClientSyncInfo;
};

struct PVRSRV_BRIDGE_IN_UNMAP_DEV_MEMORY {
	u32 ui32BridgeFlags;
	struct PVRSRV_KERNEL_MEM_INFO *psKernelMemInfo;
	struct PVRSRV_CLIENT_MEM_INFO sClientMemInfo;
	struct PVRSRV_CLIENT_SYNC_INFO sClientSyncInfo;
};

struct PVRSRV_BRIDGE_IN_MAP_EXT_MEMORY {
	u32 ui32BridgeFlags;
	struct PVRSRV_KERNEL_MEM_INFO *psKernelMemInfo;
	struct IMG_SYS_PHYADDR *psSysPAddr;
	u32 ui32Flags;
};

struct PVRSRV_BRIDGE_IN_UNMAP_EXT_MEMORY {
	u32 ui32BridgeFlags;
	struct PVRSRV_CLIENT_MEM_INFO sClientMemInfo;
	struct PVRSRV_CLIENT_SYNC_INFO sClientSyncInfo;
	u32 ui32Flags;
};

struct PVRSRV_BRIDGE_IN_MAP_DEVICECLASS_MEMORY {
	u32 ui32BridgeFlags;
	void *hDeviceClassBuffer;
	void *hDevMemContext;

};

struct PVRSRV_BRIDGE_OUT_MAP_DEVICECLASS_MEMORY {
	enum PVRSRV_ERROR eError;
	struct PVRSRV_CLIENT_MEM_INFO sClientMemInfo;
	struct PVRSRV_CLIENT_SYNC_INFO sClientSyncInfo;
	struct PVRSRV_KERNEL_MEM_INFO *psKernelMemInfo;
	struct PVRSRV_KERNEL_SYNC_INFO *psKernelSyncInfo;
	void *hMappingInfo;
};

struct PVRSRV_BRIDGE_IN_UNMAP_DEVICECLASS_MEMORY {
	u32 ui32BridgeFlags;
	struct PVRSRV_KERNEL_MEM_INFO *psKernelMemInfo;
	struct PVRSRV_CLIENT_MEM_INFO sClientMemInfo;
	struct PVRSRV_CLIENT_SYNC_INFO sClientSyncInfo;
};

struct PVRSRV_BRIDGE_IN_PDUMP_MEMPOL {
	u32 ui32BridgeFlags;
	struct PVRSRV_KERNEL_MEM_INFO *psKernelMemInfo;
	u32 ui32Offset;
	u32 ui32Value;
	u32 ui32Mask;
	IMG_BOOL bLastFrame;
	IMG_BOOL bOverwrite;
};

struct PVRSRV_BRIDGE_IN_PDUMP_SYNCPOL {
	u32 ui32BridgeFlags;
	struct PVRSRV_KERNEL_SYNC_INFO *psKernelSyncInfo;
	IMG_BOOL bIsRead;
	u32 ui32Value;
	u32 ui32Mask;
};

struct PVRSRV_BRIDGE_IN_PDUMP_DUMPMEM {
	u32 ui32BridgeFlags;
	void *pvLinAddr;
	void *pvAltLinAddr;
	struct PVRSRV_KERNEL_MEM_INFO *psKernelMemInfo;
	u32 ui32Offset;
	u32 ui32Bytes;
	u32 ui32Flags;
};

struct PVRSRV_BRIDGE_IN_PDUMP_DUMPSYNC {
	u32 ui32BridgeFlags;
	void *pvAltLinAddr;
	struct PVRSRV_KERNEL_SYNC_INFO *psKernelSyncInfo;
	u32 ui32Offset;
	u32 ui32Bytes;
};

struct PVRSRV_BRIDGE_IN_PDUMP_DUMPREG {
	u32 ui32BridgeFlags;
	struct PVRSRV_HWREG sHWReg;
	u32 ui32Flags;
};

struct PVRSRV_BRIDGE_IN_PDUMP_REGPOL {
	u32 ui32BridgeFlags;
	struct PVRSRV_HWREG sHWReg;
	u32 ui32Mask;
	u32 ui32Flags;
};

struct PVRSRV_BRIDGE_IN_PDUMP_DUMPPDREG {
	u32 ui32BridgeFlags;
	struct PVRSRV_HWREG sHWReg;
	u32 ui32Flags;
};

struct PVRSRV_BRIDGE_IN_PDUMP_MEMPAGES {
	u32 ui32BridgeFlags;
	void *hKernelMemInfo;
	struct IMG_DEV_PHYADDR *pPages;
	u32 ui32NumPages;
	struct IMG_DEV_VIRTADDR sDevAddr;
	u32 ui32Start;
	u32 ui32Length;
	IMG_BOOL bContinuous;
};

struct PVRSRV_BRIDGE_IN_PDUMP_COMMENT {
	u32 ui32BridgeFlags;
	char szComment[PVRSRV_PDUMP_MAX_COMMENT_SIZE];
	u32 ui32Flags;
};

struct PVRSRV_BRIDGE_IN_PDUMP_SETFRAME {
	u32 ui32BridgeFlags;
	u32 ui32Frame;
};

struct PVRSRV_BRIDGE_IN_PDUMP_BITMAP {
	u32 ui32BridgeFlags;
	char szFileName[PVRSRV_PDUMP_MAX_FILENAME_SIZE];
	u32 ui32FileOffset;
	u32 ui32Width;
	u32 ui32Height;
	u32 ui32StrideInBytes;
	struct IMG_DEV_VIRTADDR sDevBaseAddr;
	u32 ui32Size;
	enum PDUMP_PIXEL_FORMAT ePixelFormat;
	enum PDUMP_MEM_FORMAT eMemFormat;
	u32 ui32Flags;
};

struct PVRSRV_BRIDGE_IN_PDUMP_READREG {
	u32 ui32BridgeFlags;
	char szFileName[PVRSRV_PDUMP_MAX_FILENAME_SIZE];
	u32 ui32FileOffset;
	u32 ui32Address;
	u32 ui32Size;
	u32 ui32Flags;
};

struct PVRSRV_BRIDGE_IN_PDUMP_DRIVERINFO {
	u32 ui32BridgeFlags;
	char szString[PVRSRV_PDUMP_MAX_COMMENT_SIZE];
	IMG_BOOL bContinuous;
};

struct PVRSRV_BRIDGE_IN_PDUMP_DUMPPDDEVPADDR {
	u32 ui32BridgeFlags;
	void *hKernelMemInfo;
	u32 ui32Offset;
	struct IMG_DEV_PHYADDR sPDDevPAddr;
};

struct PVRSRV_BRIDGE_IN_PDUMP_CYCLE_COUNT_REG_READ {
	u32 ui32BridgeFlags;
	u32 ui32RegOffset;
	IMG_BOOL bLastFrame;
};

struct PVRSRV_BRIDGE_OUT_ENUMDEVICE {
	enum PVRSRV_ERROR eError;
	u32 ui32NumDevices;
	struct PVRSRV_DEVICE_IDENTIFIER asDeviceIdentifier[PVRSRV_MAX_DEVICES];
};

struct PVRSRV_BRIDGE_OUT_ACQUIRE_DEVICEINFO {

	enum PVRSRV_ERROR eError;
	void *hDevCookie;
};

struct PVRSRV_BRIDGE_OUT_ENUMCLASS {
	enum PVRSRV_ERROR eError;
	u32 ui32NumDevices;
	u32 ui32DevID[PVRSRV_MAX_DEVICES];
};

struct PVRSRV_BRIDGE_IN_OPEN_DISPCLASS_DEVICE {
	u32 ui32BridgeFlags;
	u32 ui32DeviceID;
	void *hDevCookie;
};

struct PVRSRV_BRIDGE_OUT_OPEN_DISPCLASS_DEVICE {
	enum PVRSRV_ERROR eError;
	void *hDeviceKM;
};

struct PVRSRV_BRIDGE_IN_WRAP_EXT_MEMORY {
	u32 ui32BridgeFlags;
	void *hDevCookie;
	void *hDevMemContext;
	void *pvLinAddr;
	u32 ui32ByteSize;
	u32 ui32PageOffset;
	IMG_BOOL bPhysContig;
	u32 ui32NumPageTableEntries;
	struct IMG_SYS_PHYADDR __user *psSysPAddr;
};

struct PVRSRV_BRIDGE_OUT_WRAP_EXT_MEMORY {
	enum PVRSRV_ERROR eError;
	struct PVRSRV_CLIENT_MEM_INFO sClientMemInfo;
	struct PVRSRV_CLIENT_SYNC_INFO sClientSyncInfo;
};

struct PVRSRV_BRIDGE_IN_UNWRAP_EXT_MEMORY {
	u32 ui32BridgeFlags;
	void *hKernelMemInfo;
	struct PVRSRV_CLIENT_MEM_INFO sClientMemInfo;
	struct PVRSRV_CLIENT_SYNC_INFO sClientSyncInfo;

};

#define PVRSRV_MAX_DC_DISPLAY_FORMATS			10
#define PVRSRV_MAX_DC_DISPLAY_DIMENSIONS		10
#define PVRSRV_MAX_DC_SWAPCHAIN_BUFFERS			4
#define PVRSRV_MAX_DC_CLIP_RECTS			32

struct PVRSRV_BRIDGE_OUT_ENUM_DISPCLASS_FORMATS {
	enum PVRSRV_ERROR eError;
	u32 ui32Count;
	struct DISPLAY_FORMAT asFormat[PVRSRV_MAX_DC_DISPLAY_FORMATS];
};

struct PVRSRV_BRIDGE_IN_ENUM_DISPCLASS_DIMS {
	u32 ui32BridgeFlags;
	void *hDeviceKM;
	struct DISPLAY_FORMAT sFormat;
};

struct PVRSRV_BRIDGE_OUT_ENUM_DISPCLASS_DIMS {
	enum PVRSRV_ERROR eError;
	u32 ui32Count;
	struct DISPLAY_DIMS asDim[PVRSRV_MAX_DC_DISPLAY_DIMENSIONS];
};

struct PVRSRV_BRIDGE_OUT_GET_DISPCLASS_INFO {
	enum PVRSRV_ERROR eError;
	struct DISPLAY_INFO sDisplayInfo;
};

struct PVRSRV_BRIDGE_OUT_GET_DISPCLASS_SYSBUFFER {
	enum PVRSRV_ERROR eError;
	void *hBuffer;
};

struct PVRSRV_BRIDGE_IN_CREATE_DISPCLASS_SWAPCHAIN {
	u32 ui32BridgeFlags;
	void *hDeviceKM;
	u32 ui32Flags;
	struct DISPLAY_SURF_ATTRIBUTES sDstSurfAttrib;
	struct DISPLAY_SURF_ATTRIBUTES sSrcSurfAttrib;
	u32 ui32BufferCount;
	u32 ui32OEMFlags;
	u32 ui32SwapChainID;
};

struct PVRSRV_BRIDGE_OUT_CREATE_DISPCLASS_SWAPCHAIN {
	enum PVRSRV_ERROR eError;
	void *hSwapChain;
	u32 ui32SwapChainID;
};

struct PVRSRV_BRIDGE_IN_DESTROY_DISPCLASS_SWAPCHAIN {
	u32 ui32BridgeFlags;
	void *hDeviceKM;
	void *hSwapChain;
};

struct PVRSRV_BRIDGE_IN_SET_DISPCLASS_RECT {
	u32 ui32BridgeFlags;
	void *hDeviceKM;
	void *hSwapChain;
	struct IMG_RECT sRect;
};

struct PVRSRV_BRIDGE_IN_SET_DISPCLASS_COLOURKEY {
	u32 ui32BridgeFlags;
	void *hDeviceKM;
	void *hSwapChain;
	u32 ui32CKColour;
};

struct PVRSRV_BRIDGE_IN_GET_DISPCLASS_BUFFERS {
	u32 ui32BridgeFlags;
	void *hDeviceKM;
	void *hSwapChain;
};

struct PVRSRV_BRIDGE_OUT_GET_DISPCLASS_BUFFERS {
	enum PVRSRV_ERROR eError;
	u32 ui32BufferCount;
	void *ahBuffer[PVRSRV_MAX_DC_SWAPCHAIN_BUFFERS];
};

struct PVRSRV_BRIDGE_IN_SWAP_DISPCLASS_TO_BUFFER {
	u32 ui32BridgeFlags;
	void *hDeviceKM;
	void *hBuffer;
	u32 ui32SwapInterval;
	void *hPrivateTag;
	u32 ui32ClipRectCount;
	struct IMG_RECT sClipRect[PVRSRV_MAX_DC_CLIP_RECTS];
};

struct PVRSRV_BRIDGE_IN_SWAP_DISPCLASS_TO_SYSTEM {
	u32 ui32BridgeFlags;
	void *hDeviceKM;
	void *hSwapChain;
};

struct PVRSRV_BRIDGE_IN_OPEN_BUFFERCLASS_DEVICE {
	u32 ui32BridgeFlags;
	u32 ui32DeviceID;
	void *hDevCookie;
};

struct PVRSRV_BRIDGE_OUT_OPEN_BUFFERCLASS_DEVICE {
	enum PVRSRV_ERROR eError;
	void *hDeviceKM;
};

struct PVRSRV_BRIDGE_OUT_GET_BUFFERCLASS_INFO {
	enum PVRSRV_ERROR eError;
	struct BUFFER_INFO sBufferInfo;
};

struct PVRSRV_BRIDGE_IN_GET_BUFFERCLASS_BUFFER {
	u32 ui32BridgeFlags;
	void *hDeviceKM;
	u32 ui32BufferIndex;
};

struct PVRSRV_BRIDGE_OUT_GET_BUFFERCLASS_BUFFER {
	enum PVRSRV_ERROR eError;
	void *hBuffer;
};

struct PVRSRV_BRIDGE_OUT_GET_DEVMEM_HEAPINFO {
	enum PVRSRV_ERROR eError;
	u32 ui32ClientHeapCount;
	struct PVRSRV_HEAP_INFO sHeapInfo[PVRSRV_MAX_CLIENT_HEAPS];
};

struct PVRSRV_BRIDGE_OUT_CREATE_DEVMEMCONTEXT {
	enum PVRSRV_ERROR eError;
	void *hDevMemContext;
	u32 ui32ClientHeapCount;
	struct PVRSRV_HEAP_INFO sHeapInfo[PVRSRV_MAX_CLIENT_HEAPS];
};

struct PVRSRV_BRIDGE_OUT_CREATE_DEVMEMHEAP {
	enum PVRSRV_ERROR eError;
	void *hDevMemHeap;
};

struct PVRSRV_BRIDGE_OUT_ALLOCDEVICEMEM {
	enum PVRSRV_ERROR eError;
	struct PVRSRV_KERNEL_MEM_INFO *psKernelMemInfo;
	struct PVRSRV_KERNEL_SYNC_INFO *psKernelSyncInfo;
	struct PVRSRV_CLIENT_MEM_INFO sClientMemInfo;
	struct PVRSRV_CLIENT_SYNC_INFO sClientSyncInfo;

};

struct PVRSRV_BRIDGE_OUT_EXPORTDEVICEMEM {
	enum PVRSRV_ERROR eError;
	void *hMemInfo;

};

struct PVRSRV_BRIDGE_OUT_MAPMEMINFOTOUSER {
	enum PVRSRV_ERROR eError;
	void *pvLinAddr;
	void *hMappingInfo;
};

struct PVRSRV_BRIDGE_OUT_GETFREEDEVICEMEM {
	enum PVRSRV_ERROR eError;
	u32 ui32Total;
	u32 ui32Free;
	u32 ui32LargestBlock;
};

#include "pvrmmap.h"
struct PVRSRV_BRIDGE_OUT_MHANDLE_TO_MMAP_DATA {
	enum PVRSRV_ERROR eError;
	u32 ui32MMapOffset;
	u32 ui32ByteOffset;
	u32 ui32RealByteSize;
	u32 ui32UserVAddr;
};

struct PVRSRV_BRIDGE_OUT_RELEASE_MMAP_DATA {
	enum PVRSRV_ERROR eError;
	IMG_BOOL bMUnmap;
	u32 ui32UserVAddr;
	u32 ui32RealByteSize;
};

struct PVRSRV_BRIDGE_IN_GET_MISC_INFO {
	u32 ui32BridgeFlags;
	struct PVRSRV_MISC_INFO sMiscInfo;
};

struct PVRSRV_BRIDGE_OUT_GET_MISC_INFO {
	enum PVRSRV_ERROR eError;
	struct PVRSRV_MISC_INFO sMiscInfo;
};

struct PVRSRV_BRIDGE_IN_RELEASE_MISC_INFO {
	u32 ui32BridgeFlags;
	struct PVRSRV_MISC_INFO sMiscInfo;
};

struct PVRSRV_BRIDGE_OUT_RELEASE_MISC_INFO {
	enum PVRSRV_ERROR eError;
	struct PVRSRV_MISC_INFO sMiscInfo;
};

struct PVRSRV_BRIDGE_OUT_PDUMP_ISCAPTURING {
	enum PVRSRV_ERROR eError;
	IMG_BOOL bIsCapturing;
};

struct PVRSRV_BRIDGE_IN_GET_FB_STATS {
	u32 ui32BridgeFlags;
	u32 ui32Total;
	u32 ui32Available;
};

struct PVRSRV_BRIDGE_IN_MAPPHYSTOUSERSPACE {
	u32 ui32BridgeFlags;
	void *hDevCookie;
	struct IMG_SYS_PHYADDR sSysPhysAddr;
	u32 uiSizeInBytes;
};

struct PVRSRV_BRIDGE_OUT_MAPPHYSTOUSERSPACE {
	void *pvUserAddr;
	u32 uiActualSize;
	void *pvProcess;
};

struct PVRSRV_BRIDGE_IN_UNMAPPHYSTOUSERSPACE {
	u32 ui32BridgeFlags;
	void *hDevCookie;
	void *pvUserAddr;
	void *pvProcess;
};

struct PVRSRV_BRIDGE_OUT_GETPHYSTOUSERSPACEMAP {
	void **ppvTbl;
	u32 uiTblSize;
};

struct PVRSRV_BRIDGE_IN_REGISTER_SIM_PROCESS {
	u32 ui32BridgeFlags;
	void *hDevCookie;
	void *pvProcess;
};

struct PVRSRV_BRIDGE_OUT_REGISTER_SIM_PROCESS {
	struct IMG_SYS_PHYADDR sRegsPhysBase;
	void *pvRegsBase;
	void *pvProcess;
	u32 ulNoOfEntries;
	void *pvTblLinAddr;
};

struct PVRSRV_BRIDGE_IN_UNREGISTER_SIM_PROCESS {
	u32 ui32BridgeFlags;
	void *hDevCookie;
	void *pvProcess;
	void *pvRegsBase;
};

struct PVRSRV_BRIDGE_IN_PROCESS_SIMISR_EVENT {
	u32 ui32BridgeFlags;
	void *hDevCookie;
	u32 ui32StatusAndMask;
	enum PVRSRV_ERROR eError;
};

struct PVRSRV_BRIDGE_IN_INITSRV_DISCONNECT {
	u32 ui32BridgeFlags;
	IMG_BOOL bInitSuccesful;
};

struct PVRSRV_BRIDGE_IN_ALLOC_SHARED_SYS_MEM {
	u32 ui32BridgeFlags;
	u32 ui32Flags;
	u32 ui32Size;
};

struct PVRSRV_BRIDGE_OUT_ALLOC_SHARED_SYS_MEM {
	enum PVRSRV_ERROR eError;
	struct PVRSRV_KERNEL_MEM_INFO *psKernelMemInfo;
	struct PVRSRV_CLIENT_MEM_INFO sClientMemInfo;
};

struct PVRSRV_BRIDGE_IN_FREE_SHARED_SYS_MEM {
	u32 ui32BridgeFlags;
	struct PVRSRV_KERNEL_MEM_INFO *psKernelMemInfo;
	struct PVRSRV_CLIENT_MEM_INFO sClientMemInfo;
};

struct PVRSRV_BRIDGE_OUT_FREE_SHARED_SYS_MEM {
	enum PVRSRV_ERROR eError;
};

struct PVRSRV_BRIDGE_IN_MAP_MEMINFO_MEM {
	u32 ui32BridgeFlags;
	void *hKernelMemInfo;
};

struct PVRSRV_BRIDGE_OUT_MAP_MEMINFO_MEM {
	struct PVRSRV_CLIENT_MEM_INFO sClientMemInfo;
	struct PVRSRV_CLIENT_SYNC_INFO sClientSyncInfo;
	struct PVRSRV_KERNEL_MEM_INFO *psKernelMemInfo;
	struct PVRSRV_KERNEL_SYNC_INFO *psKernelSyncInfo;
	enum PVRSRV_ERROR eError;
};

struct PVRSRV_BRIDGE_IN_UNMAP_MEMINFO_MEM {
	u32 ui32BridgeFlags;
	struct PVRSRV_CLIENT_MEM_INFO sClientMemInfo;
};

struct PVRSRV_BRIDGE_OUT_UNMAP_MEMINFO_MEM {
	enum PVRSRV_ERROR eError;
};

struct PVRSRV_BRIDGE_IN_GETMMU_PD_DEVPADDR {
	u32 ui32BridgeFlags;
	void *hDevMemContext;
};

struct PVRSRV_BRIDGE_OUT_GETMMU_PD_DEVPADDR {
	struct IMG_DEV_PHYADDR sPDDevPAddr;
	enum PVRSRV_ERROR eError;
};

struct PVRSRV_BRIDGE_IN_EVENT_OBJECT_WAIT {
	u32 ui32BridgeFlags;
	void *hOSEventKM;
};

struct PVRSRV_BRIDGE_IN_EVENT_OBJECT_OPEN {
	struct PVRSRV_EVENTOBJECT sEventObject;
};

struct PVRSRV_BRIDGE_OUT_EVENT_OBJECT_OPEN {
	void *hOSEvent;
	enum PVRSRV_ERROR eError;
};

struct PVRSRV_BRIDGE_IN_EVENT_OBJECT_CLOSE {
	struct PVRSRV_EVENTOBJECT sEventObject;
	void *hOSEventKM;
};

struct PVRSRV_BRIDGE_IN_MODIFY_SYNC_OPS {
	u32 ui32BridgeFlags;
	void *hKernelSyncInfo;
	u32 ui32ModifyFlags;

};

struct PVRSRV_BRIDGE_OUT_MODIFY_SYNC_OPS {
	enum PVRSRV_ERROR eError;
	u32 ui32ReadOpsPending;
	u32 ui32ReadOpsComplete;
	u32 ui32WriteOpsPending;
	u32 ui32WriteOpsComplete;

};

#endif
