/* Copyright (c) 2012, Code Aurora Forum. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#define pr_fmt(fmt) "AXI: BIMC: %s(): " fmt, __func__

#include <linux/slab.h>
#include <linux/io.h>
#include <mach/msm_bus_board.h>
#include "msm_bus_core.h"
#include "msm_bus_bimc.h"

enum msm_bus_bimc_slave_block {
	SLAVE_BLOCK_RESERVED = 0,
	SLAVE_BLOCK_SLAVE_WAY,
	SLAVE_BLOCK_XPU,
	SLAVE_BLOCK_ARBITER,
	SLAVE_BLOCK_SCMO,
};


/* Misc module */

#define MISC_REG_BASE(b)		((b) + 0x00000000)

#define MISC_HW_VERSION_ADDR(b)	(MISC_REG_BASE(b) + 0x0000000)
enum bimc_misc_hw_version {
	MISC_HW_VERSION_RMSK		= 0xffffff,
	MISC_HW_VERSION_MAJOR_BMSK	= 0xff0000,
	MISC_HW_VERSION_MAJOR_SHFT	= 0x10,
	MISC_HW_VERSION_MINOR_BMSK	= 0xff00,
	MISC_HW_VERSION_MINOR_SHFT	= 0x8,
	MISC_HW_VERSION_STEP_BMSK	= 0xff,
	MISC_HW_VERSION_STEP_SHFT	= 0x0,
};

#define MISC_CORE_INFO_ADDR(b)	(MISC_REG_BASE(b) + 0x00000004)
enum bimc_misc_core_info {
	MISC_CORE_INFO_RMSK		= 0xffffffff,
	MISC_CORE_INFO_CORE_INFO_BMSK	= 0xffffffff,
	MISC_CORE_INFO_CORE_INFO_SHFT	= 0x0,
};

#define MISC_HW_INFO_ADDR(b)	(MISC_REG_BASE(b) + 0x00000008)
enum bimc_misc_hw_info {
	MISC_HW_INFO_RMSK		= 0xffffffff,
	MISC_HW_INFO_HW_MAJOR_BMSK	= 0xff000000,
	MISC_HW_INFO_HW_MAJOR_SHFT	= 0x18,
	MISC_HW_INFO_HW_BRANCH_BMSK	= 0xff0000,
	MISC_HW_INFO_HW_BRANCH_SHFT	= 0x10,
	MISC_HW_INFO_HW_MINOR_BMSK	= 0xff00,
	MISC_HW_INFO_HW_MINOR_SHFT	= 0x8,
	MISC_HW_INFO_HW_ECO_BMSK	= 0xff,
	MISC_HW_INFO_HW_ECO_SHFT	= 0x0,
};

#define MISC_CORE_CLK_SEL_ADDR(b) \
	(MISC_REG_BASE(b) + 0x00000020)
enum bimc_misc_core_clk_sel {
	MISC_CORE_CLK_SEL_RMSK				= 0x3,
	MISC_CORE_CLK_SEL_CLK_2X_MODE_BMSK		= 0x2,
	MISC_CORE_CLK_SEL_CLK_2X_MODE_SHFT		= 0x1,
	MISC_CORE_CLK_SEL_CLK_2X_MODE_CTRL_EN_BMSK	= 0x1,
	MISC_CORE_CLK_SEL_CLK_2X_MODE_CTRL_EN_SHFT	= 0x0,
};

#define MISC_CLK_PERIOD_ADDR(b) \
	(MISC_REG_BASE(b) + 0x00000024)
enum bimc_misc_bimc_clk_preiod {
	MISC_CLK_PERIOD_RMSK			= 0xff,
	MISC_CLK_PERIOD_CORE_CLK_PERIOD_BMSK	= 0xff,
	MISC_CLK_PERIOD_CORE_CLK_PERIOD_SHFT	= 0x0,
};

#define MISC_SCMOn_LOCAL_CGC_THRESH_ADDR(b, n) \
		(MISC_REG_BASE(b) + 0x00000100 + 0x4 * (n))
enum bimc_misc_scm0n_local_cgc_thresh {
	MISC_SCMOn_LOCAL_CGC_THRESH_RMSK		= 0x800000ff,
	MISC_SCMOn_LOCAL_CGC_THRESH_MAXn		= 1,
	MISC_SCMOn_LOCAL_CGC_THRESH_EN_BMSK		= 0x80000000,
	MISC_SCMOn_LOCAL_CGC_THRESH_EN_SHFT		= 0x1f,
	MISC_SCMOn_LOCAL_CGC_THRESH_THRESH_VAL_BMSK	= 0xff,
	MISC_SCMOn_LOCAL_CGC_THRESH_THRESH_VAL_SHFT	= 0x0,
};

#define MISC_DPEn_LOCAL_CGC_THRESH_ADDR(b, n) \
		(MISC_REG_BASE(b) + 0x00000140 + 0x4 * (n))
enum bimc_misc_dpen_local_cgc_thresh {
	MISC_DPEn_LOCAL_CGC_THRESH_RMSK			= 0x800000ff,
	MISC_DPEn_LOCAL_CGC_THRESH_MAXn			= 1,
	MISC_DPEn_LOCAL_CGC_THRESH_EN_BMSK		= 0x80000000,
	MISC_DPEn_LOCAL_CGC_THRESH_EN_SHFT		= 0x1f,
	MISC_DPEn_LOCAL_CGC_THRESH_THRESH_VAL_BMSK	= 0xff,
	MISC_DPEn_LOCAL_CGC_THRESH_THRESH_VAL_SHFT	= 0x0,
};

#define MISC_MPORT_LOCAL_CGC_THRESH_ADDR(b) \
	(MISC_REG_BASE(b) + 0x00000180)
enum bimc_misc_mport_local_cgc_thresh {
	MISC_MPORT_LOCAL_CGC_THRESH_RMSK		= 0x800000ff,
	MISC_MPORT_LOCAL_CGC_THRESH_EN_BMSK		= 0x80000000,
	MISC_MPORT_LOCAL_CGC_THRESH_EN_SHFT		= 0x1f,
	MISC_MPORT_LOCAL_CGC_THRESH_THRESH_VAL_BMSK	= 0xff,
	MISC_MPORT_LOCAL_CGC_THRESH_THRESH_VAL_SHFT	= 0x0,
};

#define MISC_SWAY_LOCAL_CGC_THRESH_ADDR(b) \
	(MISC_REG_BASE(b) + 0x000001c0)
enum bimc_misc_sway_local_cgc_thresh {
	MISC_SWAY_LOCAL_CGC_THRESH_RMSK			= 0x800000ff,
	MISC_SWAY_LOCAL_CGC_THRESH_EN_BMSK		= 0x80000000,
	MISC_SWAY_LOCAL_CGC_THRESH_EN_SHFT		= 0x1f,
	MISC_SWAY_LOCAL_CGC_THRESH_THRESH_VAL_BMSK	= 0xff,
	MISC_SWAY_LOCAL_CGC_THRESH_THRESH_VAL_SHFT	= 0x0,
};

#define MISC_SCMOn_CGC_THRESH_ADDR(b, n) \
	(MISC_REG_BASE(b) + 0x00000200 + 0x4 * (n))
enum bimc_misc_scmon_cgc_thresh {
	MISC_SCMOn_CGC_THRESH_RMSK		= 0x800000ff,
	MISC_SCMOn_CGC_THRESH_MAXn		= 1,
	MISC_SCMOn_CGC_THRESH_EN_BMSK		= 0x80000000,
	MISC_SCMOn_CGC_THRESH_EN_SHFT		= 0x1f,
	MISC_SCMOn_CGC_THRESH_THRESH_VAL_BMSK	= 0xff,
	MISC_SCMOn_CGC_THRESH_THRESH_VAL_SHFT	= 0x0,
};

#define MISC_SCMOn_DYN_CLK_CTRL_ADDR(b, n) \
	 (MISC_REG_BASE(b) + 0x00000240 + 0x4 * (n))
enum bimc_misc_scmon_dyn_clk_ctrl {
	MISC_SCMOn_DYN_CLK_CTRL_RMSK		= 0x3,
	MISC_SCMOn_DYN_CLK_CTRL_MAXn		= 1,
	MISC_SCMOn_DYN_CLK_CTRL_CGC_EN_BMSK	= 0x2,
	MISC_SCMOn_DYN_CLK_CTRL_CGC_EN_SHFT	= 0x1,
	MISC_SCMOn_DYN_CLK_CTRL_CLK_EN_BMSK	= 0x1,
	MISC_SCMOn_DYN_CLK_CTRL_CLK_EN_SHFT	= 0x0,
};

#define MISC_DPEn_CGC_THRESH_ADDR(b, n) \
	(MISC_REG_BASE(b) + 0x00000280 + 0x4 * (n))
enum bimc_misc_dpen_cgc_thresh {
	MISC_DPEn_CGC_THRESH_RMSK		= 0x800000ff,
	MISC_DPEn_CGC_THRESH_MAXn		= 1,
	MISC_DPEn_CGC_THRESH_EN_BMSK		= 0x80000000,
	MISC_DPEn_CGC_THRESH_EN_SHFT		= 0x1f,
	MISC_DPEn_CGC_THRESH_THRESH_VAL_BMSK	= 0xff,
	MISC_DPEn_CGC_THRESH_THRESH_VAL_SHFT	= 0x0,
};

#define MISC_DPEn_DYN_CLK_CTRL_ADDR(b, n) \
	(MISC_REG_BASE(b) + 0x000002c0 + 0x4 * (n))
enum bimc_misc_dpen_dyn_clk_ctrl {
	MISC_DPEn_DYN_CLK_CTRL_RMSK		= 0x3,
	MISC_DPEn_DYN_CLK_CTRL_MAXn		= 1,
	MISC_DPEn_DYN_CLK_CTRL_CGC_EN_BMSK	= 0x2,
	MISC_DPEn_DYN_CLK_CTRL_CGC_EN_SHFT	= 0x1,
	MISC_DPEn_DYN_CLK_CTRL_CLK_EN_BMSK	= 0x1,
	MISC_DPEn_DYN_CLK_CTRL_CLK_EN_SHFT	= 0x0,
};

/* BIMC Global registers */

#define GLOBAL_1_REG_BASE(b)		((b) + 0x00001000)

#define GLOBAL_1_COMPONENT_INFO_ADDR(b) \
		(GLOBAL1_REG_BASE(b) + 0x00000000)
enum bimc_global_1_component_info {
	GLOBAL_1_COMPONENT_INFO_RMSK		= 0xffff,
	GLOBAL_1_COMPONENT_INFO_SUB_TYPE_BMSK	= 0xff00,
	GLOBAL_1_COMPONENT_INFO_SUB_TYPE_SHFT	= 0x8,
	GLOBAL_1_COMPONENT_INFO_TYPE_BMSK	= 0xff,
	GLOBAL_1_COMPONENT_INFO_TYPE_SHFT	= 0x0,
};

#define VERSION_INFO_ADDR(b) \
	(GLOBAL1_REG_BASE(b) + 0x00000010)
enum bimc_version_info {
	VERSION_INFO_RMSK		= 0xffff,
	VERSION_INFO_MAJOR_BMSK		= 0xf0000000,
	VERSION_INFO_MAJOR_SHFT		= 0x1c,
	VERSION_INFO_BRANCH_BMSK	= 0xfff0000,
	VERSION_INFO_BRANCH_SHFT	= 0x10,
	VERSION_INFO_MINOR_BMSK		= 0xff00,
	VERSION_INFO_MINOR_SHFT		= 0x8,
	VERSION_INFO_ECO_BMSK		= 0xff,
	VERSION_INFO_ECO_SHFT		= 0x0,
};

#define HW_VERSION_ADDR(b) \
	(GLOBAL1_REG_BASE(b) + 0x00000014)
enum bimc_hw_version {
	HW_VERSION_RMSK			= 0xffffffff,
	HW_VERSION_MAJOR_BMSK		= 0xf0000000,
	HW_VERSION_MAJOR_SHFT		= 0x1c,
	HW_VERSION_MINOR_BMSK		= 0xfff0000,
	HW_VERSION_MINOR_SHFT		= 0x10,
	HW_VERSION_STEP_BMSK		= 0xffff,
	HW_VERSION_STEP_SHFT		= 0x0,
};

#define BRIC_CONFIG_INFO_0_ADDR(b) \
		(GLOBAL1_REG_BASE(b) + 0x00000020)
enum bimc_bric_config_info_0 {
	BRIC_CONFIG_INFO_0_RMSK			= 0xffffffff,
	BRIC_CONFIG_INFO_0_ADDR_WIDTH_BMSK	= 0xff000000,
	BRIC_CONFIG_INFO_0_ADDR_WIDTH_SHFT	= 0x18,
	BRIC_CONFIG_INFO_0_BUSID_BMSK		= 0xff0000,
	BRIC_CONFIG_INFO_0_BUSID_SHFT		= 0x10,
	BRIC_CONFIG_INFO_0_NUM_SWAYS_BMSK	= 0xff00,
	BRIC_CONFIG_INFO_0_NUM_SWAYS_SHFT	= 0x8,
	BRIC_CONFIG_INFO_0_NUM_MPORTS_BMSK	= 0xff,
	BRIC_CONFIG_INFO_0_NUM_MPORTS_SHFT	= 0x0,
};

#define BRIC_CONFIG_INFO_1_ADDR(b) \
		(GLOBAL1_REG_BASE(b) + 0x00000030)
enum bimc_bric_config_info_1 {
	BRIC_CONFIG_INFO_1_RMSK			= 0xffffffff,
	BRIC_CONFIG_INFO_1_DATA_WIDTH_BMSK	= 0xffff0000,
	BRIC_CONFIG_INFO_1_DATA_WIDTH_SHFT	= 0x10,
	BRIC_CONFIG_INFO_1_TID_WIDTH_BMSK	= 0xff00,
	BRIC_CONFIG_INFO_1_TID_WIDTH_SHFT	= 0x8,
	BRIC_CONFIG_INFO_1_MID_WIDTH_BMSK	= 0xff,
	BRIC_CONFIG_INFO_1_MID_WIDTH_SHFT	= 0x0,
};

#define MP_INT_STATUS_ADDR(b) \
		(GLOBAL1_REG_BASE(b) + 0x00000100)
enum bimc_mp_int_status {
	MP_INT_STATUS_RMSK		= 0x7f,
	MP_INT_STATUS_MASTERPORT_BMSK	= 0x7f,
	MP_INT_STATUS_MASTERPORT_SHFT	= 0x0,
};

#define MP_INT_CLR_ADDR(b) \
	(GLOBAL1_REG_BASE(b) + 0x00000108)
enum bimc_mp_int_clr {
	MP_INT_CLR_RMSK			= 0x7f,
	MP_INT_CLR_MASTERPORT_BMSK	= 0x7f,
	MP_INT_CLR_MASTERPORT_SHFT	= 0x0,
};

#define MP_INT_EN_ADDR(b) \
		(GLOBAL1_REG_BASE(b) + 0x0000010c)
enum bimc_mp_int_en {
	MP_INT_EN_RMSK			= 0x7f,
	MP_INT_EN_MASTERPORT_BMSK	= 0x7f,
	MP_INT_EN_MASTERPORT_SHFT	= 0x0,
};

#define SW_INT_STATUS_ADDR(b) \
		(GLOBAL1_REG_BASE(b) + 0x00000110)
enum bimc_sw_int_status {
	SW_INT_STATUS_RMSK		= 0x1f,
	SW_INT_STATUS_MASTERPORT_BMSK	= 0x1f,
	SW_INT_STATUS_MASTERPORT_SHFT	= 0x0,
};

#define SW_INT_CLR_ADDR(b) \
	(GLOBAL1_REG_BASE(b) + 0x00000118)
enum bimc_sw_int_clr {
	SW_INT_CLR_RMSK			= 0x1f,
	SW_INT_CLR_MASTERPORT_BMSK	= 0x1f,
	SW_INT_CLR_MASTERPORT_SHFT	= 0x0,
};

#define SW_INT_EN_ADDR(b) \
		(GLOBAL1_REG_BASE(b) + 0x0000011c)
enum bimc_sw_int_en {
	SW_INT_EN_RMSK			= 0x1f,
	SW_INT_EN_MASTERPORT_BMSK	= 0x1f,
	SW_INT_EN_MASTERPORT_SHFT	= 0x0,
};

#define REF_TIMER_CONFIG_ADDR(b) \
		(GLOBAL1_REG_BASE(b) + 0x00000200)
enum bimc_ref_timer_config {
	REF_TIMER_CONFIG_RMSK		= 0xffff,
	REF_TIMER_CONFIG_MASTERPORT_BMSK	= 0xffff,
	REF_TIMER_CONFIG_MASTERPORT_SHFT	= 0x0,
};

#define DEBUG_SEL_ADDR(b) \
		(GLOBAL1_REG_BASE(b) + 0x00000210)
enum bimc_debug_sel {
	DEBUG_SEL_RMSK			= 0xffffffff,
	DEBUG_SEL_COMPONENT_BMSK	= 0xff000000,
	DEBUG_SEL_COMPONENT_SHFT	= 0x18,
	DEBUG_SEL_INSTANCE_BMSK		= 0xff0000,
	DEBUG_SEL_INSTANCE_SHFT		= 0x10,
	DEBUG_SEL_SEL_BMSK		= 0xffff,
	DEBUG_SEL_SEL_SHFT		= 0x0,
};

/* BIMC Global 2 */

#define GLOBAL2_REG_BASE(b)		((b) + 0x00002000)

#define GLOBAL2_COMPONENT_INFO_ADDR(b) \
		(GLOBAL2_REG_BASE(b) + 0x00000000)
enum bimc_global2_component_info {
	GLOBAL2_COMPONENT_INFO_RMSK		= 0xffff,
	GLOBAL2_COMPONENT_INFO_SUB_TYPE_BMSK	= 0xff00,
	GLOBAL2_COMPONENT_INFO_SUB_TYPE_SHFT	= 0x8,
	GLOBAL2_COMPONENT_INFO_TYPE_BMSK	= 0xff,
	GLOBAL2_COMPONENT_INFO_TYPE_SHFT	= 0x0,
};

#define DEFAULT_SEGMENT_CONFIG_ADDR(b) \
		(GLOBAL1_REG_BASE(b) + 0x000001f0)
enum bimc_default_segment_config {
	DEFAULT_SEGMENT_CONFIG_RMSK		= 0xf00f,
	DEFAULT_SEGMENT_CONFIG_REDIRECT_BMSK	= 0xf0000,
	DEFAULT_SEGMENT_CONFIG_REDIRECT_SHFT	= 0x10,
	DEFAULT_SEGMENT_CONFIG_DEFAULT_BMSK	= 0xf,
	DEFAULT_SEGMENT_CONFIG_DEFAULT_SHFT	= 0x0,
};

#define SEGMENTn_ADDR_BASEm_LOWER_ADDR(b, n, m) \
	(GLOBAL2_REG_BASE(b) + 0x00000200 + 0x80 * (n) + 0x10 * (m))
enum bimc_segmentn_addr_basem_lower {
	SEGMENTn_ADDR_BASEm_LOWER_RMSK		= 0xfff0040f,
	SEGMENTn_ADDR_BASEm_LOWER_MAXn		= 4,
	SEGMENTn_ADDR_BASEm_LOWER_BASE_31_20_BMSK	= 0xfff00000,
	SEGMENTn_ADDR_BASEm_LOWER_BASE_31_20_SHFT	= 0x14,
	SEGMENTn_ADDR_BASEm_LOWER_BASE_10_BMSK	= 0x400,
	SEGMENTn_ADDR_BASEm_LOWER_BASE_10_SHFT	= 0xa,
	SEGMENTn_ADDR_BASEm_LOWER_EN_BMSK	= 0x1,
	SEGMENTn_ADDR_BASEm_LOWER_EN_SHFT	= 0x0,
};

#define SEGMENTn_ADDR_BASEm_UPPER_ADDR(b, n, m) \
	(GLOBAL2_REG_BASE(b) + 0x00000204 + 0x80 * (n) + 0x10 * (m))
enum bimc_segmentn_addr_basem_upper {
	SEGMENTn_ADDR_BASEm_UPPER_RMSK		= 0xf,
	SEGMENTn_ADDR_BASEm_UPPER_MAXn		= 4,
};

#define SEGMENTn_ADDR_MASKm_LOWER_ADDR(b, n, m) \
	(GLOBAL2_REG_BASE(b) + 0x00000208 + 0x80 * (n) + 0x10 * (m))
enum bimc_segmentn_addr_maskm_lower {
	SEGMENTn_ADDR_MASKm_LOWER_RMSK		= 0xfff00400,
	SEGMENTn_ADDR_MASKm_LOWER_MAXn		= 4,
	SEGMENTn_ADDR_MASKm_LOWER_MASK_31_20_BMSK	= 0xfff00000,
	SEGMENTn_ADDR_MASKm_LOWER_MASK_31_20_SHFT	= 0x14,
	SEGMENTn_ADDR_MASKm_LOWER_MASK_10_BMSK	= 0x400,
	SEGMENTn_ADDR_MASKm_LOWER_MASK_10_SHFT	= 0xa,
};

#define SEGMENTn_ADDR_MASKm_UPPER_ADDR(b, n, m) \
	(GLOBAL2_REG_BASE(b) + 0x0000020c + 0x80 * (n) + 0x10 * (m))
enum bimc_segmentn_addr_maskm_upper {
	SEGMENTn_ADDR_MASKm_UPPER_RMSK		= 0xf,
	SEGMENTn_ADDR_MASKm_UPPER_MAXn		= 4,
};

/* M_Generic */

#define M_REG_BASE(b)		((b) + 0x00008000)

#define M_COMPONENT_INFO_ADDR(b, n) \
		(M_REG_BASE(b) + (0x4000 * (n)) + 0x00000000)
enum bimc_m_component_info {
	M_COMPONENT_INFO_RMSK		= 0xffffff,
	M_COMPONENT_INFO_INSTANCE_BMSK	= 0xff0000,
	M_COMPONENT_INFO_INSTANCE_SHFT	= 0x10,
	M_COMPONENT_INFO_SUB_TYPE_BMSK	= 0xff00,
	M_COMPONENT_INFO_SUB_TYPE_SHFT	= 0x8,
	M_COMPONENT_INFO_TYPE_BMSK	= 0xff,
	M_COMPONENT_INFO_TYPE_SHFT	= 0x0,
};

#define M_CONFIG_INFO_0_ADDR(b, n) \
	(M_REG_BASE(b) + (0x4000 * (n)) + 0x00000020)
enum bimc_m_config_info_0 {
	M_CONFIG_INFO_0_RMSK			= 0xff00ffff,
	M_CONFIG_INFO_0_SYNC_MODE_BMSK		= 0xff000000,
	M_CONFIG_INFO_0_SYNC_MODE_SHFT		= 0x18,
	M_CONFIG_INFO_0_CONNECTION_TYPE_BMSK	= 0xff00,
	M_CONFIG_INFO_0_CONNECTION_TYPE_SHFT	= 0x8,
	M_CONFIG_INFO_0_FUNC_BMSK		= 0xff,
	M_CONFIG_INFO_0_FUNC_SHFT		= 0x0,
};

#define M_CONFIG_INFO_1_ADDR(b, n) \
	(M_REG_BASE(b) + (0x4000 * (n)) + 0x00000030)
enum bimc_m_config_info_1 {
	M_CONFIG_INFO_1_RMSK			= 0xffffffff,
	M_CONFIG_INFO_1_SWAY_CONNECTIVITY_BMSK	= 0xffffffff,
	M_CONFIG_INFO_1_SWAY_CONNECTIVITY_SHFT	= 0x0,
};

#define M_CONFIG_INFO_2_ADDR(b, n) \
	(M_REG_BASE(b) + (0x4000 * (n)) + 0x00000040)
enum bimc_m_config_info_2 {
	M_CONFIG_INFO_2_RMSK			= 0xffffffff,
	M_CONFIG_INFO_2_M_DATA_WIDTH_BMSK	= 0xffff0000,
	M_CONFIG_INFO_2_M_DATA_WIDTH_SHFT	= 0x10,
	M_CONFIG_INFO_2_M_TID_WIDTH_BMSK	= 0xff00,
	M_CONFIG_INFO_2_M_TID_WIDTH_SHFT	= 0x8,
	M_CONFIG_INFO_2_M_MID_WIDTH_BMSK	= 0xff,
	M_CONFIG_INFO_2_M_MID_WIDTH_SHFT	= 0x0,
};

#define M_CONFIG_INFO_3_ADDR(b, n) \
	(M_REG_BASE(b) + (0x4000 * (n)) + 0x00000050)
enum bimc_m_config_info_3 {
	M_CONFIG_INFO_3_RMSK			= 0xffffffff,
	M_CONFIG_INFO_3_RCH_DEPTH_BMSK		= 0xff000000,
	M_CONFIG_INFO_3_RCH_DEPTH_SHFT		= 0x18,
	M_CONFIG_INFO_3_BCH_DEPTH_BMSK		= 0xff0000,
	M_CONFIG_INFO_3_BCH_DEPTH_SHFT		= 0x10,
	M_CONFIG_INFO_3_WCH_DEPTH_BMSK		= 0xff00,
	M_CONFIG_INFO_3_WCH_DEPTH_SHFT		= 0x8,
	M_CONFIG_INFO_3_ACH_DEPTH_BMSK		= 0xff,
	M_CONFIG_INFO_3_ACH_DEPTH_SHFT		= 0x0,
};

#define M_CONFIG_INFO_4_ADDR(b, n) \
	(M_REG_BASE(b) + (0x4000 * (n)) + 0x00000060)
enum bimc_m_config_info_4 {
	M_CONFIG_INFO_4_RMSK			= 0xffff,
	M_CONFIG_INFO_4_REORDER_BUF_DEPTH_BMSK	= 0xff00,
	M_CONFIG_INFO_4_REORDER_BUF_DEPTH_SHFT	= 0x8,
	M_CONFIG_INFO_4_REORDER_TABLE_DEPTH_BMSK	= 0xff,
	M_CONFIG_INFO_4_REORDER_TABLE_DEPTH_SHFT	= 0x0,
};

#define M_CONFIG_INFO_5_ADDR(b, n) \
	(M_REG_BASE(b) + (0x4000 * (n)) + 0x00000070)
enum bimc_m_config_info_5 {
	M_CONFIG_INFO_5_RMSK			= 0x111,
	M_CONFIG_INFO_5_MP2ARB_PIPELINE_EN_BMSK	= 0x100,
	M_CONFIG_INFO_5_MP2ARB_PIPELINE_EN_SHFT	= 0x8,
	M_CONFIG_INFO_5_MPBUF_PIPELINE_EN_BMSK	= 0x10,
	M_CONFIG_INFO_5_MPBUF_PIPELINE_EN_SHFT	= 0x4,
	M_CONFIG_INFO_5_M2MP_PIPELINE_EN_BMSK	= 0x1,
	M_CONFIG_INFO_5_M2MP_PIPELINE_EN_SHFT	= 0x0,
};

#define M_INT_STATUS_ADDR(b, n) \
	(M_REG_BASE(b) + (0x4000 * (n)) + 0x00000100)
enum bimc_m_int_status {
	M_INT_STATUS_RMSK			= 0x3,
};

#define M_INT_CLR_ADDR(b, n) \
	(M_REG_BASE(b) + (0x4000 * (n)) + 0x00000108)
enum bimc_m_int_clr {
	M_INT_CLR_RMSK			= 0x3,
};

#define M_INT_EN_ADDR(b, n) \
	(M_REG_BASE(b) + (0x4000 * (n)) + 0x0000010c)
enum bimc_m_int_en {
	M_INT_EN_RMSK			= 0x3,
};

#define M_CLK_CTRL_ADDR(b, n) \
	(M_REG_BASE(b) + (0x4000 * (n)) + 0x00000200)
enum bimc_m_clk_ctrl {
	M_CLK_CTRL_RMSK				= 0x3,
	M_CLK_CTRL_MAS_CLK_GATING_EN_BMSK	= 0x2,
	M_CLK_CTRL_MAS_CLK_GATING_EN_SHFT	= 0x1,
	M_CLK_CTRL_CORE_CLK_GATING_EN_BMSK	= 0x1,
	M_CLK_CTRL_CORE_CLK_GATING_EN_SHFT	= 0x0,
};

#define M_MODE_ADDR(b, n) \
		(M_REG_BASE(b) + (0x4000 * (n)) + 0x00000210)
enum bimc_m_mode {
	M_MODE_RMSK				= 0xf0000001,
	M_MODE_WR_GATHER_BEATS_BMSK		= 0xf0000000,
	M_MODE_WR_GATHER_BEATS_SHFT		= 0x1c,
	M_MODE_ORDERING_MODEL_BMSK		= 0x1,
	M_MODE_ORDERING_MODEL_SHFT		= 0x0,
};

#define M_PRIOLVL_OVERRIDE_ADDR(b, n) \
	(M_REG_BASE(b) + (0x4000 * (n)) + 0x00000220)
enum bimc_m_priolvl_override {
	M_PRIOLVL_OVERRIDE_RMSK			= 0x301,
	M_PRIOLVL_OVERRIDE_BMSK			= 0x300,
	M_PRIOLVL_OVERRIDE_SHFT			= 0x8,
	M_PRIOLVL_OVERRIDE_OVERRIDE_PRIOLVL_BMSK	= 0x1,
	M_PRIOLVL_OVERRIDE_OVERRIDE_PRIOLVL_SHFT	= 0x0,
};

#define M_RD_CMD_OVERRIDE_ADDR(b, n) \
	(M_REG_BASE(b) + (0x4000 * (n)) + 0x00000230)
enum bimc_m_read_command_override {
	M_RD_CMD_OVERRIDE_RMSK			= 0x37f3f,
	M_RD_CMD_OVERRIDE_AREQPRIO_BMSK		= 0x300000,
	M_RD_CMD_OVERRIDE_AREQPRIO_SHFT		= 0x18,
	M_RD_CMD_OVERRIDE_AMEMTYPE_BMSK		= 0x70000,
	M_RD_CMD_OVERRIDE_AMEMTYPE_SHFT		= 0x10,
	M_RD_CMD_OVERRIDE_ATRANSIENT_BMSK		= 0x1000,
	M_RD_CMD_OVERRIDE_ATRANSIENT_SHFT		= 0xc,
	M_RD_CMD_OVERRIDE_ASHARED_BMSK		= 0x800,
	M_RD_CMD_OVERRIDE_ASHARED_SHFT		= 0xb,
	M_RD_CMD_OVERRIDE_AREDIRECT_BMSK		= 0x400,
	M_RD_CMD_OVERRIDE_AREDIRECT_SHFT		= 0xa,
	M_RD_CMD_OVERRIDE_AOOO_BMSK			= 0x200,
	M_RD_CMD_OVERRIDE_AOOO_SHFT			= 0x9,
	M_RD_CMD_OVERRIDE_AINNERSHARED_BMSK		= 0x100,
	M_RD_CMD_OVERRIDE_AINNERSHARED_SHFT		= 0x8,
	M_RD_CMD_OVERRIDE_OVERRIDE_AREQPRIO_BMSK	= 0x40,
	M_RD_CMD_OVERRIDE_OVERRIDE_AREQPRIO_SHFT	= 0x6,
	M_RD_CMD_OVERRIDE_OVERRIDE_ATRANSIENT_BMSK	= 0x20,
	M_RD_CMD_OVERRIDE_OVERRIDE_ATRANSIENT_SHFT	= 0x5,
	M_RD_CMD_OVERRIDE_OVERRIDE_AMEMTYPE_BMSK	= 0x10,
	M_RD_CMD_OVERRIDE_OVERRIDE_AMEMTYPE_SHFT	= 0x4,
	M_RD_CMD_OVERRIDE_OVERRIDE_ASHARED_BMSK	= 0x8,
	M_RD_CMD_OVERRIDE_OVERRIDE_ASHARED_SHFT	= 0x3,
	M_RD_CMD_OVERRIDE_OVERRIDE_AREDIRECT_BMSK	= 0x4,
	M_RD_CMD_OVERRIDE_OVERRIDE_AREDIRECT_SHFT	= 0x2,
	M_RD_CMD_OVERRIDE_OVERRIDE_AOOO_BMSK		= 0x2,
	M_RD_CMD_OVERRIDE_OVERRIDE_AOOO_SHFT		= 0x1,
	M_RD_CMD_OVERRIDE_OVERRIDE_AINNERSHARED_BMSK	= 0x1,
	M_RD_CMD_OVERRIDE_OVERRIDE_AINNERSHARED_SHFT	= 0x0,
};

#define M_WR_CMD_OVERRIDE_ADDR(b, n) \
	(M_REG_BASE(b) + (0x4000 * (n)) + 0x00000240)
enum bimc_m_write_command_override {
	M_WR_CMD_OVERRIDE_RMSK			= 0x37f3f,
	M_WR_CMD_OVERRIDE_AREQPRIO_BMSK		= 0x30000,
	M_WR_CMD_OVERRIDE_AREQPRIO_SHFT		= 0x10,
	M_WR_CMD_OVERRIDE_AMEMTYPE_BMSK		= 0x7000,
	M_WR_CMD_OVERRIDE_AMEMTYPE_SHFT		= 0xc,
	M_WR_CMD_OVERRIDE_ASHARED_BMSK		= 0x800,
	M_WR_CMD_OVERRIDE_ASHARED_SHFT		= 0xb,
	M_WR_CMD_OVERRIDE_AREDIRECT_BMSK		= 0x400,
	M_WR_CMD_OVERRIDE_AREDIRECT_SHFT		= 0xa,
	M_WR_CMD_OVERRIDE_AOOO_BMSK			= 0x200,
	M_WR_CMD_OVERRIDE_AOOO_SHFT			= 0x9,
	M_WR_CMD_OVERRIDE_AINNERSHARED_BMSK		= 0x100,
	M_WR_CMD_OVERRIDE_AINNERSHARED_SHFT		= 0x8,
	M_WR_CMD_OVERRIDE_OVERRIDE_AREQPRIO_BMSK	= 0x20,
	M_WR_CMD_OVERRIDE_OVERRIDE_AREQPRIO_SHFT	= 0x5,
	M_WR_CMD_OVERRIDE_OVERRIDE_AMEMTYPE_BMSK	= 0x10,
	M_WR_CMD_OVERRIDE_OVERRIDE_AMEMTYPE_SHFT	= 0x4,
	M_WR_CMD_OVERRIDE_OVERRIDE_ASHARED_BMSK	= 0x8,
	M_WR_CMD_OVERRIDE_OVERRIDE_ASHARED_SHFT	= 0x3,
	M_WR_CMD_OVERRIDE_OVERRIDE_AREDIRECT_BMSK	= 0x4,
	M_WR_CMD_OVERRIDE_OVERRIDE_AREDIRECT_SHFT	= 0x2,
	M_WR_CMD_OVERRIDE_OVERRIDE_AOOO_BMSK	= 0x2,
	M_WR_CMD_OVERRIDE_OVERRIDE_AOOO_SHFT	= 0x1,
	M_WR_CMD_OVERRIDE_OVERRIDE_AINNERSHARED_BMSK	= 0x1,
	M_WR_CMD_OVERRIDE_OVERRIDE_AINNERSHARED_SHFT	= 0x0,
};

#define M_BKE_EN_ADDR(b, n) \
	(M_REG_BASE(b) + (0x4000 * (n)) + 0x00000300)
enum bimc_m_bke_en {
	M_BKE_EN_RMSK			= 0x1,
	M_BKE_EN_EN_BMSK		= 0x1,
	M_BKE_EN_EN_SHFT		= 0x0,
};

/* Grant Period registers */
#define M_BKE_GP_ADDR(b, n) \
	(M_REG_BASE(b) + (0x4000 * (n)) + 0x00000304)
enum bimc_m_bke_grant_period {
	M_BKE_GP_RMSK		= 0x3ff,
	M_BKE_GP_GP_BMSK	= 0x3ff,
	M_BKE_GP_GP_SHFT	= 0x0,
};

/* Grant count registers */
#define M_BKE_GC_ADDR(b, n) \
	(M_REG_BASE(b) + (0x4000 * (n)) + 0x00000308)
enum bimc_m_bke_grant_count {
	M_BKE_GC_RMSK			= 0xffff,
	M_BKE_GC_GC_BMSK		= 0xffff,
	M_BKE_GC_GC_SHFT		= 0x0,
};

/* Threshold High Registers */
#define M_BKE_THH_ADDR(b, n) \
	(M_REG_BASE(b) + (0x4000 * (n)) + 0x00000320)
enum bimc_m_bke_thresh_high {
	M_BKE_THH_RMSK		= 0xffff,
	M_BKE_THH_THRESH_BMSK	= 0xffff,
	M_BKE_THH_THRESH_SHFT	= 0x0,
};

/* Threshold Medium Registers */
#define M_BKE_THM_ADDR(b, n) \
	(M_REG_BASE(b) + (0x4000 * (n)) + 0x00000324)
enum bimc_m_bke_thresh_medium {
	M_BKE_THM_RMSK		= 0xffff,
	M_BKE_THM_THRESH_BMSK	= 0xffff,
	M_BKE_THM_THRESH_SHFT	= 0x0,
};

/* Threshold Low Registers */
#define M_BKE_THL_ADDR(b, n) \
	(M_REG_BASE(b) + (0x4000 * (n)) + 0x00000328)
enum bimc_m_bke_thresh_low {
	M_BKE_THL_RMSK			= 0xffff,
	M_BKE_THL_THRESH_BMSK		= 0xffff,
	M_BKE_THL_THRESH_SHFT		= 0x0,
};

#define M_BKE_HEALTH_0_CONFIG_ADDR(b, n) \
	(M_REG_BASE(b) + (0x4000 * (n)) + 0x00000340)
enum bimc_m_bke_health_0 {
	M_BKE_HEALTH_0_CONFIG_RMSK			= 0x80000303,
	M_BKE_HEALTH_0_CONFIG_LIMIT_CMDS_BMSK		= 0x80000000,
	M_BKE_HEALTH_0_CONFIG_LIMIT_CMDS_SHFT		= 0x1f,
	M_BKE_HEALTH_0_CONFIG_AREQPRIO_BMSK		= 0x300,
	M_BKE_HEALTH_0_CONFIG_AREQPRIO_SHFT		= 0x8,
	M_BKE_HEALTH_0_CONFIG_PRIOLVL_BMSK		= 0x3,
	M_BKE_HEALTH_0_CONFIG_PRIOLVL_SHFT		= 0x0,
};

#define M_BKE_HEALTH_1_CONFIG_ADDR(b, n) \
	(M_REG_BASE(b) + (0x4000 * (n)) + 0x00000344)
enum bimc_m_bke_health_1 {
	M_BKE_HEALTH_1_CONFIG_RMSK			= 0x80000303,
	M_BKE_HEALTH_1_CONFIG_LIMIT_CMDS_BMSK		= 0x80000000,
	M_BKE_HEALTH_1_CONFIG_LIMIT_CMDS_SHFT		= 0x1f,
	M_BKE_HEALTH_1_CONFIG_AREQPRIO_BMSK		= 0x300,
	M_BKE_HEALTH_1_CONFIG_AREQPRIO_SHFT		= 0x8,
	M_BKE_HEALTH_1_CONFIG_PRIOLVL_BMSK		= 0x3,
	M_BKE_HEALTH_1_CONFIG_PRIOLVL_SHFT		= 0x0,
};

#define M_BKE_HEALTH_2_CONFIG_ADDR(b, n) \
	(M_REG_BASE(b) + (0x4000 * (n)) + 0x00000348)
enum bimc_m_bke_health_2 {
	M_BKE_HEALTH_2_CONFIG_RMSK			= 0x80000303,
	M_BKE_HEALTH_2_CONFIG_LIMIT_CMDS_BMSK		= 0x80000000,
	M_BKE_HEALTH_2_CONFIG_LIMIT_CMDS_SHFT		= 0x1f,
	M_BKE_HEALTH_2_CONFIG_AREQPRIO_BMSK		= 0x300,
	M_BKE_HEALTH_2_CONFIG_AREQPRIO_SHFT		= 0x8,
	M_BKE_HEALTH_2_CONFIG_PRIOLVL_BMSK		= 0x3,
	M_BKE_HEALTH_2_CONFIG_PRIOLVL_SHFT		= 0x0,
};

#define M_BKE_HEALTH_3_CONFIG_ADDR(b, n) \
	(M_REG_BASE(b) + (0x4000 * (n)) + 0x0000034c)
enum bimc_m_bke_health_3 {
	M_BKE_HEALTH_3_CONFIG_RMSK			= 0x303,
	M_BKE_HEALTH_3_CONFIG_AREQPRIO_BMSK	= 0x300,
	M_BKE_HEALTH_3_CONFIG_AREQPRIO_SHFT	= 0x8,
	M_BKE_HEALTH_3_CONFIG_PRIOLVL_BMSK		= 0x3,
	M_BKE_HEALTH_3_CONFIG_PRIOLVL_SHFT		= 0x0,
};

#define M_BUF_STATUS_ADDR(b, n) \
		(M_REG_BASE(b) + (0x4000 * (n)) + 0x00000400)
enum bimc_m_buf_status {
	M_BUF_STATUS_RMSK			= 0xf03f030,
	M_BUF_STATUS_RCH_DATA_WR_FULL_BMSK	= 0x8000000,
	M_BUF_STATUS_RCH_DATA_WR_FULL_SHFT	= 0x1b,
	M_BUF_STATUS_RCH_DATA_WR_EMPTY_BMSK	= 0x4000000,
	M_BUF_STATUS_RCH_DATA_WR_EMPTY_SHFT	= 0x1a,
	M_BUF_STATUS_RCH_CTRL_WR_FULL_BMSK	= 0x2000000,
	M_BUF_STATUS_RCH_CTRL_WR_FULL_SHFT	= 0x19,
	M_BUF_STATUS_RCH_CTRL_WR_EMPTY_BMSK	= 0x1000000,
	M_BUF_STATUS_RCH_CTRL_WR_EMPTY_SHFT	= 0x18,
	M_BUF_STATUS_BCH_WR_FULL_BMSK		= 0x20000,
	M_BUF_STATUS_BCH_WR_FULL_SHFT		= 0x11,
	M_BUF_STATUS_BCH_WR_EMPTY_BMSK		= 0x10000,
	M_BUF_STATUS_BCH_WR_EMPTY_SHFT		= 0x10,
	M_BUF_STATUS_WCH_DATA_RD_FULL_BMSK	= 0x8000,
	M_BUF_STATUS_WCH_DATA_RD_FULL_SHFT	= 0xf,
	M_BUF_STATUS_WCH_DATA_RD_EMPTY_BMSK	= 0x4000,
	M_BUF_STATUS_WCH_DATA_RD_EMPTY_SHFT	= 0xe,
	M_BUF_STATUS_WCH_CTRL_RD_FULL_BMSK	= 0x2000,
	M_BUF_STATUS_WCH_CTRL_RD_FULL_SHFT	= 0xd,
	M_BUF_STATUS_WCH_CTRL_RD_EMPTY_BMSK	= 0x1000,
	M_BUF_STATUS_WCH_CTRL_RD_EMPTY_SHFT	= 0xc,
	M_BUF_STATUS_ACH_RD_FULL_BMSK		= 0x20,
	M_BUF_STATUS_ACH_RD_FULL_SHFT		= 0x5,
	M_BUF_STATUS_ACH_RD_EMPTY_BMSK		= 0x10,
	M_BUF_STATUS_ACH_RD_EMPTY_SHFT		= 0x4,
};
/*BIMC Generic */

#define S_REG_BASE(b)	((b) + 0x00048000)

#define S_COMPONENT_INFO_ADDR(b, n) \
	(S_REG_BASE(b) + (0x8000 * (n)) + 0x00000000)
enum bimc_s_component_info {
	S_COMPONENT_INFO_RMSK			= 0xffffff,
	S_COMPONENT_INFO_INSTANCE_BMSK		= 0xff0000,
	S_COMPONENT_INFO_INSTANCE_SHFT		= 0x10,
	S_COMPONENT_INFO_SUB_TYPE_BMSK		= 0xff00,
	S_COMPONENT_INFO_SUB_TYPE_SHFT		= 0x8,
	S_COMPONENT_INFO_TYPE_BMSK		= 0xff,
	S_COMPONENT_INFO_TYPE_SHFT		= 0x0,
};

#define S_HW_INFO_ADDR(b, n) \
	(S_REG_BASE(b) + (0x80000 * (n)) + 0x00000010)
enum bimc_s_hw_info {
	S_HW_INFO_RMSK				= 0xffffffff,
	S_HW_INFO_MAJOR_BMSK			= 0xff000000,
	S_HW_INFO_MAJOR_SHFT			= 0x18,
	S_HW_INFO_BRANCH_BMSK			= 0xff0000,
	S_HW_INFO_BRANCH_SHFT			= 0x10,
	S_HW_INFO_MINOR_BMSK			= 0xff00,
	S_HW_INFO_MINOR_SHFT			= 0x8,
	S_HW_INFO_ECO_BMSK			= 0xff,
	S_HW_INFO_ECO_SHFT			= 0x0,
};


/* S_SCMO_GENERIC */

#define S_SCMO_REG_BASE(b)	((b) + 0x00048000)

#define S_SCMO_CONFIG_INFO_0_ADDR(b, n) \
		(S_SCMO_REG_BASE(b) + (0x8000 * (n)) + 0x00000020)
enum bimc_s_scmo_config_info_0 {
	S_SCMO_CONFIG_INFO_0_RMSK		= 0xffffffff,
	S_SCMO_CONFIG_INFO_0_DATA_WIDTH_BMSK	= 0xffff0000,
	S_SCMO_CONFIG_INFO_0_DATA_WIDTH_SHFT	= 0x10,
	S_SCMO_CONFIG_INFO_0_TID_WIDTH_BMSK	= 0xff00,
	S_SCMO_CONFIG_INFO_0_TID_WIDTH_SHFT	= 0x8,
	S_SCMO_CONFIG_INFO_0_MID_WIDTH_BMSK	= 0xff,
	S_SCMO_CONFIG_INFO_0_MID_WIDTH_SHFT	= 0x0,
};

#define S_SCMO_CONFIG_INFO_1_ADDR(b, n) \
		(S_SCMO_REG_BASE(b) + (0x8000 * (n)) + 0x00000030)
enum bimc_s_scmo_config_info_1 {
	S_SCMO_CONFIG_INFO_1_RMSK			= 0xffffffff,
	S_SCMO_CONFIG_INFO_1_MPORT_CONNECTIVITY_BMSK	= 0xffffffff,
	S_SCMO_CONFIG_INFO_1_MPORT_CONNECTIVITY_SHFT	= 0x0,
};

#define S_SCMO_CONFIG_INFO_2_ADDR(b, n) \
		(S_SCMO_REG_BASE(b) + (0x8000 * (n)) + 0x00000040)
enum bimc_s_scmo_config_info_2 {
	S_SCMO_CONFIG_INFO_2_RMSK			= 0xff00ff,
	S_SCMO_CONFIG_INFO_2_NUM_GLOBAL_MONS_BMSK	= 0xff0000,
	S_SCMO_CONFIG_INFO_2_NUM_GLOBAL_MONS_SHFT	= 0x10,
	S_SCMO_CONFIG_INFO_2_VMID_WIDTH_BMSK	= 0xff,
	S_SCMO_CONFIG_INFO_2_VMID_WIDTH_SHFT	= 0x0,
};

#define S_SCMO_CONFIG_INFO_3_ADDR(b, n) \
		(S_SCMO_REG_BASE(b) + (0x8000 * (n)) + 0x00000050)
enum bimc_s_scmo_config_info_3 {
	S_SCMO_CONFIG_INFO_3_RMSK			= 0xffffffff,
	S_SCMO_CONFIG_INFO_3_RCH0_CTRL_DEPTH_BMSK	= 0xff000000,
	S_SCMO_CONFIG_INFO_3_RCH0_CTRL_DEPTH_SHFT	= 0x18,
	S_SCMO_CONFIG_INFO_3_RCH0_DEPTH_BMSK		= 0xff0000,
	S_SCMO_CONFIG_INFO_3_RCH0_DEPTH_SHFT		= 0x10,
	S_SCMO_CONFIG_INFO_3_BCH_DEPTH_BMSK		= 0xff00,
	S_SCMO_CONFIG_INFO_3_BCH_DEPTH_SHFT		= 0x8,
	S_SCMO_CONFIG_INFO_3_WCH_DEPTH_BMSK		= 0xff,
	S_SCMO_CONFIG_INFO_3_WCH_DEPTH_SHFT		= 0x0,
};

#define S_SCMO_CONFIG_INFO_4_ADDR(b, n) \
		(S_SCMO_REG_BASE(b) + (0x8000 * (n)) + 0x00000060)
enum bimc_s_scmo_config_info_4 {
	S_SCMO_CONFIG_INFO_4_RMSK			= 0xffff,
	S_SCMO_CONFIG_INFO_4_RCH1_CTRL_DEPTH_BMSK	= 0xff00,
	S_SCMO_CONFIG_INFO_4_RCH1_CTRL_DEPTH_SHFT	= 0x8,
	S_SCMO_CONFIG_INFO_4_RCH1_DEPTH_BMSK		= 0xff,
	S_SCMO_CONFIG_INFO_4_RCH1_DEPTH_SHFT		= 0x0,
};

#define S_SCMO_CONFIG_INFO_5_ADDR(b, n) \
		(S_SCMO_REG_BASE(b) + (0x8000 * (n)) + 0x00000070)
enum bimc_s_scmo_config_info_5 {
	S_SCMO_CONFIG_INFO_5_RMSK			= 0xffff,
	S_SCMO_CONFIG_INFO_5_DPE_CQ_DEPTH_BMSK		= 0xff00,
	S_SCMO_CONFIG_INFO_5_DPE_CQ_DEPTH_SHFT		= 0x8,
	S_SCMO_CONFIG_INFO_5_DDR_BUS_WIDTH_BMSK		= 0xff,
	S_SCMO_CONFIG_INFO_5_DDR_BUS_WIDTH_SHFT		= 0x0,
};

#define S_SCMO_CONFIG_INFO_6_ADDR(b, n) \
		(S_SCMO_REG_BASE(b) + (0x8000 * (n)) + 0x00000080)
enum bimc_s_scmo_config_info_6 {
	S_SCMO_CONFIG_INFO_6_RMSK			= 0x1111,
	S_SCMO_CONFIG_INFO_6_WBUFC_PIPE_BMSK		= 0x1000,
	S_SCMO_CONFIG_INFO_6_WBUFC_PIPE_SHFT		= 0xc,
	S_SCMO_CONFIG_INFO_6_RDOPT_PIPE_BMSK		= 0x100,
	S_SCMO_CONFIG_INFO_6_RDOPT_PIPE_SHFT		= 0x8,
	S_SCMO_CONFIG_INFO_6_ACHAN_INTF_PIPE_BMSK	= 0x10,
	S_SCMO_CONFIG_INFO_6_ACHAN_INTF_PIPE_SHFT	= 0x4,
	S_SCMO_CONFIG_INFO_6_ADDR_DECODE_HT_BMSK	= 0x1,
	S_SCMO_CONFIG_INFO_6_ADDR_DECODE_HT_SHFT	= 0x0,
};

#define S_SCMO_INT_STATUS_ADDR(b, n) \
	(S_SCMO_REG_BASE(b) + (0x8000 * (n)) + 0x00000100)
enum bimc_s_scmo_int_status {
	S_SCMO_INT_STATUS_RMSK			= 0x1,
	S_SCMO_INT_STATUS_ERR_OCCURED_BMSK	= 0x1,
	S_SCMO_INT_STATUS_ERR_OCCURED_SHFT	= 0x0,
};

#define S_SCMO_INT_CLR_ADDR(b, n) \
	(S_SCMO_REG_BASE(b) + (0x8000 * (n)) + 0x00000108)
enum bimc_s_scmo_int_clr {
	S_SCMO_INT_CLR_RMSK		= 0x1,
	S_SCMO_INT_CLR_IRQ_CLR_BMSK	= 0x1,
	S_SCMO_INT_CLR_IRQ_CLR_SHFT	= 0x0,
};

#define S_SCMO_INT_EN_ADDR(b, n) \
	(S_SCMO_REG_BASE(b) + (0x8000 * (n)) + 0x0000010c)
enum bimc_s_scmo_int_en {
	S_SCMO_INT_EN_RMSK		= 0x1,
	S_SCMO_INT_EN_IRQ_EN_BMSK	= 0x1,
	S_SCMO_INT_EN_IRQ_EN_SHFT	= 0x0,
};

#define S_SCMO_ESYN_ADDR_ADDR(b, n) \
	(S_SCMO_REG_BASE(b) + (0x8000 * (n)) + 0x00000120)
enum bimc_s_scmo_esyn_addr {
	S_SCMO_ESYN_ADDR_RMSK				= 0xffffffff,
	S_SCMO_ESYN_ADDR_ESYN_ADDR_ERR_ADDR_BMSK	= 0xffffffff,
	S_SCMO_ESYN_ADDR_ESYN_ADDR_ERR_ADDR_SHFT	= 0x0,
};

#define S_SCMO_ESYN_APACKET_0_ADDR(b, n) \
	(S_SCMO_REG_BASE(b) + (0x8000 * (n)) + 0x00000128)
enum bimc_s_scmo_esyn_apacket_0 {
	S_SCMO_ESYN_APACKET_0_RMSK			= 0xff1fffff,
	S_SCMO_ESYN_APACKET_0_ERR_ATID_BMSK		= 0xff000000,
	S_SCMO_ESYN_APACKET_0_ERR_ATID_SHFT		= 0x18,
	S_SCMO_ESYN_APACKET_0_ERR_AVMID_BMSK		= 0x1f0000,
	S_SCMO_ESYN_APACKET_0_ERR_AVMID_SHFT		= 0x10,
	S_SCMO_ESYN_APACKET_0_ERR_AMID_BMSK		= 0xffff,
	S_SCMO_ESYN_APACKET_0_ERR_AMID_SHFT		= 0x0,
};

#define S_SCMO_ESYN_APACKET_1_ADDR(b, n) \
	(S_SCMO_REG_BASE(b) + (0x8000 * (n)) + 0x0000012c)
enum bimc_s_scmo_esyn_apacket_1 {
	S_SCMO_ESYN_APACKET_1_RMSK			= 0x10ff117,
	S_SCMO_ESYN_APACKET_1_ERR_CODE_BMSK		= 0x1000000,
	S_SCMO_ESYN_APACKET_1_ERR_CODE_SHFT		= 0x18,
	S_SCMO_ESYN_APACKET_1_ERR_ALEN_BMSK		= 0xf0000,
	S_SCMO_ESYN_APACKET_1_ERR_ALEN_SHFT		= 0x10,
	S_SCMO_ESYN_APACKET_1_ERR_ASIZE_BMSK		= 0xe000,
	S_SCMO_ESYN_APACKET_1_ERR_ASIZE_SHFT		= 0xd,
	S_SCMO_ESYN_APACKET_1_ERR_ABURST_BMSK		= 0x1000,
	S_SCMO_ESYN_APACKET_1_ERR_ABURST_SHFT		= 0xc,
	S_SCMO_ESYN_APACKET_1_ERR_AEXCLUSIVE_BMSK	= 0x100,
	S_SCMO_ESYN_APACKET_1_ERR_AEXCLUSIVE_SHFT	= 0x8,
	S_SCMO_ESYN_APACKET_1_ERR_APRONTS_BMSK		= 0x10,
	S_SCMO_ESYN_APACKET_1_ERR_APRONTS_SHFT		= 0x4,
	S_SCMO_ESYN_APACKET_1_ERR_AOOORD_BMSK		= 0x4,
	S_SCMO_ESYN_APACKET_1_ERR_AOOORD_SHFT		= 0x2,
	S_SCMO_ESYN_APACKET_1_ERR_AOOOWR_BMSK		= 0x2,
	S_SCMO_ESYN_APACKET_1_ERR_AOOOWR_SHFT		= 0x1,
	S_SCMO_ESYN_APACKET_1_ERR_AWRITE_BMSK		= 0x1,
	S_SCMO_ESYN_APACKET_1_ERR_AWRITE_SHFT		= 0x0,
};

#define S_SCMO_CLK_CTRL_ADDR(b, n) \
	(S_SCMO_REG_BASE(b) + (0x8000 * (n)) + 0x00000200)
enum bimc_s_scmo_clk_ctrl {
	S_SCMO_CLK_CTRL_RMSK				= 0xffff1111,
	S_SCMO_CLK_CTRL_PEN_CMD_CG_EN_BMSK		= 0x10000,
	S_SCMO_CLK_CTRL_PEN_CMD_CG_EN_SHFT		= 0x10,
	S_SCMO_CLK_CTRL_RCH_CG_EN_BMSK			= 0x1000,
	S_SCMO_CLK_CTRL_RCH_CG_EN_SHFT			= 0xc,
	S_SCMO_CLK_CTRL_FLUSH_CG_EN_BMSK		= 0x100,
	S_SCMO_CLK_CTRL_FLUSH_CG_EN_SHFT		= 0x8,
	S_SCMO_CLK_CTRL_WCH_CG_EN_BMSK			= 0x10,
	S_SCMO_CLK_CTRL_WCH_CG_EN_SHFT			= 0x4,
	S_SCMO_CLK_CTRL_ACH_CG_EN_BMSK			= 0x1,
	S_SCMO_CLK_CTRL_ACH_CG_EN_SHFT			= 0x0,
};

#define S_SCMO_SLV_INTERLEAVE_CFG_ADDR(b, n) \
	(S_SCMO_REG_BASE(b) + (0x8000 * (n)) + 0x00000400)
enum bimc_s_scmo_slv_interleave_cfg {
	S_SCMO_SLV_INTERLEAVE_CFG_RMSK			= 0xff,
	S_SCMO_SLV_INTERLEAVE_CFG_INTERLEAVE_CS1_BMSK	= 0x10,
	S_SCMO_SLV_INTERLEAVE_CFG_INTERLEAVE_CS1_SHFT	= 0x4,
	S_SCMO_SLV_INTERLEAVE_CFG_INTERLEAVE_CS0_BMSK	= 0x1,
	S_SCMO_SLV_INTERLEAVE_CFG_INTERLEAVE_CS0_SHFT	= 0x0,
};

#define S_SCMO_ADDR_BASE_CSn_ADDR(b, n, o)	\
	(S_SCMO_REG_BASE(b) + (0x8000 * (n)) + 0x00000410 + 0x4 * (o))
enum bimc_s_scmo_addr_base_csn {
	S_SCMO_ADDR_BASE_CSn_RMSK			= 0xffff,
	S_SCMO_ADDR_BASE_CSn_MAXn			= 1,
	S_SCMO_ADDR_BASE_CSn_ADDR_BASE_BMSK		= 0xfc,
	S_SCMO_ADDR_BASE_CSn_ADDR_BASE_SHFT		= 0x2,
};

#define S_SCMO_ADDR_MAP_CSn_ADDR(b, n, o) \
	(S_SCMO_REG_BASE(b) + (0x8000 * (n)) + 0x00000420 + 0x4 * (o))
enum bimc_s_scmo_addr_map_csn {
	S_SCMO_ADDR_MAP_CSn_RMSK		= 0xffff,
	S_SCMO_ADDR_MAP_CSn_MAXn		= 1,
	S_SCMO_ADDR_MAP_CSn_RANK_EN_BMSK	= 0x8000,
	S_SCMO_ADDR_MAP_CSn_RANK_EN_SHFT	= 0xf,
	S_SCMO_ADDR_MAP_CSn_ADDR_MODE_BMSK	= 0x1000,
	S_SCMO_ADDR_MAP_CSn_ADDR_MODE_SHFT	= 0xc,
	S_SCMO_ADDR_MAP_CSn_BANK_SIZE_BMSK	= 0x100,
	S_SCMO_ADDR_MAP_CSn_BANK_SIZE_SHFT	= 0x8,
	S_SCMO_ADDR_MAP_CSn_ROW_SIZE_BMSK	= 0x30,
	S_SCMO_ADDR_MAP_CSn_ROW_SIZE_SHFT	= 0x4,
	S_SCMO_ADDR_MAP_CSn_COL_SIZE_BMSK	= 0x3,
	S_SCMO_ADDR_MAP_CSn_COL_SIZE_SHFT	= 0x0,
};

#define S_SCMO_ADDR_MASK_CSn_ADDR(b, n, o) \
	(S_SCMO_REG_BASE(b) + (0x8000 * (n)) + 0x00000430 + 0x4 * (0))
enum bimc_s_scmo_addr_mask_csn {
	S_SCMO_ADDR_MASK_CSn_RMSK		= 0xffff,
	S_SCMO_ADDR_MASK_CSn_MAXn		= 1,
	S_SCMO_ADDR_MASK_CSn_ADDR_MASK_BMSK	= 0xfc,
	S_SCMO_ADDR_MASK_CSn_ADDR_MASK_SHFT	= 0x2,
};

#define S_SCMO_SLV_STATUS_ADDR(b, n) \
	(S_SCMO_REG_BASE(b) + (0x8000 * (n)) + 0x00000450)
enum bimc_s_scmo_slv_status {
	S_SCMO_SLV_STATUS_RMSK				= 0xff3,
	S_SCMO_SLV_STATUS_GLOBAL_MONS_IN_USE_BMSK	= 0xff0,
	S_SCMO_SLV_STATUS_GLOBAL_MONS_IN_USE_SHFT	= 0x4,
	S_SCMO_SLV_STATUS_SLAVE_IDLE_BMSK		= 0x3,
	S_SCMO_SLV_STATUS_SLAVE_IDLE_SHFT		= 0x0,
};

#define S_SCMO_CMD_BUF_CFG_ADDR(b, n) \
	(S_SCMO_REG_BASE(b) + (0x8000 * (n)) + 0x00000500)
enum bimc_s_scmo_cmd_buf_cfg {
	S_SCMO_CMD_BUF_CFG_RMSK				= 0xf1f,
	S_SCMO_CMD_BUF_CFG_CMD_ORDERING_BMSK		= 0x300,
	S_SCMO_CMD_BUF_CFG_CMD_ORDERING_SHFT		= 0x8,
	S_SCMO_CMD_BUF_CFG_HP_CMD_AREQPRIO_MAP_BMSK	= 0x10,
	S_SCMO_CMD_BUF_CFG_HP_CMD_AREQPRIO_MAP_SHFT	= 0x4,
	S_SCMO_CMD_BUF_CFG_HP_CMD_Q_DEPTH_BMSK		= 0x7,
	S_SCMO_CMD_BUF_CFG_HP_CMD_Q_DEPTH_SHFT		= 0x0,
};

#define S_SCM_CMD_BUF_STATUS_ADDR(b, n) \
	(S_SCMO_REG_BASE(b) + (0x8000 * (n)) + 0x00000520)
enum bimc_s_scm_cmd_buf_status {
	S_SCMO_CMD_BUF_STATUS_RMSK				= 0x77,
	S_SCMO_CMD_BUF_STATUS_HP_CMD_BUF_ENTRIES_IN_USE_BMSK	= 0x70,
	S_SCMO_CMD_BUF_STATUS_HP_CMD_BUF_ENTRIES_IN_USE_SHFT	= 0x4,
	S_SCMO_CMD_BUF_STATUS_LP_CMD_BUF_ENTRIES_IN_USE_BMSK	= 0x7,
	S_SCMO_CMD_BUF_STATUS_LP_CMD_BUF_ENTRIES_IN_USE_SHFT	= 0x0,
};

#define S_SCMO_RCH_SEL_ADDR(b, n) \
	(S_SCMO_REG_BASE(b) + (0x8000 * (n)) + 0x00000540)
enum bimc_s_scmo_rch_sel {
	S_SCMO_RCH_SEL_RMSK			= 0xffffffff,
	S_SCMO_CMD_BUF_STATUS_RCH_PORTS_BMSK	= 0xffffffff,
	S_SCMO_CMD_BUF_STATUS_RCH_PORTS_SHFT	= 0x0,
};

#define S_SCMO_RCH_BKPR_CFG_ADDR(b, n) \
		(S_SCMO_REG_BASE(b) + (0x8000 * (n)) + 0x00000544)
enum bimc_s_scmo_rch_bkpr_cfg {
	S_SCMO_RCH_BKPR_CFG_RMSK			= 0xffffffff,
	S_SCMO_RCH_BKPR_CFG_RCH1_FIFO_BKPR_HI_TH_BMSK	= 0x3f000000,
	S_SCMO_RCH_BKPR_CFG_RCH1_FIFO_BKPR_HI_TH_SHFT	= 0x18,
	S_SCMO_RCH_BKPR_CFG_RCH1_FIFO_BKPR_LO_TH_BMSK	= 0x3f0000,
	S_SCMO_RCH_BKPR_CFG_RCH1_FIFO_BKPR_LO_TH_SHFT	= 0x10,
	S_SCMO_RCH_BKPR_CFG_RCH0_FIFO_BKPR_HI_TH_BMSK	= 0x3f00,
	S_SCMO_RCH_BKPR_CFG_RCH0_FIFO_BKPR_HI_TH_SHFT	= 0x8,
	S_SCMO_RCH_BKPR_CFG_RCH0_FIFO_BKPR_LO_TH_BMSK	= 0x3f,
	S_SCMO_RCH_BKPR_CFG_RCH0_FIFO_BKPR_LO_TH_SHFT	= 0x0,
};

#define S_SCMO_RCH_STATUS_ADDR(b, n) \
		(S_SCMO_REG_BASE(b) + (0x8000 * (n)) + 0x00000560)
enum bimc_s_scmo_rch_status {
	S_SCMO_RCH_STATUS_RMSK				= 0x33333,
	S_SCMO_RCH_STATUS_PRQ_FIFO_FULL_BMSK		= 0x20000,
	S_SCMO_RCH_STATUS_PRQ_FIFO_FULL_SHFT		= 0x11,
	S_SCMO_RCH_STATUS_PRQ_FIFO_EMPTY_BMSK		= 0x10000,
	S_SCMO_RCH_STATUS_PRQ_FIFO_EMPTY_SHFT		= 0x10,
	S_SCMO_RCH_STATUS_RCH1_QUAL_FIFO_FULL_BMSK	= 0x2000,
	S_SCMO_RCH_STATUS_RCH1_QUAL_FIFO_FULL_SHFT	= 0xd,
	S_SCMO_RCH_STATUS_RCH1_QUAL_FIFO_EMPTY_BMSK	= 0x1000,
	S_SCMO_RCH_STATUS_RCH1_QUAL_FIFO_EMPTY_SHFT	= 0xc,
	S_SCMO_RCH_STATUS_RCH1_DATA_FIFO_FULL_BMSK	= 0x200,
	S_SCMO_RCH_STATUS_RCH1_DATA_FIFO_FULL_SHFT	= 0x9,
	S_SCMO_RCH_STATUS_RCH1_DATA_FIFO_EMPTY_BMSK	= 0x100,
	S_SCMO_RCH_STATUS_RCH1_DATA_FIFO_EMPTY_SHFT	= 0x8,
	S_SCMO_RCH_STATUS_RCH0_QUAL_FIFO_FULL_BMSK	= 0x20,
	S_SCMO_RCH_STATUS_RCH0_QUAL_FIFO_FULL_SHFT	= 0x5,
	S_SCMO_RCH_STATUS_RCH0_QUAL_FIFO_EMPTY_BMSK	= 0x10,
	S_SCMO_RCH_STATUS_RCH0_QUAL_FIFO_EMPTY_SHFT	= 0x4,
	S_SCMO_RCH_STATUS_RCH0_DATA_FIFO_FULL_BMSK	= 0x2,
	S_SCMO_RCH_STATUS_RCH0_DATA_FIFO_FULL_SHFT	= 0x1,
	S_SCMO_RCH_STATUS_RCH0_DATA_FIFO_EMPTY_BMSK	= 0x1,
	S_SCMO_RCH_STATUS_RCH0_DATA_FIFO_EMPTY_SHFT	= 0x0,
};

#define S_SCMO_WCH_BUF_CFG_ADDR(b, n) \
	(S_SCMO_REG_BASE(b) + (0x8000 * (n)) + 0x00000580)
enum bimc_s_scmo_wch_buf_cfg {
	S_SCMO_WCH_BUF_CFG_RMSK				= 0xff,
	S_SCMO_WCH_BUF_CFG_WRITE_BLOCK_READ_BMSK	= 0x10,
	S_SCMO_WCH_BUF_CFG_WRITE_BLOCK_READ_SHFT	= 0x4,
	S_SCMO_WCH_BUF_CFG_COALESCE_EN_BMSK		= 0x1,
	S_SCMO_WCH_BUF_CFG_COALESCE_EN_SHFT		= 0x0,
};

#define S_SCMO_WCH_STATUS_ADDR(b, n) \
	(S_SCMO_REG_BASE(b) + (0x8000 * (n)) + 0x000005a0)
enum bimc_s_scmo_wch_status {
	S_SCMO_WCH_STATUS_RMSK				= 0x333,
	S_SCMO_WCH_STATUS_BRESP_FIFO_FULL_BMSK		= 0x200,
	S_SCMO_WCH_STATUS_BRESP_FIFO_FULL_SHFT		= 0x9,
	S_SCMO_WCH_STATUS_BRESP_FIFO_EMPTY_BMSK		= 0x100,
	S_SCMO_WCH_STATUS_BRESP_FIFO_EMPTY_SHFT		= 0x8,
	S_SCMO_WCH_STATUS_WDATA_FIFO_FULL_BMSK		= 0x20,
	S_SCMO_WCH_STATUS_WDATA_FIFO_FULL_SHFT		= 0x5,
	S_SCMO_WCH_STATUS_WDATA_FIFO_EMPTY_BMSK		= 0x10,
	S_SCMO_WCH_STATUS_WDATA_FIFO_EMPTY_SHFT		= 0x4,
	S_SCMO_WCH_STATUS_WBUF_FULL_BMSK		= 0x2,
	S_SCMO_WCH_STATUS_WBUF_FULL_SHFT		= 0x1,
	S_SCMO_WCH_STATUS_WBUF_EMPTY_BMSK		= 0x1,
	S_SCMO_WCH_STATUS_WBUF_EMPTY_SHFT		= 0x0,
};

#define S_SCMO_FLUSH_CFG_ADDR(b, n) \
	(S_SCMO_REG_BASE(b) + (0x8000 * (n)) + 0x000005c0)
enum bimc_s_scmo_flush_cfg {
	S_SCMO_FLUSH_CFG_RMSK				= 0xffffffff,
	S_SCMO_FLUSH_CFG_FLUSH_IN_ORDER_BMSK		= 0x10000000,
	S_SCMO_FLUSH_CFG_FLUSH_IN_ORDER_SHFT		= 0x1c,
	S_SCMO_FLUSH_CFG_FLUSH_IDLE_DELAY_BMSK		= 0x3ff0000,
	S_SCMO_FLUSH_CFG_FLUSH_IDLE_DELAY_SHFT		= 0x10,
	S_SCMO_FLUSH_CFG_FLUSH_UPPER_LIMIT_BMSK		= 0xf00,
	S_SCMO_FLUSH_CFG_FLUSH_UPPER_LIMIT_SHFT		= 0x8,
	S_SCMO_FLUSH_CFG_FLUSH_LOWER_LIMIT_BMSK		= 0xf,
	S_SCMO_FLUSH_CFG_FLUSH_LOWER_LIMIT_SHFT		= 0x0,
};

#define S_SCMO_FLUSH_CMD_ADDR(b, n) \
	(S_SCMO_REG_BASE(b) + (0x8000 * (n)) + 0x000005c4)
enum bimc_s_scmo_flush_cmd {
	S_SCMO_FLUSH_CMD_RMSK				= 0xf,
	S_SCMO_FLUSH_CMD_FLUSH_ALL_BUF_BMSK		= 0x3,
	S_SCMO_FLUSH_CMD_FLUSH_ALL_BUF_SHFT		= 0x0,
};

#define S_SCMO_CMD_OPT_CFG0_ADDR(b, n) \
	(S_SCM0_REG_BASE(b) + (0x8000 * (n)) + 0x00000700)
enum bimc_s_scmo_cmd_opt_cfg0 {
	S_SCMO_CMD_OPT_CFG0_RMSK		= 0xffffff,
	S_SCMO_CMD_OPT_CFG0_IGNORE_BANK_UNAVL_BMSK	= 0x100000,
	S_SCMO_CMD_OPT_CFG0_IGNORE_BANK_UNAVL_SHFT	= 0x14,
	S_SCMO_CMD_OPT_CFG0_MASK_CMDOUT_PRI_BMSK	= 0x10000,
	S_SCMO_CMD_OPT_CFG0_MASK_CMDOUT_PRI_SHFT	= 0x10,
	S_SCMO_CMD_OPT_CFG0_DPE_CMD_REORDERING_BMSK	= 0x1000,
	S_SCMO_CMD_OPT_CFG0_DPE_CMD_REORDERING_SHFT	= 0xc,
	S_SCMO_CMD_OPT_CFG0_WR_OPT_EN_BMSK		= 0x100,
	S_SCMO_CMD_OPT_CFG0_WR_OPT_EN_SHFT		= 0x8,
	S_SCMO_CMD_OPT_CFG0_RD_OPT_EN_BMSK		= 0x10,
	S_SCMO_CMD_OPT_CFG0_RD_OPT_EN_SHFT		= 0x4,
	S_SCMO_CMD_OPT_CFG0_PAGE_MGMT_POLICY_BMSK	= 0x1,
	S_SCMO_CMD_OPT_CFG0_PAGE_MGMT_POLICY_SHFT	= 0x0,
};

#define S_SCMO_CMD_OPT_CFG1_ADDR(b, n) \
	(S_SCMO_REG_BASE(b) + (0x8000 * (n)) + 0x00000704)
enum bimc_s_scmo_cmd_opt_cfg1 {
	S_SCMO_CMD_OPT_CFG1_RMSK			= 0xffffffff,
	S_SCMO_CMD_OPT_CFG1_HSTP_CMD_TIMEOUT_BMSK	= 0x1f000000,
	S_SCMO_CMD_OPT_CFG1_HSTP_CMD_TIMEOUT_SHFT	= 0x18,
	S_SCMO_CMD_OPT_CFG1_HP_CMD_TIMEOUT_BMSK		= 0x1f0000,
	S_SCMO_CMD_OPT_CFG1_HP_CMD_TIMEOUT_SHFT		= 0x10,
	S_SCMO_CMD_OPT_CFG1_MP_CMD_TIMEOUT_BMSK		= 0x1f00,
	S_SCMO_CMD_OPT_CFG1_MP_CMD_TIMEOUT_SHFT		= 0x8,
	S_SCMO_CMD_OPT_CFG1_LP_CMD_TIMEOUT_BMSK		= 0x1f,
	S_SCMO_CMD_OPT_CFG1_LP_CMD_TIMEOUT_SHFT		= 0x0,
};

#define S_SCMO_CMD_OPT_CFG2_ADDR(b, n) \
	(S_SCMO_REG_BASE(b) + (0x8000 * (n)) + 0x00000708)
enum bimc_s_scmo_cmd_opt_cfg2 {
	S_SCMO_CMD_OPT_CFG2_RMSK			= 0xff,
	S_SCMO_CMD_OPT_CFG2_RWOPT_CMD_TIMEOUT_BMSK	= 0xf,
	S_SCMO_CMD_OPT_CFG2_RWOPT_CMD_TIMEOUT_SHFT	= 0x0,
};

#define S_SCMO_CMD_OPT_CFG3_ADDR(b, n) \
	(S_SCMO_REG_BASE(b) + (0x8000 * (n)) + 0x0000070c)
enum bimc_s_scmo_cmd_opt_cfg3 {
	S_SCMO_CMD_OPT_CFG3_RMSK			= 0xff,
	S_SCMO_CMD_OPT_CFG3_FLUSH_CMD_TIMEOUT_BMSK	= 0xf,
	S_SCMO_CMD_OPT_CFG3_FLUSH_CMD_TIMEOUT_SHFT	= 0x0,
};

/* S_SWAY_GENERIC */
#define S_SWAY_REG_BASE(b)	((b) + 0x00048000)

#define S_SWAY_CONFIG_INFO_0_ADDR(b, n) \
	(S_SWAY_REG_BASE(b) + (0x8000 * (n)) + 0x00000020)
enum bimc_s_sway_config_info_0 {
	S_SWAY_CONFIG_INFO_0_RMSK		= 0xff0000ff,
	S_SWAY_CONFIG_INFO_0_SYNC_MODE_BMSK	= 0xff000000,
	S_SWAY_CONFIG_INFO_0_SYNC_MODE_SHFT	= 0x18,
	S_SWAY_CONFIG_INFO_0_FUNC_BMSK		= 0xff,
	S_SWAY_CONFIG_INFO_0_FUNC_SHFT		= 0x0,
};

#define S_SWAY_CONFIG_INFO_1_ADDR(b, n) \
	(S_SWAY_REG_BASE(b) + (0x8000 * (n)) + 0x00000030)
enum bimc_s_sway_config_info_1 {
	S_SWAY_CONFIG_INFO_1_RMSK			= 0xffffffff,
	S_SWAY_CONFIG_INFO_1_MPORT_CONNECTIVITY_BMSK	= 0xffffffff,
	S_SWAY_CONFIG_INFO_1_MPORT_CONNECTIVITY_SHFT	= 0x0,
};

#define S_SWAY_CONFIG_INFO_2_ADDR(b, n) \
	(S_SWAY_REG_BASE(b) + (0x8000 * (n)) + 0x00000040)
enum bimc_s_sway_config_info_2 {
	S_SWAY_CONFIG_INFO_2_RMSK			= 0xffff0000,
	S_SWAY_CONFIG_INFO_2_MPORT_CONNECTIVITY_BMSK	= 0xffff0000,
	S_SWAY_CONFIG_INFO_2_MPORT_CONNECTIVITY_SHFT	= 0x10,
};

#define S_SWAY_CONFIG_INFO_3_ADDR(b, n) \
	(S_SWAY_REG_BASE(b) + (0x8000 * (n)) + 0x00000050)
enum bimc_s_sway_config_info_3 {
	S_SWAY_CONFIG_INFO_3_RMSK			= 0xffffffff,
	S_SWAY_CONFIG_INFO_3_RCH0_DEPTH_BMSK		= 0xff000000,
	S_SWAY_CONFIG_INFO_3_RCH0_DEPTH_SHFT		= 0x18,
	S_SWAY_CONFIG_INFO_3_BCH_DEPTH_BMSK		= 0xff0000,
	S_SWAY_CONFIG_INFO_3_BCH_DEPTH_SHFT		= 0x10,
	S_SWAY_CONFIG_INFO_3_WCH_DEPTH_BMSK		= 0xff,
	S_SWAY_CONFIG_INFO_3_WCH_DEPTH_SHFT		= 0x0,
};

#define S_SWAY_CONFIG_INFO_4_ADDR(b, n) \
	(S_SWAY_REG_BASE(b) + (0x8000 * (n)) + 0x00000060)
enum bimc_s_sway_config_info_4 {
	S_SWAY_CONFIG_INFO_4_RMSK			= 0x800000ff,
	S_SWAY_CONFIG_INFO_4_DUAL_RCH_EN_BMSK		= 0x80000000,
	S_SWAY_CONFIG_INFO_4_DUAL_RCH_EN_SHFT		= 0x1f,
	S_SWAY_CONFIG_INFO_4_RCH1_DEPTH_BMSK		= 0xff,
	S_SWAY_CONFIG_INFO_4_RCH1_DEPTH_SHFT		= 0x0,
};

#define S_SWAY_CONFIG_INFO_5_ADDR(b, n) \
	(S_SWAY_REG_BASE(b) + (0x8000 * (n)) + 0x00000070)
enum bimc_s_sway_config_info_5 {
	S_SWAY_CONFIG_INFO_5_RMSK			= 0x800000ff,
	S_SWAY_CONFIG_INFO_5_QCH_EN_BMSK		= 0x80000000,
	S_SWAY_CONFIG_INFO_5_QCH_EN_SHFT		= 0x1f,
	S_SWAY_CONFIG_INFO_5_QCH_DEPTH_BMSK		= 0xff,
	S_SWAY_CONFIG_INFO_5_QCH_DEPTH_SHFT		= 0x0,
};

#define S_SWAY_CONFIG_INFO_6_ADDR(b, n) \
	(S_SWAY_REG_BASE(b) + (0x8000 * (n)) + 0x00000080)
enum bimc_s_sway_config_info_6 {
	S_SWAY_CONFIG_INFO_6_RMSK			= 0x1,
	S_SWAY_CONFIG_INFO_6_S2SW_PIPELINE_EN_BMSK	= 0x1,
	S_SWAY_CONFIG_INFO_6_S2SW_PIPELINE_EN_SHFT	= 0x0,
};

#define S_SWAY_INT_STATUS_ADDR(b, n) \
	(S_SWAY_REG_BASE(b) + (0x8000 * (n)) + 0x00000100)
enum bimc_s_sway_int_status {
	S_SWAY_INT_STATUS_RMSK		= 0x3,
	S_SWAY_INT_STATUS_RFU_BMSK	= 0x3,
	S_SWAY_INT_STATUS_RFU_SHFT	= 0x0,
};

#define S_SWAY_INT_CLR_ADDR(b, n) \
	(S_SWAY_REG_BASE(b) + (0x8000 * (n)) + 0x00000108)
enum bimc_s_sway_int_clr {
	S_SWAY_INT_CLR_RMSK		= 0x3,
	S_SWAY_INT_CLR_RFU_BMSK		= 0x3,
	S_SWAY_INT_CLR_RFU_SHFT		= 0x0,
};


#define S_SWAY_INT_EN_ADDR(b, n) \
	(S_SWAY_REG_BASE(b) + (0x8000 * (n)) + 0x0000010c)
enum bimc_s_sway_int_en {
	S_SWAY_INT_EN_RMSK		= 0x3,
	S_SWAY_INT_EN_RFU_BMSK		= 0x3,
	S_SWAY_INT_EN_RFU_SHFT		= 0x0,
};

#define S_SWAY_CLK_CTRL_ADDR(b, n) \
	(S_SWAY_REG_BASE(b) + (0x8000 * (n)) + 0x00000200)
enum bimc_s_sway_clk_ctrl {
	S_SWAY_CLK_CTRL_RMSK				= 0x3,
	S_SWAY_CLK_CTRL_SLAVE_CLK_GATING_EN_BMSK	= 0x2,
	S_SWAY_CLK_CTRL_SLAVE_CLK_GATING_EN_SHFT	= 0x1,
	S_SWAY_CLK_CTRL_CORE_CLK_GATING_EN_BMSK		= 0x1,
	S_SWAY_CLK_CTRL_CORE_CLK_GATING_EN_SHFT		= 0x0,
};

#define S_SWAY_RCH_SEL_ADDR(b, n) \
	(S_SWAY_REG_BASE(b) + (0x8000 * (n)) + 0x00000210)
enum bimc_s_sway_rch_sel {
	S_SWAY_RCH_SEL_RMSK		= 0x7f,
	S_SWAY_RCH_SEL_UNUSED_BMSK	= 0x7f,
	S_SWAY_RCH_SEL_UNUSED_SHFT	= 0x0,
};


#define S_SWAY_MAX_OUTSTANDING_REQS_ADDR(b, n) \
	(S_SWAY_REG_BASE(b) + (0x8000 * (n)) + 0x00000220)
enum bimc_s_sway_max_outstanding_reqs {
	S_SWAY_MAX_OUTSTANDING_REQS_RMSK	= 0xffff,
	S_SWAY_MAX_OUTSTANDING_REQS_WRITE_BMSK	= 0xff00,
	S_SWAY_MAX_OUTSTANDING_REQS_WRITE_SHFT	= 0x8,
	S_SWAY_MAX_OUTSTANDING_REQS_READ_BMSK	= 0xff,
	S_SWAY_MAX_OUTSTANDING_REQS_READ_SHFT	= 0x0,
};


#define S_SWAY_BUF_STATUS_0_ADDR(b, n) \
	(S_SWAY_REG_BASE(b) + (0x8000 * (n)) + 0x00000400)
enum bimc_s_sway_buf_status_0 {
	S_SWAY_BUF_STATUS_0_RMSK			= 0xf0300f03,
	S_SWAY_BUF_STATUS_0_RCH0_DATA_RD_FULL_BMSK	= 0x80000000,
	S_SWAY_BUF_STATUS_0_RCH0_DATA_RD_FULL_SHFT	= 0x1f,
	S_SWAY_BUF_STATUS_0_RCH0_DATA_RD_EMPTY_BMSK	= 0x40000000,
	S_SWAY_BUF_STATUS_0_RCH0_DATA_RD_EMPTY_SHFT	= 0x1e,
	S_SWAY_BUF_STATUS_0_RCH0_CTRL_RD_FULL_BMSK	= 0x20000000,
	S_SWAY_BUF_STATUS_0_RCH0_CTRL_RD_FULL_SHFT	= 0x1d,
	S_SWAY_BUF_STATUS_0_RCH0_CTRL_RD_EMPTY_BMSK	= 0x10000000,
	S_SWAY_BUF_STATUS_0_RCH0_CTRL_RD_EMPTY_SHFT	= 0x1c,
	S_SWAY_BUF_STATUS_0_BCH_RD_FULL_BMSK		= 0x200000,
	S_SWAY_BUF_STATUS_0_BCH_RD_FULL_SHFT		= 0x15,
	S_SWAY_BUF_STATUS_0_BCH_RD_EMPTY_BMSK		= 0x100000,
	S_SWAY_BUF_STATUS_0_BCH_RD_EMPTY_SHFT		= 0x14,
	S_SWAY_BUF_STATUS_0_WCH_DATA_WR_FULL_BMSK	= 0x800,
	S_SWAY_BUF_STATUS_0_WCH_DATA_WR_FULL_SHFT	= 0xb,
	S_SWAY_BUF_STATUS_0_WCH_DATA_WR_EMPTY_BMSK	= 0x400,
	S_SWAY_BUF_STATUS_0_WCH_DATA_WR_EMPTY_SHFT	= 0xa,
	S_SWAY_BUF_STATUS_0_WCH_CTRL_WR_FULL_BMSK	= 0x200,
	S_SWAY_BUF_STATUS_0_WCH_CTRL_WR_FULL_SHFT	= 0x9,
	S_SWAY_BUF_STATUS_0_WCH_CTRL_WR_EMPTY_BMSK	= 0x100,
	S_SWAY_BUF_STATUS_0_WCH_CTRL_WR_EMPTY_SHFT	= 0x8,
	S_SWAY_BUF_STATUS_0_ACH_WR_FULL_BMSK		= 0x2,
	S_SWAY_BUF_STATUS_0_ACH_WR_FULL_SHFT		= 0x1,
	S_SWAY_BUF_STATUS_0_ACH_WR_EMPTY_BMSK		= 0x1,
	S_SWAY_BUF_STATUS_0_ACH_WR_EMPTY_SHFT		= 0x0,
};

#define S_SWAY_BUF_STATUS_1_ADDR(b, n) \
	(S_SWAY_REG_BASE(b) + (0x8000 * (n)) + 0x00000410)
enum bimc_s_sway_buf_status_1 {
	S_SWAY_BUF_STATUS_1_RMSK			= 0xf0,
	S_SWAY_BUF_STATUS_1_RCH1_DATA_RD_FULL_BMSK	= 0x80,
	S_SWAY_BUF_STATUS_1_RCH1_DATA_RD_FULL_SHFT	= 0x7,
	S_SWAY_BUF_STATUS_1_RCH1_DATA_RD_EMPTY_BMSK	= 0x40,
	S_SWAY_BUF_STATUS_1_RCH1_DATA_RD_EMPTY_SHFT	= 0x6,
	S_SWAY_BUF_STATUS_1_RCH1_CTRL_RD_FULL_BMSK	= 0x20,
	S_SWAY_BUF_STATUS_1_RCH1_CTRL_RD_FULL_SHFT	= 0x5,
	S_SWAY_BUF_STATUS_1_RCH1_CTRL_RD_EMPTY_BMSK	= 0x10,
	S_SWAY_BUF_STATUS_1_RCH1_CTRL_RD_EMPTY_SHFT	= 0x4,
};

#define S_SWAY_BUF_STATUS_2_ADDR(b, n) \
	(S_SWAY_REG_BASE(b) + (0x8000 * (n)) + 0x00000420)
enum bimc_s_sway_buf_status_2 {
	S_SWAY_BUF_STATUS_2_RMSK		= 0x30,
	S_SWAY_BUF_STATUS_2_QCH_RD_FULL_BMSK	= 0x20,
	S_SWAY_BUF_STATUS_2_QCH_RD_FULL_SHFT	= 0x5,
	S_SWAY_BUF_STATUS_2_QCH_RD_EMPTY_BMSK	= 0x10,
	S_SWAY_BUF_STATUS_2_QCH_RD_EMPTY_SHFT	= 0x4,
};

/* S_ARB_GENERIC */

#define S_ARB_REG_BASE(b)	((b) + 0x00049000)

#define S_ARB_COMPONENT_INFO_ADDR(b, n) \
	(S_SWAY_REG_BASE(b) + (0x8000 * (n)) + 0x00000000)
enum bimc_s_arb_component_info {
	S_ARB_COMPONENT_INFO_RMSK		= 0xffffff,
	S_ARB_COMPONENT_INFO_INSTANCE_BMSK	= 0xff0000,
	S_ARB_COMPONENT_INFO_INSTANCE_SHFT	= 0x10,
	S_ARB_COMPONENT_INFO_SUB_TYPE_BMSK	= 0xff00,
	S_ARB_COMPONENT_INFO_SUB_TYPE_SHFT	= 0x8,
	S_ARB_COMPONENT_INFO_TYPE_BMSK		= 0xff,
	S_ARB_COMPONENT_INFO_TYPE_SHFT		= 0x0,
};

#define S_ARB_CONFIG_INFO_0_ADDR(b, n) \
		(S_ARB_REG_BASE(b) + (0x8000 * (n)) + 0x00000020)
enum bimc_s_arb_config_info_0 {
	S_ARB_CONFIG_INFO_0_RMSK			= 0x800000ff,
	S_ARB_CONFIG_INFO_0_ARB2SW_PIPELINE_EN_BMSK	= 0x80000000,
	S_ARB_CONFIG_INFO_0_ARB2SW_PIPELINE_EN_SHFT	= 0x1f,
	S_ARB_CONFIG_INFO_0_FUNC_BMSK			= 0xff,
	S_ARB_CONFIG_INFO_0_FUNC_SHFT			= 0x0,
};

#define S_ARB_CONFIG_INFO_1_ADDR(b, n) \
		(S_ARB_REG_BASE(b) + (0x8000 * (n)) + 0x00000030)
enum bimc_s_arb_config_info_1 {
	S_ARB_CONFIG_INFO_1_RMSK			= 0xffffffff,
	S_ARB_CONFIG_INFO_1_MPORT_CONNECTIVITY_BMSK	= 0xffffffff,
	S_ARB_CONFIG_INFO_1_MPORT_CONNECTIVITY_SHFT	= 0x0,
};

#define S_ARB_CLK_CTRL_ADDR(b) \
	(S_ARB_REG_BASE(b) + (0x8000 * (n)) + 0x00000200)
enum bimc_s_arb_clk_ctrl {
	S_ARB_CLK_CTRL_RMSK				= 0x1,
	S_ARB_CLK_CTRL_SLAVE_CLK_GATING_EN_BMSK		= 0x2,
	S_ARB_CLK_CTRL_SLAVE_CLK_GATING_EN_SHFT		= 0x1,
	S_ARB_CLK_CTRL_CORE_CLK_GATING_EN_BMSK		= 0x1,
	S_ARB_CLK_CTRL_CORE_CLK_GATING_EN_SHFT		= 0x0,
	S_ARB_CLK_CTRL_CLK_GATING_EN_BMSK		= 0x1,
	S_ARB_CLK_CTRL_CLK_GATING_EN_SHFT		= 0x0,
};

#define S_ARB_MODE_ADDR(b, n) \
	(S_ARB_REG_BASE(b) + (0x8000 * (n)) + 0x00000210)
enum bimc_s_arb_mode {
	S_ARB_MODE_RMSK				= 0xf0000001,
	S_ARB_MODE_WR_GRANTS_AHEAD_BMSK		= 0xf0000000,
	S_ARB_MODE_WR_GRANTS_AHEAD_SHFT		= 0x1c,
	S_ARB_MODE_PRIO_RR_EN_BMSK		= 0x1,
	S_ARB_MODE_PRIO_RR_EN_SHFT		= 0x0,
};

#define BKE_HEALTH_MASK \
	(M_BKE_HEALTH_0_CONFIG_LIMIT_CMDS_BMSK |\
	M_BKE_HEALTH_0_CONFIG_AREQPRIO_BMSK |\
	M_BKE_HEALTH_0_CONFIG_PRIOLVL_BMSK)

#define BKE_HEALTH_VAL(limit, areq, plvl) \
	((((limit) << M_BKE_HEALTH_0_CONFIG_LIMIT_CMDS_SHFT) & \
	M_BKE_HEALTH_0_CONFIG_LIMIT_CMDS_BMSK) | \
	(((areq) << M_BKE_HEALTH_0_CONFIG_AREQPRIO_SHFT) & \
	M_BKE_HEALTH_0_CONFIG_AREQPRIO_BMSK) | \
	(((plvl) << M_BKE_HEALTH_0_CONFIG_PRIOLVL_SHFT) & \
	M_BKE_HEALTH_0_CONFIG_PRIOLVL_BMSK))

#define MAX_GRANT_PERIOD \
	(M_BKE_GP_GP_BMSK >> \
	M_BKE_GP_GP_SHFT)

#define MAX_GC \
	(M_BKE_GC_GC_BMSK >> \
	M_BKE_GC_GC_SHFT)

static int bimc_div(uint64_t *a, uint32_t b)
{
	if ((*a > 0) && (*a < b))
		return 1;
	else
		return do_div(*a, b);
}

#define ENABLE(val) ((val) == 1 ? 1 : 0)
void msm_bus_bimc_set_mas_clk_gate(struct msm_bus_bimc_info *binfo,
	uint32_t mas_index, struct msm_bus_bimc_clk_gate *bgate)
{
	uint32_t val, mask, reg_val;
	void __iomem *addr;

	reg_val = readl_relaxed(M_CLK_CTRL_ADDR(binfo->base,
			mas_index)) & M_CLK_CTRL_RMSK;
	addr = M_CLK_CTRL_ADDR(binfo->base, mas_index);
	mask = (M_CLK_CTRL_MAS_CLK_GATING_EN_BMSK |
		M_CLK_CTRL_CORE_CLK_GATING_EN_BMSK);
	val = (bgate->core_clk_gate_en <<
		M_CLK_CTRL_MAS_CLK_GATING_EN_SHFT) |
		bgate->port_clk_gate_en;
	writel_relaxed(((reg_val & (~mask)) | (val & mask)), addr);
	/* Ensure clock gating enable mask is set before exiting */
	wmb();
}

void msm_bus_bimc_arb_en(struct msm_bus_bimc_info *binfo,
	uint32_t slv_index, bool en)
{
	uint32_t reg_val, reg_mask_val, enable, val;

	reg_mask_val = (readl_relaxed(S_ARB_CONFIG_INFO_0_ADDR(binfo->
		base, slv_index)) & S_ARB_CONFIG_INFO_0_FUNC_BMSK)
		>> S_ARB_CONFIG_INFO_0_FUNC_SHFT;
	enable = ENABLE(en);
	val = enable << S_ARB_MODE_PRIO_RR_EN_SHFT;
	if (reg_mask_val == BIMC_ARB_MODE_PRIORITY_RR) {
		reg_val = readl_relaxed(S_ARB_CONFIG_INFO_0_ADDR(binfo->
			base, slv_index)) & S_ARB_MODE_RMSK;
		writel_relaxed(((reg_val & (~(S_ARB_MODE_PRIO_RR_EN_BMSK))) |
			(val & S_ARB_MODE_PRIO_RR_EN_BMSK)),
			S_ARB_MODE_ADDR(binfo->base, slv_index));
		/* Ensure arbitration mode is set before returning */
		wmb();
	}
}

static void set_qos_mode(void __iomem *baddr, uint32_t index, uint32_t val0,
	uint32_t val1, uint32_t val2)
{
	uint32_t reg_val, val;

	reg_val = readl_relaxed(M_PRIOLVL_OVERRIDE_ADDR(baddr,
		index)) & M_PRIOLVL_OVERRIDE_RMSK;
	val = val0 << M_PRIOLVL_OVERRIDE_OVERRIDE_PRIOLVL_SHFT;
	writel_relaxed(((reg_val & ~(M_PRIOLVL_OVERRIDE_OVERRIDE_PRIOLVL_BMSK))
		| (val & M_PRIOLVL_OVERRIDE_OVERRIDE_PRIOLVL_BMSK)),
		M_PRIOLVL_OVERRIDE_ADDR(baddr, index));
	reg_val = readl_relaxed(M_RD_CMD_OVERRIDE_ADDR(baddr, index)) &
		M_RD_CMD_OVERRIDE_RMSK;
	val = val1 << M_RD_CMD_OVERRIDE_OVERRIDE_AREQPRIO_SHFT;
	writel_relaxed(((reg_val & ~(M_RD_CMD_OVERRIDE_OVERRIDE_AREQPRIO_BMSK
		)) | (val & M_RD_CMD_OVERRIDE_OVERRIDE_AREQPRIO_BMSK)),
		M_RD_CMD_OVERRIDE_ADDR(baddr, index));
	reg_val = readl_relaxed(M_WR_CMD_OVERRIDE_ADDR(baddr, index)) &
		M_WR_CMD_OVERRIDE_RMSK;
	val = val2 << M_WR_CMD_OVERRIDE_OVERRIDE_AREQPRIO_SHFT;
	writel_relaxed(((reg_val & ~(M_WR_CMD_OVERRIDE_OVERRIDE_AREQPRIO_BMSK
		)) | (val & M_WR_CMD_OVERRIDE_OVERRIDE_AREQPRIO_BMSK)),
		M_WR_CMD_OVERRIDE_ADDR(baddr, index));
	/* Ensure the priority register writes go through */
	wmb();
}

static void msm_bus_bimc_set_qos_mode(struct msm_bus_bimc_info *binfo,
	uint32_t mas_index, uint8_t qmode_sel)
{
	uint32_t reg_val, val;

	switch (qmode_sel) {
	case BIMC_QOS_MODE_FIXED:
		reg_val = readl_relaxed(M_BKE_EN_ADDR(binfo->base,
			mas_index)) & M_BKE_EN_RMSK;
		writel_relaxed((reg_val & (~M_BKE_EN_EN_BMSK)),
			M_BKE_EN_ADDR(binfo->base, mas_index));
		/* Ensure that the book-keeping register writes
		 * go through before setting QoS mode.
		 * QoS mode registers might write beyond 1K
		 * boundary in future
		 */
		wmb();
		set_qos_mode(binfo->base, mas_index, 1, 1, 1);
		break;

	case BIMC_QOS_MODE_BYPASS:
		reg_val = readl_relaxed(M_BKE_EN_ADDR(binfo->base,
			mas_index)) & M_BKE_EN_RMSK;
		writel_relaxed((reg_val & (~M_BKE_EN_EN_BMSK)),
			M_BKE_EN_ADDR(binfo->base, mas_index));
		/* Ensure that the book-keeping register writes
		 * go through before setting QoS mode.
		 * QoS mode registers might write beyond 1K
		 * boundary in future
		 */
		wmb();
		set_qos_mode(binfo->base, mas_index, 0, 0, 0);
		break;

	case BIMC_QOS_MODE_REGULATOR:
	case BIMC_QOS_MODE_LIMITER:
		set_qos_mode(binfo->base, mas_index, 0, 0, 0);
		reg_val = readl_relaxed(M_BKE_EN_ADDR(binfo->base,
			mas_index)) & M_BKE_EN_RMSK;
		val = 1 << M_BKE_EN_EN_SHFT;
		/* Ensure that the book-keeping register writes
		 * go through before setting QoS mode.
		 * QoS mode registers might write beyond 1K
		 * boundary in future
		 */
		wmb();
		writel_relaxed(((reg_val & (~M_BKE_EN_EN_BMSK)) | (val &
			M_BKE_EN_EN_BMSK)), M_BKE_EN_ADDR(binfo->base,
			mas_index));
		break;
	default:
		break;
	}
}

static void set_qos_prio_rl(void __iomem *addr, uint32_t rmsk,
	uint8_t index, struct msm_bus_bimc_qos_mode *qmode)
{
	uint32_t reg_val, val0, val;

	/* Note, addr is already passed with right mas_index */
	reg_val = readl_relaxed(addr) & rmsk;
	val0 = BKE_HEALTH_VAL(qmode->rl.qhealth[index].limit_commands,
		qmode->rl.qhealth[index].areq_prio,
		qmode->rl.qhealth[index].prio_level);
	val = (reg_val & (~(BKE_HEALTH_MASK) | (val0 & BKE_HEALTH_MASK)));
	writel_relaxed(val, addr);
	/* Ensure that priority for regulator/limiter modes are
	 * set before returning
	 */
	wmb();

}

static void msm_bus_bimc_set_qos_prio(struct msm_bus_bimc_info *binfo,
	uint32_t mas_index, uint8_t qmode_sel,
	struct msm_bus_bimc_qos_mode *qmode)
{
	uint32_t reg_val, val;

	switch (qmode_sel) {
	case BIMC_QOS_MODE_FIXED:
		reg_val = readl_relaxed(M_PRIOLVL_OVERRIDE_ADDR(binfo->
			base, mas_index)) & M_PRIOLVL_OVERRIDE_RMSK;
		val =  qmode->fixed.prio_level <<
			M_PRIOLVL_OVERRIDE_OVERRIDE_PRIOLVL_SHFT;
		writel_relaxed(((reg_val &
			~(M_PRIOLVL_OVERRIDE_OVERRIDE_PRIOLVL_BMSK)) | (val
			& M_PRIOLVL_OVERRIDE_OVERRIDE_PRIOLVL_BMSK)),
			M_PRIOLVL_OVERRIDE_ADDR(binfo->base, mas_index));

		reg_val = readl_relaxed(M_RD_CMD_OVERRIDE_ADDR(binfo->
			base, mas_index)) & M_RD_CMD_OVERRIDE_RMSK;
		val =  qmode->fixed.areq_prio_rd <<
			M_RD_CMD_OVERRIDE_AREQPRIO_SHFT;
		writel_relaxed(((reg_val & ~(M_RD_CMD_OVERRIDE_AREQPRIO_BMSK))
			| (val & M_RD_CMD_OVERRIDE_AREQPRIO_BMSK)),
			M_RD_CMD_OVERRIDE_ADDR(binfo->base, mas_index));

		reg_val = readl_relaxed(M_WR_CMD_OVERRIDE_ADDR(binfo->
			base, mas_index)) & M_WR_CMD_OVERRIDE_RMSK;
		val =  qmode->fixed.areq_prio_wr <<
			M_WR_CMD_OVERRIDE_AREQPRIO_SHFT;
		writel_relaxed(((reg_val & ~(M_WR_CMD_OVERRIDE_AREQPRIO_BMSK))
			| (val & M_WR_CMD_OVERRIDE_AREQPRIO_BMSK)),
			M_WR_CMD_OVERRIDE_ADDR(binfo->base, mas_index));
		/* Ensure that fixed mode register writes go through
		 * before returning
		 */
		wmb();
		break;

	case BIMC_QOS_MODE_REGULATOR:
	case BIMC_QOS_MODE_LIMITER:
		set_qos_prio_rl(M_BKE_HEALTH_3_CONFIG_ADDR(binfo->base,
			mas_index), M_BKE_HEALTH_3_CONFIG_RMSK, 3, qmode);
		set_qos_prio_rl(M_BKE_HEALTH_2_CONFIG_ADDR(binfo->base,
			mas_index), M_BKE_HEALTH_2_CONFIG_RMSK, 2, qmode);
		set_qos_prio_rl(M_BKE_HEALTH_1_CONFIG_ADDR(binfo->base,
			mas_index), M_BKE_HEALTH_1_CONFIG_RMSK, 1, qmode);
		set_qos_prio_rl(M_BKE_HEALTH_1_CONFIG_ADDR(binfo->base,
			mas_index), M_BKE_HEALTH_0_CONFIG_RMSK, 0 , qmode);
		break;
	case BIMC_QOS_MODE_BYPASS:
	default:
		break;
	}
}

static void set_qos_bw_regs(void __iomem *baddr, uint32_t mas_index,
	long int th, long int tm, long int tl, uint32_t gp,
	uint32_t gc, bool bke_en)
{
	uint32_t reg_val, val;

	/* Disable BKE before writing to registers as per spec */
	reg_val = readl_relaxed(M_BKE_EN_ADDR(baddr, mas_index)) &
		M_BKE_EN_RMSK;
	writel_relaxed((reg_val & ~(M_BKE_EN_EN_BMSK)),
		M_BKE_EN_ADDR(baddr, mas_index));

	/* Write values of registers calculated */
	reg_val = readl_relaxed(M_BKE_GP_ADDR(baddr, mas_index))
		& M_BKE_GP_RMSK;
	val =  gp << M_BKE_GP_GP_SHFT;
	writel_relaxed(((reg_val & ~(M_BKE_GP_GP_BMSK)) | (val &
		M_BKE_GP_GP_BMSK)), M_BKE_GP_ADDR(baddr, mas_index));

	reg_val = readl_relaxed(M_BKE_GC_ADDR(baddr, mas_index)) &
		M_BKE_GC_RMSK;
	val =  gc << M_BKE_GC_GC_SHFT;
	writel_relaxed(((reg_val & ~(M_BKE_GC_GC_BMSK)) | (val &
		M_BKE_GC_GC_BMSK)), M_BKE_GC_ADDR(baddr, mas_index));

	reg_val = readl_relaxed(M_BKE_THH_ADDR(baddr, mas_index)) &
		M_BKE_THH_RMSK;
	val =  th << M_BKE_THH_THRESH_SHFT;
	writel_relaxed(((reg_val & ~(M_BKE_THH_THRESH_BMSK)) | (val &
		M_BKE_THH_THRESH_BMSK)), M_BKE_THH_ADDR(baddr, mas_index));

	reg_val = readl_relaxed(M_BKE_THM_ADDR(baddr, mas_index)) &
		M_BKE_THM_RMSK;
	val =  tm << M_BKE_THM_THRESH_SHFT;
	writel_relaxed(((reg_val & ~(M_BKE_THM_THRESH_BMSK)) | (val &
		M_BKE_THM_THRESH_BMSK)), M_BKE_THM_ADDR(baddr, mas_index));

	reg_val = readl_relaxed(M_BKE_THL_ADDR(baddr, mas_index)) &
		M_BKE_THL_RMSK;
	val =  tl << M_BKE_THL_THRESH_SHFT;
	writel_relaxed(((reg_val & ~(M_BKE_THL_THRESH_BMSK)) |
		(val & M_BKE_THL_THRESH_BMSK)), M_BKE_THL_ADDR(baddr,
		mas_index));

	/* Set BKE enable to the value it was */
	reg_val = readl_relaxed(M_BKE_EN_ADDR(baddr, mas_index)) &
		M_BKE_EN_RMSK;
	val =  bke_en << M_BKE_EN_EN_SHFT;
	writel_relaxed(((reg_val & ~(M_BKE_EN_EN_BMSK)) | (val &
		M_BKE_EN_EN_BMSK)), M_BKE_EN_ADDR(baddr, mas_index));
	/* Ensure that all bandwidth register writes have completed
	 * before returning
	 */
	wmb();
}

static void msm_bus_bimc_set_qos_bw(struct msm_bus_bimc_info *binfo,
	uint32_t mas_index, struct msm_bus_bimc_qos_bw *qbw)
{
	uint32_t bke_en;

	/* Validate QOS Frequency */
	if (binfo->qos_freq == 0) {
		MSM_BUS_DBG("Zero frequency\n");
		return;
	}

	/* Get enable bit for BKE before programming the period */
	bke_en = (readl_relaxed(M_BKE_EN_ADDR(binfo->base, mas_index)) &
		M_BKE_EN_EN_BMSK) >> M_BKE_EN_EN_SHFT;

	/* Only calculate if there's a requested bandwidth and window */
	if (qbw->bw && qbw->ws) {
		uint64_t th, tm, tl;
		uint32_t gp, gc, data_width;
		uint64_t gp_nominal, gp_required, gp_calc, data, temp;
		uint64_t win = qbw->ws * binfo->qos_freq;
		temp = win;
		/*
		 * Calculate nominal grant period defined by requested
		 * window size.
		 * Ceil this value to max grant period.
		 */
		bimc_div(&temp, 1000000);
		gp_nominal = min_t(uint64_t, MAX_GRANT_PERIOD, temp);
		/*
		 * Calculate max window size, defined by bw request.
		 * Units: (KHz, MB/s)
		 */
		data_width = (readl_relaxed(M_CONFIG_INFO_2_ADDR(
			binfo->base, mas_index)) &
			M_CONFIG_INFO_2_M_DATA_WIDTH_BMSK) >>
			M_CONFIG_INFO_2_M_DATA_WIDTH_SHFT;

		/* If unspecified, use data-width 8 by default */
		if (!data_width)
			data_width = 8;

		gp_calc = MAX_GC * data_width * binfo->qos_freq * 1000;
		gp_required = gp_calc;
		bimc_div(&gp_required, qbw->bw);

		/* User min of two grant periods */
		gp = min_t(uint64_t, gp_nominal, gp_required);

		/* Calculate bandwith in grants and ceil. */
		temp = qbw->bw * gp;
		data = data_width * binfo->qos_freq * 1000;
		bimc_div(&temp, data);
		gc = min_t(uint64_t, MAX_GC, temp);

		/* Calculate thresholds */
		th = qbw->bw - qbw->thh;
		tm = qbw->bw - qbw->thm;
		tl = qbw->bw - qbw->thl;

		th = th * gp;
		bimc_div(&th, data);
		tm = tm * gp;
		bimc_div(&tm, data);
		tl = tl * gp;
		bimc_div(&tl, data);

		MSM_BUS_DBG("BIMC: BW: mas_index: %d, th: %llu tm: %llu\n",
			mas_index, th, tm);
		MSM_BUS_DBG("BIMC: tl: %llu gp:%u gc: %u bke_en: %u\n",
			tl, gp, gc, bke_en);
		set_qos_bw_regs(binfo->base, mas_index, th, tm, tl, gp,
			gc, bke_en);
	} else
		/* Clear bandwidth registers */
		set_qos_bw_regs(binfo->base, mas_index, 0, 0, 0, 0, 0,
			bke_en);
}

static int msm_bus_bimc_allocate_commit_data(struct msm_bus_fabric_registration
	*fab_pdata, void **cdata, int ctx)
{
	struct msm_bus_bimc_commit **cd = (struct msm_bus_bimc_commit **)cdata;
	struct msm_bus_bimc_info *binfo =
		(struct msm_bus_bimc_info *)fab_pdata->hw_data;

	MSM_BUS_DBG("Allocating BIMC commit data\n");
	*cd = kzalloc(sizeof(struct msm_bus_bimc_commit), GFP_KERNEL);
	if (!*cd) {
		MSM_BUS_DBG("Couldn't alloc mem for cdata\n");
		return -ENOMEM;
	}

	(*cd)->mas = binfo->cdata[ctx].mas;
	(*cd)->slv = binfo->cdata[ctx].slv;

	return 0;
}

static void *msm_bus_bimc_allocate_bimc_data(struct platform_device *pdev,
	struct msm_bus_fabric_registration *fab_pdata)
{
	struct resource *bimc_mem;
	struct resource *bimc_io;
	struct msm_bus_bimc_info *binfo;
	int i;

	MSM_BUS_DBG("Allocating BIMC data\n");
	binfo = kzalloc(sizeof(struct msm_bus_bimc_info), GFP_KERNEL);
	if (!binfo) {
		WARN(!binfo, "Couldn't alloc mem for bimc_info\n");
		return NULL;
	}

	binfo->qos_freq = fab_pdata->qos_freq;

	binfo->params.nmasters = fab_pdata->nmasters;
	binfo->params.nslaves = fab_pdata->nslaves;
	binfo->params.bus_id = fab_pdata->id;

	for (i = 0; i < NUM_CTX; i++) {
		binfo->cdata[i].mas = kzalloc(sizeof(struct
			msm_bus_node_hw_info) * fab_pdata->nmasters * 2,
			GFP_KERNEL);
		if (!binfo->cdata[i].mas) {
			MSM_BUS_ERR("Couldn't alloc mem for bimc master hw\n");
			kfree(binfo);
			return NULL;
		}

		binfo->cdata[i].slv = kzalloc(sizeof(struct
			msm_bus_node_hw_info) * fab_pdata->nslaves * 2,
			GFP_KERNEL);
		if (!binfo->cdata[i].slv) {
			MSM_BUS_DBG("Couldn't alloc mem for bimc slave hw\n");
			kfree(binfo->cdata[i].mas);
			kfree(binfo);
			return NULL;
		}
	}

	bimc_mem = platform_get_resource(pdev, IORESOURCE_MEM, 0);
	if (!bimc_mem && !fab_pdata->virt) {
		MSM_BUS_ERR("Cannot get BIMC Base address\n");
		kfree(binfo);
		return NULL;
	}

	bimc_io = request_mem_region(bimc_mem->start,
			resource_size(bimc_mem), pdev->name);
	if (!bimc_io) {
		MSM_BUS_ERR("BIMC memory unavailable\n");
		kfree(binfo);
		return NULL;
	}

	binfo->base = ioremap(bimc_mem->start, resource_size(bimc_mem));
	if (!binfo->base) {
		MSM_BUS_ERR("IOremap failed for BIMC!\n");
		release_mem_region(bimc_mem->start, resource_size(bimc_mem));
		kfree(binfo);
		return NULL;
	}

	fab_pdata->hw_data = (void *)binfo;
	return (void *)binfo;
}

static void free_commit_data(void *cdata)
{
	struct msm_bus_bimc_commit *cd = (struct msm_bus_bimc_commit *)cdata;

	kfree(cd->mas);
	kfree(cd->slv);
	kfree(cd);
}

static void msm_bus_bimc_update_bw(struct msm_bus_inode_info *hop,
	struct msm_bus_inode_info *info,
	struct msm_bus_fabric_registration *fab_pdata,
	void *sel_cdata, int *master_tiers,
	long int add_bw)
{
	struct msm_bus_bimc_info *binfo;
	struct msm_bus_bimc_qos_bw qbw;
	int i;
	long int bw;
	int ports = info->node_info->num_mports;
	struct msm_bus_bimc_commit *sel_cd =
		(struct msm_bus_bimc_commit *)sel_cdata;

	MSM_BUS_DBG("BIMC: Update bw for ID %d, with IID: %d: %ld\n",
		info->node_info->id, info->node_info->priv_id, add_bw);

	binfo = (struct msm_bus_bimc_info *)fab_pdata->hw_data;

	if (info->node_info->num_mports == 0) {
		MSM_BUS_DBG("BIMC: Skip Master BW\n");
		goto skip_mas_bw;
	}

	ports = info->node_info->num_mports;
	bw = INTERLEAVED_BW(fab_pdata, add_bw, ports);

	for (i = 0; i < ports; i++) {
		sel_cd->mas[info->node_info->masterp[i]].bw += bw;
		sel_cd->mas[info->node_info->masterp[i]].hw_id =
			info->node_info->mas_hw_id;
		MSM_BUS_DBG("BIMC: Update mas_bw for ID: %d -> %llu\n",
			info->node_info->priv_id,
			sel_cd->mas[info->node_info->masterp[i]].bw);
		if (info->node_info->hw_sel == MSM_BUS_RPM)
			sel_cd->mas[info->node_info->masterp[i]].dirty = 1;
		else {
			if (!info->node_info->qport) {
				MSM_BUS_DBG("No qos ports to update!\n");
				break;
			}
			MSM_BUS_DBG("qport: %d\n", info->node_info->qport[i]);
			qbw.bw = sel_cd->mas[info->node_info->masterp[i]].bw;
			qbw.ws = info->node_info->ws;
			/* Threshold low = 90% of bw */
			qbw.thl = (90 * bw) / 100;
			/* Threshold medium = bw */
			qbw.thm = bw;
			/* Threshold high = 10% more than bw */
			qbw.thh = (110 * bw) / 100;
			/* Check if info is a shared master.
			 * If it is, mark it dirty
			 * If it isn't, then set QOS Bandwidth
			 **/
			msm_bus_bimc_set_qos_bw(binfo,
				info->node_info->qport[i], &qbw);
		}
	}

skip_mas_bw:
	ports = hop->node_info->num_sports;
	MSM_BUS_DBG("BIMC: ID: %d, Sports: %d\n", hop->node_info->priv_id,
		ports);
	if (ports)
		bw = INTERLEAVED_BW(fab_pdata, add_bw, ports);
	else
		return;

	for (i = 0; i < ports; i++) {
		sel_cd->slv[hop->node_info->slavep[i]].bw += bw;
		sel_cd->slv[hop->node_info->slavep[i]].hw_id =
			hop->node_info->slv_hw_id;
		MSM_BUS_DBG("BIMC: Update slave_bw: ID: %d -> %llu\n",
			hop->node_info->priv_id,
			sel_cd->slv[hop->node_info->slavep[i]].bw);
		MSM_BUS_DBG("BIMC: Update slave_bw: index: %d\n",
			hop->node_info->slavep[i]);
		/* Check if hop is a shared slave.
		 * If it is, mark it dirty
		 * If it isn't, then nothing to be done as the
		 * slaves are in bypass mode.
		 **/
		if (hop->node_info->hw_sel == MSM_BUS_RPM) {
			MSM_BUS_DBG("Slave dirty: %d, slavep: %d\n",
				hop->node_info->priv_id,
				hop->node_info->slavep[i]);
			sel_cd->slv[hop->node_info->slavep[i]].dirty = 1;
		}
	}
}

static int msm_bus_bimc_commit(struct msm_bus_fabric_registration
	*fab_pdata, void *hw_data, void **cdata)
{
	MSM_BUS_DBG("\nReached BIMC Commit\n");
	msm_bus_remote_hw_commit(fab_pdata, hw_data, cdata);
	return 0;
}

static int msm_bus_bimc_mas_init(struct msm_bus_bimc_info *binfo,
	struct msm_bus_inode_info *info)
{
	int i;
	struct msm_bus_bimc_qos_mode *qmode;
	qmode = kzalloc(sizeof(struct msm_bus_bimc_qos_mode),
		GFP_KERNEL);
	if (!qmode) {
		MSM_BUS_WARN("Couldn't alloc prio data for node: %d\n",
			info->node_info->id);
		return -ENOMEM;
	}

	switch (info->node_info->mode) {
	case BIMC_QOS_MODE_FIXED:
		qmode->fixed.prio_level = info->node_info->prio_lvl;
		qmode->fixed.areq_prio_rd = info->node_info->prio_rd;
		qmode->fixed.areq_prio_wr = info->node_info->prio_wr;
		break;
	default:
		break;
	}

	info->hw_data = (void *)qmode;
	if (!info->node_info->qport) {
		MSM_BUS_DBG("No QoS Ports to init\n");
		return 0;
	}

	for (i = 0; i < info->node_info->num_mports; i++) {
		/* If in bypass mode, update priority */
		if (info->node_info->mode != BIMC_QOS_MODE_BYPASS)
			msm_bus_bimc_set_qos_prio(binfo, info->node_info->
				qport[i], info->node_info->mode, qmode);

		/* If in fixed mode, update bandwidth */
		if (info->node_info->mode != BIMC_QOS_MODE_FIXED) {
			struct msm_bus_bimc_qos_bw qbw;
			qbw.ws = info->node_info->ws;
			msm_bus_bimc_set_qos_bw(binfo,
				info->node_info->qport[i], &qbw);
		}

		/* set mode */
		msm_bus_bimc_set_qos_mode(binfo, info->node_info->qport[i],
			info->node_info->mode);
	}

	return 0;
}

static void msm_bus_bimc_node_init(void *hw_data,
	struct msm_bus_inode_info *info)
{
	struct msm_bus_bimc_info *binfo =
		(struct msm_bus_bimc_info *)hw_data;

	if (!IS_SLAVE(info->node_info->priv_id))
		msm_bus_bimc_mas_init(binfo, info);
}

static int msm_bus_bimc_port_halt(uint32_t haltid, uint8_t mport)
{
	return 0;
}

static int msm_bus_bimc_port_unhalt(uint32_t haltid, uint8_t mport)
{
	return 0;
}


int msm_bus_bimc_hw_init(struct msm_bus_fabric_registration *pdata,
	struct msm_bus_hw_algorithm *hw_algo)
{
	/* Set interleaving to true by default */
	MSM_BUS_DBG("\nInitializing BIMC...\n");
	pdata->il_flag = true;
	hw_algo->allocate_commit_data = msm_bus_bimc_allocate_commit_data;
	hw_algo->allocate_hw_data = msm_bus_bimc_allocate_bimc_data;
	hw_algo->node_init = msm_bus_bimc_node_init;
	hw_algo->free_commit_data = free_commit_data;
	hw_algo->update_bw = msm_bus_bimc_update_bw;
	hw_algo->commit = msm_bus_bimc_commit;
	hw_algo->port_halt = msm_bus_bimc_port_halt;
	hw_algo->port_unhalt = msm_bus_bimc_port_unhalt;
	/* BIMC slaves are shared. Slave registers are set through RPM */
	if (!pdata->ahb)
		pdata->rpm_enabled = 1;
	return 0;
}

