/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX/HB9DRD
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef FSK441FileReceive_H
#define	FSK441FileReceive_H

#include "FSK441Receive.h"
#include "FSK441Levels.h"
#include "FSK441Spectrum.h"
#include "FSK441Message.h"

class CFSK441FileReceive : public CFSK441Receive {

    public:
	CFSK441FileReceive();
	virtual ~CFSK441FileReceive();

	virtual void setFileName(const wxString& fileName);
	virtual void openSoundDevice();
	virtual CSoundDev* getSoundDevice()
	{
		wxASSERT(m_soundDev != NULL);
		return m_soundDev;
	}
	virtual void closeSoundDevice();

	virtual bool getEndTime();

	virtual void recordAudio(const wxString& id, double* audioData, int length) const;
	virtual void showLevels(CFSK441Levels* levels) const;
	virtual void showSpectrum(CFSK441Spectrum* spectrum) const;
	virtual void receiveMessage(CFSK441Message* message) const;

	virtual wxString createId();

	virtual void error(const wxString& text);

    private:
	wxString   m_fileName;
	CSoundDev* m_soundDev;
};

#endif
