/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX/HB9DRD
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "FSK441Preferences.h"

#include "FSK441App.h"

#include "fsk441/FSK441Defs.h"

const int BORDER_SIZE = 5;

BEGIN_EVENT_TABLE(CFSK441Preferences, wxDialog)
	EVT_BUTTON(wxID_OK,     CFSK441Preferences::onOK)
	EVT_BUTTON(wxID_CANCEL, CFSK441Preferences::onCancel)
END_EVENT_TABLE()

CFSK441Preferences::CFSK441Preferences(wxWindow* parent, int id) :
wxDialog(parent, id, wxT("FSK441 Preferences")),
m_personal(NULL),
m_message(NULL),
m_sound(NULL),
m_ptt(NULL),
m_protocol(NULL)
{
	wxBoxSizer* mainSizer = new wxBoxSizer(wxVERTICAL);

	wxNotebook* noteBook = new wxNotebook(this, -1);
	wxNotebookSizer* sizer = new wxNotebookSizer(noteBook);

	wxString callsign, locator;
	::wxGetApp().getPersonal(callsign, locator);
	m_personal = new CPersonalPreferences(noteBook, -1, callsign, locator);
	noteBook->AddPage(m_personal, wxT("Personal"), true);

	wxString* messages = new wxString[FSK441_MAX_MESSAGES];
	for (int i = 0; i < FSK441_MAX_MESSAGES; i++)
		messages[i] = ::wxGetApp().getOriginalMessage(i);
	m_message = new CMessagePreferences(noteBook, -1, messages, FSK441_MAX_MESSAGES, FSK441_MAX_MESSAGE_LENGTH);
	noteBook->AddPage(m_message, wxT("Messages"), false);
	delete[] messages;

	wxString soundType, soundFileName;
	int soundBits;
	::wxGetApp().getSound(soundType, soundFileName, soundBits);
	m_sound = new CSoundPreferences(noteBook, -1, soundFileName, soundBits);
	noteBook->AddPage(m_sound, wxT("Sound"), false);

	wxString pttType, pttDevice;
	::wxGetApp().getPTT(pttType, pttDevice);
	m_ptt = new CPTTPreferences(noteBook, -1, pttType, pttDevice);
	noteBook->AddPage(m_ptt, wxT("PTT"), false);

	bool singleTone = ::wxGetApp().getSingleTone();
	m_protocol = new CFSK441ProtocolPreferences(noteBook, -1, singleTone);
	noteBook->AddPage(m_protocol, wxT("FSK441"), false);

	mainSizer->Add(sizer, 1, wxALL | wxGROW, BORDER_SIZE);

	wxBoxSizer* buttonSizer = new wxBoxSizer(wxHORIZONTAL);

	wxButton* okButton     = new wxButton(this, wxID_OK, wxT("OK"));
	okButton->SetDefault();
	buttonSizer->Add(okButton, 0, wxALL | wxALIGN_RIGHT, BORDER_SIZE);

	wxButton* cancelButton = new wxButton(this, wxID_CANCEL, wxT("Cancel"));
	buttonSizer->Add(cancelButton, 0, wxALL | wxALIGN_RIGHT, BORDER_SIZE);

	mainSizer->Add(buttonSizer, 0, wxALL | wxALIGN_RIGHT, BORDER_SIZE);

	SetAutoLayout(true);
	Layout();

	mainSizer->Fit(this);
	mainSizer->SetSizeHints(this);

	SetSizer(mainSizer);
}

CFSK441Preferences::~CFSK441Preferences()
{
}

void CFSK441Preferences::onOK(const wxCommandEvent& event)
{
	wxASSERT(m_personal != NULL);
	wxASSERT(m_message != NULL);
	wxASSERT(m_sound != NULL);
	wxASSERT(m_ptt != NULL);
	wxASSERT(m_protocol != NULL);

	if (!m_personal->isCallsignValid()) {
		wxMessageDialog dialog(this, wxT("The Callsign is not valid"), wxT("FSK441 Error"), wxICON_ERROR);
		dialog.ShowModal();
		return;
	}

	if (!m_personal->isLocatorValid()) {
		wxMessageDialog dialog(this, wxT("The Locator is not valid"), wxT("FSK441 Error"), wxICON_ERROR);
		dialog.ShowModal();
		return;
	}

	if (!m_ptt->isValid()) {
		wxMessageDialog dialog(this, wxT("The PTT device is not allowed to be empty"), wxT("FSK441 Error"), wxICON_ERROR);
		dialog.ShowModal();
		return;
	}

	if (!m_sound->isValid()) {
		wxMessageDialog dialog(this, wxT("The sound card device is not allowed to be empty"), wxT("FSK441 Error"), wxICON_ERROR);
		dialog.ShowModal();
		return;
	}

	for (int i = 0; i < FSK441_MAX_MESSAGES; i++) {
		if (!m_message->isValid(i)) {
			wxMessageDialog dialog(this, wxT("A message is not valid"), wxT("FSK441 Error"), wxICON_ERROR);
			dialog.ShowModal();
			return;
		}
	}

	wxString callsign = m_personal->getCallsign();
	wxString locator  = m_personal->getLocator();
	::wxGetApp().setPersonal(callsign, locator);

	wxString pttType   = m_ptt->getType();
	wxString pttDevice = m_ptt->getDevice();
	::wxGetApp().setPTT(pttType, pttDevice);

	wxString soundFileName = m_sound->getFileName();
	int      soundBits     = m_sound->getBits();
	::wxGetApp().setSound(wxT("card"), soundFileName, soundBits);

	for (int i = 0; i < FSK441_MAX_MESSAGES; i++) {
		wxString message = m_message->getMessage(i);
		::wxGetApp().setMessage(i, message);
	}

	bool singleTone = m_protocol->getSingleTone();
	::wxGetApp().setSingleTone(singleTone);

	if (IsModal()) {
		EndModal(wxID_OK);
	} else {
		SetReturnCode(wxID_OK);
		Show(false);
	}
}

void CFSK441Preferences::onCancel(const wxCommandEvent& event)
{
	if (IsModal()) {
		EndModal(wxID_CANCEL);
	} else {
		SetReturnCode(wxID_CANCEL);
		Show(false);
	}
}
