/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX/HB9DRD
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "JT44Lookups.h"

#include <wx/object.h>		// Not sure why ?
#include <wx/debug.h>

CJT44Lookups::CJT44Lookups()
{
}

CJT44Lookups::~CJT44Lookups()
{
}

bool CJT44Lookups::lookupSync(int n) const
{
	return lookupPosition(n) == -1;
}

int CJT44Lookups::lookupChar(wxChar c) const
{
	for (int i = 0; i < 69; i++) {
		if (jt44Table[i].c == c)
			return jt44Table[i].n;
	}

	return -1;
}

wxChar CJT44Lookups::lookupTone(int n) const
{
	for (int i = 0; i < 69; i++) {
		if (jt44Table[i].n == n)
			return jt44Table[i].c;
	}

	return wxChar(0);
}

int CJT44Lookups::lookupPosition(int n) const
{
	wxASSERT(n >= 0 && n <= 134);

	return positionTable[n];
}
