/****************************************************************************
** $Id: bilderCW.C 3181 2008-04-01 15:19:44Z karstenm $
**
*****************************************************************************/

#include <qwidget.h>
#include <qlayout.h>
#include <qevent.h> 
#include <qwhatsthis.h>
#include <qtooltip.h>
#include <qmessagebox.h>
#include <qpainter.h>
#include <qvaluelist.h> 
#include <qgrid.h>
#include <qbitmap.h>
#include <qtabwidget.h> 
#include <qinputdialog.h>

#include <viaio/Vlib.h>
#include <viaio/VImage.h>
#include <viaio/mu.h>
#include <viaio/option.h>

#include "bilderCW.h"
#include "VLTools.h"
#include "pictureView.h"
#include "lView.h"

// cb_bits and cm_bits were generated by X bitmap program.

#define cb_width  32
#define cb_height 32
static unsigned char cb_bits[] = {              // cursor bitmap
  0x00, 0x80, 0x01, 0x00, 0x00, 0xc0, 0x02, 0x00, 0x00, 0x60, 0x03, 0x00,
  0x00, 0xe0, 0x00, 0x00, 0x00, 0xa0, 0x00, 0x00, 0x00, 0xa0, 0x08, 0x00,
  0x00, 0xa0, 0x13, 0x00, 0x80, 0x63, 0x60, 0x00, 0x40, 0x4c, 0x84, 0x00,
  0x30, 0x30, 0x11, 0x01, 0x10, 0x12, 0x40, 0x02, 0x48, 0x00, 0x01, 0x04,
  0x08, 0x24, 0x4a, 0x04, 0x04, 0x41, 0x00, 0x09, 0x4c, 0x08, 0x48, 0x04,
  0x84, 0x80, 0x00, 0x04, 0x14, 0x12, 0x8a, 0x04, 0x04, 0x40, 0x20, 0x04,
  0x24, 0x09, 0x81, 0x04, 0x04, 0x20, 0x04, 0x00, 0x84, 0x84, 0x10, 0x02,
  0x24, 0x10, 0x22, 0x01, 0x08, 0x41, 0x00, 0x01, 0x30, 0x04, 0x89, 0x00,
  0x80, 0x20, 0x40, 0x00, 0x40, 0x08, 0x2a, 0x00, 0x80, 0x01, 0x20, 0x00,
  0x00, 0xfe, 0x23, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x28, 0x00,
  0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, };

#define cm_width  32
#define cm_height 32
static unsigned char cm_bits[] = {              // cursor bitmap mask
  0x00, 0x80, 0x01, 0x00, 0x00, 0xc0, 0x03, 0x00, 0x00, 0xe0, 0x03, 0x00,
  0x00, 0xe0, 0x00, 0x00, 0x00, 0xe0, 0x00, 0x00, 0x00, 0xe0, 0x0c, 0x00,
  0x00, 0xe0, 0x1f, 0x00, 0x80, 0xe3, 0x7f, 0x00, 0xc0, 0xcf, 0xff, 0x00,
  0xf0, 0xff, 0xff, 0x01, 0xf0, 0xff, 0xff, 0x03, 0xf8, 0xff, 0xff, 0x07,
  0xf8, 0xff, 0xff, 0x07, 0xfc, 0xff, 0xff, 0x0f, 0xfc, 0xff, 0xff, 0x07,
  0xfc, 0xff, 0xff, 0x07, 0xfc, 0xff, 0xff, 0x07, 0xfc, 0xff, 0xff, 0x07,
  0xfc, 0xff, 0xff, 0x07, 0xfc, 0xff, 0xff, 0x03, 0xfc, 0xff, 0xff, 0x03,
  0xfc, 0xff, 0xff, 0x01, 0xf8, 0xff, 0xff, 0x01, 0xf0, 0xff, 0xff, 0x00,
  0xc0, 0xff, 0x7f, 0x00, 0xc0, 0xff, 0x3f, 0x00, 0x80, 0xff, 0x3f, 0x00,
  0x00, 0xfe, 0x3f, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x38, 0x00,
  0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, };

extern VImage *fnc, *src;


BilderCW::BilderCW( QWidget *parent, const char *name, prefs *pr_, VString pat, double *ca, double *cp, double *extent, double *fixpoint, const char *version, int *scalingfaktor )
  : QWidget( parent, name ), pr(pr_), pat_m(pat), version_m(version), ca_m(ca), cp_m(cp), extent_m(extent), fixpoint_m(fixpoint), scalingfaktor_m(scalingfaktor)
{
  if (pr->verbose) fprintf(stderr,"Starting bilderCW...\n");

    
  rows=VImageNRows(src[0]);
  columns=VImageNColumns(src[0]);
  bands=VImageNFrames(src[0]);
  
  if (fnc[0]) {
    fnc_rows=VImageNRows(fnc[pr->active]);
    fnc_columns=VImageNColumns(fnc[pr->active]);
    fnc_bands=VImageNFrames(fnc[pr->active]);
  } else {
    fnc_rows=0;
    fnc_columns=0;
    fnc_bands=0;
  }
  

  if (pr->hgfarbe[0]==1) {
    setPalette( QPalette( QColor( 255, 255, 255 ) ) );
  } else {
    setPalette( QPalette( QColor( 0,0,0) ) );
  }
  hlayout = new QHBoxLayout( this, 0 );
  layout = new QGridLayout( hlayout, 0, (int)pr->infilenum/4, 0);

  pr->ogl=0;
  if ( QGLFormat::hasOpenGL() && pr->graph[0] ) pr->ogl=1;
  
  QBitmap cb( cb_width, cb_height, cb_bits, TRUE );
  QBitmap cm( cm_width, cm_height, cm_bits, TRUE );
  QCursor custom( cb, cm );                   // create bitmap cursor
  if (pr->verbose) qDebug("GL-Support %d\n", pr->ogl);

  files=pr->infilenum;
  if (pr->infilenum>=pr->zmapfilenum) {
    if (pr->infilenum>pr->zmapfilenum && pr->zmapfilenum>1) {
      QMessageBox::warning( this, "error",
			  "error\n" );
    }
    files=pr->infilenum;
  } else {
    if (pr->infilenum<pr->zmapfilenum && pr->infilenum>1) {
      QMessageBox::warning( this, "error",
			  "error\n" );
    }
    else
      files=pr->zmapfilenum;
  }

  bild1 = (pictureView **) VMalloc(sizeof(pictureView *) * (files+1) );
  bild2 = (pictureView **) VMalloc(sizeof(pictureView *) * (files+1) );
  bild3 = (pictureView **) VMalloc(sizeof(pictureView *) * (files+1) );
  ogl = (MyGLDrawer **) VMalloc(sizeof(MyGLDrawer *) * (files+1) );

  if (fnc[0]) {
    pr->slidefaktor[0] = 1000.0/(pr->pmax-pr->zeropoint);
    pr->slidefaktor[1] = 1000.0/(pr->nmax+pr->zeropoint);

    posslide = new QSlider( QSlider::Vertical, this,
			    "positive" );
    posslide->setPalette( parent->palette() );
    posslide->setCursor( pointingHandCursor );
    QToolTip::add( posslide, QRect( 0, 0, 2, 2 ), "positive slider" );
    QWhatsThis::add( posslide, "This is a Slider.\n"
		     "Here you can change the positive threshold for the z-value.");
    negslide = new QSlider( QSlider::Vertical, this,
			    "negative" );
    negslide->setPalette( parent->palette() );
    negslide->setCursor( pointingHandCursor );
    QToolTip::add( negslide, QRect( 0, 0, 2, 2 ), "negative slider" );
    QWhatsThis::add( negslide, "This is a Slider.\n"
		     "Here you can change the negative threshold for the z-value.");
    posslide->setGeometry( 10, 80, 100, 15 );
    posslide->setRange( int(pr->zeropoint*pr->slidefaktor[0]), int(pr->pmax*pr->slidefaktor[0]) );
    posslide->setValue( int(pr->thresh*pr->slidefaktor[0]) );
    posslide->setTickmarks(QSlider::TickSetting( 2 ));
    posslide->setTickInterval((int)100);
    posslide->setFocusPolicy ( QWidget::NoFocus);
    negslide->setGeometry( 10, 80, 100, 15 );
    negslide->setRange( int(-pr->zeropoint*pr->slidefaktor[1]), int(pr->nmax*pr->slidefaktor[1]) );
    if ( pr->thresh )
      negslide->setValue( int(pr->nmax*pr->slidefaktor[1]) );
    else
      negslide->setValue( int(pr->zeropoint*pr->slidefaktor[1]) );
    negslide->setTickmarks(QSlider::TickSetting( 2 ));
    negslide->setTickInterval((int)100);
    negslide->setFocusPolicy ( QWidget::NoFocus);
  }

	     

  gLayout(this);
  if (pr->verbose) fprintf(stderr,"end of bilderCW.C\n");
}

void BilderCW::gLayout(QWidget *parent) {

  for (int i=0;i<files;i++) {
    QBoxLayout *topLayout = new QHBoxLayout( layout, 0 );
    //    if (files<=1) {
    flowLayout = new SimpleFlow( topLayout, -1);
    //}
    if ( pr->thresh )
      bild1[i] = new pictureView( parent, "coronar", pr, 1, i, files, ca_m, cp_m, extent_m, fixpoint_m, 0, pr->thresh, pr->nmax, scalingfaktor_m );
    else
      bild1[i] = new pictureView( parent, "coronar", pr, 1, i, files, ca_m, cp_m, extent_m, fixpoint_m, 0, 0, 0, scalingfaktor_m );
    if (!pr->picture[0]) bild1[i]->hide();
    bild1[i]->setCursor( crossCursor );
    QToolTip::add( bild1[i], QRect( 0, 0, 2, 2 ), "coronar" );
    QWhatsThis::add( bild1[i], "This is the <b>coronar</b> view.");
    if ( pr->thresh )
      bild2[i] = new pictureView( parent, "sagittal", pr, 2, i, files, ca_m, cp_m, extent_m, fixpoint_m, 0, pr->thresh, pr->nmax, scalingfaktor_m );
    else
      bild2[i] = new pictureView( parent, "sagittal", pr, 2, i, files, ca_m, cp_m, extent_m, fixpoint_m, 0, 0, 0, scalingfaktor_m );
    if (!pr->picture[1]) bild2[i]->hide();
    bild2[i]->setCursor( crossCursor );
    QToolTip::add( bild2[i], QRect( 0, 0, 2, 2 ), "sagittal" );
    QWhatsThis::add( bild2[i], "This is the <b>sagittal</b> view.");
    if ( pr->thresh )
      bild3[i] = new pictureView( parent, "axial", pr, 3, i, files, ca_m, cp_m, extent_m, fixpoint_m, 0, pr->thresh, pr->nmax, scalingfaktor_m );
    else
      bild3[i] = new pictureView( parent, "axial", pr, 3, i, files, ca_m, cp_m, extent_m, fixpoint_m, 0, 0, 0, scalingfaktor_m );
    if (!pr->picture[2]) bild3[i]->hide();
    bild3[i]->setCursor( crossCursor );
    QToolTip::add( bild3[i], QRect( 0, 0, 2, 2 ), "axial" );
    QWhatsThis::add( bild3[i], "This is the <b>axial</b> view.");

    if (pr->ogl) {
      ogl[i]=new MyGLDrawer( parent, "opengl", src, fnc, pr, 0, 0, ca_m, cp_m, extent_m, i); /* "i" added by A. Hagert */
      ogl[i]->setCursor( crossCursor );
      if (!pr->picture[3]) {
	ogl[i]->hide();
      }
    }
    
    // f->resize(100,100);
    //ogl->setCursor( crossCursor );
    //    if (files<=10) {

    flowLayout->add( bild1[i] );
    flowLayout->add( bild2[i] );
    flowLayout->add( bild3[i] );
    
    if (pr->ogl) {
      flowLayout->add( ogl[i] );
    }
    //topLayout->addWidget( f );
    /*    } else {
	  topLayout->addWidget( bild1[i],1 );
	  topLayout->addWidget( bild2[i],1 );
	  topLayout->addWidget( bild3[i],1 );
	  
	  if (pr->ogl) {
	  topLayout->addWidget( ogl[i],1 );
	  }
	  }*/
  } 
  
  if (pr->ogl) {
   rc1= new QScrollBar(-180,180,1,10,0,Vertical,this);
    rc1->setPalette( QPalette( QColor( lightGray ) ) );
    rc1->setCursor( pointingHandCursor );
    rc2= new QScrollBar(-180,180,1,10,180,Vertical,this);
    rc2->setPalette( QPalette( QColor( lightGray ) ) );
    rc2->setCursor( pointingHandCursor );
    rc3= new QScrollBar(-180,180,1,10,180,Vertical,this);
    rc3->setPalette( QPalette( QColor( lightGray ) ) );
    rc3->setCursor( pointingHandCursor );
    la1 = new QLabel ( " x", this, "x", 0 );
    la1->setPalette( QPalette( QColor( lightGray ) ) );
    la2 = new QLabel ( " y", this, "y", 0 );
    la2->setPalette( QPalette( QColor( lightGray ) ) );
    la3 = new QLabel ( " z", this, "z", 0 );
    la3->setPalette( QPalette( QColor( lightGray ) ) );
    if (!pr->picture[3]) {
      //rc1->hide();
      //rc2->hide();
      //rc3->hide();
      //la1->hide();
      //la2->hide();
      //la3->hide();
    }
    
    QToolTip::add( ogl[0], QRect( 0, 0, 2, 2 ), "openGL" );
    QWhatsThis::add( ogl[0], "openGL");
    
    QBoxLayout *oglhlayout = new QHBoxLayout();
    hlayout->addLayout( oglhlayout, 0 );
    QBoxLayout *oglvlayout = new QVBoxLayout( oglhlayout, 0 );
    oglvlayout->addWidget( rc1,1 );
    oglvlayout->addWidget( la1,0 );
    oglvlayout->addWidget( rc2,1 );
    oglvlayout->addWidget( la2,0 );
    oglvlayout->addWidget( rc3,1 );
    oglvlayout->addWidget( la3,0 );
    for (int i=0;i<files;i++) {
      QObject::connect( rc1, SIGNAL(valueChanged(int)),ogl[i],SLOT(setXRotation(int)) );
      QObject::connect( rc2, SIGNAL(valueChanged(int)),ogl[i],SLOT(setYRotation(int)) );
      QObject::connect( rc3, SIGNAL(valueChanged(int)),ogl[i],SLOT(setZRotation(int)) );
      /* added by A. Hagert -> scrollbars listen on mouserotation of the graph */
      QObject::connect( ogl[i], SIGNAL(mouseRotated(int, int, int)),this,SLOT(SetXYZScrollbars(int, int, int)) );
    }
  }
  
  if (fnc[0]) {
    hlayout->addWidget( posslide, 0 );
    hlayout->addWidget( negslide, 0 );
  }

  for (int i=0;i<files;i++) {
    if (fnc[0]) {
      connect( posslide, SIGNAL(valueChanged(int)), bild1[i], SLOT(posChanged(int)) );
      connect( posslide, SIGNAL(valueChanged(int)), bild2[i], SLOT(posChanged(int)) );     
      connect( posslide, SIGNAL(valueChanged(int)), bild3[i], SLOT(posChanged(int)) );
      connect( posslide, SIGNAL(sliderReleased()), this, SLOT(SlideReleased()) );
      if (pr->ogl) {
	connect( posslide, SIGNAL(valueChanged(int)), ogl[i], SLOT(posChanged(int)) );
	connect( posslide, SIGNAL(sliderReleased()), ogl[i], SLOT(posChanged()) );
      }
      connect( negslide, SIGNAL(valueChanged(int)), bild1[i], SLOT(negChanged(int)) );
      connect( negslide, SIGNAL(valueChanged(int)), bild2[i], SLOT(negChanged(int)) );     
      connect( negslide, SIGNAL(valueChanged(int)), bild3[i], SLOT(negChanged(int)) );
      connect( negslide, SIGNAL(sliderReleased()), this, SLOT(SlideReleased()) );
      if (pr->ogl) {
	connect( negslide, SIGNAL(valueChanged(int)), ogl[i], SLOT(negChanged(int)) );
	connect( negslide, SIGNAL(sliderReleased()), ogl[i], SLOT(negChanged()) );
      }
    }
    if (pr->ogl) {
      connect( ogl[i], SIGNAL(zeichneOGL()), this, SLOT(nowsliderChange()) );
    }
    for (int j=0;j<files;j++) {
      connect( bild1[j], SIGNAL(viewChanged()), bild1[i], SLOT(repaintf()) );
      connect( bild1[j], SIGNAL(viewChanged()), bild2[i], SLOT(repaintf()) );
      connect( bild1[j], SIGNAL(viewChanged()), bild3[i], SLOT(repaintf()) );
      connect( bild2[j], SIGNAL(viewChanged()), bild1[i], SLOT(repaintf()) );
      connect( bild2[j], SIGNAL(viewChanged()), bild2[i], SLOT(repaintf()) );
      connect( bild2[j], SIGNAL(viewChanged()), bild3[i], SLOT(repaintf()) );
      connect( bild3[j], SIGNAL(viewChanged()), bild1[i], SLOT(repaintf()) );
      connect( bild3[j], SIGNAL(viewChanged()), bild2[i], SLOT(repaintf()) );
      connect( bild3[j], SIGNAL(viewChanged()), bild3[i], SLOT(repaintf()) );
      
      if (pr->ogl) {
	connect( bild1[j], SIGNAL(viewChanged()), ogl[i], SLOT(crossChange()) );
	connect( bild2[j], SIGNAL(viewChanged()), ogl[i], SLOT(crossChange()) );
	connect( bild3[j], SIGNAL(viewChanged()), ogl[i], SLOT(crossChange()) );
	connect( ogl[j], SIGNAL(kreuzBewegt()), bild1[i], SLOT(repaintf()) );
	connect( ogl[j], SIGNAL(kreuzBewegt()), bild2[i], SLOT(repaintf()) );
	connect( ogl[j], SIGNAL(kreuzBewegt()), bild3[i], SLOT(repaintf()) );
	connect( ogl[j], SIGNAL(zeichneOGL()), ogl[i], SLOT(updateGL()) );
      }
    }
  }

}

void BilderCW::nowsliderChange() {
  /*
    rc1->setValue ( ogl[0]->xRot );
    rc2->setValue ( ogl[0]->yRot );
    rc3->setValue ( ogl[0]->zRot );
  */
  if (pr->sw2) {
    pr->slidefaktor[0] = 1000.0/(pr->pmax-pr->zeropoint);
    pr->slidefaktor[1] = 1000.0/(pr->nmax+pr->zeropoint);
    posslide->setRange( int(pr->zeropoint*pr->slidefaktor[0]), int(pr->pmax*pr->slidefaktor[0]) );
    posslide->setTickInterval((int)100);
    if (posslide->value()<pr->zeropoint*pr->slidefaktor[0] || posslide->value()>pr->pmax*pr->slidefaktor[0] )
      posslide->setValue( int(pr->zeropoint*pr->slidefaktor[0]) );
    negslide->setRange( int(-pr->zeropoint*pr->slidefaktor[1]), int(pr->nmax*pr->slidefaktor[1]) );
    negslide->setTickInterval((int)100);
    if (negslide->value()<-pr->zeropoint*pr->slidefaktor[1] || negslide->value()>pr->nmax*pr->slidefaktor[1] )
      negslide->setValue( int(-pr->zeropoint*pr->slidefaktor[1]) );
  }
}

void BilderCW::hideLayout(QWidget *parent) {

  for (int i=0;i<pr->files;i++) {
    if (!pr->picture[0]) bild1[i]->hide(); else bild1[i]->show();
    if (!pr->picture[1]) bild2[i]->hide(); else bild2[i]->show();
    if (!pr->picture[2]) bild3[i]->hide(); else bild3[i]->show();
    if (pr->ogl) {
      if (!pr->picture[3]) {
	ogl[i]->hide();
	//rc1->hide();rc2->hide();rc3->hide();
	//la1->hide();la2->hide();la3->hide();
      } else {
	ogl[i]->show();
	rc1->show();rc2->show();rc3->show();
	la1->show();la2->show();la3->show();
      }
    }
  }
}

void BilderCW::print()
{
  QMessageBox::warning( this, "Warning",
  "Printing not yet implemented.\nContact the Lipsia group if necessary.");
  return;

  printer = new QPrinter;
  printer->setPrintProgram("lpr");
  int pm1w=bild1[0]->get_image().width();
  int pm2w=bild2[0]->get_image().width();
  //int pm3w=bild3[0]->image.width();
  int pm1h=bild1[0]->get_image().height();
  //int pm2h=bild2[0]->image.height();
  int pm3h=bild3[0]->get_image().height();

  if ( printer->setup(this) ) {  
    
    QPainter p;
    p.begin( printer );         
    //QFontMetrics fm = p.fontMetrics();
    //QPaintDeviceMetrics metrics( printer );  
    p.drawText(0,40, tr("printed by \"vlview %1\"").arg(version_m));
    for (int i=0;i<files;i++) {
      p.drawImage(0, 60+i*pm3h, bild1[i]->get_image());
      p.drawImage(0+pm1w, 60+i*pm3h, bild2[i]->get_image());
      p.drawImage(0+pm1w+pm2w, 60+i*pm3h, bild3[i]->get_image());
      if (pr->hgfarbe[0]==0) p.fillRect(0,60+pm1h+i*pm3h,pm1w+pm2w,pm3h-pm1h, QColor(0,0,0));
    }
  

    p.drawPixmap(1, 60+pm3h-32+(files-1)*pm3h, bild1[0]->cpm);
    p.drawText(0, 80+files*pm3h, tr("patient: \"%1\"").arg(pat_m));
    p.drawText(0, 100+files*pm3h, tr("pixel coordinates: \"X:%1 Y:%2 Z:%3\"").arg(pr->cursorp[0]).arg(pr->cursorp[1]).arg(pr->cursorp[2]));    
    p.end();   
  } else {
    //QMessageBox::about( this, "Printing","Printing aborted\n");    
  }
}

void BilderCW::setInterpolNN()
{
  pr->mousemove=0;
  pr->interpoltype=0;
  for (int j=0;j<files;j++) {
    bild1[j]->changeInterpol(ip_nn);
    bild1[j]->repaintf();
    bild2[j]->changeInterpol(ip_nn);
    bild2[j]->repaintf();
    bild3[j]->changeInterpol(ip_nn);
    bild3[j]->repaintf();
  }
	
}

void BilderCW::setInterpolBilin()
{
  pr->mousemove=0;
  pr->interpoltype=1;
  for (int j=0;j<files;j++) {
    bild1[j]->changeInterpol(ip_bilin);
    bild1[j]->repaintf();
    bild2[j]->changeInterpol(ip_bilin);
    bild2[j]->repaintf();
    bild3[j]->changeInterpol(ip_bilin);
    bild3[j]->repaintf();
  }
	
}
	
void BilderCW::setInterpolBicub()
{
  pr->mousemove=0;
  pr->interpoltype=2;
  for (int j=0;j<files;j++) {
    bild1[j]->changeInterpol(ip_bicub);
    bild1[j]->repaintf();
    bild2[j]->changeInterpol(ip_bicub);
    bild2[j]->repaintf();
    bild3[j]->changeInterpol(ip_bicub);
    bild3[j]->repaintf();
  }
	
}

void BilderCW::setInterpolBicub6()
{
  pr->mousemove=0;
  pr->interpoltype=3;
  for (int j=0;j<files;j++) {
    bild1[j]->changeInterpol(ip_bicub_6);
    bild1[j]->repaintf();
    bild2[j]->changeInterpol(ip_bicub_6);
    bild2[j]->repaintf();
    bild3[j]->changeInterpol(ip_bicub_6);
    bild3[j]->repaintf();
  }
	
}

void BilderCW::setInterpolBSpline()
{
  pr->mousemove=0;
  pr->interpoltype=4;
  for (int j=0;j<files;j++) {
    bild1[j]->changeInterpol(ip_bspline);
    bild1[j]->repaintf();
    bild2[j]->changeInterpol(ip_bspline);
    bild2[j]->repaintf();
    bild3[j]->changeInterpol(ip_bspline);
    bild3[j]->repaintf();
  }
	
}




void BilderCW::setVoxelSystem(int i)
{
  pr->talairach=0;
  if (i==0) pr->pixelco=1;                           //ana
  if (i==1) pr->pixelco=0;                           //mm
  if (i==2 && pr->sw2>0.5) pr->pixelco=2;            //zmap
  if (i==3 && pr->talairachoff==0)  pr->talairach=1; //talairach
 
  if (pr->only_sulci==1)
    ogl[0]->talCross(float(pr->cursorp[0]),float(pr->cursorp[1]),float(pr->cursorp[2]));
  else {
    talCross(int(pr->cursorp[0]),int(pr->cursorp[1]),int(pr->cursorp[2])); 
    talEcht(int(pr->cursorp[0]),int(pr->cursorp[1]),int(pr->cursorp[2]));
  }
  emit setVoxelBox();
}

	
void BilderCW::zoomplus()
{
  if (pr->bildzoom<8) pr->bildzoom *= 1.05;
  for (int j=0;j<files;j++) {
    bild1[j]->repaintf();
    bild2[j]->repaintf();
    bild3[j]->repaintf();
  }
}

void BilderCW::zoomminus()
{
  if (pr->bildzoom>1.05) pr->bildzoom /= 1.05;
  else pr->bildzoom=1;
  for (int j=0;j<files;j++) {
    bild1[j]->repaintf();
    bild2[j]->repaintf();
    bild3[j]->repaintf();
  }
}

void BilderCW::zoomplusdouble()
{
  if (pr->bildzoom<8) pr->bildzoom *= 2.0;
  for (int j=0;j<files;j++) {
    bild1[j]->repaintf();
    bild2[j]->repaintf();
    bild3[j]->repaintf();
  }
}

void BilderCW::zoomminusdouble()
{
  if (pr->bildzoom>2) pr->bildzoom /= 2.0;
  else pr->bildzoom=1;
  for (int j=0;j<files;j++) {
    bild1[j]->repaintf();
    bild2[j]->repaintf();
    bild3[j]->repaintf();
  }
}

void BilderCW::coordIN() {
  bool ok = FALSE;
  char *token=NULL;
  int x=(int)rint(pr->cursorp[0]),y=(int)rint(pr->cursorp[1]),z=(int)rint(pr->cursorp[2]); // rint added by A. Hagert (for float-graphs)

  int arr[10];
  QString s;
  if (pr->talairach==1 && pr->atlas==1) {
    s = QInputDialog::getText( tr( "Talairach coordinates [ X Y Z ]" ), tr( "Please enter Talairach coordinates (separated with spaces)" ), 
			       QLineEdit::Normal, QString::null, &ok, this );
  } else {
    if (pr->pixelco==1)
	    s = QInputDialog::getText( tr( "Anatomical voxel coordinates [ X Y Z ]" ), 
				       tr( "Please enter anatomical voxel coordinates (separated with spaces)" ),
				       QLineEdit::Normal, QString::null, &ok, this );
    else if (pr->pixelco==2 && pr->sw2)
      s = QInputDialog::getText( tr( "Zmap voxel coordinates [ X Y Z ]" ), tr( "Please enter zmap voxel coordinates (separated with spaces)" ), 
				 QLineEdit::Normal,QString::null, &ok, this );
    else
      s = QInputDialog::getText( tr( "Pixel coordinates in mm [ X Y Z ]" ), tr( "Please enter the coordinates in mm (separated with spaces)" ), 
				 QLineEdit::Normal, QString::null, &ok, this );
  }
  if ( ok && !s.isEmpty() ) {
    // user entered something and pressed ok
    char *ons = (char*)strdup(s);
    int i=0;
    token = strtok(ons, " ");
    if (token != NULL) {
      arr[i++] = atoi(token);
      
      while ((token = strtok(NULL, " ")) != NULL) { 
	arr[i++]=atoi(token);
      }
    }
    if (i==3) {
      x=arr[0];
      y=arr[1];
      z=arr[2];
    } else {
      QMessageBox::warning( this, "Warning",
      "Please specify 3 coordinates\nseparated with spaces");
      return; 
    }
  } else return;
  if (pr->talairach==1 && pr->atlas==1) {
    VLTools mytools;
    mytools.VTal3Pixel(x,y,z, pr->voxel, extent_m, ca_m, (int)files, pr->pixelmult );
  } else {
    if (pr->pixelco==1) {
      //die koordinaten bleiben wie sie sind
    }
    else if (pr->pixelco==2) {
      x=(int)rint((double)x/pr->pixelmult[0]*pr->pixelm2[0]);
      y=(int)rint((double)y/pr->pixelmult[1]*pr->pixelm2[1]);
      z=(int)rint((double)z/pr->pixelmult[2]*pr->pixelm2[2]);
    }
    else {
      x=(int)rint((double)x/pr->pixelmult[0]);
      y=(int)rint((double)y/pr->pixelmult[1]);
      z=(int)rint((double)z/pr->pixelmult[2]);
    }
  }
  if (z<0 || z>=bands || y<0 || y>=rows || x<0 || x>=columns) {
    QMessageBox::warning( this, "Warning",
    "Illegal coordinates specified");
    return;  
  }

  pr->cursorp[1]=y;pr->cursorp[0]=x;pr->cursorp[2]=z;
  for (int j=0;j<files;j++) {
    bild1[j]->repaintf();
    bild2[j]->repaintf();
    bild3[j]->repaintf();
  }
  talCross(int(pr->cursorp[0]),int(pr->cursorp[1]),int(pr->cursorp[2]));
  
  if (fnc[0]) {
    if (pr->cursorp[2]<fnc_bands && pr->cursorp[1]<fnc_rows && pr->cursorp[0]<fnc_columns)
      emit z2Wert(VPixel(fnc[pr->active],(int)rint(pr->cursorp[2]),(int)rint(pr->cursorp[1]),(int)rint(pr->cursorp[0]),VFloat));  // rint added by A. Hagert (for float-graphs)
  } else if (pr->cursorp[2]<bands && pr->cursorp[1]<rows && pr->cursorp[0]<columns) {
    emit z2Wert(VGetPixel(src[pr->active],(int)rint(pr->cursorp[2]),(int)rint(pr->cursorp[1]),(int)rint(pr->cursorp[0])));    // rint added by A. Hagert (for float-graphs)
  }

  emit sendtoserver();
}

void BilderCW::talCross( int col, int row, int band ) {
  int x=col, y=row, z=band;
  int files=0;
  double XXt = (double)x; 
  double YYt = (double)y; 
  double ZZt = (double)z; 

  if (pr->infilenum>pr->zmapfilenum) 
    files=pr->infilenum;
  else 
    files=pr->zmapfilenum;
  
  if (pr->talairach==1 && pr->talairachoff==0) {
    VLTools mytools;
    mytools.VPixel3Tal(XXt,YYt,ZZt, extent_m, ca_m ,cp_m, (int)files, pr->pixelmult);
    emit crossPosit((float)XXt,(float)YYt,(float)ZZt,"t"); 
  } else {
    XXt *= pr->pixelmult[0]; 
    YYt *= pr->pixelmult[1]; 
    ZZt *= pr->pixelmult[2]; 

    if (pr->pixelco==1) 
      emit crossPosit((float)x,(float)y,(float)z,"a");
    else if (pr->pixelco==2)
      emit crossPosit((float)floor(XXt/pr->pixelm2[0]),(float)floor(YYt/pr->pixelm2[1]),(float)floor(ZZt/pr->pixelm2[2]),"z"); 
    else 
      emit crossPosit((float)floor(XXt),(float)floor(YYt),(float)floor(ZZt),"m");  
  }
}

void BilderCW::talEcht( int col, int row, int band ) {
	int x=col, y=row, z=band;
	int files=0;
	double XXt = (double)x; 
	double YYt = (double)y; 
	double ZZt = (double)z; 

	if (pr->infilenum>pr->zmapfilenum) 
		files=pr->infilenum;
	else 
		files=pr->zmapfilenum;
  
	if ( pr->talairach==1 && pr->talairachoff==0 ) {
		VLTools mytools;
		mytools.VPixel3Tal(XXt,YYt,ZZt, extent_m, ca_m ,cp_m, (int)files, pr->pixelmult);
		emit echtPosit((float)XXt,(float)YYt,(float)ZZt,"t");
	} else {
	  XXt *= pr->pixelmult[0]; 
	  YYt *= pr->pixelmult[1]; 
	  ZZt *= pr->pixelmult[2]; 

	  if (pr->pixelco==1)
	    emit echtPosit((float)x,(float)y,(float)z,"a");
	  else if (pr->pixelco==2)
	    emit echtPosit((float)floor(XXt/pr->pixelm2[0]),(float)floor(YYt/pr->pixelm2[1]),(float)floor(ZZt/pr->pixelm2[2]),"z");
	  else
	    emit echtPosit((float)floor(XXt),(float)floor(YYt),(float)floor(ZZt),"m");
	}
}


/* search the maximum z-value in picture */
void BilderCW::findMinMaxZ(int vorz)
{
  VFloat maxwertfloat=0;
  double maxwertubyte=0;
  int x=(int)rint(pr->cursorp[0]); // rint by A.Hagert
  int y=(int)rint(pr->cursorp[1]); // rint by A.Hagert
  int z=(int)rint(pr->cursorp[2]); // rint by A.Hagert
  if (fnc[0])
    maxwertfloat=VPixel(fnc[pr->active],z,y,x,VFloat);
  else
    maxwertubyte=VGetPixel(src[pr->active],z,y,x);  
  //Search
  for (int xi=(int)rint(pr->cursorp[0])-pr->radius; xi<(int)rint(pr->cursorp[0])+pr->radius; xi++) {    
    for (int yi=(int)rint(pr->cursorp[1])-pr->radius;yi<(int)rint(pr->cursorp[1])+pr->radius;yi++) {
      for (int zi=(int)rint(pr->cursorp[2])-pr->radius;zi<(int)rint(pr->cursorp[2])+pr->radius;zi++) {
	if (fnc[0]) {
	  if (xi>=0 && yi>=0 && zi>=0 && xi<fnc_columns && yi<fnc_rows && zi<fnc_bands ) {
	    if ( VPixel(fnc[pr->active],zi,yi,xi,VFloat) != 0.0 && maxwertfloat*vorz<VPixel(fnc[pr->active],zi,yi,xi,VFloat)*vorz ) {
	      maxwertfloat=VPixel(fnc[pr->active],zi,yi,xi,VFloat);
	      x=xi; y=yi; z=zi;
	    }	  
	  }
	} else {
	  if (xi>=0 && yi>=0 && zi>=0 && xi<columns && yi<rows && zi<bands ) {
	    if ( maxwertubyte*vorz<VGetPixel(src[pr->active],zi,yi,xi)*vorz ) {
	      maxwertubyte=VGetPixel(src[pr->active],zi,yi,xi);
	      x=xi; y=yi; z=zi;
	    }	  
	  }
	}
      }
    }
  } 
  pr->cursorp[1]=y;pr->cursorp[0]=x;pr->cursorp[2]=z;
  for (int j=0;j<files;j++) {
    bild1[j]->repaintf();
    bild2[j]->repaintf();
    bild3[j]->repaintf();
  }
  talCross(int(pr->cursorp[0]),int(pr->cursorp[1]),int(pr->cursorp[2]));
  
  if (fnc[0]) {
    if (pr->cursorp[2]<fnc_bands && pr->cursorp[1]<fnc_rows && pr->cursorp[0]<fnc_columns)
      emit z2Wert(VPixel(fnc[pr->active],(int)rint(pr->cursorp[2]),(int)rint(pr->cursorp[1]),(int)rint(pr->cursorp[0]),VFloat));   // rint by A.Hagert
  } else if (pr->cursorp[2]<bands && pr->cursorp[1]<rows && pr->cursorp[0]<columns) {
    emit  z2Wert(VGetPixel(src[pr->active],(int)rint(pr->cursorp[2]),(int)rint(pr->cursorp[1]),(int)rint(pr->cursorp[0])));   // rint by A.Hagert
  }

  emit sendtoserver();
}

void BilderCW::findMinZ() 
{
  findMinMaxZ(-1);
}

void BilderCW::findMaxZ() 
{
  findMinMaxZ(1);
}

void BilderCW::reset()
{
  // zoom to 1
  pr->bildzoom=1;

  // initialize cursor position
  if (ca_m[0*files]>1 && ca_m[1*files]>1 && ca_m[2*files]>1) {
    pr->cursorp[0]=(int)rint(ca_m[0*files]);
    pr->cursorp[1]=(int)rint(ca_m[1*files]);
    pr->cursorp[2]=(int)rint(ca_m[2*files]);
  } else {
    pr->cursorp[0]=(int)VImageNColumns(src[0])/2;
    pr->cursorp[1]=(int)VImageNRows(src[0])/2;
    pr->cursorp[2]=(int)VImageNFrames(src[0])/2;
  }

  // repaint
  for (int j=0;j<files;j++) {
    bild1[j]->repaintf();
    bild2[j]->repaintf();
    bild3[j]->repaintf();
  }
  talCross(int(pr->cursorp[0]),int(pr->cursorp[1]),int(pr->cursorp[2]));
  
  if (fnc[0]) {
    if (pr->cursorp[2]<fnc_bands && pr->cursorp[1]<fnc_rows && pr->cursorp[0]<fnc_columns)
      emit z2Wert(VPixel(fnc[pr->active],(int)rint(pr->cursorp[2]),(int)rint(pr->cursorp[1]),(int)rint(pr->cursorp[0]),VFloat));   //  rint by A.Hagert
  } else if (pr->cursorp[2]<bands && pr->cursorp[1]<rows && pr->cursorp[0]<columns) {
    emit  z2Wert(VGetPixel(src[pr->active],(int)rint(pr->cursorp[2]),(int)rint(pr->cursorp[1]),(int)rint(pr->cursorp[0])));   // rint by A.Hagert
 } 

  emit sendtoserver();
}

/* added  by A. Hagert for adaption of the x,y,z-scrollbars to mouse_rotation of
   the graph */
void BilderCW::SetXYZScrollbars( int xdegrees, int ydegrees, int zdegrees )
{
  rc1->setValue(xdegrees);   // x - scrollbar
  rc2->setValue(ydegrees);   // y - scrollbar
  rc3->setValue(zdegrees);   // z - scrollbar
}

void BilderCW::SlideReleased()
{
  emit SlideReleasedForVLRender();
}

void BilderCW::wheelEvent(QWheelEvent* e)
{
  if (e->delta()<0)
    zoomminus();
  else
    zoomplus();

}

void BilderCW::leaveEvent ( QEvent *)
{
  emit echtPosit(0.0,0.0,0.0,"0");
  emit zWert(0.0);
}
