package Lire::AsciiDlf::AsciiDlfFactory;

use strict;

use base qw/ Lire::ReportSpecFactory /;

use Carp;

use Lire::AsciiDlf::Group;
use Lire::AsciiDlf::GroupOp;
use Lire::AsciiDlf::Rangegroup;
use Lire::AsciiDlf::Records;
use Lire::AsciiDlf::Timegroup;
use Lire::AsciiDlf::Timeslot;

sub new {
    my $proto = shift;
    my $class = ref $proto || $proto;

    bless {}, $class;
}

sub create_group {
    my $self = shift;

    return new Lire::AsciiDlf::Group( @_ );
}

sub create_rangegroup {
    my $self = shift;

    return new Lire::AsciiDlf::Rangegroup( @_ );
}

sub create_timegroup {
    my $self = shift;

    return new Lire::AsciiDlf::Timegroup( @_ );
}

sub create_timeslot {
    my $self = shift;

    return new Lire::AsciiDlf::Timeslot( @_ );
}

sub create_sum {
    my $self = shift;

    return new Lire::AsciiDlf::GroupOp::Sum( @_ );
}

sub create_avg {
    my $self = shift;

    return new Lire::AsciiDlf::GroupOp::Avg( @_ );
}

sub create_min {
    my $self = shift;

    return new Lire::AsciiDlf::GroupOp::Min( @_ );
}

sub create_max {
    my $self = shift;

    return new Lire::AsciiDlf::GroupOp::Max( @_ );
}

sub create_first {
    my $self = shift;

    return new Lire::AsciiDlf::GroupOp::First( @_ );
}

sub create_last {
    my $self = shift;

    return new Lire::AsciiDlf::GroupOp::Last( @_ );
}

sub create_count {
    my $self = shift;

    return new Lire::AsciiDlf::GroupOp::Count( @_ );
}

sub create_records {
    my $self = shift;

    return new Lire::AsciiDlf::Records( @_ );
}

# keep perl happy
1;

__END__

=pod

=head1 NAME

Lire::AsciiDlf::AsciiDlfFactory -

=head1 SYNOPSIS


=head1 DESCRIPTION

=head1 VERSION

$Id: AsciiDlfFactory.pm,v 1.20 2004/03/26 00:27:34 wsourdeau Exp $

=head1 COPYRIGHT

Copyright (C) 2001 Stichting LogReport Foundation LogReport@LogReport.org

This file is part of Lire.

Lire is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program (see COPYING); if not, check with
http://www.gnu.org/copyleft/gpl.html or write to the Free Software 
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.

=head1 AUTHOR

Francis J. Lacoste <flacoste@logreport.org>

=cut
