package tests::AverageTest;

use strict;

use base qw/Lire::Test::TestCase tests::TestStoreFixture/;

use Lire::Average;
use Lire::ReportSpec;
use tests::MockAggregator;

sub new {
    my $self = shift()->SUPER::new( @_ );

    $self->init();

    return $self;
}

sub set_up {
    my $self = shift->SUPER::set_up();

    $self->set_up_test_schema();

    $self->{'spec'} = new Lire::ReportSpec();
    $self->{'spec'}->superservice( 'test' );
    $self->{'spec'}->id( 'test-sum' );

    my $mock = new tests::MockAggregator( 'report_spec' => $self->{'spec'} );

    $self->{'avg_op'} = new Lire::Average( 'report_spec' => $self->{'spec'},
                                           'parent' => $mock,
                                           'field' => 'file_size',
                                           'name' => 'avgTest' );

    $self->{'cfg'}{'lr_scale_numbers'} = 0;
    $self->{'cfg'}{'lr_scale_bytes'} = 1;
    $self->{'cfg'}{'lr_scale_seconds'} = 1;

    return  $self;
}

sub test_build_avg_query {
    my  $self = $_[0];

    foreach my $t ( [ 'file-size', undef, undef,
                      [ 'avgTest_total', 'sum("file-size")',
                        'avgTest_n', 'count(*)',
                        'avgTest', 'sum("file-size")/count(*)'] ],
                    [ 'file_size', 'time-taken', undef,
                      [ 'avgTest_total', 'sum(file_size*"time-taken")',
                        'avgTest_n', 'count(*)',
                        'avgTest', 'sum(file_size*"time-taken")/count(*)' ] ],
                    [ 'file-size', undef, [ 'connection-id', 'user' ],
                      [ 'avgTest_total', 'sum("file-size")',
                        'avgTest_n', 'lr_count_uniq("connection-id",user)',
                        'avgTest', 'sum("file-size")/lr_count_uniq("connection-id",user)'
                      ],] )
    {
        my ( $field, $weight, $by_fields, $aggrFields ) = @$t;

        $self->{'avg_op'}{'field'} = $field;
        $self->{'avg_op'}{'weight'} = $weight;
        $self->{'avg_op'}{'by_fields'} = $by_fields;
        my $e_query = new Lire::DlfQuery( 'test' );
        for ( my $i=0; $i < @$aggrFields; $i += 2) {
            $e_query->add_aggr_field( $aggrFields->[$i], $aggrFields->[$i+1] );
        }
        my $query = new Lire::DlfQuery( 'test' );
        $self->{'avg_op'}->_build_avg_query( $query );
        $self->assert_deep_equals( $e_query, $query );
    }
}

sub test_required_fields {
    my $self = $_[0];

    $self->assert_deep_equals( [ 'file_size' ],
                               $self->{'avg_op'}->sql_required_fields() );

    $self->{'avg_op'}{'weight'} = 'time_taken';
    $self->assert_deep_equals( [ 'file_size', 'time_taken' ],
                               $self->{'avg_op'}->sql_required_fields() );

    $self->{'avg_op'}{'by_fields'} = [ 'connection_id', 'user' ];
    $self->assert_deep_equals( [ 'file_size', 'time_taken', 'connection_id',
                                 'user' ],
                               $self->{'avg_op'}->sql_required_fields() );
}

sub test_create_value {
    my $self = $_[0];

    foreach my $t ( [ 'transfer-complete', 0, 0, 10, 'NaN', 'NaN' ],
                    [ 'transfer-complete', 10, 5, 0, '2.00', '2.00' ],
                    [ 'file_size', 102400, 11, 0, '9.1k', '9309.09' ], )
    {
        my ($field, $total, $n, $mc, $content, $value ) = @$t;

        my $row = { 'avgTest_total' => $total,
                    'avgTest_n' => $n,
                    '_lr_avgTest_mc' => $mc };

        $self->{'avg_op'}{'field'} = $field;
        my $v = $self->{'avg_op'}->create_value( undef, $row );
        my $e_v = { 'value' => $value,
                    'missing_cases' => $mc,
                    'content' => $content,
                    'total' => $total,
                    'n' => $n };
        $self->assert_deep_equals( $e_v, $v );
    }
}


1;
