package tests::ReportOperatorTest;

use strict;

use Lire::ReportSpec;
use Lire::ReportOperator;

use base qw/Lire::Test::TestCase tests::TestStoreFixture/;

sub new {
    my $self = shift()->SUPER::new( @_ );

    $self->init();
    $self->init_i18n();

    return $self;
}

sub set_up {
    my $self = shift->SUPER::set_up();

    $self->set_up_locale();
    $self->set_up_test_schema();

    my $spec = $self->{'spec'} = new Lire::ReportSpec();
    $spec->superservice( 'test' );

    my $op = bless {}, 'Lire::ReportOperator';
    $op->init( 'report_spec' => $spec,
               'op' => 'mock',
               'label' => 'JPEG Files' );
    $self->{'op'} = $op;

    return $self;
}

sub tear_down {
    my $self = shift->SUPER::tear_down();

    $self->tear_down_locale();

    return $self;
}

sub test_label_i18n {
    my $self = $_[0];

    my $op = $self->{'op'};
    $self->assert_str_equals( 'JPEG Files', $op->label() );
    $self->set_locale( 'fr_CA' );
    $self->assert_str_equals( 'Fichiers JPEG', $op->label() );
}

1;
