package tests::ReportSubreportTest;

use strict;

use base qw/ Lire::Test::TestCase /;

use Lire::Report;
use Lire::Report::Subreport;
use Lire::Report::TableInfo;
use Class::Inner;
use Carp;

sub new {
    my $self = shift()->SUPER::new( @_ );

    my $start = time;
    my $end = $start + 86400;
    $self->{'report'} = new Lire::Report( "test", $start, $end );
    $self;
}

sub set_up {
    my $self = shift->SUPER::set_up();

    return $self;
}

sub tear_down {
    my $self = shift->SUPER::tear_down();

    return $self;
}

sub test_new {
    my $self = $_[0];

    my $subreport = new Lire::Report::Subreport( $self->{'report'}, "top-dirs" );
    $self->assert_not_null( $subreport, "new() returned undef" );
    $self->assert_equals( $self->{'report'}, $subreport->{'report'} );
    $self->assert_equals( $self->{'report'}->superservice,
                          $subreport->superservice,
                        );
    $self->assert_equals( $self->{'report'}->timespan_start,
                          $subreport->timespan_start,
                        );
    $self->assert_equals( $self->{'report'}->timespan_end,
                          $subreport->timespan_end,
                        );
    $self->assert_equals( "top-dirs", $subreport->type );
}

sub test_new_missing {
    my $self = $_[0];

    my $subreport = new_missing Lire::Report::Subreport( $self->{'report'},
                                                         "top-dirs",
                                                         "error",
                                                       );
    $self->assert_not_null( $subreport, "new_missing() returned undef" );
    $self->assert_equals( $self->{'report'}, $subreport->{'report'} );
    $self->assert_equals( $self->{'report'}->superservice,
                          $subreport->superservice,
                        );
    $self->assert_equals( $self->{'report'}->timespan_start,
                          $subreport->timespan_start,
                        );
    $self->assert_equals( $self->{'report'}->timespan_end,
                          $subreport->timespan_end,
                        );
    $self->assert_equals( "top-dirs", $subreport->type );
    $self->assert_equals( "error", $subreport->missing_reason );

}

sub test_delete {
    my $self = $_[0];

    my $subreport = new Lire::Report::Subreport( $self->{'report'},
                                                 "top-dirs" );
    $self->assert_not_null( $subreport, "new() returned undef" );
    $subreport->delete;
    $self->assert_null( $subreport->{'report'},
                        "reference to report wasn't removed" );
    $self->assert_null( $subreport->{'table_info'},
                        "reference to table_info wasn't removed" );
}

sub test_missing_delete {
    my $self = $_[0];

    my $subreport = new_missing Lire::Report::Subreport( $self->{'report'},
                                                         "top-dirs", "error" );
    $self->assert_not_null( $subreport, "new_missing() returned undef" );
    $subreport->delete;
    $self->assert_null( $subreport->{'report'},
                        "reference to report wasn't removed" );
}

sub test_assign_row_indices {
    my $self = $_[0];

    my $subreport = new Lire::Report::Subreport( $self->{'report'}, "test" );
    my $table_info = new Lire::Report::TableInfo();
    $table_info->create_column_info( 'cell1', 'categorical', 'string' );
    my $group_info1 = $table_info->create_group_info( 'nested1' );
    $group_info1->create_column_info( 'cell2', 'categorical', 'string' );
    $group_info1->create_column_info( 'cell3', 'numerical', 'int' );
    my $group_info2 = $table_info->create_group_info( 'nested2' );
    $group_info2->create_column_info( 'cell4', 'categorical', 'string' );
    $group_info2->create_column_info( 'cell5', 'numerical', 'int' );

    $subreport->table_info( $table_info );
    my $entry = $subreport->create_entry();
    my $idx = $subreport->assign_row_indices();
    $self->assert_null( $subreport->{'row_idx'},
                        "'row_idx' attribute of Subreport should always be undef" );
    $self->assert_equals( 0, $idx );
    $self->assert_equals( 0, $entry->row_idx() );

    return;
}

sub test_finalize {
    my $self = $_[0];

    my $rank = 0;
    my $subreport =
      new Class::Inner( 'parent' => 'Lire::Report::Subreport',
                        'args' => [ $self->{'report'}, 'test' ],
                        'methods' =>
                        {
                         'assign_row_indices' => sub {
                             $_[0]->{'assign_row_indices()'} = $rank++;
                         },
                         'compute_column_info_stats' => sub {
                             $_[0]->{'compute_column_info_stats()'} = $rank++;
                         }
                        } );

    my $mock_table_info =
      new Class::Inner( 'parent' => 'Lire::Report::TableInfo',
                        'methods' => 
                        { 'compute_columns_width' => sub {
                            $_[0]->{'compute_columns_width()'} = $rank++;
                          },
                        } );
    $subreport->table_info( $mock_table_info );
    $subreport->finalize();

    $self->assert_equals( 0, $subreport->{'assign_row_indices()'}  );
    $self->assert_equals( 1, $subreport->{'compute_column_info_stats()'} );
    $self->assert_equals( 2, $mock_table_info->{'compute_columns_width()'} );
    return;
}

sub test_subreport {
    my $self = $_[0];

    my $table = new Lire::Report::Subreport( $self->{'report'}, 'test' );
    $self->assert_equals( $table, $table->subreport() );
}
1;
