package tests::UIExecutableWidgetTest;

use strict;

no warnings 'redefine';

use base qw/ Lire::Test::TestCase /;

use Lire::Config::TypeSpec;

use Curses::UI;
use File::Basename qw/ dirname basename /;

use Lire::Test::CursesUIDriver;

sub set_up {
    my $self = $_[0];
    $self->SUPER::set_up();

    $self->{'driver'} = new Lire::Test::CursesUIDriver();
    $self->{'driver'}->setup_curses_ui();

    $self->{'ui'} = new Curses::UI();
    $self->{'driver'}->set_curses_ui( $self->{'ui'} );
    $self->{'window'} = $self->{'ui'}->add( 'window', 'Window' );

    my $spec = new Lire::Config::ConfigSpec();
    $spec->add( new Lire::Config::ExecutableSpec( 'name' => 'exec_param' ) );
    $self->{'exec_param'} =
      $spec->get( 'exec_param' )->instance( 'value' => '/bin/sh');
    $self->{'spec'} = $spec;

    return;
}

sub tear_down {
    my $self = $_[0];
    $self->SUPER::tear_down();

    $self->{'driver'}->teardown_curses_ui();

    return;
}

sub test_new {
    my $self = $_[0];

    my $widget = $self->{'window'}->add( 'exec_widget', 'Lire::UI::ExecutableWidget',
                                         'value' => $self->{'exec_param'} );
    $self->assert( UNIVERSAL::isa( $widget, 'Lire::UI::FileWidget' ),
                   "not a Lire::UI::FileWidget instance: $widget" );
    $self->assert( UNIVERSAL::isa( $widget, 'Lire::UI::ExecutableWidget' ),
                   "not a Lire::UI::ExecutableWidget instance: $widget" );
}

1;
