package tests::UIUtilsTest;

use strict;

use base qw/ Lire::Test::TestCase /;

use Lire::UI::Utils qw/ button_box_width text_for_width /;

sub test_button_box_width {
    my $self = $_[0];

    my $buttons = [ {'-label' => '< Cancel >',
                     '-onpress' => sub { } } ];
    $self->assert_num_equals( 10,
                              button_box_width( $buttons ) );
    $buttons = [ {'-label' => '< Cancel >',
                  '-onpress' => sub { } },
                 {'-label' => '< OK >',
                  '-onpress' => sub { } } ];
    $self->assert_num_equals( 17,
                              button_box_width( $buttons ) );
}

sub test_text_for_width {
    my $self = $_[0];

    $self->assert_dies( qr/missing \'text\' parameter/,
                        sub { text_for_width() } );
    $self->assert_dies( qr/missing \'width\' parameter/,
                        sub { text_for_width( 'wawa' ) } );
    $self->assert_dies( qr/\'width' should be a positive, greater than or equal to 5, integer: \'-3\'/,
                        sub { text_for_width( 'wawa', -3 ) } );
    $self->assert_dies( qr/\'width' should be a positive, greater than or equal to 5, integer: \'wawa\'/,
                        sub { text_for_width( 'wawa', 'wawa' ) } );

    $self->assert_str_equals( 'wawa',
                              text_for_width( 'wawa', 10 ) );
    $self->assert_str_equals( 'b...s',
                              text_for_width( 'bigwawatestormorethan9chars', 5 ) );
    $self->assert_str_equals( 'big...ars',
                              text_for_width( 'big wawa test or more than 9 chars', 9 ) );
    $self->assert_str_equals( 'big...hars',
                              text_for_width( 'big wawa test or more than 10 chars', 10 ) );
    $self->assert_str_equals( 'big...test',
                              text_for_width( 'big           test', 10 ) );
}

1;
