package Lire::Extensions::WWW::UserAgentSchema;

# vim:syntax=perl

use strict;

use Lire::Config;
use Lire::Utils qw/ tempfile /;
use Lire::Logger qw/ lr_info /;

use base qw/ Lire::AsciiDlf::ExtendedFieldsCreator /;

use Lire::WWW::UserAgent;

use Carp;

sub init_computation {
    my ( $self, $dlf_info ) = @_;

    my $os_dflt = $self->schema->field( "os" )->default;
    my $lang_dflt = $self->schema->field( "lang" )->default;
    my $browser_dflt = $self->schema->field( "browser" )->default;
    $self->{'analyzer'} =
      new Lire::WWW::UserAgent( 'os_default' => $os_dflt,
				'language_default' => $lang_dflt,
				'browser_default' => $browser_dflt,
			      );

    # Cache the field's index of requested_page
    $self->{'useragent_idx'}  = $self->schema->field( "useragent" )->pos;
}

sub create_extended_fields {
    my ( $self, $dlf ) = @_;

    my $ua = $dlf->[$self->{'useragent_idx'} ];
    if ( ! defined $ua ) {
	return [ (undef) x 3 ];
    } else {
	$self->{'analyzer'}->setUserAgent($ua);

	my $browser = $self->{'analyzer'}->getBrowser();
	my $os	    = $self->{'analyzer'}->getOS();
	my $lang    = $self->{'analyzer'}->getLanguage();

	return [ $browser, $os, $lang ];
    }
}

sub end_computation {
    my ( $self ) = shift;

    $self->SUPER::end_computation( @_ );

    # Save values that resulted in unknown values
    if ( Lire::Config->get( 'lr_debug' ) ) {
	my ($fh, $filename) = tempfile( "unknown_os-XXXXXX",
					'SUFFIX' => '.txt' );
	lr_info( "saving unknown OS in ", $filename );
	foreach my $os ( keys %{$self->{'analyzer'}{'notInOSHash'}} ) {
	    print $fh $os, "\n";
	}
	close $fh;
	unlink $filename unless -s $filename;

	($fh, $filename) = tempfile( "unknown_browser-XXXXXX",
				     'SUFFIX' => '.txt' );
	lr_info( "saving unknown browsers in ", $filename );
	foreach my $b ( keys %{$self->{'analyzer'}{'notInBrowserHash'}} ) {
	    print $fh $b, "\n";
	}
	close $fh;
	unlink $filename unless -s $filename;
    }

    # Free memory
    delete $self->{'analyzer'};
}

# keep perl happy
1;

__END__

=pod

=head1 NAME

Lire::Extensions::WWW::UserAgentSchema -

=head1 SYNOPSIS

Fixme

=head1 DESCRIPTION

Fixme

=head1 VERSION

$Id: UserAgentSchema.pm,v 1.12 2004/03/20 00:26:29 flacoste Exp $

=head1 COPYRIGHT

Copyright (C) 2001 Stichting LogReport Foundation LogReport@LogReport.org

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program (see COPYING); if not, check with
http://www.gnu.org/copyleft/gpl.html or write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.

=head1 AUTHOR

Francis J. Lacoste <flacoste@logreport.org>

=cut
