package tests::XMLSpecParserTest;

use strict;

use base qw/ Lire::Test::TestCase tests::TestStoreFixture/;

use Lire::XMLSpecParser;

sub new {
    my $self = shift()->SUPER::new( @_ );

    $self->init();

    return $self;
}


sub set_up {
    my $self = $_[0];

    $self->SUPER::set_up();
    $self->{'parser'} = new Lire::XMLSpecParser();

    $self->set_up_test_schema();

    return;
}

sub test_spec_start {
    my $self = $_[0];

    $self->{'parser'}->spec_start( 'lrsml:report-spec',
                                   { 'id' => 'x-by-y',
                                     'superservice' => 'test',
                                     'schema' => 'test-derived',
                                     'joined-schemas' => 'test test-extended'
                                   } );
    $self->assert_isa( 'Lire::ReportSpec', $self->{'parser'}{'_spec'} );
    $self->assert_str_equals( 'x-by-y', $self->{'parser'}{'_spec'}->id() );
    $self->assert_str_equals( 'test',
                              $self->{'parser'}{'_spec'}->superservice() );
    $self->assert_str_equals( 'test-derived',
                              $self->{'parser'}{'_spec'}{'schema'} );
    $self->assert_deep_equals( [ 'test', 'test-extended' ],
                               $self->{'parser'}{'_spec'}->joined_schemas() );

}

1;
