# MyConverter should be replaced by an appropriate package
# name for you DLF converter.
#
# It will need to installed according perl convention.
package MyConverter;

use strict;

# A DlfConverter is a subclass of Lire::DlfConverter
use base qw/Lire::DlfConverter/;

# The constructor. The constructor can be called anything. It isn't
# used by the Lire framework. You'll instantiate the converter
# yourself in the DLF Converter registration script.
sub new {
    my ( $class, @params ) = @_;

    # Of course, you'll probably process @params yourself
    # here.
    my $self = bless { 'params' => \@params }, $class;

    return $self;
}

########################################################################
#                          METADATA METHODS
#
# The following methods are used to provide information about your
# converter to the Lire framework.
#
########################################################################

# Returns the name of the converter. It is this name that
# is used as an argument to lr_log2report.
#
# Some existing names are 'combined', 'w3c_extended', 'bind8_query'.
#
# It should be unique and describe adequately the log format processed
# by your converter.
sub name {
    my $self = $_[0];

    return "myconverter";
}

# A more verbose name that is used for display in user interface.
sub title {
    my $self = $_[0];

    return "My first DLF Converter"
}

# A short blurb describing your converter. The returned string
# should be a valid DocBook string. If you don't know DocBook, you
# only have to know that <para></para> is used to delimit paragraphs.
sub description {
    my $self = $_[0];

    return <<EOF;
<para>This is a DLF Converter which processes log files in the
MyFormat format.</para>
<para>This format's description is available on the
<ulink url="http://www.logreport.org/myformat.html">LogReport</ulink>
website.</para>
EOF
}

# This method should returns the list of schemas used by your
# converter. For example, the 'combined' DLF converter transforms
# combined log format log file into the 'www' schema.
#
# One DLF converter can output DLF records in more than one schema. For
# example, many 'firewall' log files can contains both 'proxy' and 'firewall'
# records.
sub schemas {
    my $self = $_[0];

    return ( "myschema" );
}

# If your log file is line oriented, you don't need to change this 
# method. Each line in the log files will be  passed to your converter's
# process_log_line() method.
#
# If your log format is not line oriented, (for example, it's an XML file),
# you need to return 0 here. In that case, the process_log_file method will
# be called.
sub handle_log_line { 
    my $self = $_[0];

    return 1;
}

########################################################################
#                          PROCESSING METHODS
#
# These methods are used to implement the actual behavior of your
# DLF converters.
#
########################################################################

# This method is called once before the log file is processed so
# that your DLF converter can initialize its state.
#
# The configuration data is received in the third parameter. This
# scalar is the result of the as_value() method of the
# Lire::Config::Value implementing the type. For a record, this is
# an hash reference.
sub init_dlf_converter {
    my ( $self, $process, $config ) = @_;

    $self->{'stuff'} = $config->{'stuff'};
    $self->{'other'} = $config->{'other'};

    return;
}

# This method is used to parse $line and convert it to
# a DLF record of one of the schema returned by schemas().
#
# The line-ending character(s) is already stripped from $line.
sub process_log_line {
    my ( $self, $process, $line ) = @_;

    eval {
        # Parse $line into a 'myconverter' record.
        my $dlf = {};

        # ignore_log_line() can be used to report log line which
        # are ignored by this converter
        if ($line =~ /ignore/ ) {

            $process->ignore_log_line( $line, "No a myconverter log line" );

        } else {

            ( $dlf->{'ts_field'},
              $dlf->{'string_field'},
              $dlf->{'int_field'},
              $dlf->{'host_field'} ) = $line =~ /(string) (int) (host)/;

            # Write a DLF to the store. The first parameter
            # gives the DLF schema of the hash reference.
            #
            # Each field in the 'myschema' schema is mapped to a key
            # with the same name in the hash reference. Missing key
            # or undef values are mapped to the LIRE_NA missing value.
            #
            # The schema value must be one which was returned by
            # the schemas() method.
            $process->write_dlf( 'myschema', $dlf );
        }
    };
    if ( $@ ) {
        # Report an error with that line
        $process->error( $@, $line );
    }
}

# If handle_log_lines() returned false, this will be called once
# to process the log file. $fh is a file handle opened on the
# log file. You would use $process like in the process_log_line
# example.
#
# sub process_log_file {
#     my ( $self, $process, $fh ) = @_;
# }

# This is called once, after the log file is finished processing.
# Unless you DLF converter is stateful, this method won't probably
# used by your converter.
sub finish_conversion {
    my ( $self, $process ) = @_;

    return;
}

# Perl modules should return 1, when required.
1;
