/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 */

 /* (C) Marcin Kwadrans <quar@vitea.pl> */

#include "include/support.h"
#include "include/paritycommand.h"
#include "include/message.h"

class LWCommandDownTo: public LWParityCommand {
private:
gboolean firstIter;
public:
LWCommandDownTo (): firstIter(TRUE) {}
	
LWValue *execute1 (LWContext *context, guint argc, LWValue *args[])
{
	g_return_val_if_fail (argc == 1, NULL);
	g_return_val_if_fail (context->instrPtr->next != NULL, NULL);
	g_return_val_if_fail (FALSE == g_queue_is_empty (context->stack), NULL);

	LWValue *iterVariable = (LWValue *) g_queue_peek_head (context->stack);	
	
	if ((firstIter == TRUE && iterVariable->toInt() < args[0]->toInt()) ||
		(firstIter == FALSE && iterVariable->toInt() <= args[0]->toInt()))
	{
		firstIter = TRUE;
		g_queue_pop_head (context->stack);
		context->instrPtr = context->instrPtr->next->next;
	} else 
	if (firstIter == FALSE) {
		LWValue *v = new LWValue(iterVariable->toInt() - 1);
		iterVariable->set (v);
		delete v;
	} else 
		firstIter = FALSE;
	
	return NULL;
}

const gchar *getName (void)
{
	return "downto";
}	

gchar *getHint ()
{
	return _("Countdown to");
}

void checkArgc (guint n)
{
	if (n != 1) 
		throw new LWMessage (LW_ERROR_WrongNumberOfArguments);
}

gboolean isOpen ()
{
	return FALSE;	
}

void matchWith (LWCommand *cmd)
{
	if (g_strcasecmp (cmd->getName(), "for2"))
			throw new LWMessage (LW_ERROR_DowntoButWhereIsFor);
	
	match();
}

gboolean isLoop ()
{
	return TRUE;
}

void reset1 ()
{
	firstIter = TRUE;
	LWParityCommand::reset1();
}

};

LWSymbol *new_LWCommandDownTo()
{
	return new LWCommandDownTo();
}
