/************************************************************************/
/*  author :   Mikkel Damsgaard                                         */
/*             Kirsebaerhaven 85b                                        */
/*                                                                      */
/*             DK-8520 Lystrup                                          */
/*             email mikdam@daimi.aau.dk                                */
/*                                                                      */
/*  files :                                                             */
/*  Divsol.c           QRfact.h           Divsol.h           Jacobi.c   */     
/*  Jacobi.h           Triang.c           print.c            MM.c       */   
/*  Triang.h           print.h            MM.h               QRfact.c   */   
/*  main.c             main.h                                           */
/*                                                                      */
/*  It calculates the eigenvalues for 4 different matrixes. It does not */
/*  take any input; those 4 matrixes are calculated by MakeMatrix       */
/*  function. Output is given as 4 files: val2, val3, val4, val5, that  */
/*  contains the eigenvalues for each of the matrixes.                  */
/*                                                                      */
/************************************************************************/
#include "main.h"
#include "MM.h"


/* Iterate, by doing QR iterations with wilson shiftQ, asume that A is  
   tridiagonal, return Q, such that Q^TAQ=diag(l1,l2,...,ln).
   Using algorithm 8.2.3 */
Matrix QRiterate(Matrix A, Matrix U);
void Givens(double x,double y, double *s, double *c);
void ApplyRGivens(Matrix U,double s, double c,int i,int j);
