/*
 * audio_file_processor.h - declaration of class audioFileProcessor
 *                          (sound-generator-plugin for using audio-files)
 *
 * Linux MultiMedia Studio
 * Copyright (c) 2004-2005 Tobias Doerffel <tobydox@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */


#ifndef _AUDIO_FILE_PROCESSOR_H
#define _AUDIO_FILE_PROCESSOR_H

#include "qt3support.h"

#ifdef QT4

#include <QPixmap>

#else

#include <qpixmap.h>

#endif

#include "sound_generator.h"
#include "sample_buffer.h"
#include "spc_bg_hndl_widget.h"


class knob;
class pixmapButton;


class audioFileProcessor : public soundGenerator, public specialBgHandlingWidget
{
	Q_OBJECT
public:
	audioFileProcessor( channelTrack * _channel_track );
	
	~audioFileProcessor();
	void FASTCALL playNote( notePlayHandle * _n );
	virtual void FASTCALL deleteNotePluginData( notePlayHandle * _n );

	inline virtual const QString & pluginName( void ) const
	{
		return( audioFileProcessor::s_pluginName );
	}


	virtual void FASTCALL saveSettings( QDomDocument & _doc,
						QDomElement & _parent );
	virtual void FASTCALL loadSettings( const QDomElement & _this );
	static QDomElement defaultSettings( const QString & _audio_file = "" );

	inline virtual QString nodeName( void ) const
	{
		return( s_pluginNodeName );
	}

	virtual Uint32 getBeatLen( notePlayHandle * _n ) const;




protected slots:
	void openAudioFile( void );
	void reverseBtnToggled( bool _on );
	void ampKnobChanged( float _new_value );
	void startKnobChanged( float _new_value );
	void endKnobChanged( float _new_value );
	void lineDrawBtnToggled( bool _on );
	void dotDrawBtnToggled( bool _on );
	void sampleUpdated( void );
	void setAudioFile( const QString & _audio_file );


protected:
	void paintEvent( QPaintEvent * );


private:

	friend class soundGenerator;

	sampleBuffer m_sampleBuffer;
	
	sampleBuffer::drawMethods m_drawMethod;

	QPixmap m_graph;
	knob * m_ampKnob;
	knob * m_startKnob;
	knob * m_endKnob;
	pixmapButton * m_openAudioFileButton;
	pixmapButton * m_viewLinesPB;
	pixmapButton * m_viewDotsPB;
	pixmapButton * m_reverseButton;
	pixmapButton * m_loopButton;

	static QPixmap * s_graphBg;
	static QPixmap * s_afpArtwork;

	static const QString s_pluginName;
	static const QString s_pluginNodeName;

	void updateSample( void );
	void FASTCALL setStartAndEndKnob( float _s, float _e );

} ;


#endif
