/*
 * audio_oss.h - device-class that implements OSS-PCM-output
 *
 * Linux MultiMedia Studio
 * Copyright (c) 2004-2005 Tobias Doerffel <tobydox@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */


#ifndef _AUDIO_OSS_H
#define _AUDIO_OSS_H

#include "audio_device.h"
#include "tab_widget.h"

#define OSS_SUPPORT


class lcdSpinBox;
class QLineEdit;


class audioOSS : public audioDevice
{
public:
	audioOSS( Uint32 _sample_rate, bool & _success_ful );
	~audioOSS();

	inline static QString name( void )
	{
		return( setupWidget::tr( "OSS (Open Sound System)" ) );
	}

	static QString probeDevice( void );


	class setupWidget : public audioDevice::setupWidget
	{
	public:
		setupWidget( QWidget * _parent );
		virtual ~setupWidget();

		virtual void saveSettings( void );

	private:
		QLineEdit * m_device;
		lcdSpinBox * m_channels;

	} ;


private:
	virtual void FASTCALL writeBufferToDev( surroundSampleFrame * _ab,
						Uint32 _frames,
						float _master_output );

	int m_audioFD;

	bool m_convertEndian;

} ;


#endif
