/*
 * midi_out.h - soundgenerator midiOut which just sends all notes to external
 *              MIDI-device
 *
 * Linux MultiMedia Studio
 * Copyright (c) 2004-2005 Tobias Doerffel <tobydox@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */


#ifndef _MIDI_OUT_H
#define _MIDI_OUT_H

#include "sound_generator.h"




class midiOut : public soundGenerator
{
	Q_OBJECT
public:
	midiOut( channelTrack * _channel_track );

	~midiOut();

	void FASTCALL playNote( notePlayHandle * _n );
	virtual void FASTCALL deleteNotePluginData( notePlayHandle * _n );

	inline virtual const QString & pluginName( void ) const
	{
		return( midiOut::s_pluginName );
	}


	virtual void FASTCALL saveSettings( QDomDocument & _doc,
							QDomElement & _parent );
	virtual void FASTCALL loadSettings( const QDomElement & _this );
        static QDomElement defaultSettings( void );
	inline virtual QString nodeName( void ) const
	{
		return( s_pluginNodeName );
	}


private:

	friend class soundGenerator;

	static const QString s_pluginName;
	static const QString s_pluginNodeName;

} ;


#endif
