/*
 * sound_generator.h - declaration of class sound_generator, which provides a
 *                     standard interface for all sound generators
 *
 * Linux MultiMedia Studio
 * Copyright (c) 2004-2005 Tobias Doerffel <tobydox@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */


#ifndef _SOUND_GENERATOR_H
#define _SOUND_GENERATOR_H


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include "qt3support.h"

#ifdef QT4

#include <QWidget>
#include <QVector>

#else

#include <qwidget.h>
#include <qvaluevector.h>

#endif


#include "types.h"
#include "settings.h"
#include "mixer.h"


// forward-declarations
class channelTrack;
class notePlayHandle;


class soundGenerator : public QWidget, public settings
{
	Q_OBJECT
public:
	soundGenerator( channelTrack * _channel_track );
	virtual ~soundGenerator();

	// must be overloaded by plugin
	virtual void FASTCALL playNote( notePlayHandle * note_to_play ) = 0;
	virtual const QString & pluginName( void ) const = 0;

	// needed for deleting plugin-data of a note, plugin has to cast
	// void-ptr so that the plugin-data
	// is deleted properly (call of dtor if it's a class!!!)
	virtual void FASTCALL deleteNotePluginData( notePlayHandle *
							_note_to_play ) = 0;

	// Get number samples that should be used when playing beat (note with
	// unspecified length)
	// Per default this function returns 0. In this case, channel is using
	// the length of the longest envelope (if one active).
	virtual Uint32 FASTCALL beatLen( notePlayHandle * _n ) const;

	// this is a cool static function -> it returns an instance of a plugin
	// according to given settings (this function is written (that means
	// implemented) by plugin-scanner in src/plugin_management.cpp)
	static soundGenerator * FASTCALL pluginInstance(
						const QString & _node_name,
						channelTrack * _channel_track );

	// fills the given vector with the names of all
	// sound-generator-plugins (src/plugin_management.cpp!)
	static void FASTCALL getPluginNames( vvector<QString> & _plugin_names );


protected:
	// every sound-plugin has to give its produced wave-data to this
	// function, because it handles things like volume, panning and FX
	// channels
	void FASTCALL processAudioBuffer( sampleFrame * _ab, Uint32 _frames,
							notePlayHandle * _n );

	// may be plugins wanna know their channel-track?? :-)
	inline channelTrack * getChannelTrack( void ) const
	{
		return( m_channelTrack );
	}


private:
	channelTrack * m_channelTrack;

} ;


#endif
