/*
 * lmms.cpp - LMMS-base-system, contains main() and main-window
 *
 * Linux MultiMedia Studio
 * Copyright (c) 2004-2005 Tobias Doerffel <tobydox@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */


#include "qt3support.h"

#ifdef QT4

#include <QApplication>
#include <QLocale>
#include <QFileDialog>
#include <QCloseEvent>
#include <QSplitter>
#include <QStatusBar>
#include <QMenuBar>
#include <QToolButton>
#include <QSplashScreen>
#include <QStatusBar>
#include <QToolBar>
#include <QAction>
#include <QMessageBox>

#else

#include <qsplitter.h>
#include <qapplication.h>
#include <qtextcodec.h>
#include <qdir.h>
#include <qfiledialog.h>
#include <qpopupmenu.h>
#include <qmenubar.h>
#include <qtoolbutton.h>
#include <qstatusbar.h>
#include <qaction.h>
#include <qmessagebox.h>

#if QT_VERSION >= 0x030200
#include <qsplashscreen.h>
#endif

#endif

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include "lmms_main_win.h"
#include "bb_editor.h"
#include "song_editor.h"
#include "piano_roll.h"
#include "embed.h"
#include "about_dialog.h"
#include "browser.h"
#include "side_bar.h"
#include "config_mgr.h"
#include "mixer.h"
#include "project_notes.h"
#include "buffer_allocator.h"
#include "setup_dialog.h"
#include "preset_preview_play_handle.h"
#include "audio_dummy.h"


#if QT_VERSION >= 0x030100
QSplashScreen * lmmsMainWin::s_splashScreen = NULL;
extern int splash_alignment_flags;
#endif

lmmsMainWin * lmmsMainWin::s_instanceOfMe = NULL;



lmmsMainWin::lmmsMainWin() :
	QMainWindow(
#ifndef QT4
			0 , NULL, WDestructiveClose
#endif
		),
	m_templatesMenu( NULL )
{
#ifdef QT4
	setAttribute( Qt::WA_DeleteOnClose );
#endif

	// small workaround, because inst() is called by objects which
	// are created within this function
	s_instanceOfMe = this;

	QStatusBar * status_bar = new QStatusBar( this );
	status_bar->setSizeGripEnabled( TRUE );

	QWidget * w = new QWidget( this );
	QHBoxLayout * hbox = new QHBoxLayout( w );
	sideBar * side_bar = new sideBar( Qt::Vertical, w );
	side_bar->setStyle( sideBar::VSNET/*KDEV3ICON*/ );
	side_bar->setPosition( sideBar::DockLeft );

	QSplitter * splitter = new QSplitter( Qt::Horizontal, w );
#if QT_VERSION >= 0x030200
	splitter->setChildrenCollapsible( FALSE );
#endif

	int id = 0;
	QString wdir = configManager::inst()->lmmsWorkingDir();
	side_bar->appendTab( new browser( wdir+"projects", "*.xml",
							tr( "My projects" ),
					embed::getIconPixmap( "project_file" ),
							splitter ), ++id );
	side_bar->appendTab( new browser( wdir+"samples", "*.wav *.ogg *.voc "
						"*.aif *.aiff *.au *.raw",
							tr( "My samples" ),
					embed::getIconPixmap( "sound_file" ),
							splitter ), ++id );
	side_bar->appendTab( new browser( wdir+"presets", "*.cs.xml",
							tr( "My presets" ),
					embed::getIconPixmap( "preset_file" ),
							splitter ), ++id );
	side_bar->appendTab( new browser( QDir::homePath(), "*",
							tr( "My home" ),
					embed::getIconPixmap( "home" ),
							splitter ), ++id );
	side_bar->appendTab( new browser( QDir::rootPath(), "*",
							tr( "Root directory" ),
					embed::getIconPixmap( "root" ),
							splitter ), ++id );

	m_workspace = new lmmsWorkspace( splitter );
	m_workspace->setScrollBarsEnabled( TRUE );

#ifdef QT4
	m_workspace->setBackground( embed::getIconPixmap(
						"background_artwork" ) );
#else
	m_workspace->setPaletteBackgroundPixmap( embed::getIconPixmap(
						"background_artwork" ) );
#endif

	hbox->addWidget( side_bar );
	hbox->addWidget( splitter );
	setCentralWidget( w );


#if QT_VERSION >= 0x030200
	if( qApp->argc() > 1 )
	{
		s_splashScreen->showMessage( tr( "Loading song..." ),
							splash_alignment_flags,
								Qt::white );
	}
	else
	{
		s_splashScreen->showMessage( tr( "Creating new song..." ),
							splash_alignment_flags,
								Qt::white );
	}
#endif
	songEditor::inst();


#if QT_VERSION >= 0x030200
	s_splashScreen->showMessage( tr( "Creating GUI..." ),
							splash_alignment_flags,
								Qt::white );
#endif
	resetWindowTitle( "" );
	setWindowIcon( embed::getIconPixmap( "icon" ) );

	// TODO: when dropping qt3-support clean up the whole menu- and toolbar
	// code and create QAction's to be inserted in menu- and toolbar - the
	// current situation is horrible.....!!!!!!!


	m_projectTools = new QToolBar( this );
#ifdef QT4
	addToolBar( Qt::TopToolBarArea, m_projectTools );
#else
	addDockWindow( m_projectTools, tr( "Song management" ), DockTop,
									TRUE );
#endif

	QAction * a;

#ifdef QT4
	a = new QAction( embed::getIconPixmap( "project_new" ),
						tr( "Create new project" ),
							m_projectTools );
	a->setShortcut( tr( "Ctrl+N" ) );
	connect( a, SIGNAL( activated() ), this, SLOT( createNewProject() ) );

	a = new QAction( embed::getIconPixmap( "project_open" ),
						tr( "Open existing project" ),
							m_projectTools );
	a->setShortcut( tr( "Ctrl+O" ) );
	connect( a, SIGNAL( activated() ), this, SLOT( openProject() ) );

	a = new QAction( embed::getIconPixmap( "project_save" ),
						tr( "Save current project" ),
							m_projectTools );
	a->setShortcut( tr( "Ctrl+S" ) );
	connect( a, SIGNAL( activated() ), this, SLOT( saveProject() ) );

	a = new QAction( embed::getIconPixmap( "project_export" ),
						tr( "Export current project" ),
							m_projectTools );
	a->setShortcut( tr( "Ctrl+E" ) );
	connect( a, SIGNAL( activated() ), songEditor::inst(),
						SLOT( exportProject() ) );

#else
/*	a = new QAction( embed::getIconPixmap( "project_new" ),
							tr( "Create new project" ),
							CTRL + Key_N, this );
	connect( a, SIGNAL( activated() ), this, SLOT( createNewProject() ) );
	a->addTo( m_projectTools );*/
	QToolButton * t = new QToolButton( embed::getIconPixmap(
							"project_new" ),
						tr( "Create new project" ),
						QString::null, this,
						SLOT( createNewProject() ),
							m_projectTools );
	t->setAccel( Qt::Key_F6 );
	QDir d( configManager::inst()->projectsDir() + "templates" );
	QStringList templates = d.entryList( "*.xml",
						QDir::Files | QDir::Readable );
	if( !templates.isEmpty() )
	{
		m_templatesMenu = new QMenu( t );
		for( QStringList::iterator it = templates.begin();
						it != templates.end(); ++it )
		{
			m_templatesMenu->insertItem(
					embed::getIconPixmap( "project_file" ),
					( *it ).left( ( *it ).length() - 4 ) );
		}
		connect( m_templatesMenu, SIGNAL( activated( int ) ),
			this, SLOT( createNewProjectFromTemplate( int ) ) );
		t->setMenu( m_templatesMenu );
		t->setPopupDelay( 0 );
	}

	a = new QAction( 
#if QT_VERSION < 0x030200
			"",
#endif		    
			embed::getIconPixmap( "project_open" ),
						tr( "Open existing project" ),
							CTRL + Key_O, this );
	connect( a, SIGNAL( activated() ), this, SLOT( openProject() ) );
	a->addTo( m_projectTools );

	a = new QAction( 
#if QT_VERSION < 0x030200
			"",
#endif		    
			embed::getIconPixmap( "project_save" ),
						tr( "Save current project" ),
							CTRL + Key_S, this );
	connect( a, SIGNAL( activated() ), this, SLOT( saveProject() ) );
	a->addTo( m_projectTools );

	a = new QAction( 
#if QT_VERSION < 0x030200
			"",
#endif		    
			embed::getIconPixmap( "project_export" ),
						tr( "Export current project" ),
							CTRL + Key_E, this );
	connect( a, SIGNAL( activated() ), songEditor::inst(),
						SLOT( exportProject() ) );
	a->addTo( m_projectTools );

#endif



	m_windowTools = new QToolBar( tr( "Windows" ), this );
#ifdef QT4
	addToolBar( Qt::TopToolBarArea, m_windowTools );
#else
	addDockWindow( m_windowTools, tr( "Windows" ), Qt::DockTop, FALSE );
#endif


#ifndef QT4

	// window-toolbar
	m_bbEditorWindow = new QToolButton( embed::getIconPixmap( "bb_track" ),
						tr( "Show/Hide Beat+Bassline "
							"Editor" ) + " (F6)",
						QString::null,
					this, SLOT( toggleBBEditorWin() ),
								m_windowTools );
	m_bbEditorWindow->setAccel( Qt::Key_F6 );
#ifdef QT4
	m_bbEditorWindow->setWhatsThis( 
#else
	QWhatsThis::add( m_bbEditorWindow, 
#endif
		tr( "By pressing this button, you can show or hide the "
			"Beat+Bassline Editor. The Beat+Bassline Editor is "
			"needed for setting beats, opening, adding and "
			"removing channels, cutting, copying and pasting "
			"beat- and bassline-patterns and other things like "
			"that." ) );


	m_pianoRollWindow = new QToolButton( embed::getIconPixmap( "piano" ),
						tr( "Show/Hide Piano-Roll" ) +
									" (F7)",
								QString::null,
					this, SLOT( togglePianoRollWin() ),
								m_windowTools );
	m_pianoRollWindow->setAccel( Key_F7 );
	QWhatsThis::add( m_pianoRollWindow, tr( "By pressing this button, you "
						"can show or hide the "
						"Piano-Roll. With the help of "
						"the Piano-Roll you can edit "
						"melody-patterns in an easy "
						"way." ) );

	m_projectNotesWindow = new QToolButton( embed::getIconPixmap(
							"project_notes" ),
						tr( "Show/Hide Project notes" )+
								" (F10)",
								QString::null,
					this, SLOT( toggleProjectNotesWin() ),
								m_windowTools );
	m_projectNotesWindow->setAccel( Key_F10 );
	QWhatsThis::add( m_projectNotesWindow, tr( "By pressing this button, "
							"you can show or hide "
							"the project notes "
							"window. "
							"In this window you "
							"can put down your "
							"project notes.") );

	m_songEditorWindow = new QToolButton( embed::getIconPixmap(
								"songeditor" ),
						tr( "Show/Hide Song-Editor" ) +
									" (F8)",
								QString::null,
					this, SLOT( toggleSongEditorWin() ),
								m_windowTools );
	m_songEditorWindow->setAccel( Qt::Key_F8 );
#ifdef QT4
	m_songEditorWindow->setWhatsThis(
#else
	QWhatsThis::add( m_songEditorWindow,
#endif
		tr( "By pressing this button, you can show or hide the "
			"Song-Editor. With the Song-Editor you can edit the "
			"song and set when and which track should be played. "
			"You can also insert and move samples (e.g. "
			"rap-samples) directly in the playlist." ) );


	m_effectBoardWindow = new QToolButton( embed::getIconPixmap(
							"effect_board" ),
						tr( "Show/Hide EffectBoard" ) +
									" (F9)",
						QString::null,
						this, SLOT( emptySlot() ),
								m_windowTools );
	m_effectBoardWindow->setAccel( Qt::Key_F9 );
#ifdef QT4
	m_effectBoardWindow->setWhatsThis( 
#else
	QWhatsThis::add( m_effectBoardWindow,
#endif
		tr( "By pressing this button, you can show or hide the "
			"EffectBoard. The EffectBoard is a very powerful tool "
			"for managing effects for your song. You can insert "
			"effects into different effect-channels." ) );

#endif

//#ifndef QT4
	// create a "What's this"-Button
//	(void) QWhatsThis::whatsThisButton( m_windowTools );


	// project-popup-menu
	m_projectMenu = new QMenu( this );
#ifdef QT4
	menuBar()->addMenu( m_projectMenu )->setText( tr( "&Project" ) );
#else
	menuBar()->insertItem( tr( "&Project" ), m_projectMenu );
#endif
	m_projectMenu->addAction( embed::getIconPixmap( "project_new" ),
					tr( "&New" ),
					this, SLOT( createNewProject() ),
					Qt::CTRL + Qt::Key_N );

	m_projectMenu->addAction( embed::getIconPixmap( "project_open" ),
					tr( "&Open..." ),
					this, SLOT( openProject() ),
					Qt::CTRL + Qt::Key_O );	

	m_projectMenu->addAction( embed::getIconPixmap( "project_save" ),
					tr( "&Save" ),
					this, SLOT( saveProject() ),
					Qt::CTRL + Qt::Key_S );

	m_projectMenu->addAction( embed::getIconPixmap( "project_saveas" ),
					tr( "Save &As..." ),
					this, SLOT( saveProjectAs() ),
					Qt::CTRL + Qt::SHIFT + Qt::Key_S );
#ifdef QT4
	m_projectMenu->addSeparator();
#else
	m_projectMenu->insertSeparator();
#endif
	m_projectMenu->addAction( /*embed::getIconPixmap( "project_import" ),*/
					tr( "Import file" ),
					songEditor::inst(),
					SLOT( importProject() ) );
#ifdef QT4
	m_projectMenu->addSeparator();
#else
	m_projectMenu->insertSeparator();
#endif
	m_projectMenu->addAction( embed::getIconPixmap( "project_export" ),
					tr( "E&xport" ),
					songEditor::inst(),
					SLOT( exportProject() ),
					Qt::CTRL + Qt::Key_E );
#ifdef QT4
	m_projectMenu->addSeparator();
#else
	m_projectMenu->insertSeparator();
#endif
	m_projectMenu->addAction( embed::getIconPixmap( "exit" ), tr( "&Quit" ),
					qApp, SLOT( closeAllWindows() ),
					Qt::CTRL+Qt::Key_Q );


	QMenu * m_settingsMenu = new QMenu( this );
#ifdef QT4
	menuBar()->addMenu( m_settingsMenu )->setText( tr( "&Settings" ) );
#else
	menuBar()->insertItem( tr( "&Settings" ), m_settingsMenu );
#endif
	m_settingsMenu->addAction( embed::getIconPixmap( "setup_general" ),
					tr( "Show settings dialog" ),
					this, SLOT( showSettingsDialog() ) );
	m_settingsMenu->addAction( embed::getIconPixmap( "wizard" ),
					tr( "Show setup wizard" ),
					configManager::inst(), SLOT( exec() ) );

	
	// help-popup-menu
	m_helpMenu = new QMenu( this );
#ifdef QT4
	menuBar()->addMenu( m_helpMenu )->setText( tr( "&Help" ) );
#else
	menuBar()->insertItem( tr( "&Help" ), m_helpMenu );
#endif
	m_helpMenu->addAction( embed::getIconPixmap( "help" ), tr( "Help" ),
							this, SLOT( help() ) );
	m_helpMenu->addAction( embed::getIconPixmap( "whatsthis" ),
					tr( "What's this?" ),
					this, SLOT( enterWhatsThisMode() ) );
#ifdef QT4
	m_helpMenu->addSeparator();
#else
	m_helpMenu->insertSeparator();
#endif
	m_helpMenu->addAction( embed::getIconPixmap( "icon" ), tr( "About" ),
						this, SLOT( aboutLMMS() ) );

	// now start mixer-thread
	mixer::inst()->start(
#if QT_VERSION >= 0x030200
			QThread::HighestPriority
#endif
				);

	// setup-dialog opened before?
	if( !configManager::inst()->value( "app", "configured" ).toInt() )
	{
		// no, so show it that user can setup everything
		setupDialog().exec();
		configManager::inst()->setValue( "app", "configured", "1" );
	}
	// look whether mixer could use a audio-interface beside audioDummy
	else if( mixer::inst()->audioDevName() == audioDummy::name() )
	{
		// no, so we offer setup-dialog with audio-settings...
		setupDialog sd( setupDialog::AUDIO_SETTINGS );
		sd.exec();
	}
}




lmmsMainWin::~lmmsMainWin()
{
	// first make sure mixer-thread is in our way during clean-up...
	mixer::inst()->quitThread();

	// destroy editors with all their children
	delete songEditor::inst();
	delete bbEditor::inst();

	presetPreviewPlayHandle::cleanUp();


	// destroy mixer
	delete mixer::inst();


	// now we can clean up all allocated buffer
	bufferAllocator::cleanUp( 0 );

	// destroy config-manager (which automatically saves config-file)
	delete configManager::inst();

}




void lmmsMainWin::resetWindowTitle( const QString & _add )
{
	QString title = _add;
	if( _add == "" && songEditor::inst()->projectFileName() != "" )
	{
		title = QFileInfo( songEditor::inst()->projectFileName()
#ifdef QT4
						).completeBaseName();
#else
						).baseName( TRUE );
#endif
	}
	if( title != "" )
	{
		title += " - ";
	}
	setWindowTitle( title + tr( "LMMS %1" ).arg( VERSION ) );
}




void lmmsMainWin::closeEvent( QCloseEvent * _ce )
{
	if( songEditor::inst()->mayChangeProject() == TRUE )
	{
		_ce->accept();
	}
	else
	{
		_ce->ignore();
	}
}




void lmmsMainWin::createNewProject( void )
{
	if( songEditor::inst()->mayChangeProject() == TRUE )
	{
		songEditor::inst()->createNewProject();
	}
}




void lmmsMainWin::createNewProjectFromTemplate( int _idx )
{
#ifdef QT4
	// TODO!!!
#else
	if( m_templatesMenu != NULL &&
				songEditor::inst()->mayChangeProject() == TRUE )
	{
		songEditor::inst()->createNewProjectFromTemplate(
			configManager::inst()->projectsDir() + "templates/" +
				m_templatesMenu->text( _idx ) + ".xml" );
	}
#endif
}




void lmmsMainWin::openProject( void )
{
	if( songEditor::inst()->mayChangeProject() == TRUE )
	{
#ifdef QT4
		QFileDialog ofd( this, tr( "Open project" ), "",
					tr( "MultiMedia Project (*.xml)" ) );
#else
		QFileDialog ofd( QString::null,
					tr( "MultiMedia Project (*.xml)" ),
							this, "", TRUE );
		ofd.setWindowTitle( tr( "Open project" ) );
#endif
		ofd.setDirectory( configManager::inst()->projectsDir() );
		ofd.setFileMode( QFileDialog::ExistingFiles );
		if( ofd.exec () == QDialog::Accepted &&
						!ofd.selectedFiles().isEmpty() )
		{
			songEditor::inst()->loadProject(
						ofd.selectedFiles()[0] );
		}
	}
}




bool lmmsMainWin::saveProject( void )
{
	if( songEditor::inst()->projectFileName() == "" )
	{
		return( saveProjectAs() );
	}
	else
	{
		songEditor::inst()->saveProject();
	}
	return( TRUE );
}




bool lmmsMainWin::saveProjectAs( void )
{
#ifdef QT4
	QFileDialog sfd( this, tr( "Save project" ), "",
					tr( "MultiMedia Project (*.xml)" ) );
#else
	QFileDialog sfd( QString::null, tr( "MultiMedia Project (*.xml)" ),
							this, "", TRUE );
	sfd.setWindowTitle( tr( "Save project" ) );
#endif
	sfd.setFileMode( QFileDialog::AnyFile );
	QString f = songEditor::inst()->projectFileName();
	if( f != "" )
	{
		sfd.selectFile( QFileInfo( f ).fileName() );
#ifdef QT4
		sfd.setDirectory( QFileInfo( f ).absolutePath() );
#else
		sfd.setDirectory( QFileInfo( f ).dirPath( TRUE ) );
#endif
	}
	else
	{
		sfd.setDirectory( configManager::inst()->projectsDir() );
	}

	if( sfd.exec () == QFileDialog::Accepted &&
#ifdef QT4
		!sfd.selectedFiles().isEmpty() && sfd.selectedFiles()[0] != ""
#else
		sfd.selectedFile() != ""
#endif
 		)
	{
#ifdef QT4
		songEditor::inst()->saveProjectAs( sfd.selectedFiles()[0] );
#else
		songEditor::inst()->saveProjectAs( sfd.selectedFile() );
#endif
		return( TRUE );
	}
	return( FALSE );
}




void lmmsMainWin::toggleBBEditorWin( void )
{
	if( bbEditor::inst()->isHidden() == TRUE ||
			m_workspace->activeWindow() != bbEditor::inst() )
	{
		bbEditor::inst()->show();
		bbEditor::inst()->setFocus();
	}
	else
	{
		bbEditor::inst()->hide();
	}
}




void lmmsMainWin::toggleSongEditorWin( void )
{
	if( songEditor::inst()->isHidden() == TRUE ||
			m_workspace->activeWindow() != songEditor::inst() )
	{
		songEditor::inst()->show();
		songEditor::inst()->setFocus();
	}
	else
	{
		songEditor::inst()->hide();
	}
}




void lmmsMainWin::toggleProjectNotesWin( void )
{
	if( songEditor::inst()->getProjectNotesWindow()->isHidden() == TRUE ||
		m_workspace->activeWindow() !=
				songEditor::inst()->getProjectNotesWindow() )
	{
		songEditor::inst()->getProjectNotesWindow()->show();
		songEditor::inst()->getProjectNotesWindow()->setFocus();
	}
	else
	{
		songEditor::inst()->getProjectNotesWindow()->hide();
	}
}




void lmmsMainWin::togglePianoRollWin( void )
{
	if( pianoRoll::inst()->isHidden() == TRUE ||
			m_workspace->activeWindow() != pianoRoll::inst() )
	{
		pianoRoll::inst()->show();
		pianoRoll::inst()->setFocus();
	}
	else
	{
		pianoRoll::inst()->hide();
	}
}




void lmmsMainWin::showSettingsDialog( void )
{
	setupDialog().exec();
}




void lmmsMainWin::aboutLMMS( void )
{
	aboutDialog().exec();
}




void lmmsMainWin::help( void )
{
	QMessageBox::information( this, tr( "Help not available" ),
					tr( "Currently there's no help "
						"available in LMMS.\n"
						"Please visit "
						"http://lmms.sourceforge.net "
						"and click on "
						"\"Documentation\".\nThere "
						"hopefully you'll find the "
						"stuff you want to know..." ),
					QMessageBox::Ok );
}



#include "lmms_main_win.moc"

