/*
 * midi_out.cpp - soundgenerator midiOut which just sends all notes to external
 *                MIDI-device
 *
 * Linux MultiMedia Studio
 * Copyright (c) 2004-2005 Tobias Doerffel <tobydox@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */


#include "qt3support.h"

#ifdef QT4

#include <Qt/QtXml>

#else

#include <qdom.h>

#endif


#include "midi_out.h"
#include "channel_track.h"
#include "embed.h"
#include "note_play_handle.h"



const QString midiOut::s_pluginName = "MIDI-Out";
const QString midiOut::s_pluginNodeName = "midiout";


midiOut::midiOut( channelTrack * _channel_track ) :
	soundGenerator( _channel_track )
{
#ifdef QT4
	QPalette pal;
	pal.setBrush( backgroundRole(), embed::getIconPixmap(
							"midiout_artwork" ) );
	setPalette( pal );
#else
	setErasePixmap( embed::getIconPixmap( "midiout_artwork" ) );
#endif
}




midiOut::~midiOut()
{
}




void midiOut::saveSettings( QDomDocument & _doc, QDomElement & _parent )
{
	QDomElement mo_de = _doc.createElement( nodeName() );
	_parent.appendChild( mo_de );
}




void midiOut::loadSettings( const QDomElement & _this )
{
}




QDomElement midiOut::defaultSettings( void )
{
	QDomDocument d;
	QDomElement e = d.createElement( s_pluginNodeName );
	e.setTagName( s_pluginNodeName );
	return( e );
}




void midiOut::playNote( notePlayHandle * _n )
{
	if( _n->totalFramesPlayed() == 0 )
	{
		int key = _n->getChannelTrack()->masterKey( _n );

		// send according note-on-event...
		mixer::inst()->getMIDIDevice()->processOutEvent(
				midiEvent( NOTE_ON, 0, key, _n->getVolume() *
								128 / 100 ) );
	}
}




void midiOut::deleteNotePluginData( notePlayHandle * _n )
{
	int key = _n->getChannelTrack()->masterKey( _n );
	mixer::inst()->getMIDIDevice()->processOutEvent(
					midiEvent( NOTE_OFF, 0, key, 0 ) );
}





#include "midi_out.moc"

