/*
 * fstclient.h - client for XFST-server
 *
 * Copyright (c) 2005 Tobias Doerffel <tobydox/at/users.sourceforge.net>
 * 
 * This file is part of Linux MultiMedia Studio - http://lmms.sourceforge.net
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */


#ifndef _FSTCLIENT_H
#define _FSTCLIENT_H


#include "qt3support.h"

#ifdef QT4

#include <QString>
#include <QMutex>

#else

#include <qstring.h>
#include <qmutex.h>

#endif


#include "mixer.h"
#include "communication.h"
#include "midi.h"



class remoteVSTPlugin
{
public:
	remoteVSTPlugin( const QString & _plugin );
	~remoteVSTPlugin();

	void showEditor( void );
	void hideEditor( void );

	const QString & name( void ) const
	{
		return( m_name );
	}
	const QString & vendorString( void ) const
	{
		return( m_vendorString );
	}
	const QString & productString( void ) const
	{
		return( m_productString );
	}

	Sint32 vstVersion( void ) const
	{
		return( m_vstVersion );
	}
	
	void process( sampleFrame * _in_buf, sampleFrame * _out_buf );
	void enqueueMidiEvent( const midiEvent & _event,
						const Uint32 _frames_ahead );

	Uint8 inputCount( void ) const
	{
		return( m_inputCount );
	}

	Uint8 outputCount( void ) const
	{
		return( m_outputCount );
	}

	QWidget * pluginWidget( void )
	{
		return( m_pluginWidget );
	}

	bool failed( void ) const
	{
		return( m_failed );
	}


private:
	template<typename T>
	inline T readValueS( void ) const
	{
		return( ::readValue<T>( m_serverInFD ) );
	}

	template<typename T>
	inline void writeValueS( const T & _i ) const
	{
		::writeValue<T>( _i, m_serverOutFD );
	}

	inline std::string readStringS( void ) const
	{
		return( ::readString( m_serverInFD ) );
	}

	inline void writeStringS( const char * _str ) const
	{
		::writeString( _str, m_serverOutFD );
	}

	inline void lock( void )
	{
		m_serverMutex.lock();
	}

	inline void unlock( void )
	{
		m_serverMutex.unlock();
	}

	bool messagesLeft( void ) const;
	Sint16 processNextMessage( void );

	void setShmKeyAndSize( const Uint16 _key, const size_t _size );
	void setPluginXID( const Sint32 _plugin_xid );



	bool m_failed;
	QString m_plugin;
	QWidget * m_pluginWidget;
	Sint32 m_pluginWID;

	int m_pipes[2][2];
	int m_serverInFD;
	int m_serverOutFD;

	QMutex m_serverMutex;

	QString m_name;
	QString m_vendorString;
	QString m_productString;
	Sint32 m_vstVersion;

	Uint8 m_inputCount;
	Uint8 m_outputCount;

	int m_shmID;
	float * m_shm;
	size_t m_shmSize;

} ;


#endif
