import gtk

class Alert:

    def __init__(self, icontype, buttons, primary, secondary):
    	self.buttons = buttons

    	alert = gtk.Dialog()
	for i in range(len(buttons)):
	    alert.add_button(buttons[i][0], i)
    	alert.set_default_response(len(buttons) - 1)
	alert.connect("response", self.response)

	icon = gtk.Image()
	icon.set_from_stock(icontype, gtk.ICON_SIZE_DIALOG)
	icon.show()

	label = gtk.Label()
	label.set_markup('<span weight="bold" size="larger">' +
	    	    	 primary +
			 '</span>\n\n' +
			 secondary)
	label.show()

	hbox = gtk.HBox()
	hbox.pack_start(icon)
	hbox.pack_start(label)
	hbox.show()

	alert.vbox.pack_start(hbox)

    	alert.set_property("title", u"")
    	alert.set_property("border-width", 6)
#    	alert.set_property("type", u"")
    	alert.set_property("resizable", gtk.FALSE)
    	alert.set_property("has-separator", gtk.FALSE)
	
	alert.vbox.set_property("spacing", 12)
	
	hbox.set_property("spacing", 12)
	hbox.set_property("border-width", 6)
	
	icon.set_property("yalign", 0.0)
	
	label.set_property("selectable", gtk.TRUE)
	label.set_property("use-markup", gtk.TRUE)
	label.set_property("wrap", gtk.TRUE)
	label.set_property("yalign", 0.0)

	alert.show()

    def response(self, dialog, response_id):
    	dialog.destroy()
	tuple = self.buttons[response_id]
	if len(tuple) == 2:
	    tuple[1]()
