import gobject
import gtk

import MetaData


class Model:

    NAME_COLUMN = 0
    IS_EDITABLE_COLUMN = 1
    OBJECT_COLUMN = 2

    def __init__(self, doc):
    	assert doc == None or doc.type == u"lodju-document"
    	self.doc = doc
    	self.store = gtk.TreeStore(gobject.TYPE_STRING, 
	    	    	    	   gobject.TYPE_BOOLEAN,
				   gobject.TYPE_PYOBJECT)
    	self.editable = gtk.TRUE

    def set_document(self, doc):
    	self.doc = doc
	self.populate()

    def populate_helper(self, parent, folder):
    	iter = self.store.insert_before(parent, None)
	self.set_folder(iter, folder)
	for subfolder in folder.subfolders.get():
	    self.populate_helper(iter, subfolder)

    def populate(self):
    	self.store.clear()
	if self.doc:
	    for folder in self.doc.folders.get():
		self.populate_helper(None, folder)

    def set_folder(self, iter, folder):
    	self.store.set_value(iter, self.OBJECT_COLUMN, folder)
	self.store.set_value(iter, self.NAME_COLUMN, folder[u"name"])
	self.store.set_value(iter, self.IS_EDITABLE_COLUMN, self.editable)
	folder.listen(self.folder_attribute_changed)
	if self.doc:
	    self.doc.make_dirty()

    def get_folder(self, iter):
    	return self.store.get_value(iter, self.OBJECT_COLUMN)

    def get_folder_from_path(self, path):
    	return self.get_folder(self.store.get_iter(path))

    def get_folder_name(self, iter):
    	return self.store.get_value(iter, self.NAME_COLUMN)

    def find_folder_helper(self, folder, iter):
    	while iter != None:
	    if self.store.get_value(iter, self.OBJECT_COLUMN) == folder:
		return iter
    	    i2 = self.find_folder_helper(folder, 
	    	    	    	    	 self.store.iter_children(iter))
    	    if i2:
	    	return i2
	    iter = self.store.iter_next(iter)
    	return None

    def find_folder(self, folder):
    	return self.find_folder_helper(folder, self.store.get_iter_first())

    def folder_attribute_changed(self, folder, name):
    	if name == u"name":
	    iter = self.find_folder(folder)
	    if iter:
		self.store.set_value(iter, self.NAME_COLUMN, folder[u"name"])

    def path_to_last_folder(self):
	 iter = self.store.get_iter_first()
	 if iter is None:
	    return None
	 while iter:
	    last = iter
	    iter = self.store.iter_next(iter)
	 return self.store.get_path(last)

    def paste_folder(self, selected_iter, new_folder):
    	if selected_iter:
	    iter = self.store.insert_after(None, selected_iter)
    	else:
	    iter = self.store.insert_before(None, None)
    	self.set_folder(iter, new_folder)
	for subfolder in new_folder.subfolders.get():
	    self.paste_folder_as_child(iter, subfolder)
	return iter

    def paste_folder_before(self, selected_iter, new_folder):
	iter = self.store.insert_before(None, selected_iter)
    	self.set_folder(iter, new_folder)
	for subfolder in new_folder.subfolders.get():
	    self.paste_folder_as_child(iter, subfolder)
	return iter

    def paste_folder_as_child(self, selected_iter, new_folder):
	iter = self.store.insert_before(selected_iter, None)
    	self.set_folder(iter, new_folder)
	for subfolder in new_folder.subfolders.get():
	    self.paste_folder_as_child(iter, subfolder)
	return iter

    def set_subfolders(self, iter):
    	folder = self.get_folder(iter)
	folder.subfolders.clear()
	child = self.store.iter_children(iter)
	while child:
	    folder.subfolders.add(self.get_folder(child))
	    self.set_subfolders(child)
	    child = self.store.iter_next(child)

    def build_folder_tree(self):
    	folders = MetaData.Folders()
    	iter = self.store.get_iter_first()
	while iter:
	    self.set_subfolders(iter)
	    folders.add(self.get_folder(iter))
	    iter = self.store.iter_next(iter)
	self.doc.set_folders(folders)

    def collect_ids(self, folders):
    	ids = []
    	for folder in folders:
	    ids = ids + \
	    	  [folder[u"id"]] + \
		  map(lambda p: p[u"id"], folder.photos.get()) + \
	    	  self.collect_ids(folder.subfolders.get())
	return ids

    def collect_items(self, items):
    	list = []
    	for item in items:
	    list.append(item)
	    if item.type == u"folder":
	    	list = list + item.photos.get() + \
		    	self.collect_items(item.subfolders.get())
    	return list

    def set_unique_ids(self, metadatas):
    	self.build_folder_tree()
	ids = self.collect_ids(self.doc.folders.get())
    	for metadata in self.collect_items(metadatas):
	    id = metadata[u"id"]
	    while id in ids:
		id = u"%d" % MetaData.id_counter.get()
	    metadata[u"id"] = id
	    ids.append(id)

    def copy_file(self, orig_filename, dest_stream):
    	f = open(orig_filename, "r")
	while 1:
	    data = f.read(64 * 1024)
	    if not data:
	    	break
	    dest_stream.write(data)
    	f.close()

    def copy_from_other_lodju(self, photolist):
    	for photo in photolist:
	    f = self.doc.storage.new_original(photo[u"id"])
	    self.copy_file(photo[u"dnd:original-filename"], f)
	    self.doc.storage.close_original(photo[u"id"], f)
	    f = self.doc.storage.new_thumbnail(photo[u"id"])
	    self.copy_file(photo[u"dnd:thumbnail-filename"], f)
	    self.doc.storage.close_thumbnail(photo[u"id"], f)

    def copy_folders_from_other_lodju(self, folderlist):
    	for folder in folderlist:
	    self.copy_from_other_lodju(folder.photos.get())
	    self.copy_folders_from_other_lodju(folder.subfolders.get())

class View:

    def __init__(self, window, model, controller, xml):
    	self.window = window
    	self.model = model
	self.controller = controller
	
    	# Create the tree view itself
	self.widget = xml.get_widget("folder_tree")
	self.widget.set_model(model.store)
	self.renderer = gtk.CellRendererText()
	self.renderer.connect("edited", self.controller.folder_name_edited)
	self.column = gtk.TreeViewColumn("Folder", self.renderer,
				     text=self.model.NAME_COLUMN,
				     editable=self.model.IS_EDITABLE_COLUMN)
	self.widget.append_column(self.column)

    	self.widget.connect("drag-begin", self.controller.drag_begin)
    	self.widget.connect("drag-data-get", self.controller.drag_data_get)
    	self.widget.connect("drag-data-delete", 
	    	    	    self.controller.drag_data_delete)
    	self.widget.connect("drag-end", self.controller.drag_end)
    	self.widget.drag_source_set(gtk.gdk.BUTTON1_MASK,
				    [("application/x-lodju-folders", 0, 1)],
				    gtk.gdk.ACTION_MOVE)

    	self.widget.connect("drag-motion", self.controller.drag_motion)
#    	self.widget.connect("drag-leave", self.controller.drag_leave)
    	self.widget.connect("drag-data-received", 
	    	    	    self.controller.drag_data_received)
    	self.widget.drag_dest_set(gtk.DEST_DEFAULT_ALL,
	    	    	    	  [("application/x-lodju-folders", 0, 0),
	    	    	    	   ("application/x-lodju-photos", 0, 1)],
				  gtk.gdk.ACTION_MOVE)
	
	self.selection = self.widget.get_selection()
	self.selection.set_mode(gtk.SELECTION_MULTIPLE)
	self.selection.connect("changed", self.controller.selection_changed)

	self.thumb_area = None
	self.drop_highlight = None
	
	self.model.populate()
	
    	self.folder_menu_entries = {}
	for name in ["delete_folder", "folder_properties", "export_folder"]:
	    self.folder_menu_entries[name] = xml.get_widget(name)
	self.set_sensitivity()

    def store_iter(self, *args):
    	self.selection_iters.append(args[2])

    def get_selection_iters(self):
    	self.selection_iters = []
	self.selection.selected_foreach(self.store_iter)
	return self.selection_iters

    def set_sensitivity(self):
    	iters = self.get_selection_iters()
	if len(iters) == 1:
	    sensitive = ["delete_folder", "folder_properties", "export_folder"]
    	elif len(iters) > 1:
	    sensitive = ["export_folder"]
	else:
	    sensitive = []
	for name in self.folder_menu_entries.keys():
	    if name in sensitive:
	    	self.folder_menu_entries[name].set_sensitive(gtk.TRUE)
    	    else:
	    	self.folder_menu_entries[name].set_sensitive(gtk.FALSE)

    def set_thumb_area(self, thumb_area):
    	self.thumb_area = thumb_area

    def draw_rectangle(self, gc, rect):
    	window = self.widget.get_bin_window()
	x, y, width, height = rect
	window.draw_rectangle(gc, gtk.FALSE, x, y, width, height)

    def drop_position(self, has_folder, x, y):
    	tuple = self.widget.get_dest_row_at_pos(x, y)
	if not tuple:
	    return None, 0
	path, drop_pos = tuple
	if drop_pos == gtk.TREE_VIEW_DROP_BEFORE:
	    return path, -1
	if drop_pos == gtk.TREE_VIEW_DROP_AFTER:
	    return path, 1
    	return path, 0

    def draw_drop_highlight(self, has_folder, x, y):
	bg = self.widget.get_style().bg_gc[gtk.STATE_NORMAL]
	fg = self.widget.get_style().fg_gc[gtk.STATE_NORMAL]

    	if self.drop_highlight:
	    self.draw_rectangle(bg, self.drop_highlight)

    	path, before_on_or_after = self.drop_position(has_folder, x, y)
	if path:
	    cellarea = self.widget.get_cell_area(path, self.column)
	    if before_on_or_after == -1:
		self.drop_highlight = (cellarea.x, cellarea.y, 
				       cellarea.width, 1)
    	    elif before_on_or_after == 0:
		self.drop_highlight = (cellarea.x, cellarea.y, 
		    	    	       cellarea.width, cellarea.height)
	    else:
		self.drop_highlight = (cellarea.x, 
				       cellarea.y + cellarea.height, 
				       cellarea.width, 1)
    	    self.draw_rectangle(fg, self.drop_highlight)
	else:
	    self.drop_highlight = None

class Controller:

    def __init__(self, model, view):
    	self.model = model
	self.view = view
	self.dragged_folder = None
	self.type_folders = gtk.gdk.atom_intern("application/x-lodju-folders")
	self.type_photos = gtk.gdk.atom_intern("application/x-lodju-photos")

    def selection_changed(self, *args):
    	iters = self.view.get_selection_iters()
	folders = map(lambda iter: self.model.get_folder(iter), iters)
	self.view.thumb_area.set_folders(folders)
	self.view.set_sensitivity()

    def folder_name_edited(self, *args):
    	pass

    def get_selection_iters_helper(self, model, path, iter):
    	self.iters.append(iter)

    def get_selection_iters(self):
    	self.iters = []
	self.view.selection.selected_foreach(self.get_selection_iters_helper)
	return self.iters

    def dropping_folder(self, context):
    	atom = gtk.gdk.atom_intern("application/x-lodju-folders")
	return atom in context.targets

    def drag_motion(self, *args):
	widget, context, x, y, timestamp = args
	self.view.draw_drop_highlight(self.dropping_folder(context), x, y)

    def is_selection_or_child(self, path):
	for iter in self.get_selection_iters():
	    sel = self.model.store.get_path(iter)
	    if len(path) >= len(sel) and path[:len(sel)] == sel:
	    	return iter
	return None

    def drag_data_received(self, *args):
	widget, context, x, y, selectiondata, info, timestamp = args
	internal = self.view.window.drag_source_is_within_window(context)
	is_folders = self.type_folders == selectiondata.target
	path, before_on_or_after = self.view.drop_position(is_folders, x, y)
	p = MetaData.Parser()
	p.feed(selectiondata.data)
	if path:
	    if is_folders:
    	    	new_folders = p.close()
		assert new_folders.type == u"folders"
		folders = new_folders.get()
		if not internal:
		    self.model.set_unique_ids(folders)
		    self.model.copy_folders_from_other_lodju(folders)
	    	iter = self.model.store.get_iter(path)
		xiter = self.is_selection_or_child(path)
    	    	if xiter:
		    for f in folders:
			xiter = self.model.paste_folder_before(xiter, f)
	    	elif before_on_or_after == -1:
		    list = folders[:]
		    iter = self.model.paste_folder_before(iter, list[0])
		    for f in list[1:]:
			iter = self.model.paste_folder(iter, f)
		elif before_on_or_after == 0:
		    list = folders[:]
		    iter = self.model.paste_folder_as_child(iter, list[0])
		    for f in list[1:]:
			iter = self.model.paste_folder(iter, f)
		elif before_on_or_after >= 0:
		    for f in folders:
		    	iter = self.model.paste_folder(iter, f)
    	    else:
	    	assert selectiondata.target == self.type_photos
    	    	photos = p.close().get()
		if not internal:
		    self.model.set_unique_ids(photos)
		    self.model.copy_from_other_lodju(photos)
		else:
		    self.view.window.thumb.controller.internal_drag = 1
		folder = self.model.get_folder_from_path(path)
		for photo in photos:
		    folder.photos.add(photo)
		if not internal:
		    self.view.thumb_area.reset_folders()
    	else:
	    assert is_folders
	    new_folders = p.close()
	    assert new_folders.type == u"folders"
	    new_folders = new_folders.get()
	    if not internal:
		self.model.set_unique_ids(new_folders)
		self.model.copy_folders_from_other_lodju(new_folders)
	    iter = None
	    for f in new_folders:
		iter = self.model.paste_folder(iter, f)

    def set_image_file_attributes(self, folder):
    	for photo in folder.photos.get():
	    photo.set_image_filenames(self.model.doc.storage)
    	for subfolder in folder.subfolders.get():
	    self.set_image_file_attributes(subfolder)

    def unset_image_file_attributes(self, folder):
    	for photo in folder.photos.get():
	    photo.unset_image_filenames()
    	for subfolder in folder.subfolders.get():
	    self.set_image_file_attributes(subfolder)

    def drag_begin(self, *args):
    	folders = MetaData.Folders()
    	for iter in self.get_selection_iters():
	    self.model.set_subfolders(iter)
	    folder = self.model.get_folder(iter)
	    folders.add(folder)
    	for folder in folders.get():
	    self.set_image_file_attributes(folder)
	self.dragged_folder = folders.get_xml_document()
    	for folder in folders.get():
	    self.unset_image_file_attributes(folder)

#    def drag_leave(self, *args):
#	self.view.undraw_drop_indicator()

    def drag_data_get(self, *args):
    	assert type(self.dragged_folder) == type(u"")
	area, context, selectiondata, info, data = args
	selectiondata.set(selectiondata.target, 8,
			  self.dragged_folder.encode("utf-8"))

    def drag_data_delete(self, *args):
	for iter in self.get_selection_iters():
	    self.model.store.remove(iter)
	    self.model.doc.make_dirty()
	
    def drag_end(self, *args):
	return
