#!/bin/sh

set -e

XSL="convert-lodju1-to-lodju2.xsl"

if [ "$2" = "" ]
then
    echo "Usage: $0 old-file.lodju new-directory.lodju" 1>&2
    exit 1
fi

input="$1"
output="$2"

if [ -e "$output" ]
then
    echo "$0: Already exists: $output" 1>&2
    exit 1
fi

mkdir -p "$output"
mkdir -p "$output/orig"
mkdir -p "$output/orig.new"
mkdir -p "$output/thumb"
mkdir -p "$output/thumb.new"
xsltproc -o "$output/lodju.xml" "$XSL" "$input"
echo "Converted. Now start Lodju2 on $output and use 'Photo/Import missing'"
