#!/usr/bin/perl -w

#$Header: /mnt/u1/cvs/logtrend/logtrend-doc/doc/LogTrend-SimpleAgent-0.82.2/lib/LogTrend/Action/Execute.pm,v 1.1 2002/04/10 01:18:46 jdive Exp $
##*****************************************************************************
##  Class Execute
##  Description  : Write alarm in system logs using Syslog
##
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Laurent Simonneau l.simonneau@atrid.fr
##*****************************************************************************
#$Log: Execute.pm,v $
#Revision 1.1  2002/04/10 01:18:46  jdive
#fixed description, uncompressed simpleagent
#
#Revision 1.2  2001/11/02 13:55:42  lsimonneau
#Add Action support for agents' alarms.
#Add action support for LinuxAgent Process alarms.
#
#Revision 1.1  2001/10/31 16:44:53  lsimonneau
#Move Action from ComplexAlarm to LogTrend root.
#

package LogTrend::Action::Execute;

use strict;
use LogTrend::Action;

@LogTrend::Action::Execute::ISA = ("LogTrend::Action");

##*****************************************************************************
## Constructor  public
##  Description  : creat a new ExecuteAction
##  Parameters   : The XML node
##*****************************************************************************
sub new 
{
    my ($classname, $xml_node) = @_;
    my $self = $classname->SUPER::new();
    
    bless($self, $classname);
    
    $self->ParseXMLAction($xml_node);

    return $self;
}


##*****************************************************************************
## Method ParseXMLAction private
##  Description  : Run the action
##  Parameters   : none
##*****************************************************************************
sub ParseXMLAction
{
    my ($self, $node) = @_;
    my $list;
    
    $list = $node->getChildNodes();
    $node = $list->item(0) or die("Execute: invalid \"Execute\" Tag");
    
    $self->{COMMAND} = $node->getNodeValue();
}


##*****************************************************************************
## Method Run public
##  Description  : Run the action
##  Parameters   : the alarm level
##*****************************************************************************
sub Run 
{
    my ($self, $alarm_level) = @_;
    
    system("$self->{COMMAND}");
}

1;
