#!/usr/bin/perl -w

#$Header: /mnt/u1/cvs/logtrend/logtrend-doc/doc/LogTrend-SimpleAgent-0.82.2/lib/LogTrend/Action/SMS/SMSProxy.pm,v 1.1 2002/04/10 01:18:46 jdive Exp $
##*****************************************************************************
##  Class SMSProxy.pm
##  Description  : Interprete requests and create an XML description
##
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Laurent Simonneau l.simonneau@atrid.fr
##*****************************************************************************
#$Log: SMSProxy.pm,v $
#Revision 1.1  2002/04/10 01:18:46  jdive
#fixed description, uncompressed simpleagent
#
#Revision 1.2  2001/12/05 10:09:08  lsimonneau
#Minor bugfixes
#
#Revision 1.1  2001/10/31 16:44:53  lsimonneau
#Move Action from ComplexAlarm to LogTrend root.
#
#Revision 1.4  2001/09/14 15:21:22  lsimonneau
#minor bugfixes.
#
#Revision 1.3  2001/06/21 16:07:14  lsimonneau
#Dplacement de la clause 'package' avant les 'use'
#
#Revision 1.2  2001/06/05 08:54:28  lsimonneau
#Utilisation de HTML::Form pour construire les requtes dans SMSSender.
#
#Problme de Cookies : L'envoie de SMS avec genie.fr ne fonctionne
#plus. Le problme vient de cookies mais je ne sais pas comment le
#rsoudre. Peut tre que le probleme vient de libwww-perl.
#
#Plus aucun site ne fonctionne :(
#La plupart ce protgent contre les scripts.
#
#Revision 1.1  2001/05/30 09:36:57  lsimonneau
#Premire version du module d'alarmes complexes dans le CVS.
#Toutes les fonctionnalits ont t testes et correctement.
#

package LogTrend::Action::SMS::SMSProxy;

use strict;
use IO::Socket;
use LWP;
use LogTrend::Action::SMS::SMSUserAgent;
use HTTP::Daemon;
use HTTP::Request;
use HTTP::Response;
use HTTP::Cookies;
use HTML::Form;
use URI;
$URI::uric .= "|";
use URI::Escape;
use XML::Writer;


##*****************************************************************************
##  Constructor public
##  Description  : Create a new SMSProxy
##
##  Parameters   : none
##*****************************************************************************

sub new {
    my ($classname, $proxy_port) = @_;
    my  $self = {};

    bless($self, $classname);
    
    $self->{PORT} = $proxy_port;
    
    return $self;
}



##*****************************************************************************
##  Run method public
##  Description  : Start interpretation
##
##  Parameters   : none
##*****************************************************************************
sub Run {
    my ($self, $phone_nat, $phone_inter, $message, $xml_file_name) = @_;
    
    $message = URI::Escape::uri_escape($message);
    $message =~ s/%20/+/g;
    
    $self->{PHONE_NAT} = $phone_nat;
    $self->{PHONE_INTER} = $phone_inter;
    $self->{MESSAGE} = $message;

    # Create a new HTTP Daemon
    my $http_daemon = new HTTP::Daemon 
	LocalAddr => 'localhost',
	LocalPort => $self->{PORT};
    
    exit(1) unless defined $http_daemon;

    my $http_daemon_client_connect;

    # Create a new SMSUserAgent (isa LWP::UserAgent)
    my $user_agent = new SMSUserAgent;
    $user_agent->env_proxy();
    $user_agent->cookie_jar(new HTTP::Cookies);
    
    # Create the XML::Writer
    my $output = new IO::File(">$xml_file_name");
    $self->{XML_WRITER} = new XML::Writer(OUTPUT => $output);
    $self->{XML_WRITER}->xmlDecl();
    $self->{XML_WRITER}->startTag("SMSWebSite");


    $self->{PHONE_DETECTED} = 0;
    $self->{MESSAGE_DETECTED} = 0;
    
    # Foreach connection
    while($http_daemon_client_connect = $http_daemon->accept() and !$self->{PHONE_DETECTED} and !$self->{MESSAGE_DETECTED}) {
	my $save_cur_request = 0;

	# Wait for a request from the web browser
	my $request = $http_daemon_client_connect->get_request();
	
	my $request_method = $request->method();
	my $request_uri = URI->new($request->uri());
	
	#  look for form arguments in URI (for GET) or content (for PUT)
	my $form_args;
	if($request_method eq "GET" or $request_method eq "HEAD") {
	    # Check if there are form arguments in the URI
	    $form_args = $request_uri->query();
	}
	elsif($request_method eq "POST" or $request_method eq "PUT") {
	    $form_args = $request->content();
	}
	
	# Send the request and wait for the response
	my $response = $user_agent->request($request);
	
	my $response_type = $response->header("Content-Type");	
	$response_type = "" unless defined $response_type;

	# send the response to the client
	print $http_daemon_client_connect $response->as_string;

	my @temp_request_list = ([$request, $response]);

	# follow 301 or 302 Status code but save request and response and 
	# look for new cookies 
	while($response->is_redirect) {	    

	    if(defined $response->header("Set-Cookie") or
	       defined $response->header("Set-Cookie2")) {
		$save_cur_request = 1;
	    }
	    
	    # close connection and wait for a new connection from the browser 
	    close($http_daemon_client_connect);
	    $http_daemon_client_connect = $http_daemon->accept();

	    # get a new request
	    my $temp_request = $http_daemon_client_connect->get_request();
	    $response = $user_agent->request($temp_request);

	    # send it to the client
	    print $http_daemon_client_connect $response->as_string;

	    push @temp_request_list, [$temp_request, $response];
	}

	# set the $save_cur_request flag if there are cookies in the response header
	if(defined $response->header("Set-Cookie") or
	   defined $response->header("Set-Cookie2")) {
	    $save_cur_request = 1;
	}
	
	# if the response has text/html type
	if($response_type =~ /^text\/html/i) {
	    # if there are form arguments in URI
	    if(defined $form_args) {
		
		# look for the right form in the previous html page
		if($self->parseForm($request, $form_args) == 1) {
		    $save_cur_request = 1;
		    
		    # Remove the for args from the URI
		    if($request_method eq "GET") {
			$request->uri =~ /(.*?)\?/;
			$request->uri($1);
		    }
		}
	    }	    

	    if($save_cur_request) {
		# Save the request in the XML File
		if($self->{XML_WRITER}->current_element eq "Request") {
		    $self->{XML_WRITER}->endTag("Request");
		}
		
		my $request_referer = $request->header("Referer");
		$request_referer = "" unless defined $request_referer;

		$self->{XML_WRITER}->startTag("Request",
				      type => $request->method,
				      uri => $request->uri,
				      referer => $request_referer);

		$self->{LAST_SAVED_URL} = $request->uri;
	    }
	    
	    # save the last requests
	    push @{$self->{REQUEST_LIST}}, @temp_request_list;
	}
	
	close($http_daemon_client_connect);
    }
    
    close($http_daemon);
    
    if($self->{XML_WRITER}->current_element eq "Request") {
	$self->{XML_WRITER}->endTag("Request");
    }

    $self->{XML_WRITER}->endTag("SMSWebSite");
    $self->{XML_WRITER}->end();
}





##*****************************************************************************
##  parseForm method private
##  Description  : look form a form in HTML content
##
##  Parameters   : none
##*****************************************************************************

sub parseForm {
    my ($self, $request, $form_args) = @_;

    my $request_referer =  $request->header("Referer");
    return 0 unless defined $request_referer;
    
    my $index;
    # look for the request of the referer 
    for ($index = $#{$self->{REQUEST_LIST}};
	 $index >= 0 and $self->{REQUEST_LIST}[$index]->[0]->uri ne $request_referer;
	 $index--) {}
    
    # if there are no valid form in previous result
    return 0 if $index == -1;

    # Retrieve all form of the referer
    my @form_list = HTML::Form->parse($self->{REQUEST_LIST}[$index]->[1]->content(),
				      $self->{REQUEST_LIST}[$index]->[1]->base());

    
    # Create a hash (arg name, arg value) with the form args of the URI
    my %form_args_hash;
    while($form_args =~ s/(.*?)=(.*?)($|&)//i) {
	$form_args_hash{$1}=URI::Escape::uri_unescape($2);
    }
    
    # look for the right form in html data
    my $form_nb = 0;
    my $valid_form = -1;	
    my $max_arg_found = 0;

    foreach my $form (@form_list) {
	my $arg_found_nb=0;
	foreach my $arg (keys %form_args_hash) {
	    if(defined $form->find_input($arg)) {
		$arg_found_nb++;
	    }
	}
	
	if($arg_found_nb > $max_arg_found) {
	    $valid_form = $form_nb;
	    $max_arg_found = $arg_found_nb;
	}
	
	$form_nb++;
    }
    
    # Parse the valid form and build its XML Entity 
    my $referer_referer = $self->{REQUEST_LIST}[$index]->[0]->header("Referer");
    $referer_referer = "" unless defined $referer_referer;

    return 0 if $valid_form == -1 ;
	
    if(! ($self->{XML_WRITER}->current_element eq "Request" and 
	  $self->{LAST_SAVED_URL} eq $request_referer)) {
	
	if($self->{XML_WRITER}->current_element eq "Request") {
	    $self->{XML_WRITER}->endTag("Request");
	}
	
	$self->{XML_WRITER}->startTag("Request", 
				      type => $self->{REQUEST_LIST}[$index]->[0]->method,
				      uri => $self->{REQUEST_LIST}[$index]->[0]->uri,
				      referer => $referer_referer);
    }
    
    # save the form in the XML File
    $self->{XML_WRITER}->startTag("Form", nbr => $valid_form);
    
    # Look for field modified by user			
    foreach my $arg (keys %form_args_hash) {
	
	# if the field is present in the form
	if(defined $form_list[$valid_form]->find_input($arg)) {
	    my $form_arg_value = $form_list[$valid_form]->value($arg);
	    
	    # if the value of this field has not changed	    
	    if (defined $form_arg_value and
		$form_arg_value eq $form_args_hash{$arg}) {
		
		$self->{XML_WRITER}->emptyTag("Arg", name => $arg);
	    }
	    # if it's the phone number (national format)
	    elsif($form_args_hash{$arg} eq $self->{PHONE_NAT}) {
		#print "National phone number detected!!!\n";
		$self->{XML_WRITER}->emptyTag("Arg", name => $arg, is_national_phone_number => "1");
		
		$self->{PHONE_DETECTED} = 1;
	    }
	    # if it's the phone number (international format)
	    elsif($form_args_hash{$arg} eq $self->{PHONE_INTER}) {
		$self->{XML_WRITER}->emptyTag("Arg", name => $arg, is_international_phone_number => "1");
		
		$self->{PHONE_DETECTED} = 1;
	    }
	    # if it's the phone number (international format without plus)
	    elsif("+$form_args_hash{$arg}" eq $self->{PHONE_INTER}) {
		$self->{XML_WRITER}->emptyTag("Arg", name => $arg, is_international_phone_number_without_plus => "1");
		
		$self->{PHONE_DETECTED} = 1;
	    }
	    # if it's the message
	    elsif($form_args_hash{$arg} eq $self->{MESSAGE}) {
		$self->{XML_WRITER}->emptyTag("Arg", name => $arg, is_message => "1");
		
		$self->{MESSAGE_DETECTED}++;
	    }
	    # if the value of this field has changed
	    else {				    
		$self->{XML_WRITER}->emptyTag("Arg", 
					      name => $arg, value => $form_args_hash{$arg});
	    }
	}
	else {
	    $self->{XML_WRITER}->emptyTag("Arg", 
					  name => $arg, value => $form_args_hash{$arg});
	}
    }
    
    # Store the result
    $self->{XML_WRITER}->endTag("Form");
    $self->{XML_WRITER}->endTag("Request");
    
    return 1;
}		

1;
