#!/usr/bin/perl -w

#$Header: /mnt/u1/cvs/logtrend/logtrend-doc/doc/LogTrend-SimpleAgent-0.82.2/lib/LogTrend/Action/Xmessage.pm,v 1.1 2002/04/10 01:18:46 jdive Exp $
##*****************************************************************************
##  Class Xmessage 
##  Description  : Print an xmessage on specified display
##
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Laurent Simonneau l.simonneau@atrid.fr
##*****************************************************************************
#$Log: Xmessage.pm,v $
#Revision 1.1  2002/04/10 01:18:46  jdive
#fixed description, uncompressed simpleagent
#
#Revision 1.2  2001/11/02 13:55:42  lsimonneau
#Add Action support for agents' alarms.
#Add action support for LinuxAgent Process alarms.
#
#Revision 1.1  2001/10/31 16:44:53  lsimonneau
#Move Action from ComplexAlarm to LogTrend root.
#
#Revision 1.1  2001/10/01 09:12:00  lsimonneau
#Rename xmessageAction.pm into XmessageAction.pm
#--------------------------------------------
#
#Revision 1.4  2001/06/21 16:07:14  lsimonneau
#Dplacement de la clause 'package' avant les 'use'
#
#Revision 1.3  2001/06/20 14:09:53  lsimonneau
#Minor bugfixes
#
#Revision 1.2  2001/06/07 14:41:04  lsimonneau
#Passage du unshift @INC, '..' au LogTrend::
#
#Revision 1.1  2001/05/30 09:36:57  lsimonneau
#Premire version du module d'alarmes complexes dans le CVS.
#Toutes les fonctionnalits ont t testes et correctement.
#

package LogTrend::Action::Xmessage;

use strict;
use LogTrend::Action;

@LogTrend::Action::Xmessage::ISA = ("LogTrend::Action");

##*****************************************************************************
## Constructor  public
##  Description  : creat a new Xmessage
##  Parameters   : the xml node.
##*****************************************************************************
sub new 
{
    my ($classname, $xml_node) = @_;
    my $self = $classname->SUPER::new();          
    

    bless($self, $classname);
    
    $self->ParseXMLAction($xml_node);

    return $self;
}


##*****************************************************************************
## Method ParseXMLAction private
##  Description  : Run the action
##  Parameters   : none
##*****************************************************************************
sub ParseXMLAction
{
    my ($self, $node) = @_;
    my ($list, $attributes, $attrnode);
    
    $attributes = $node->getAttributes() || die("Error in \"Xmessage\" tag.");

    $attrnode = $attributes->getNamedItem("Display") ||
	die("No 'Display' field in \"Xmessage\" tag.");
    $self->{DISPLAY}=$attrnode->getValue();
    
    $list = $node->getChildNodes();        
    $node = $list->item(0) or die("Xmessage: invalid \"Xmessage\" Tag");
    
    $self->{MESSAGE} = $node->getNodeValue();
}


##*****************************************************************************
## Method Run public
##  Description  : Run the action
##  Parameters   : the alarm level
##*****************************************************************************
sub Run 
{
    my ($self, $alarm_level) = @_;
    
    system("xmessage \"$alarm_level \n\n$self->{MESSAGE}\n\n\"");
}

1;
