#!/usr/bin/perl -w

#$Header: /mnt/u1/cvs/logtrend/logtrend-doc/doc/LogTrend-SimpleAgent-0.82.2/lib/LogTrend/Agent/DataAlarmsSet.pm,v 1.1 2002/04/10 01:18:46 jdive Exp $
##******************************************************************************
## Class DataAlarmsSet
##  Description  : class to stock data and alarms
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Sylvain Lhullier s.lhullier@atrid.fr
##  Author       : David Mascle d.mascle@atrid.fr
##******************************************************************************
#$Log: DataAlarmsSet.pm,v $
#Revision 1.1  2002/04/10 01:18:46  jdive
#fixed description, uncompressed simpleagent
#
#Revision 1.9  2001/10/05 11:55:08  slhullier
#in the other case -> otherwise
#
#Revision 1.8  2001/06/20 13:54:25  slhullier
#
#Correction du bug GMT/LocalTime
#
#Revision 1.7  2001/06/07 14:08:54  slhullier
#
#Passage de  unshift @INC,'..';  aux packages Logtrend::....
#
#Revision 1.6  2001/06/01 08:17:44  fdesar
#
#Added IsEmpty methode to check if a collection collected something
#
#Revision 1.5  2001/04/20 07:13:31  slhullier
#
#Premier essais (concluant) de stockage des messages sur disque
#
#Revision 1.4  2001/03/08 17:33:54  slhullier
#
#L'agent ne meurt plus des que le serveur ne repond plus.
#
#Revision 1.3  2001/02/20 17:01:27  slhullier
#
#Mise en commentaire (+tab etc)
#
#Revision 1.2  2001/02/20 15:50:20  slhullier
#
#Apres modification du nom de certaines classes
#
#Revision 1.1.1.1  2001/02/06 09:48:28  fdubuy
#
#First CVS version : all work done by D.Mascle
#
#

package LogTrend::Agent::DataAlarmsSet;

use LogTrend::Agent::Data;
use LogTrend::Agent::DataDescriptionSet;
use LogTrend::Agent::Alarm;
use LogTrend::Agent::AlarmDescriptionSet;

##******************************************************************************
## Constructor  public
##  Parameters   : a collection date, an agent's source, an agent's number,
##                 an agent's version, an agent's activation date,
##                 a DataDescriptionSet object, an AlarmDescriptionSet object
##******************************************************************************
sub new
{
   my ($classname, $agentsource, $agentnumber, $agentversion,
       $agentactivationdate, $datadescriptionset, $alarmdescriptionset) = @_;
   my $self = {};
   bless($self, $classname);
   $self->{AGENTSOURCE} = $agentsource;
   $self->{AGENTNUMBER} = $agentnumber;
   $self->{AGENTVERSION} = $agentversion;
   $self->{AGENTACTIVATIONDATE} = $agentactivationdate;
   $self->{DATADESCRIPTIONSET} = $datadescriptionset;
   $self->{ALARMDESCRIPTIONSET} = $alarmdescriptionset;
   $self->NewDate();
   return $self;
}

##******************************************************************************
## Method NewDate
##  Description  : put the actual date in the $self->{COLLECTIONDATE} variable;
##  Parameters   : none
##  Return value : none
##******************************************************************************
sub NewDate
{
   my ($self) = @_;
   $self->{COLLECTIONDATE} = gmtime(time())." GMT";
}

##******************************************************************************
## Method Empty
##  Description  : 
##  Parameters   : 
##  Return value : 
##******************************************************************************
sub Empty
{
   my ($self) = @_;
   undef $self->{ALARMLIST};
   undef $self->{DATALIST};
}

##******************************************************************************
## Method IsEmpty
##  Description  : Test if a collection stored datas or alarms
##  Parameters   : none
##  Return value : true if neither datas or alarms have been collected,
##                 false otherwise
##******************************************************************************
sub IsEmpty
{
   my ($self) = @_;
   return(not defined($self->{ALARMLIST}) and not defined($self->{DATALIST}));
}

##******************************************************************************
## Method AddAlarm  public
##  Description  : adds an alarm to the set
##  Parameters   : an alarm number
##  Return value : 1 if successfull and 0 otherwise
##******************************************************************************
sub AddAlarm
{
   my ($self, $number) = @_;
   my $result = 0;

   if ($self->{ALARMDESCRIPTIONSET}->AlarmDescriptionExists($number))
   {
      if (!$self->AlarmIsAlreadyActivated($number))
      {
         push(@{$self->{ALARMLIST}}, LogTrend::Agent::Alarm->new($number));
         $result = 1;
      }
   }

   return $result;
}

##******************************************************************************
## Method AlarmIsAlreadyActivated  private
##  Description  : checks if an alarm is already activated
##  Parameters   : an alarm number
##  Return value : 1 if the test is positive and 0 otherwise
##******************************************************************************
sub AlarmIsAlreadyActivated
{
   my ($self, $number) = @_;
   my $result = 0;

   if (defined @{$self->{ALARMLIST}})
   {
      my $nbalarms = @{$self->{ALARMLIST}};
      my $ind = 0;

      while (!$result && ($ind < $nbalarms))
      {
         if ($self->{ALARMLIST}[$ind]->GetNumber() == $number)
         {
            $result = 1;
         }
         $ind++;
      }
   }

   return $result;
}

##******************************************************************************
## Method DataIsAlreadyInTheList  private
##  Description  : checks if a data is already in the list
##  Parameters   : a data number
##  Return value : 1 if the test is positive and 0 otherwise
##******************************************************************************
sub DataIsAlreadyInTheList
{
   my ($self, $number) = @_;
   my $result = 0;

   if (defined @{$self->{DATALIST}})
   {
      my $nbdata = @{$self->{DATALIST}};
      my $ind = 0;

      while (!$result && ($ind < $nbdata))
      {
         if ($self->{DATALIST}[$ind]->GetNumber() == $number)
         {
            $result = 1;
         }
         $ind++;
      }
   }

   return $result;
}

##******************************************************************************
## Method AddData  public
##  Description  : adds a data to the set
##  Parameters   : a data type, a data number, a data value
##  Return value : 1 if successfull and 0 otherwise
##******************************************************************************
sub AddData
{
   my ($self, $type, $number, $value) =@_;
   my $result = 0;

   if (!$self->DataIsAlreadyInTheList($number))
   {
      my $datatype = $self->{DATADESCRIPTIONSET}->GetDataType($number);
      if (defined $datatype)
      {
         if ($datatype eq $type)
         {
            push(@{$self->{DATALIST}}, LogTrend::Agent::Data->new($number, $value));
            $result = 1;
         }
      }
   }

   return $result;
}

##******************************************************************************
## Method AddDataText  public
##  Description  : adds a text data to the set
##  Parameters   : a data number, a data value
##  Return value : 1 if successfull and 0 otherwise
##******************************************************************************
sub AddDataText
{
   my ($self, $number, $value) =@_;
   return $self->AddData('Text', $number, $value);
}

##******************************************************************************
## Method AddDataInteger  public
##  Description  : adds an integer data to the set
##  Parameters   : a data number, a data value
##  Return value : 1 if successfull and 0 otherwise
##******************************************************************************
sub AddDataInteger
{
   my ($self, $number, $value) =@_;
   return $self->AddData('Integer', $number, $value);
}

##******************************************************************************
## Method AddDataReal  public
##  Description  : adds a real data to the set
##  Parameters   : a data number, a data value
##  Return value : 1 if successfull and 0 otherwise
##******************************************************************************
sub AddDataReal
{
   my ($self, $number, $value) =@_;
   return $self->AddData('Real', $number, $value);
}

##******************************************************************************
## Method AddDataDate  public
##  Description  : adds a date data to the set
##  Parameters   : a data number, a data value
##  Return value : 1 if successfull and 0 otherwise
##******************************************************************************
sub AddDataDate
{
   my ($self, $number, $value) =@_;
   return $self->AddData('Date', $number, $value);
}

##******************************************************************************
## Method AddDataTime  public
##  Description  : adds a time data to the set
##  Parameters   : a data number, a data value
##  Return value : 1 if successfull and 0 otherwise
##******************************************************************************
sub AddDataTime
{
   my ($self, $number, $value) =@_;
   return $self->AddData('Time', $number, $value);
}

##******************************************************************************
## Method AddDataDateTime  public
##  Description  : adds a date/time data to the set
##  Parameters   : a data number, a data value
##  Return value : 1 if successfull and 0 otherwise
##******************************************************************************
sub AddDataDateTime
{
   my ($self, $number, $value) =@_;
   return $self->AddData('DateTime', $number, $value);
}

##******************************************************************************
## Method ConvertToXml  public
##  Description  : formats the data/alarms set in xml
##  Parameters   : none
##  Return value : an xml string representation of the data/alarms set
##******************************************************************************
sub ConvertToXml
{
   my $self = shift;
   my $result = "<ADA>".
                "<S>".$self->{AGENTSOURCE}."</S>".
                "<N>".$self->{AGENTNUMBER}."</N>".
                "<V>".$self->{AGENTVERSION}."</V>".
                "<AD>".$self->{AGENTACTIVATIONDATE}."</AD>".
                "<CD>".$self->{COLLECTIONDATE}."</CD>".
                "<DT>";

   my $adata = undef;
   foreach $adata (@{$self->{DATALIST}})
   {
      $result = $result.${adata}->ConvertToXml();
   }
   $result = $result."</DT>";

   # adds the alarms' list
   $result = $result."<AT>";
   my $analarm = undef;
   foreach $analarm (@{$self->{ALARMLIST}})
   {
      $result = $result.${analarm}->ConvertToXml();
   }
   $result = $result."</AT>";

   $result = $result."</ADA>";

   return $result;
}

##******************************************************************************
1;
