#!/usr/bin/perl -w

#$Header: /mnt/u1/cvs/logtrend/logtrend-doc/doc/LogTrend-SimpleAgent-0.82.2/lib/LogTrend/Agent/DataDescriptionSet.pm,v 1.1 2002/04/10 01:18:46 jdive Exp $
##******************************************************************************
## Class DataDescriptionSet
##  Description  : class to stock data descriptions
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Sylvain Lhullier s.lhullier@atrid.fr
##  Author       : David Mascle d.mascle@atrid.fr
##******************************************************************************
#$Log: DataDescriptionSet.pm,v $
#Revision 1.1  2002/04/10 01:18:46  jdive
#fixed description, uncompressed simpleagent
#
#Revision 1.8  2001/10/05 11:55:08  slhullier
#in the other case -> otherwise
#
#Revision 1.7  2001/06/07 14:08:54  slhullier
#
#Passage de  unshift @INC,'..';  aux packages Logtrend::....
#
#Revision 1.6  2001/02/22 17:02:23  slhullier
#
#Gestion des systemes de fichiers par LinuxAgent.
#Premiers tests concluants, reste a ajouter des alarmes et a faire
#des tests en situation reelle.
#
#Revision 1.5  2001/02/21 09:27:06  slhullier
#
#Avant ajout de l'info dans le fichier de description de l'agent
#
#Revision 1.4  2001/02/20 17:01:27  slhullier
#
#Mise en commentaire (+tab etc)
#
#Revision 1.3  2001/02/20 15:50:20  slhullier
#
#Apres modification du nom de certaines classes
#
#Revision 1.2  2001/02/20 10:21:55  slhullier
#
#Passage de la fonction de parsage de config XML dans Agent.pm
#Creation des tags Generic et Specific
#Fichiers agentdescription.xml plus lisibles (avec \n)
#Supression de methodes pas appellee du fichier Agent.pm
#
#Revision 1.1.1.1  2001/02/06 09:48:27  fdubuy
#
#First CVS version : all work done by D.Mascle
#
#

package LogTrend::Agent::DataDescriptionSet;

use LogTrend::Agent::DataDescription;

##******************************************************************************
## Constructor  public
##  Description  : creat a new DataDescriptionSet
##******************************************************************************
sub new
{
   my ($classname) = @_;
   my $self = {};
   bless($self, $classname);
   return $self;
}

##******************************************************************************
## Method DataDescriptionExists  private
##  Description  : tests if a data description exists
##  Parameters   : a data description number
##  Return value : 1 if the data description exists and 0 otherwise
##******************************************************************************
sub DataDescriptionExists
{
   my ($self, $number) = @_;
   my $result = 0;

   if (defined @{$self->{DATADESCRIPTIONLIST}})
   {
      my $nbdata = @{$self->{DATADESCRIPTIONLIST}};
      my $ind = 0;

      while (!$result && ($ind < $nbdata))
      {
         if ($self->{DATADESCRIPTIONLIST}[$ind]->GetNumber() == $number)
         {
            $result = 1;
         }
         $ind++;
      }
   }

   return $result;
}

##******************************************************************************
## Method ConvertToXml  public
##  Description  : formats the data descriptions list in xml
##  Parameters   : none
##  Return value : an xml string representation of the data descriptions list
##******************************************************************************
sub ConvertToXml
{
   my $self = shift;
   my $result = "";

   $result = $result."<DataDescriptionSet>\n";

   my $datadescription = undef;

   foreach $datadescription (@{$self->{DATADESCRIPTIONLIST}})
   {
     $result = $result.${datadescription}->ConvertToXml();
   }

   $result = $result."</DataDescriptionSet>\n";

   return $result;
}

##******************************************************************************
## Method AddDataDescription  public
##  Description  : adds a data description to the data descriptions list
##  Parameters   : a data number, the data type, the data unit,
##                 an information message describing the data, an internal-info
##  Return value : 1 if successfull and 0 otherwise
##******************************************************************************
sub AddDataDescription
{
   my ($self, $number, $type, $unit, $description, $internal) = @_;
   my $result = 0;

   if (!$self->DataDescriptionExists($number))
   {
      push( @{$self->{DATADESCRIPTIONLIST}},
            LogTrend::Agent::DataDescription->new($number, $type, $unit, $description, $internal) );
      $result = 1;
   }

   return $result;
}

##******************************************************************************
## Method GetDataType  public
##  Description  : returns the type of a data
##  Parameters   : a data number
##  Return value : a string representation of the type if successfull
##                 or undef otherwise
##******************************************************************************
sub GetDataType
{
   my ($self, $number) = @_;
   my $result = undef;

   if (defined @{$self->{DATADESCRIPTIONLIST}})
   {
      my $nbdata = @{$self->{DATADESCRIPTIONLIST}};
      my $ind = 0;
      my $found = 0;
      while (!$found && ($ind < $nbdata))
      {
         if ($self->{DATADESCRIPTIONLIST}[$ind]->GetNumber() == $number)
         {
            $result = $self->{DATADESCRIPTIONLIST}[$ind]->GetType($number);
            $found = 1;
         }
         $ind++;
      }
   }

   return $result;
}

##******************************************************************************
1;
