#!/usr/bin/perl -w

#$Header: /mnt/u1/cvs/logtrend/logtrend-doc/doc/LogTrend-SimpleAgent-0.82.2/lib/LogTrend/Agent/MailDataSender.pm,v 1.1 2002/04/10 01:18:46 jdive Exp $
##******************************************************************************
## Class MailDataSender  isa  DataSender
##  Description  : class for sending data to the server via mail
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Sylvain Lhullier s.lhullier@atrid.fr
##******************************************************************************
#$Log: MailDataSender.pm,v $
#Revision 1.1  2002/04/10 01:18:46  jdive
#fixed description, uncompressed simpleagent
#
#Revision 1.15.2.2  2002/02/20 14:25:34  lsimonneau
#*** empty log message ***
#
#Revision 1.20  2002/02/20 14:20:31  lsimonneau
#Use Reply-To instead of Return-Path in mails
#
#Revision 1.19  2002/02/20 14:04:48  lsimonneau
#Change Reply to instead of Return-Path in agents and MailBridge.pl.
#Major bugfixes in StorageServer GPG Key rings management.
#
#Revision 1.15.2.1  2002/02/14 15:43:30  lsimonneau
#Minor features enhancement
#Add a Sender attribut in the Mail tag of agents config file.
#Use SMTP Server when available or /usr/lib/sendmail otherwise.
#Add the -s <smtp_server> option to MailBridge.pl.
#
#Revision 1.16  2002/02/13 10:42:28  lsimonneau
#*** empty log message ***
#
#Revision 1.15  2002/01/16 14:42:45  slhullier
#sendmail -f$self->{ADMINMAIL}
#
#Revision 1.14  2002/01/08 12:42:56  lsimonneau
#Major bugfixes : Correct signature crash in daemon mode and use /usr/lib/sendmail -t -i
#to send mail insetead of MIME::Entity->smtpsend
#
#Revision 1.13  2001/12/10 16:58:34  lsimonneau
#Use GnuPG::Interface instead of Crypt::RSA for perl 5.005 compatibility.
#
#Revision 1.12  2001/11/16 10:32:28  lsimonneau
#Major feature enhancement : Implementation of authentification with RSA signatu
#re.
#
#IMPORTANT : Agents are incompatible with older version.
#
#Revision 1.11  2001/10/15 14:41:24  lsimonneau
#Implementation of a not sent data queue.
#When StorageServer is down or smtp server not respond, data is queued.
#The queue is emptied when connection can be established.
#If the agent is stopped (term int die ...) data is sent.
#If data can't be sent, a mail with queue file is sent to agent admin.
#
#Revision 1.10  2001/07/10 12:55:16  slhullier
#*** empty log message ***
#
#Revision 1.9  2001/06/07 14:08:54  slhullier
#
#Passage de  unshift @INC,'..';  aux packages Logtrend::....
#
#Revision 1.8  2001/04/10 15:43:01  slhullier
#
#Repository pour MailBridge en cours
#
#Revision 1.7  2001/03/26 09:00:10  slhullier
#
#MailBridge : XML et gzip opperationnel, mis en place spa/serveur
#
#Revision 1.6  2001/03/23 17:14:35  slhullier
#
#MailBridge: todo en XML, donnees gzip
#Pas fini : gunzip description
#
#Revision 1.5  2001/02/20 17:01:27  slhullier
#
#Mise en commentaire (+tab etc)
#
#Revision 1.4  2001/02/20 10:21:55  slhullier
#
#Passage de la fonction de parsage de config XML dans Agent.pm
#Creation des tags Generic et Specific
#Fichiers agentdescription.xml plus lisibles (avec \n)
#Supression de methodes pas appellee du fichier Agent.pm
#
#Revision 1.3  2001/02/09 10:11:11  slhullier
#
#
#Suppression ancienne fonction + petit oubli
#
#Revision 1.2  2001/02/08 15:21:52  slhullier
#
#
#Mail avec attachement : cote Agent fait.
#
#Revision 1.1  2001/02/07 14:38:09  slhullier
#
#
#Le systeme MailBridge fonctionne.
#Mise en service sur spa.
#

package LogTrend::Agent::MailDataSender;

use strict;
use LogTrend::Common::LogDie;
use LogTrend::Agent::DataSender;
use IO::Socket;
use MIME::Entity;
use Net::SMTP;
use Errno;

use vars qw( @ISA );
@ISA = ("LogTrend::Agent::DataSender");

##******************************************************************************
## Constructor  public  (>DataSender)
##  Parameters   : the host and port for connection, login and password for
##                 identification
##******************************************************************************
sub new
{
   my ($classname, $host, $port, $mailforbridge,
       $mail_smtp, $adminmail, $sendermail) = @_;
   my $self = $classname->SUPER::new( $host, $port );
   $self->{MAILFORBRIDGE} = $mailforbridge;
   $self->{MAIL_SMTP} = $mail_smtp;
   $self->{ADMINMAIL}     = $adminmail;
   $self->{SENDERMAIL}     = $sendermail;
   bless($self, $classname);
   return $self;
}

##******************************************************************************
## Method SetData  public  (>DataSender)
##  Description  : sends the agent's data and alarms to a storage server
##  Parameters   : the data to send (string)
##  Return value : 0 if successfull, 1 if problem with cache files or while sending mail.
##                 
##******************************************************************************
sub SendData
{
   my ($self, $xmldataandalarms, $signature) = @_;

   ##===========================================================================
   ## Directory creation
   ##===========================================================================
   my $tmpFilePrefix = "/tmp/logtrend-agent-";
   my $i=0;
   my $dir = $tmpFilePrefix.$$."-".$i;
   $! = 0;
   while( !mkdir( $dir, 0700 ) &&
          $!{EEXIST} )   # file exists
   {
      $i ++;
      $dir = $tmpFilePrefix.$$."-".$i;
      $! = 0;
   }

   if( $! != 0 )
   {
       SysLog("Can't open MailDataSender cache file : $!");
       return "ERROR IO Can't open MailDataSender cache file : $!";
   }
   
   ##===========================================================================
   ## Files creation
   ##===========================================================================
   if( ! open( TODO, ">$dir/todo.xml" ) )
   { 
       rmdir  "$dir";
       return "ERROR IO Can't open $dir/todo.xml for writing"; 
   }
   print TODO "<DataAndAlarms H=\"$self->{HOST}\" P=\"$self->{PORT}\" />\n";
   close TODO;

   if( ! open( XML, "|gzip -c>$dir/dataandalarms.xml.gz" ) )
   { 
       unlink "$dir/todo.xml"; 
       rmdir  "$dir"; 
       return "ERROR IO Can't open $dir/dataandalarms.xml.gz for writing"; 
   }
   print XML $xmldataandalarms;
   close XML;
     
   if( ! open( SIGNATURE, ">$dir/signature.asc" ) )
   { 
       unlink "$dir/todo.xml"; 
       unlink "$dir/dataandalarms.xml.gz"; 
       rmdir  "$dir"; 
       return "ERROR IO Can't open $dir/signature.asc for writing"; 
   }
   print SIGNATURE $signature;
   close SIGNATURE;
   

   ##===========================================================================
   ## Creating Mail
   ##===========================================================================
   my $mail = MIME::Entity->build( "Type"        => "multipart/mixed",
                                   "To"          => "$self->{MAILFORBRIDGE}",
                                   "From"        => "$self->{SENDERMAIL}",
                                   "Reply-To" => "$self->{ADMINMAIL}",
                                   "Subject"     => "LogTrend: SendDataAndAlarms" );

   $mail->attach( Path        => "$dir/todo.xml",
                  Type        => "application/logtrend",
                  Encoding    => "quoted-printable" );

   $mail->attach( Path        => "$dir/dataandalarms.xml.gz",
                  Type        => "application/x-gzip",
                  Encoding    => "base64" );

   $mail->attach( Path        => "$dir/signature.asc",
                  Type        => "text/plain",
                  Encoding    => "base64" );

   ##===========================================================================
   ## Sending Mail
   ##===========================================================================


   if($self->{MAIL_SMTP} eq 'localhost') {
        open(MAILER, "| /usr/lib/sendmail -t  -i -f$self->{SENDERMAIL}");
        $mail->print(\*MAILER);
        close(MAILER);
    }
    else {
        my $smtp = Net::SMTP->new($self->{MAIL_SMTP});
        $smtp->mail($self->{SENDERMAIL});
        $smtp->to($self->{MAILFORBRIDGE});
        $smtp->data([ $mail->stringify ]);
        $smtp->quit;
    }

   ##===========================================================================
   ## Deleting files & directory
   ##===========================================================================
   unlink "$dir/todo.xml";
   unlink "$dir/dataandalarms.xml.gz";
   rmdir  "$dir";

   return "OK";
}

##******************************************************************************
1;
