#!/usr/bin/perl -w

#$Header: /mnt/u1/cvs/logtrend/logtrend-doc/doc/LogTrend-SimpleAgent-0.82.2/lib/LogTrend/Common/Duration.pm,v 1.1 2002/04/10 01:18:47 jdive Exp $
##******************************************************************************
## Class Duration
##  Description  : A package for duration interpretation
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Sylvain Lhullier s.lhullier@atrid.fr (06.03.2001)
##******************************************************************************
#$Log: Duration.pm,v $
#Revision 1.1  2002/04/10 01:18:47  jdive
#fixed description, uncompressed simpleagent
#
#Revision 1.7  2001/11/09 13:42:42  slhullier
#Duration/Interval/StartStop modification
#
#Revision 1.6  2001/11/06 14:30:06  slhullier
#Empty string bug-fixed
#
#Revision 1.5  2001/11/02 09:36:36  slhullier
#Duration: adding new format (2w3j) and ReverseDuration
#
#Revision 1.4  2001/06/29 07:32:40  slhullier
#
#Die->die
#
#Revision 1.3  2001/06/14 16:10:19  slhullier
#*** empty log message ***
#
#Revision 1.2  2001/06/07 14:08:54  slhullier
#
#Passage de  unshift @INC,'..';  aux packages Logtrend::....
#
#Revision 1.1  2001/03/09 16:16:23  slhullier
#
#Les seuils ne sont plus dans linuxagentdescription.xml
#mais relus dans Configuration.xml
#Gestion de la non reponse du serveur
#

package LogTrend::Common::Duration;

use Exporter;
use Time::Local;

use vars qw( @ISA @EXPORT );
@ISA = qw(Exporter);
@EXPORT = qw( &Duration &ReverseDuration );

use strict;

my @unitsList = ( 'y', 'M', 'w', 'd', 'h', 'm', 's' );
#           rank:  0    1    2    3    4    5    6

my %durationCoef = ( $unitsList[6] =>      1,                             # second
                     $unitsList[5] =>      60,                            # minute
                     $unitsList[4] =>      60*60,                         # hour
                     $unitsList[3] =>      60*60*24,                      # day
                     $unitsList[2] =>      60*60*24*   7,                 # week
                     $unitsList[1] => int( 60*60*24*(365.242/12) +0.5 ),  # month
                     $unitsList[0] => int( 60*60*24* 365.242 +0.5 )       # year
                   );

##******************************************************************************
## Function Duration
##  Description  : return number of seconds for duration
##  Parameters   : duration 2|(2s|2m|2h|2j|2w|2M|2y)+, am optional no-die flag
##  Return value : duration in seconds or a text-error
##******************************************************************************
sub Duration
{
   my ($duration,$noDie) = @_;
   my $seconds = 0;

   return $duration  if( $duration =~ /^[0-9]+$/ );

   my $units = join( '', @unitsList );

   if( $duration =~ /^([0-9]+[$units])*$/ )
   {
      foreach my $d ($duration =~ /[0-9]+[$units]/g )
      {
         my ($v,$u) = ($d =~ /([0-9]+)([$units])/);
         $seconds += $v * $durationCoef{$u};
      }
      return $seconds;
   }
   else
   {
      my $error = "bad duration description \"$duration\"";
      return $error  if( defined($noDie) );
      die( $error );
   }

}

##******************************************************************************
## Function ReverseDuration   public
##  Description  : return a Duration string representing the time duration
##                 in its canonical format
##  Parameters   : a number of seconds
##  Return value : a valid Duration string
##******************************************************************************
sub ReverseDuration
{
   my $seconds = shift;
   my $string = "";

   if( $seconds !~ /^[0-9]+$/ )
   {
      $seconds = Duration($seconds);
   }

   foreach my $u (@unitsList)
   {
      my $coef = int($seconds/$durationCoef{$u});
      if( $coef > 0 )
      {
         $string  .= $coef.$u;
         $seconds -= $coef*$durationCoef{$u};
      }
   }

   $string = "0"  if( $string eq "" );

   return $string;

}

##******************************************************************************
1;
