;; Titlepage.dsl 
;; Dfinition de la page de couverture des supports de cours Atrid
;; Reprend presque en intgralit le dbttlpg.dsl des feuilles de style Docbook
;; Les modifications concernent la taille des polices et l'espacement des sections
;;
;; Version 1.0 - Frdric DUBUY - 26 octobre 2000
;;
;; == Title pages for BOOKs =============================================

(define (book-titlepage-recto-elements)
  (list (normalize "title") 
	(normalize "subtitle") 
	(normalize "graphic") 
	(normalize "mediaobject")
	(normalize "corpauthor") 
	(normalize "authorgroup") 
	(normalize "author") 
	(normalize "editor")))

(define (book-titlepage-verso-elements)
  (list (normalize "title") 
	(normalize "subtitle") 
	(normalize "corpauthor") 
	(normalize "authorgroup") 
	(normalize "author") 
	(normalize "editor")
	(normalize "edition") 
	(normalize "pubdate") 
	(normalize "copyright")
	(normalize "abstract") 
	(normalize "legalnotice") 
	(normalize "revhistory")))

(define (book-titlepage-content? elements side)
  (titlepage-content? elements (if (equal? side 'recto)
				   (book-titlepage-recto-elements)
				   (book-titlepage-verso-elements))))

(define (book-titlepage elements #!optional (side 'recto))
  (let ((nodelist (titlepage-nodelist 
		   (if (equal? side 'recto)
		       (book-titlepage-recto-elements)
		       (book-titlepage-verso-elements))
		   elements)))
    (make simple-page-sequence
      page-n-columns: %titlepage-n-columns%
      input-whitespace-treatment: 'collapse
      use: default-text-style

      ;; This hack is required for the RTF backend. If an external-graphic
      ;; is the first thing on the page, RTF doesn't seem to do the right
      ;; thing (the graphic winds up on the baseline of the first line
      ;; of the page, left justified).  This "one point rule" fixes
      ;; that problem.
      (make paragraph
	line-spacing: 1pt
	(literal ""))
      
      (let loop ((nl nodelist) (lastnode (empty-node-list)))
	(if (node-list-empty? nl)
	    (empty-sosofo)
	    (make sequence
	      (if (or (node-list-empty? lastnode)
		      (not (equal? (gi (node-list-first nl))
				   (gi lastnode))))
		  (book-titlepage-before (node-list-first nl) side)
		  (empty-sosofo))
	      (cond
		((equal? (gi (node-list-first nl)) (normalize "abbrev"))
		 (book-titlepage-abbrev (node-list-first nl) side))
		((equal? (gi (node-list-first nl)) (normalize "abstract"))
		 (book-titlepage-abstract (node-list-first nl) side))
		((equal? (gi (node-list-first nl)) (normalize "address"))
		 (book-titlepage-address (node-list-first nl) side))
		((equal? (gi (node-list-first nl)) (normalize "affiliation"))
		 (book-titlepage-affiliation (node-list-first nl) side))
		((equal? (gi (node-list-first nl)) (normalize "artpagenums"))
		 (book-titlepage-artpagenums (node-list-first nl) side))
		((equal? (gi (node-list-first nl)) (normalize "author"))
		 (book-titlepage-author (node-list-first nl) side))
		((equal? (gi (node-list-first nl)) (normalize "authorblurb"))
		 (book-titlepage-authorblurb (node-list-first nl) side))
		((equal? (gi (node-list-first nl)) (normalize "authorgroup"))
		 (book-titlepage-authorgroup (node-list-first nl) side))
		((equal? (gi (node-list-first nl)) (normalize "authorinitials"))
		 (book-titlepage-authorinitials (node-list-first nl) side))
		((equal? (gi (node-list-first nl)) (normalize "bibliomisc"))
		 (book-titlepage-bibliomisc (node-list-first nl) side))
		((equal? (gi (node-list-first nl)) (normalize "biblioset"))
		 (book-titlepage-biblioset (node-list-first nl) side))
		((equal? (gi (node-list-first nl)) (normalize "bookbiblio"))
		 (book-titlepage-bookbiblio (node-list-first nl) side))
		((equal? (gi (node-list-first nl)) (normalize "citetitle"))
		 (book-titlepage-citetitle (node-list-first nl) side))
		((equal? (gi (node-list-first nl)) (normalize "collab"))
		 (book-titlepage-collab (node-list-first nl) side))
		((equal? (gi (node-list-first nl)) (normalize "confgroup"))
		 (book-titlepage-confgroup (node-list-first nl) side))
		((equal? (gi (node-list-first nl)) (normalize "contractnum"))
		 (book-titlepage-contractnum (node-list-first nl) side))
		((equal? (gi (node-list-first nl)) (normalize "contractsponsor"))
		 (book-titlepage-contractsponsor (node-list-first nl) side))
		((equal? (gi (node-list-first nl)) (normalize "contrib"))
		 (book-titlepage-contrib (node-list-first nl) side))
		((equal? (gi (node-list-first nl)) (normalize "copyright"))
		 (book-titlepage-copyright (node-list-first nl) side))
		((equal? (gi (node-list-first nl)) (normalize "corpauthor"))
		 (book-titlepage-corpauthor (node-list-first nl) side))
		((equal? (gi (node-list-first nl)) (normalize "corpname"))
		 (book-titlepage-corpname (node-list-first nl) side))
		((equal? (gi (node-list-first nl)) (normalize "date"))
		 (book-titlepage-date (node-list-first nl) side))
		((equal? (gi (node-list-first nl)) (normalize "edition"))
		 (book-titlepage-edition (node-list-first nl) side))
		((equal? (gi (node-list-first nl)) (normalize "editor"))
		 (book-titlepage-editor (node-list-first nl) side))
		((equal? (gi (node-list-first nl)) (normalize "firstname"))
		 (book-titlepage-firstname (node-list-first nl) side))
		((equal? (gi (node-list-first nl)) (normalize "graphic"))
		 (book-titlepage-graphic (node-list-first nl) side))
		((equal? (gi (node-list-first nl)) (normalize "honorific"))
		 (book-titlepage-honorific (node-list-first nl) side))
		((equal? (gi (node-list-first nl)) (normalize "indexterm"))
		 (book-titlepage-indexterm (node-list-first nl) side))
		((equal? (gi (node-list-first nl)) (normalize "invpartnumber"))
		 (book-titlepage-invpartnumber (node-list-first nl) side))
		((equal? (gi (node-list-first nl)) (normalize "isbn"))
		 (book-titlepage-isbn (node-list-first nl) side))
		((equal? (gi (node-list-first nl)) (normalize "issn"))
		 (book-titlepage-issn (node-list-first nl) side))
		((equal? (gi (node-list-first nl)) (normalize "issuenum"))
		 (book-titlepage-issuenum (node-list-first nl) side))
		((equal? (gi (node-list-first nl)) (normalize "itermset"))
		 (book-titlepage-itermset (node-list-first nl) side))
		((equal? (gi (node-list-first nl)) (normalize "keywordset"))
		 (book-titlepage-keywordset (node-list-first nl) side))
		((equal? (gi (node-list-first nl)) (normalize "legalnotice"))
		 (book-titlepage-legalnotice (node-list-first nl) side))
		((equal? (gi (node-list-first nl)) (normalize "lineage"))
		 (book-titlepage-lineage (node-list-first nl) side))
		((equal? (gi (node-list-first nl)) (normalize "mediaobject"))
		 (book-titlepage-mediaobject (node-list-first nl) side))
		((equal? (gi (node-list-first nl)) (normalize "modespec"))
		 (book-titlepage-modespec (node-list-first nl) side))
		((equal? (gi (node-list-first nl)) (normalize "orgname"))
		 (book-titlepage-orgname (node-list-first nl) side))
		((equal? (gi (node-list-first nl)) (normalize "othercredit"))
		 (book-titlepage-othercredit (node-list-first nl) side))
		((equal? (gi (node-list-first nl)) (normalize "othername"))
		 (book-titlepage-othername (node-list-first nl) side))
		((equal? (gi (node-list-first nl)) (normalize "pagenums"))
		 (book-titlepage-pagenums (node-list-first nl) side))
		((equal? (gi (node-list-first nl)) (normalize "printhistory"))
		 (book-titlepage-printhistory (node-list-first nl) side))
		((equal? (gi (node-list-first nl)) (normalize "productname"))
		 (book-titlepage-productname (node-list-first nl) side))
		((equal? (gi (node-list-first nl)) (normalize "productnumber"))
		 (book-titlepage-productnumber (node-list-first nl) side))
		((equal? (gi (node-list-first nl)) (normalize "pubdate"))
		 (book-titlepage-pubdate (node-list-first nl) side))
		((equal? (gi (node-list-first nl)) (normalize "publisher"))
		 (book-titlepage-publisher (node-list-first nl) side))
		((equal? (gi (node-list-first nl)) (normalize "publishername"))
		 (book-titlepage-publishername (node-list-first nl) side))
		((equal? (gi (node-list-first nl)) (normalize "pubsnumber"))
		 (book-titlepage-pubsnumber (node-list-first nl) side))
		((equal? (gi (node-list-first nl)) (normalize "releaseinfo"))
		 (book-titlepage-releaseinfo (node-list-first nl) side))
		((equal? (gi (node-list-first nl)) (normalize "revhistory"))
		 (book-titlepage-revhistory (node-list-first nl) side))
		((equal? (gi (node-list-first nl)) (normalize "seriesinfo"))
		 (book-titlepage-seriesinfo (node-list-first nl) side))
		((equal? (gi (node-list-first nl)) (normalize "seriesvolnums"))
		 (book-titlepage-seriesvolnums (node-list-first nl) side))
		((equal? (gi (node-list-first nl)) (normalize "subjectset"))
		 (book-titlepage-subjectset (node-list-first nl) side))
		((equal? (gi (node-list-first nl)) (normalize "subtitle"))
		 (book-titlepage-subtitle (node-list-first nl) side))
		((equal? (gi (node-list-first nl)) (normalize "surname"))
		 (book-titlepage-surname (node-list-first nl) side))
		((equal? (gi (node-list-first nl)) (normalize "title"))
		 (book-titlepage-title (node-list-first nl) side))
		((equal? (gi (node-list-first nl)) (normalize "titleabbrev"))
		 (book-titlepage-titleabbrev (node-list-first nl) side))
		((equal? (gi (node-list-first nl)) (normalize "volumenum"))
		 (book-titlepage-volumenum (node-list-first nl) side))
		(else
		 (book-titlepage-default (node-list-first nl) side)))
	      (loop (node-list-rest nl) (node-list-first nl))))))))

(define (book-titlepage-before node side)
  (if (equal? side 'recto)
      (cond
       ((equal? (gi node) (normalize "corpauthor"))
	(make paragraph
	  space-after: (* (HSIZE 5) %head-after-factor% 8)
	  (literal "\no-break-space;")))
       ((equal? (gi node) (normalize "authorgroup"))
	(if (have-sibling? (normalize "corpauthor") node)
	    (empty-sosofo)
	    (make paragraph
	      space-after: (* (HSIZE 5) %head-after-factor% 8)
	      (literal "\no-break-space;"))))
       ((equal? (gi node) (normalize "author"))
	(if (or (have-sibling? (normalize "corpauthor") node) 
		(have-sibling? (normalize "authorgroup") node))
	    (empty-sosofo)
	    (make paragraph
	      space-after: (* (HSIZE 5) %head-after-factor% 8)
	      (literal "\no-break-space;"))))
       (else (empty-sosofo)))
      (empty-sosofo)))

(define (book-titlepage-default node side)
  (let ((foo (debug (string-append "No book-titlepage-* for " (gi node) "!"))))
    (empty-sosofo)))

(define (book-titlepage-element node side)
  (if (equal? side 'recto)
      (with-mode book-titlepage-recto-mode
	(process-node-list node))
      (with-mode book-titlepage-verso-mode
	(process-node-list node))))

(define (book-titlepage-abbrev node side)
  (book-titlepage-element node side))
(define (book-titlepage-abstract node side)
  (book-titlepage-element node side))
(define (book-titlepage-address node side)
  (book-titlepage-element node side))
(define (book-titlepage-affiliation node side)
  (book-titlepage-element node side))
(define (book-titlepage-artpagenums node side)
  (book-titlepage-element node side))
(define (book-titlepage-author node side)
  (book-titlepage-element node side))
(define (book-titlepage-authorblurb node side)
  (book-titlepage-element node side))
(define (book-titlepage-authorgroup node side)
  (book-titlepage-element node side))
(define (book-titlepage-authorinitials node side)
  (book-titlepage-element node side))
(define (book-titlepage-bibliomisc node side)
  (book-titlepage-element node side))
(define (book-titlepage-biblioset node side)
  (book-titlepage node side))
(define (book-titlepage-bookbiblio node side)
  (book-titlepage node side))
(define (book-titlepage-citetitle node side)
  (book-titlepage-element node side))
(define (book-titlepage-collab node side)
  (book-titlepage-element node side))
(define (book-titlepage-confgroup node side)
  (book-titlepage-element node side))
(define (book-titlepage-contractnum node side)
  (book-titlepage-element node side))
(define (book-titlepage-contractsponsor node side)
  (book-titlepage-element node side))
(define (book-titlepage-contrib  node side)
  (book-titlepage-element node side))
(define (book-titlepage-copyright node side)
  (book-titlepage-element node side))

(define (book-titlepage-corpauthor node side)
  (if (equal? side 'recto)
      (book-titlepage-element node side)
      (if (first-sibling? node)
	  (make paragraph
	    (with-mode book-titlepage-verso-mode
	      (process-node-list
	       (select-elements (children (parent node)) 
				(normalize "corpauthor")))))
	  (empty-sosofo))))

(define (book-titlepage-corpname node side)
  (book-titlepage-element node side))
(define (book-titlepage-date node side)
  (book-titlepage-element node side))
(define (book-titlepage-edition node side)
  (book-titlepage-element node side))
(define (book-titlepage-editor node side)
  (book-titlepage-element node side))
(define (book-titlepage-firstname node side)
  (book-titlepage-element node side))
(define (book-titlepage-graphic node side)
  (book-titlepage-element node side))
(define (book-titlepage-honorific node side)
  (book-titlepage-element node side))
(define (book-titlepage-indexterm node side)
  (book-titlepage-element node side))
(define (book-titlepage-invpartnumber node side)
  (book-titlepage-element node side))
(define (book-titlepage-isbn node side)
  (book-titlepage-element node side))
(define (book-titlepage-issn node side)
  (book-titlepage-element node side))
(define (book-titlepage-issuenum node side)
  (book-titlepage-element node side))
(define (book-titlepage-itermset node side)
  (book-titlepage-element node side))
(define (book-titlepage-keywordset node side)
  (book-titlepage-element node side))
(define (book-titlepage-legalnotice node side)
  (book-titlepage-element node side))
(define (book-titlepage-lineage node side)
  (book-titlepage-element node side))
(define (book-titlepage-mediaobject node side)
  (book-titlepage-element node side))
(define (book-titlepage-modespec node side)
  (book-titlepage-element node side))
(define (book-titlepage-orgname node side)
  (book-titlepage-element node side))
(define (book-titlepage-othercredit node side)
  (book-titlepage-element node side))
(define (book-titlepage-othername node side)
  (book-titlepage-element node side))
(define (book-titlepage-pagenums node side)
  (book-titlepage-element node side))
(define (book-titlepage-printhistory node side)
  (book-titlepage-element node side))
(define (book-titlepage-productname node side)
  (book-titlepage-element node side))
(define (book-titlepage-productnumber node side)
  (book-titlepage-element node side))
(define (book-titlepage-pubdate node side)
  (book-titlepage-element node side))
(define (book-titlepage-publisher node side)
  (book-titlepage-element node side))
(define (book-titlepage-publishername node side)
  (book-titlepage-element node side))
(define (book-titlepage-pubsnumber node side)
  (book-titlepage-element node side))
(define (book-titlepage-releaseinfo node side)
  (book-titlepage-element node side))
(define (book-titlepage-revhistory node side)
  (book-titlepage-element node side))
(define (book-titlepage-seriesinfo node side)
  (book-titlepage-element node side))
(define (book-titlepage-seriesvolnums node side)
  (book-titlepage-element node side))
(define (book-titlepage-subjectset node side)
  (book-titlepage-element node side))
(define (book-titlepage-subtitle node side)
  (book-titlepage-element node side))
(define (book-titlepage-surname node side)
  (book-titlepage-element node side))
(define (book-titlepage-title node side)
  (book-titlepage-element node side))
(define (book-titlepage-titleabbrev node side)
  (book-titlepage-element node side))
(define (book-titlepage-volumenum node side)
  (book-titlepage-element node side))

(define book-titlepage-recto-style
  (style
      font-family-name: %title-font-family%
      font-weight: 'bold
      font-size: (HSIZE 1)))

(define book-titlepage-verso-style
  (style
      font-family-name: %body-font-family%))

(mode book-titlepage-recto-mode
  (element abbrev
    (make paragraph
      use: book-titlepage-recto-style
      quadding: %division-title-quadding%
      (process-children)))

  (element abstract
    (make display-group
      use: book-titlepage-recto-style
      quadding: 'start
      ($semiformal-object$)))

  (element (abstract title) (empty-sosofo))

  (element (abstract para)
    (make paragraph
      use: book-titlepage-recto-style
      quadding: 'start
      (process-children)))

  (element address 
    (make display-group
      use: book-titlepage-recto-style
      quadding: %division-title-quadding%
      (with-mode titlepage-address-mode 
	($linespecific-display$ %indent-address-lines% %number-address-lines%))))

  (element affiliation
    (make display-group
      use: book-titlepage-recto-style
      (process-children)))

  (element artpagenums
    (make paragraph
      use: book-titlepage-recto-style
      quadding: %division-title-quadding%
      (process-children)))

  (element author
    (let ((author-name  (author-string))
	  (author-affil (select-elements (children (current-node)) 
					 (normalize "affiliation"))))
      (make sequence      
	(make paragraph
	  use: book-titlepage-recto-style
	  font-size: (HSIZE 12)
	  line-spacing: (* (HSIZE 12) %line-spacing-factor%)
	  space-before: (* (HSIZE 2) %head-before-factor%)
	  quadding: %division-title-quadding%
	  keep-with-next?: #t
	  (literal author-name))
	(process-node-list author-affil))))

  (element authorblurb
    (make display-group
      use: book-titlepage-recto-style
      quadding: 'start
      (process-children)))

  (element (authorblurb para)
    (make paragraph
      use: book-titlepage-recto-style
      quadding: 'start
      (process-children)))

  (element authorgroup
    (make display-group
      (process-children)))

  (element authorinitials
    (make paragraph
      use: book-titlepage-recto-style
      quadding: %division-title-quadding%
      (process-children)))

  (element bibliomisc (process-children))

  (element bibliomset (process-children))

  (element collab
    (make paragraph
      use: book-titlepage-recto-style
      quadding: %division-title-quadding%
      (process-children)))

  (element confgroup
    (make paragraph
      use: book-titlepage-recto-style
      quadding: %division-title-quadding%
      (process-children)))

  (element contractnum
    (make paragraph
      use: book-titlepage-recto-style
      quadding: %division-title-quadding%
      (process-children)))

  (element contractsponsor
    (make paragraph
      use: book-titlepage-recto-style
      quadding: %division-title-quadding%
      (process-children)))

  (element contrib
    (make paragraph
      use: book-titlepage-recto-style
      quadding: %division-title-quadding%
      (process-children)))

  (element copyright
    (make paragraph
      use: book-titlepage-recto-style
      quadding: %division-title-quadding%
      (literal (gentext-element-name (current-node)))
      (literal "\no-break-space;")
      (literal (dingbat "copyright"))
      (literal "\no-break-space;")
      (process-children)))

  (element (copyright year)
    (make sequence
      (process-children)
      (if (not (last-sibling? (current-node)))
	  (literal ", ")
	  (literal (string-append " " (gentext-by) " ")))))
  
  (element (copyright holder) ($charseq$))

  (element corpauthor
    (make sequence
      (make paragraph
	use: book-titlepage-recto-style
	font-size: (HSIZE 12)
	line-spacing: (* (HSIZE 12) %line-spacing-factor%)
	space-before: (* (HSIZE 2) %head-before-factor%)
	quadding: %division-title-quadding%
	keep-with-next?: #t
	(process-children))
      ;; This paragraph is a hack to get the spacing right.
      ;; Authors always have an affiliation paragraph below them, even if
      ;; it's empty, so corpauthors need one too.
      (make paragraph
	use: book-titlepage-recto-style
	font-size: (HSIZE 1)
	line-spacing: (* (HSIZE 1) %line-spacing-factor%)
	space-after: (* (HSIZE 2) %head-after-factor% 4)
	quadding: %division-title-quadding%
	keep-with-next?: #t
	(literal "\no-break-space;"))))

  (element corpname
    (make paragraph
      use: book-titlepage-recto-style
      quadding: %division-title-quadding%
      (process-children)))

  (element date
    (make paragraph
      use: book-titlepage-recto-style
      quadding: %division-title-quadding%
      (process-children)))

  (element edition
    (make paragraph
      use: book-titlepage-recto-style
      quadding: %division-title-quadding%
      (process-children)
      (literal "\no-break-space;")
      (literal (gentext-element-name-space (gi (current-node))))))

  (element editor
    (let ((editor-name (author-string)))
      (make sequence      
	(if (first-sibling?) 
	    (make paragraph
	      use: book-titlepage-recto-style
	      font-size: (HSIZE 1)
	      line-spacing: (* (HSIZE 1) %line-spacing-factor%)
	      space-before: (* (HSIZE 2) %head-before-factor% 6)
	      quadding: %division-title-quadding%
	      keep-with-next?: #t
	      (literal (gentext-edited-by)))
	    (empty-sosofo))
	(make paragraph
	  use: book-titlepage-recto-style
	  font-size: (HSIZE 3)
	  line-spacing: (* (HSIZE 3) %line-spacing-factor%)
	  space-after: (* (HSIZE 2) %head-after-factor% 4)
	  quadding: %division-title-quadding%
	  keep-with-next?: #t
	  (literal editor-name)))))

  (element firstname
    (make paragraph
      use: book-titlepage-recto-style
      quadding: %division-title-quadding%
      (process-children)))

  (element graphic
    (let* ((nd (current-node))
	   (fileref (attribute-string "fileref" nd))
	   (entityref (attribute-string "entityref" nd))
	   (format (attribute-string "format" nd))
	   (align (attribute-string "align" nd)))
      (if (or fileref entityref) 
	  (make external-graphic
	    notation-system-id: (if format format "")
	    entity-system-id: (if fileref 
				  (graphic-file fileref)
				  (if entityref 
				      (entity-generated-system-id entityref)
				      ""))
	    display?: #t
	    display-alignment: 'center)
	  (empty-sosofo))))

  (element honorific
    (make paragraph
      use: book-titlepage-recto-style
      quadding: %division-title-quadding%
      (process-children)))

  (element isbn
    (make paragraph
      use: book-titlepage-recto-style
      quadding: %division-title-quadding%
      (process-children)))

  (element issn
    (make paragraph
      use: book-titlepage-recto-style
      quadding: %division-title-quadding%
      (process-children)))

  (element itermset (empty-sosofo))

  (element invpartnumber
    (make paragraph
      use: book-titlepage-recto-style
      quadding: %division-title-quadding%
      (process-children)))

  (element issuenum
    (make paragraph
      use: book-titlepage-recto-style
      quadding: %division-title-quadding%
      (process-children)))

  (element jobtitle
    (make paragraph
      use: book-titlepage-recto-style
      quadding: %division-title-quadding%
      (process-children)))

  (element keywordset (empty-sosofo))

  (element legalnotice
    (make display-group
      use: book-titlepage-recto-style
      ($semiformal-object$)))

  (element (legalnotice title) (empty-sosofo))

  (element (legalnotice para)
    (make paragraph
      use: book-titlepage-recto-style
      quadding: 'start
      line-spacing: (* 0.8 (inherited-line-spacing))
      font-size: (* 0.8 (inherited-font-size))
      (process-children)))

  (element lineage
    (make paragraph
      use: book-titlepage-recto-style
      quadding: %division-title-quadding%
      (process-children)))

  (element modespec (empty-sosofo))

  (element orgdiv
    (make paragraph
      use: book-titlepage-recto-style
      quadding: %division-title-quadding%
      (process-children)))

  (element orgname
    (make paragraph
      use: book-titlepage-recto-style
      quadding: %division-title-quadding%
      (process-children)))

  (element othercredit
    (make paragraph
      use: book-titlepage-recto-style
      quadding: %division-title-quadding%
      (process-children)))

  (element othername
    (make paragraph
      use: book-titlepage-recto-style
      quadding: %division-title-quadding%
      (process-children)))

  (element pagenums
    (make paragraph
      use: book-titlepage-recto-style
      quadding: %division-title-quadding%
      (process-children)))

  (element printhistory
    (make paragraph
      use: book-titlepage-recto-style
      quadding: %division-title-quadding%
      (process-children)))

  (element productname
    (make paragraph
      use: book-titlepage-recto-style
      quadding: %division-title-quadding%
      (process-children)))

  (element productnumber
    (make paragraph
      use: book-titlepage-recto-style
      quadding: %division-title-quadding%
      (process-children)))

  (element pubdate
    (make paragraph
      use: book-titlepage-recto-style
      quadding: %division-title-quadding%
      (process-children)))

  (element publisher
    (make display-group
      use: book-titlepage-recto-style
      quadding: %division-title-quadding%
      (process-children)))

  (element publishername
    (make paragraph
      use: book-titlepage-recto-style
      quadding: %division-title-quadding%
      (process-children)))

  (element pubsnumber
    (make paragraph
      use: book-titlepage-recto-style
      quadding: %division-title-quadding%
      (process-children)))

  (element releaseinfo
    (make paragraph
      use: book-titlepage-recto-style
      quadding: %division-title-quadding%
      (process-children)))

  (element revhistory
    (make sequence
      (make paragraph
	use: book-titlepage-recto-style
	space-before: (* (HSIZE 3) %head-before-factor%)
	space-after: (/ (* (HSIZE 1) %head-before-factor%) 2)
	(literal (gentext-element-name (current-node))))
      (make table
	before-row-border: #f
	(process-children))))
  
  (element (revhistory revision)
    (let ((revnumber (select-elements (descendants (current-node)) 
				      (normalize "revnumber")))
	  (revdate   (select-elements (descendants (current-node)) 
				      (normalize "date")))
	  (revauthor (select-elements (descendants (current-node))
				      (normalize "authorinitials")))
	  (revremark (select-elements (descendants (current-node))
				      (normalize "revremark"))))
      (make sequence
	(make table-row
	  (make table-cell
	    column-number: 1
	    n-columns-spanned: 1
	    n-rows-spanned: 1
	    start-indent: 0pt
	    (if (not (node-list-empty? revnumber))
		(make paragraph
		  use: book-titlepage-recto-style
		  font-size: %bf-size%
		  font-weight: 'medium
		  (literal (gentext-element-name-space (current-node)))
		  (process-node-list revnumber))
		(empty-sosofo)))
	  (make table-cell
	    column-number: 2
	    n-columns-spanned: 1
	    n-rows-spanned: 1
	    start-indent: 0pt
	    cell-before-column-margin: (if (equal? (print-backend) 'tex)
					   6pt
					   0pt)
	    (if (not (node-list-empty? revdate))
		(make paragraph
		  use: book-titlepage-recto-style
		  font-size: %bf-size%
		  font-weight: 'medium
		  (process-node-list revdate))
		(empty-sosofo)))
	  (make table-cell
	    column-number: 3
	    n-columns-spanned: 1
	    n-rows-spanned: 1
	    start-indent: 0pt
	    cell-before-column-margin: (if (equal? (print-backend) 'tex)
					   6pt
					   0pt)
	    (if (not (node-list-empty? revauthor))
		(make paragraph
		  use: book-titlepage-recto-style
		  font-size: %bf-size%
		  font-weight: 'medium
		  (literal (gentext-revised-by))
		  (process-node-list revauthor))
		(empty-sosofo))))
	(make table-row
	  cell-after-row-border: #f
	  (make table-cell
	    column-number: 1
	    n-columns-spanned: 3
	    n-rows-spanned: 1
	    start-indent: 0pt
	    (if (not (node-list-empty? revremark))
		(make paragraph
		  use: book-titlepage-recto-style
		  font-size: %bf-size%
		  font-weight: 'medium
		  space-after: (if (last-sibling?) 
				   0pt
				   (/ %block-sep% 2))
		  (process-node-list revremark))
		(empty-sosofo)))))))
  
  (element (revision revnumber) (process-children-trim))
  (element (revision date) (process-children-trim))
  (element (revision authorinitials) (process-children-trim))
  (element (revision revremark) (process-children-trim))

  (element seriesvolnums
    (make paragraph
      use: book-titlepage-recto-style
      quadding: %division-title-quadding%
      (process-children)))

  (element shortaffil
    (make paragraph
      use: book-titlepage-recto-style
      quadding: %division-title-quadding%
      (process-children)))

  (element subjectset (empty-sosofo))

  (element subtitle 
    (make paragraph
      use: book-titlepage-recto-style
      font-size: (HSIZE 4)
      line-spacing: (* (HSIZE 4) %line-spacing-factor%)
      space-before: (* (HSIZE 4) %head-before-factor%)
      quadding: %division-subtitle-quadding%
      keep-with-next?: #t
      (process-children-trim)))

  (element surname
    (make paragraph
      use: book-titlepage-recto-style
      quadding: %division-title-quadding%
      (process-children)))

  (element title 
    (make paragraph
      use: book-titlepage-recto-style
      font-size: (HSIZE 15)
      line-spacing: (* (HSIZE 15) %line-spacing-factor%)
      space-before: (* (HSIZE 5) %head-before-factor%)
      space-after: (* (HSIZE 15) %head-before-factor%)
      quadding: %division-title-quadding%
      keep-with-next?: #t
      (with-mode title-mode
	(process-children-trim))))

  (element titleabbrev (empty-sosofo))

  (element volumenum
    (make paragraph
      use: book-titlepage-recto-style
      quadding: %division-title-quadding%
      (process-children)))
)

(mode book-titlepage-verso-mode
  (element abbrev
    (make paragraph
      use: book-titlepage-verso-style
      (process-children)))

  (element abstract ($semiformal-object$))

  (element (abstract title) (empty-sosofo))

  (element address 
    (make display-group
      use: book-titlepage-verso-style
      (with-mode titlepage-address-mode 
	($linespecific-display$ %indent-address-lines% %number-address-lines%))))

  (element affiliation
    (make paragraph
      use: book-titlepage-verso-style
      (process-children)))

  (element artpagenums
    (make paragraph
      use: book-titlepage-verso-style
      (process-children)))

  (element author
    ;; Print the author name.  Handle the case where there's no AUTHORGROUP
    (let ((in-group (have-ancestor? (normalize "authorgroup") (current-node))))
      (if (not in-group)
	  (make paragraph
	    ;; Hack to get the spacing right below the author name line...
	    space-after: (* %bf-size% %line-spacing-factor%)
	    (make sequence
	      (literal (gentext-by))
	      (literal "\no-break-space;")
	      (literal (author-list-string))))
	  (make sequence 
	    (literal (author-list-string))))))  

  (element authorblurb
    (make paragraph
      use: book-titlepage-verso-style
      (process-children)))

  (element authorgroup
    (make paragraph
      space-after: (* %bf-size% %line-spacing-factor%)
      (make sequence
	(literal (gentext-by))
	(literal "\no-break-space;")
	(process-children-trim))))

  (element authorinitials
    (make paragraph
      use: book-titlepage-verso-style
      (process-children)))

  (element bibliomisc (process-children))

  (element bibliomset (process-children))

  (element collab
    (make paragraph
      use: book-titlepage-verso-style
      (process-children)))

  (element confgroup
    (make paragraph
      use: book-titlepage-verso-style
      (process-children)))

  (element contractnum
    (make paragraph
      use: book-titlepage-verso-style
      (process-children)))

  (element contractsponsor
    (make paragraph
      use: book-titlepage-verso-style
      (process-children)))

  (element contrib
    (make paragraph
      use: book-titlepage-verso-style
      (process-children)))

  (element copyright
    (make paragraph
      use: book-titlepage-verso-style
      (literal (gentext-element-name (current-node)))
      (literal "\no-break-space;")
      (literal (dingbat "copyright"))
      (literal "\no-break-space;")
      (process-children)))

  (element (copyright year)
    (make sequence
      (process-children)
      (if (not (last-sibling? (current-node)))
	  (literal ", ")
	  (literal (string-append " " (gentext-by) " ")))))
  
  (element (copyright holder) ($charseq$))

  (element corpauthor
    ;; note: book-titlepage-corpauthor takes care of wrapping multiple
    ;; corpauthors
    (make sequence
      (if (first-sibling?)
	  (if (equal? (gi (parent (current-node))) (normalize "authorgroup"))
	      (empty-sosofo)
	      (literal (gentext-by) " "))
	  (literal ", "))
      (process-children)))

  (element corpname
    (make paragraph
      use: book-titlepage-verso-style
      (process-children)))

  (element date
    (make paragraph
      use: book-titlepage-verso-style
      (process-children)))

  (element edition
    (make paragraph
      (process-children)
      (literal "\no-break-space;")
      (literal (gentext-element-name-space (gi (current-node))))))

  (element editor
    ;; Print the editor name.
    (let ((in-group (have-ancestor? (normalize "authorgroup") (current-node))))
      (if (or #t (not in-group)) ; nevermind, always put out the Edited by
	  (make paragraph
	    ;; Hack to get the spacing right below the author name line...
	    space-after: (* %bf-size% %line-spacing-factor%)
	    (make sequence
	      (literal (gentext-edited-by))
	      (literal "\no-break-space;")
	      (literal (author-string))))
	  (make sequence 
	    (literal (author-string))))))

  (element firstname
    (make paragraph
      use: book-titlepage-verso-style
      (process-children)))

  (element graphic
    (let* ((nd (current-node))
	   (fileref (attribute-string "fileref" nd))
	   (entityref (attribute-string "entityref" nd))
	   (format (attribute-string "format" nd))
	   (align (attribute-string "align" nd)))
      (if (or fileref entityref) 
	  (make external-graphic
	    notation-system-id: (if format format "")
	    entity-system-id: (if fileref 
				  (graphic-file fileref)
				  (if entityref 
				      (entity-generated-system-id entityref)
				      ""))
	    display?: #t
	    display-alignment: 'start)
	  (empty-sosofo))))

  (element honorific
    (make paragraph
      use: book-titlepage-verso-style
      (process-children)))

  (element isbn
    (make paragraph
      use: book-titlepage-verso-style
      (process-children)))

  (element issn
    (make paragraph
      use: book-titlepage-verso-style
      (process-children)))

  (element itermset (empty-sosofo))

  (element invpartnumber
    (make paragraph
      use: book-titlepage-verso-style
      (process-children)))

  (element issuenum
    (make paragraph
      use: book-titlepage-verso-style
      (process-children)))

  (element jobtitle
    (make paragraph
      use: book-titlepage-verso-style
      (process-children)))

  (element keywordset (empty-sosofo))

  (element legalnotice
    (make display-group
      use: book-titlepage-verso-style
      ($semiformal-object$)))

  (element (legalnotice title) (empty-sosofo))

  (element (legalnotice para) 
    (make paragraph
      use: book-titlepage-verso-style
      font-size: (* (inherited-font-size) 0.8)
      (process-children-trim)))

  (element lineage
    (make paragraph
      use: book-titlepage-verso-style
      (process-children)))

  (element modespec (empty-sosofo))

  (element orgdiv
    (make paragraph
      use: book-titlepage-verso-style
      (process-children)))

  (element orgname
    (make paragraph
      use: book-titlepage-verso-style
      (process-children)))

  (element othercredit
    (make paragraph
      use: book-titlepage-verso-style
      (process-children)))

  (element othername
    (make paragraph
      use: book-titlepage-verso-style
      (process-children)))

  (element pagenums
    (make paragraph
      use: book-titlepage-verso-style
      (process-children)))

  (element printhistory
    (make display-group
      use: book-titlepage-verso-style
      (process-children)))

  (element productname
    (make paragraph
      use: book-titlepage-verso-style
      (process-children)))

  (element productnumber
    (make paragraph
      use: book-titlepage-verso-style
      (process-children)))

  (element pubdate
    (make paragraph
      (literal (gentext-element-name-space (gi (current-node))))
      (process-children)))

  (element publisher
    (make paragraph
      use: book-titlepage-verso-style
      (process-children)))

  (element publishername
    (make paragraph
      use: book-titlepage-verso-style
      (process-children)))

  (element pubsnumber
    (make paragraph
      use: book-titlepage-verso-style
      (process-children)))

  (element releaseinfo
    (make paragraph
      use: book-titlepage-verso-style
      (process-children)))

  (element revhistory
    (make sequence
      (make paragraph
	use: book-titlepage-verso-style
	space-before: (* (HSIZE 3) %head-before-factor%)
	space-after: (/ (* (HSIZE 1) %head-before-factor%) 2)
	(literal (gentext-element-name (current-node))))
      (make table
	before-row-border: #f
	(process-children))))
  
  (element (revhistory revision)
    (let ((revnumber (select-elements (descendants (current-node)) 
				      (normalize "revnumber")))
	  (revdate   (select-elements (descendants (current-node)) 
				      (normalize "date")))
	  (revauthor (select-elements (descendants (current-node))
				      (normalize "authorinitials")))
	  (revremark (select-elements (descendants (current-node))
				      (normalize "revremark"))))
      (make sequence
	(make table-row
	  (make table-cell
	    column-number: 1
	    n-columns-spanned: 1
	    n-rows-spanned: 1
	    start-indent: 0pt
	    (if (not (node-list-empty? revnumber))
		(make paragraph
		  use: book-titlepage-verso-style
		  font-size: %bf-size%
		  font-weight: 'medium
		  (literal (gentext-element-name-space (current-node)))
		  (process-node-list revnumber))
		(empty-sosofo)))
	  (make table-cell
	    column-number: 2
	    n-columns-spanned: 1
	    n-rows-spanned: 1
	    start-indent: 0pt
	    cell-before-column-margin: (if (equal? (print-backend) 'tex)
					   6pt
					   0pt)
	    (if (not (node-list-empty? revdate))
		(make paragraph
		  use: book-titlepage-verso-style
		  font-size: %bf-size%
		  font-weight: 'medium
		  (process-node-list revdate))
		(empty-sosofo)))
	  (make table-cell
	    column-number: 3
	    n-columns-spanned: 1
	    n-rows-spanned: 1
	    start-indent: 0pt
	    cell-before-column-margin: (if (equal? (print-backend) 'tex)
					   6pt
					   0pt)
	    (if (not (node-list-empty? revauthor))
		(make paragraph
		  use: book-titlepage-verso-style
		  font-size: %bf-size%
		  font-weight: 'medium
		  (literal (gentext-revised-by))
		  (process-node-list revauthor))
		(empty-sosofo))))
	(make table-row
	  cell-after-row-border: #f
	  (make table-cell
	    column-number: 1
	    n-columns-spanned: 3
	    n-rows-spanned: 1
	    start-indent: 0pt
	    (if (not (node-list-empty? revremark))
		(make paragraph
		  use: book-titlepage-verso-style
		  font-size: %bf-size%
		  font-weight: 'medium
		  space-after: (if (last-sibling?) 
				   0pt
				   (/ %block-sep% 2))
		  (process-node-list revremark))
		(empty-sosofo))))))) 
  
  (element (revision revnumber) (process-children-trim))
  (element (revision date) (process-children-trim))
  (element (revision authorinitials) (process-children-trim))
  (element (revision revremark) (process-children-trim))

  (element seriesvolnums
    (make paragraph
      use: book-titlepage-verso-style
      (process-children)))

  (element shortaffil
    (make paragraph
      use: book-titlepage-verso-style
      (process-children)))

  (element subjectset (empty-sosofo))

  (element subtitle
    (make sequence
      font-family-name: %title-font-family%
      font-weight: 'bold
      (literal (if (first-sibling?) ": " "; "))
      (process-children)))

  (element surname
    (make paragraph
      use: book-titlepage-verso-style
      (process-children)))

  (element title
    (make sequence
      font-family-name: %title-font-family%
      font-weight: 'bold
      (with-mode title-mode
	(process-children))))

  (element titleabbrev (empty-sosofo))

  (element volumenum
    (make paragraph
      use: book-titlepage-verso-style
      (process-children)))
)

