#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/Action/SMS/SMSSender.pm,v 1.1 2001/10/31 16:44:53 lsimonneau Exp $
##*****************************************************************************
##  Class SMSSender.pm
##  Description  :  Parse  XML description and send HTTP request
##
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Laurent Simonneau l.simonneau@atrid.fr
##*****************************************************************************
#$Log: SMSSender.pm,v $
#Revision 1.1  2001/10/31 16:44:53  lsimonneau
#Move Action from ComplexAlarm to LogTrend root.
#
#Revision 1.8  2001/06/29 11:55:02  lsimonneau
#Amlioration des message d'erreur, Die -> die.
#
#Revision 1.7  2001/06/21 16:07:14  lsimonneau
#Dplacement de la clause 'package' avant les 'use'
#
#Revision 1.6  2001/06/11 08:16:28  lsimonneau
#Minor bugfixes
#
#Revision 1.5  2001/06/07 14:41:04  lsimonneau
#Passage du unshift @INC, '..' au LogTrend::
#
#Revision 1.4  2001/06/06 15:37:25  lsimonneau
#Ajout des entits <Prerequest function="func_name"> et <Postrequest function="func_name"> qui permettent de lancer une fonction externe avant ou apres l'xcution de la requte.
#Le code de cette fonction devra tre dans un fichier nomm "nom_du_site".pm.
#
#Cration de genie.pm et adaptation de genie.xml. Une fonction du type Postrequest va ce charger d'analys la page HTML contenant le code javascript qui crait les fameux cookies source de mon problme, et va donc crer ces cookies.
#
#genie.fr fonctionne a nouveau :)
#
#Revision 1.3  2001/06/05 15:25:42  lsimonneau
#Bug des cookies rsolut. Le site de test (genie.fr) crait dynamiquement
#des cookies grace a du javascript. Or LWP ne supporte pas le javascript.
#L'utilisation de ce site n'est donc pas possible.
#
#Suppression de genie.xml et lycos.xml.
#
#Il n'y a toujours aucun site qui fonctionne :(
#
#Revision 1.2  2001/06/05 08:54:28  lsimonneau
#Utilisation de HTML::Form pour construire les requtes dans SMSSender.
#
#Problme de Cookies : L'envoie de SMS avec genie.fr ne fonctionne
#plus. Le problme vient de cookies mais je ne sais pas comment le
#rsoudre. Peut tre que le probleme vient de libwww-perl.
#
#Plus aucun site ne fonctionne :(
#La plupart ce protgent contre les scripts.
#
#Revision 1.1  2001/05/30 09:36:57  lsimonneau
#Premire version du module d'alarmes complexes dans le CVS.
#Toutes les fonctionnalits ont t testes et correctement.
#

package LogTrend::Action::SMS::SMSSender;

use strict;
use LWP;
use HTTP::Request;
use HTTP::Response;
use HTTP::Cookies;
use HTML::Form;
use XML::DOM;


##*****************************************************************************
##  Constructor public
##  Description  : Create a new SMSSender
##
##  Parameters   : none
##*****************************************************************************

sub new {
    my ($classname, $phone_nat, $phone_inter, $message) = @_;
    my  $self = {};

    bless($self, $classname);

    $self->{PHONE_NAT} = $phone_nat;
    $self->{PHONE_INTER} = $phone_inter;
    $self->{MESSAGE} = $message;

    return $self;
}


##*****************************************************************************
##  Send method public
##  Description  : Run the parse_and_send method for each provider while 
##                 the SMS is not sent
##
##  Parameters   : none
##*****************************************************************************

sub Send {
    my $self = shift;
    
    my $default_path = __FILE__;
    $default_path =~ s/\/SMSSender.pm$//;

    open(PROV_LIST_FILE, "$default_path/site-priority") 
	or die "Can't open $default_path/site-priority";
    
    while(<PROV_LIST_FILE>) {
	chomp($_);	
	next if $_ eq "";
	
	#print "Try with $_\n";
	last if $self->parse_and_send("$default_path/${_}.xml");
    }
}

##*****************************************************************************
##  parse_and_send method private
##  Description  : Parse the XML file and send the SMS
##
##  Parameters   : none
##*****************************************************************************

sub parse_and_send  {
    my ($self, $filename) = @_;
    my ($list,$node,$valueref,$attributes,$attrnode,$formlist,$formnode);

    # Create a new XML::DOM parser and parse the web site description file
    my $parser = new XML::DOM::Parser() or die($!);
    my $doc = $parser->parsefile($filename) or return 0;
        
    # Scan the DOM tree
    my $rootlist = $doc->getElementsByTagName("SMSWebSite") 
	or return 0;
    
    ## Tag SMSWebSite
    my $rootnode = $rootlist->item(0) 
	or return;    

    ## For each Request
    $list = $rootnode->getElementsByTagName("Request")
	or return 0;

    my $nb_request = $list->getLength;    
    my $prev_form=undef;

    my $user_agent = new LWP::UserAgent;
    $user_agent->env_proxy();
    $user_agent->cookie_jar(new HTTP::Cookies);

    # For each request
    my $i;
    for($i = 0; $i < $nb_request; $i++) {
	my %request;
	my $http_request;
	my $response;
	my $form = undef;
	my $form_nbr;
	my @form_list;
	my ($arglist, $argnode);
	my $nb_arg;

	$node = $list->item($i) or return 0;
	$attributes = $node->getAttributes() or return 0;

	$attrnode = $attributes->getNamedItem("type") or return 0;
	$request{type}=$attrnode->getValue();

	$attrnode = $attributes->getNamedItem("uri") or return 0;
	$request{uri}=$attrnode->getValue();

	$attrnode = $attributes->getNamedItem("referer") or return 0;
	$request{referer}=$attrnode->getValue();
		

	# build the request
	if (defined $prev_form) {
	    $http_request = $prev_form->make_request;
	}
	else {	
	    $http_request = HTTP::Request->new(GET => $request{uri});
	}
	
	$prev_form = undef;
	
	$http_request->header('Referer', $request{referer});

	# if there is a Prerequest, run this function
	my $prereq_list = $node->getElementsByTagName("Prerequest");
	if ($prereq_list->getLength > 0) {
	    my $prereq_node = $prereq_list->item(0);
	    my $prereq_attr = $prereq_node->getAttributes() or return 0;

	    my $prereq_attrnode = $prereq_attr->getNamedItem("function") or return 0;
	    my $prereq_funcname = $prereq_attrnode->getValue();

	    # load the package $prov_name.pm
	    my $package_name = $filename;
	    $package_name =~ s/\.xml$//;

	    require $package_name;

	    return 0 unless defined &{"${package_name}::${prereq_funcname}"};

	    eval "${package_name}::${prereq_funcname}(\$user_agent, \$http_request)";
	    die $@ if $@;
	}

	

	# Send the request 
	$response = $user_agent->request($http_request);
	return 0 if $response->is_error;

	while($response->is_redirect) {
	    # And then we update the URL based on the Location header.
	    my($referral_uri) = $response->header('Location');
	    {
		# Some servers erroneously return a relative URL for redirects,
		# so make it absolute if it not already is.
		local $URI::ABS_ALLOW_RELATIVE_SCHEME = 1;
		my $base = $response->base;
		$referral_uri = $HTTP::URI_CLASS->new($referral_uri, $base)->abs($base);
	    }

	    my $temp_request = HTTP::Request->new (GET => $referral_uri);

	    $temp_request->header('Referer', $request{referer});
	    $response = $user_agent->request($temp_request);
	}

	# Parse Form
	if(($formlist = $node->getElementsByTagName("Form")) and ($formnode = $formlist->item(0))) {

	    $attributes = $formnode->getAttributes() or return 0;
	    
	    $attrnode = $attributes->getNamedItem("nbr") or return 0;
	    
	    $form_nbr=$attrnode->getValue();
	    
	    
	    @form_list = HTML::Form->parse($response->content(),
					   $http_request->uri());


	    return 0 unless defined $form_list[$form_nbr];

	    $form = $form_list[$form_nbr];

	    # For each arg
	    $arglist = $formnode->getElementsByTagName("Arg");
	    $nb_arg = $arglist->getLength;	   	    

	    for(my $j = 0; $j < $nb_arg; $j++) {
		my $arg_name;
		my $arg_value;
			
		$argnode = $arglist->item($j);
		$attributes = $argnode->getAttributes() || return 0;

		$attrnode = $attributes->getNamedItem("name") or return 0;
		$arg_name = $attrnode->getValue() or return 0;

		if($attrnode = $attributes->getNamedItem("value")) {
		    $arg_value = $attrnode->getValue();
		    
		    if(! defined $form->find_input($arg_name)) {
 			$form->push_input("hidden", {"name", $arg_name, "value", $arg_value});
		    }		    
		    else {
			$form->value($arg_name => $arg_value);
		    }
		}
		elsif($attrnode = $attributes->getNamedItem("is_national_phone_number")){
		    $arg_value = $attrnode->getValue();
		    $form->value($arg_name => $self->{PHONE_NAT});
		}
		elsif($attrnode = $attributes->getNamedItem("is_international_phone_number")){
		    $arg_value = $attrnode->getValue();
		    $form->value($arg_name => $self->{PHONE_INTER});
		}
		elsif($attrnode = $attributes->getNamedItem("is_international_phone_number_without_plus")){
		    $arg_value = $attrnode->getValue();
		    my $temp = $self->{PHONE_INTER};
		    $temp =~ s/^\+//;
		    $form->value($arg_name => $temp);
		}
		elsif($attrnode = $attributes->getNamedItem("is_message")){
		    $arg_value = $attrnode->getValue();		  
		    
		    $form->value($arg_name => $self->{MESSAGE});
		}
	    }
	    
	    $prev_form = $form;
	}
	
	# if there is a Postrequest, run this function
	my $postreq_list = $node->getElementsByTagName("Postrequest");
	if ($postreq_list->getLength > 0) {
	    my $postreq_node = $postreq_list->item(0);
	    my $postreq_attr = $postreq_node->getAttributes() or return 0;

	    my $postreq_attrnode = $postreq_attr->getNamedItem("function") or return 0;
	    my $postreq_funcname = $postreq_attrnode->getValue();

	    # load the package $prov_name.pm
	    my $package_name = $filename;
	    $package_name =~ s/\.xml$//;

	    require "${package_name}.pm";

	    $package_name =~ s/.*\///g;

	    return 0 unless defined &{"${package_name}::${postreq_funcname}"};

	    eval "${package_name}::${postreq_funcname}(\$user_agent, \$http_request, \$response)";
	    die $@ if $@;
	}
    }

    return 1;
}


1;
