#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/Agent/DataSender.pm,v 1.5 2001/11/16 10:32:28 lsimonneau Exp $
##******************************************************************************
## Class DataSender  virtual
##  Description  : generic class for sending data to the server
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Sylvain Lhullier s.lhullier@atrid.fr
##******************************************************************************
#$Log:

package LogTrend::Agent::DataSender;

use strict;

##******************************************************************************
## Constructor  public
##  Parameters   : the host and port for connection, login and password for
##                 identification
##******************************************************************************
sub new
{
   my ($classname, $host, $port) = @_;
   my $self = {};
   bless($self, $classname);
   $self->{HOST}     = $host;
   $self->{PORT}     = $port;
   return $self;
}

##******************************************************************************
## Function SetData  public virtual
##  Description  : sends the agent's data and alarms to a storage server
##  Parameters   : the data to send (string) and the signature 
##  Return value : 0 if successfull, 1 if problem with the agent
##                 or 2 if problem with the server (for futur re-try)
##******************************************************************************
sub SendData
{
}

##******************************************************************************
1;
