/* Copyright (C) 2001/2002 sgop@users.sourceforge.net
   This is free software distributed under the terms of the
   GNU Public License.  See the file COPYING for details. */

typedef void (*ping_update_func)( unsigned long ip, int ptime );
typedef void (*notify_func)( const char* topic, const char* format,
			     ...);

void ping_configure(int life_time, int max_pings, char* command);
void ping_set_funcs(ping_update_func func1, notify_func func2);

/* return value
 * >0 : ping time
 *  0 : no ping time available
 * -1 : ping in progress
 */
int ping(unsigned long addr);

/* increases the lifetime of the pings
 * and cleans up pings that have expired
 */
void ping_inc_counter(int value);
