/* Copyright (C) 2000-2003 Markus Lausser (sgop@users.sf.net)
   This is free software distributed under the terms of the
   GNU Public License.  See the file COPYING for details. */

char *get_search_string(char *str);

resume_t *resume_new(long access);
void resume_destroy(resume_t * resume);
void resume_load(char *fname, int import);
int resume_save(gpointer data);

int resume_insert_file(resume_t * resume, file_t * file);

resume_t *resume_search_short_file(char *filename);
resume_t *resume_search_long_file(char *filename);
resume_t *resume_search_file(file_t * file);
GList *resume_search_size(long size);
GList *resume_search_size_real(long size);
void resume_search(resume_t * resume, net_t* net);
void resume_search_all(net_t* net, int force);
void resume_remove_search(resume_t * resume);
void resume_update_search(resume_t* resume, char* text);

void resume_show(resume_t * resume);
void resume_queued_update(resume_t* resume);
void resume_hide(resume_t * resume);
void resume_update(resume_t * resume);
void resume_update_resume2(resume_t * resume);
void resume_cancel(resume_t * resume);
void resume_remove(resume_t * resume);
void resume_freeze(resume_t * resume);
void resume_thaw(resume_t * resume);
void resume_dont_search(resume_t* resume);
void resume_allow_search(resume_t* resume);

int resume_has_potentials(resume_t* resume);
time_t resume_time_of_death(resume_t* resume);
void resume_remove_outdated();

int resume_timer(gpointer data);
void resume_saver_start();
void resume_saver_stop();

GtkWidget* create_abort_win (void);
void resume_options_setup(GtkWidget* win, resume_t* resume);
void resume_draw_segment(GtkWidget* win, GdkWindow* window,
			 file_segment_t** segment);
void resume_draw_segments(GtkWidget* win, GdkWindow* window,
			  resume_t* resume, file_segment_t** selected);
void change_segment(GtkWidget* win, file_segment_t** segment);
void resume_modify_values(GtkWidget* win);
int resume_finished(resume_t* resume);
void resume_scan_dead();
void resume_set_size(resume_t* resume, long size);
void segment_size_show(GtkWidget* area, int new_size);

