from kdeemul import *
from utils import *
import backtick
import paths

class LExportBase(QDialog):
	def __init__(self, parent, keys):
		QDialog.__init__(self, parent, "Lphoto", True)
		self.lib = parent.lib
		self.settings = parent.settings
		self.count = len(keys)
		self.byteSize = self.lib.getTotalSize(keys);
		self.keys = keys
		self.quality = 100
		
	def getUniqueFile(self, list, path, photo):
		# makes sure name is unique for this expo
		i = 0
		out = str(os.path.join(path, photo.getFilename(self.useTitle)))
		while out in list:
			out = str(os.path.join(path, photo.getFilename(self.useTitle, i)))
			i = i + 1
		return out
	
	def initSizeChoices(self):
		# init sizeCombo
		self.sizes = [
		[i18n("Small (320x240)"), QSize(320,240), 65000],
		[i18n("Medium (640x480)"), QSize(640,480), 124000],
		[i18n("Large (1200x900)"), QSize(1200,900), 180000],
		[i18n("Full (Actual Size)"), None, None]
		]
		
		for size in self.sizes:
			self.sizeCombo.insertItem(size[0])
		# select last item
		self.sizeCombo.setCurrentItem(self.sizeCombo.count()-1)

		# quality values
		self.qualities = [
		[i18n("Original"), 100],
		[i18n("Best"), 90],
		[i18n("Good"), 80],
		[i18n("Fair"), 60]
		]
		
		for q in self.qualities:
			self.qualityCombo.insertItem(q[0])
		self.qualityCombo.setCurrentItem(0)

	def buildSpacer(self, grid, r, c, s):
		grid.addRowSpacing(r,s)
		return r
		
	def buildSizeInGrid(self, grid, r, c):
		bg = QButtonGroup("ImageSize", self)
		bg.hide()
		l = QLabel(i18n("Image Size:"), self)
		grid.addWidget(l,r,c)

		hl = QHBoxLayout(self, 0, 0)
		grid.addLayout(hl,r,c+1)	
		self.sizeRadio = QRadioButton("", self)
		self.sizeRadio.setSizePolicy(QSizePolicy.Fixed, QSizePolicy.Fixed)
		bg.insert(self.sizeRadio, 0)
		hl.addWidget(self.sizeRadio)
		hl.addSpacing(5)

		self.sizeCombo = QComboBox(self)
		hl.addWidget(self.sizeCombo)
		
		self.customRadio = QRadioButton(i18n("Custom Size"), self)
		grid.addWidget(self.customRadio,r+1,c+1)
		bg.insert(self.customRadio, 1)
		
		gl = QGridLayout(self, 2, 2, 0)
		grid.addMultiCellLayout(gl, r+2, r+3, c+1, c+1)
		l = QLabel(i18n("Max Width: "), self)
		l.setSizePolicy(QSizePolicy.Fixed, QSizePolicy.Fixed)
		gl.addWidget(l, 0, 0)
		
		self.widthEdit = QLineEdit(self)
		self.widthEdit.setValidator(QIntValidator(10, 12000, self))
		self.widthEdit.setSizePolicy(QSizePolicy.Fixed, QSizePolicy.Fixed)
		gl.addWidget(self.widthEdit, 0, 1)

		l = QLabel(i18n("Max Height: "), self)
		l.setSizePolicy(QSizePolicy.Fixed, QSizePolicy.Fixed)
		gl.addWidget(l, 1, 0)
		self.heightEdit = QLineEdit(self)
		self.heightEdit.setValidator(QIntValidator(10, 12000, self))
		self.heightEdit.setSizePolicy(QSizePolicy.Fixed, QSizePolicy.Fixed)
		gl.addWidget(self.heightEdit, 1, 1)

		l = QLabel(i18n("Quality:"), self)
		grid.addWidget(l,r+4,c)
		self.qualityCombo = QComboBox(self)
		grid.addWidget(self.qualityCombo,r+4,c+1)
		return r+4
		
	def buildPathInGrid(self, grid, r, c):
		l = QLabel(i18n("Export Folder: "), self)
		grid.addWidget(l,r,c)
		hl = QHBoxLayout()
		grid.addLayout(hl,r,c+1)
		self.exportEdit = QLineEdit(self)
		hl.addWidget(self.exportEdit)
		self.exportPathButton = QPushButton(i18n("Change Folder..."), self)
		hl.addWidget(self.exportPathButton)
		return r
	
	def buildNameInGrid(self, grid, r, c):
		l = QLabel(i18n("Filenames:"), self)
		grid.addWidget(l,r,c)
		bg = QButtonGroup("Filenames", self)
		bg.hide()
		self.titleRadio = QRadioButton(i18n("Use Title as filename"), self)
		bg.insert(self.titleRadio);
		grid.addWidget(self.titleRadio, r, c+1)
		self.origRadio = QRadioButton(i18n("Use original filename"), self)
		bg.insert(self.origRadio);
		grid.addWidget(self.origRadio, r+1, c+1)
		return r+1

	def buildInfoLabelsInGrid(self, grid, r, c):
		if self.count == 1:
			t = i18n("1 photo")
		else:
			t = i18n("%d photos" % (self.count))
		l = QLabel(t, self)
		grid.addWidget(l, r, c+1)
		self.sizeLabel = QLabel("", self)
		grid.addWidget(self.sizeLabel, r+1, c+1)
		return r+1
		
	def slotChangeSize(self, i):
		self.sizeRadio.setChecked(True)
		self.computeEstimatedSize()
		
	def slotRadioToggle(self, b):
		if b:
			self.computeEstimatedSize()
			
	def slotSizeEdit(self, s):
		self.customRadio.setChecked(True)
		self.computeEstimatedSize()

	def slotShowPathDialog(self):
		path = KFileDialog.getExistingDirectory(self.exportEdit.text(), None, i18n("Select your export directory"))
		if path:
			self.exportEdit.setText(path)

	def computeEstimatedSize(self):
		if (self.sizeRadio.isChecked()):
			self.size = self.sizes[self.sizeCombo.currentItem()][1]
		else:
			w = self.widthEdit.text()	# returns QString
			h = self.heightEdit.text()	# returns QString
			if w and h:
				self.size = QSize(int(str(w)), int(str(h)))
			else:
				self.size = None

		
		if self.size:  # if no size can be found, use filesize
			b = self.count * (0.75 * self.size.width() * self.size.height() + 2500)
		else:
			b = self.byteSize

		self.quality = self.qualities[self.qualityCombo.currentItem()][1]
		if self.quality:
			b = b * self.quality / 100 

		self.sizeLabel.setText(u"%s %s" % (i18n("Estimated Total Size: "), LUtils.humanByteOutput(b)))
		
	def serializeSizeSettings(self, category, bRestore):
		self.settings.serializeEdit(self.widthEdit, category, "width", bRestore)
		self.settings.serializeEdit(self.heightEdit, category, "height", bRestore)
		self.settings.serializeCombo(self.sizeCombo, category, "sizeIndex", bRestore)
		self.settings.serializeCombo(self.qualityCombo, category, "quality", bRestore)
		self.settings.serializeRadioGroup([self.sizeRadio, self.customRadio], category, "usesize", bRestore, default=0)

	def saveKeys(self, keys, dir, progress):
		copies = [] # array files we have saved so far
		LUtils.ensureDirectory(dir)

		for key in keys:
			photo = self.lib.getPhoto(key)
			filename = photo.getFilename(self.useTitle)
			progress.setLabelText(i18n("Exporting %s" % (filename)))
			
			outPath = self.getUniqueFile(copies, dir, photo)
			photo.export(outPath, self.size, self.quality, photo['Format'])
			
			copies.append(outPath)
			progress.setProgress(progress.progress()+1)
			if progress.wasCancelled():
				return

class LAlbumExport(LExportBase):
	def __init__(self, parent, lib, albumPath):
		self.albumPath = albumPath
		keys = self.albumPath and lib.getAlbum(self.albumPath)['KeyList'] or []
		
		LExportBase.__init__(self, parent, keys)
		self.setCaption(i18n("Export Album"))
		
		gl = QGridLayout(self,15,2,5)

		r = self.buildPathInGrid(gl, 0, 0)
		r = self.buildSpacer(gl, r+1, 0, 10)
		r = self.buildNameInGrid(gl, r+1, 0)
		r = self.buildSpacer(gl, r+1, 0, 10)
		r = self.buildSizeInGrid(gl, r+1, 0)
		r = self.buildSpacer(gl, r+1, 0, 10)
		r = self.buildInfoLabelsInGrid(gl, r+1, 0)	

		r = self.buildSpacer(gl, r+1, 0, 10)
		
		hl = QHBoxLayout()
		gl.addLayout(hl,r+1,1)
		hl.addStretch()
		self.exportButton = QPushButton(i18n("Export"), self)
		hl.addWidget(self.exportButton)
		self.exportButton.setDefault(True)
		hl.addSpacing(5)
		self.cancelButton = QPushButton(i18n("Cancel"), self)
		hl.addWidget(self.cancelButton)

		QObject.connect(self.exportButton, SIGNAL("clicked()"), self, SLOT("accept()"))
		QObject.connect(self.cancelButton, SIGNAL("clicked()"), self, SLOT("reject()"))
		QObject.connect(self.exportPathButton, SIGNAL("clicked()"), self.slotShowPathDialog)
		QObject.connect(self.sizeCombo, SIGNAL("activated(int)"), self.slotChangeSize)
		QObject.connect(self.sizeRadio, SIGNAL("toggled(bool)"), self.slotRadioToggle)
		QObject.connect(self.customRadio, SIGNAL("toggled(bool)"), self.slotRadioToggle)
		QObject.connect(self.widthEdit, SIGNAL("textChanged(const QString &)"), self.slotSizeEdit)
		QObject.connect(self.heightEdit, SIGNAL("textChanged(const QString &)"), self.slotSizeEdit)
		QObject.connect(self.qualityCombo, SIGNAL("activated(int)"), self.slotChangeSize)
		# init dialog settings
		self.initSizeChoices()
		
		self.__serialize(True)

	def done(self, result):
		if result == QDialog.Accepted:
			if (self.sizeRadio.isChecked()):
				self.size = self.sizes[self.sizeCombo.currentItem()][1]
			else:
				try:
					self.size = QSize(int(str(self.widthEdit.text())), int(str(self.heightEdit.text())))
				except ValueError:
					self.size = None
			self.exportDir = str(os.path.join(str(self.exportEdit.text())))
			self.useTitle = self.titleRadio.isChecked()
			
			self.__serialize(False)
			
		return QDialog.done(self, result)

	def __serialize(self, bRestore):
		self.serializeSizeSettings("AlbumExport", bRestore)		
		# export folder settings
		self.settings.serializeEdit(self.exportEdit, "AlbumExport", "folder", bRestore, os.path.expanduser('~/My Documents'))
		# filenaming settings
		self.settings.serializeRadioGroup([self.titleRadio, self.origRadio], "AlbumExport", "usetitle", bRestore)
			
	def __exportAlbum(self, exportRoot, albumPath, progress):
		
		if albumPath:
			exportDir = str(os.path.join(exportRoot, albumPath[-1]))
			album = self.lib.getAlbum(albumPath)
			children = album['AlbumList']
			self.saveKeys(album['KeyList'], exportDir, progress)
		else:
			exportDir = str(exportRoot)
			children = [ i for i in self.lib.getAlbumList() if i['Type'] == "normal" ]
						
		# process child albums
		for child in children:
			if progress.wasCancelled():
				return
			self.__exportAlbum(exportDir, albumPath + [child['AlbumName']], progress)
	
	def __countPhotos(self, albumPath):
		if albumPath:
			album = self.lib.getAlbum(albumPath)
			children = album['AlbumList']
			t = len(album['KeyList'])
		else:
			children = [ i for i in self.lib.getAlbumList() if i['Type'] == "normal" ]
			t = 0
		for child in children:
			t = t + self.__countPhotos(albumPath + [child['AlbumName']])
		return t 

		
	def export(self):
		total = self.__countPhotos(self.albumPath)
		
		progress = QProgressDialog(i18n("Exporting Album"),i18n("Cancel"),total,None,"progress",True)
		progress.setMinimumDuration(0)
		progress.setCaption(i18n("Creating Photo List"))
		progress.setProgress(0)
		
		progress.setCaption(i18n("Saving Files"))
		self.__exportAlbum(self.exportDir, self.albumPath, progress)
		
		
class LSelectionExport(LExportBase):
	def __init__(self, parent, lib, keys):
		LExportBase.__init__(self, parent, keys)
		self.setCaption(i18n("Export Selection"))
		
		gl = QGridLayout(self,15,2,5)

		r = self.buildPathInGrid(gl, 0, 0)
		r = self.buildSpacer(gl, r+1, 0, 10)
		r = self.buildNameInGrid(gl, r+1, 0)
		r = self.buildSpacer(gl, r+1, 0, 10)
		r = self.buildSizeInGrid(gl, r+1, 0)
		r = self.buildSpacer(gl, r+1, 0, 10)
		r = self.buildInfoLabelsInGrid(gl, r+1, 0)	

		r = self.buildSpacer(gl, r+1, 0, 10)
		
		hl = QHBoxLayout()
		gl.addLayout(hl,r+1,1)
		hl.addStretch()
		self.exportButton = QPushButton(i18n("Export"), self)
		hl.addWidget(self.exportButton)
		self.exportButton.setDefault(True)
		hl.addSpacing(5)
		self.cancelButton = QPushButton(i18n("Cancel"), self)
		hl.addWidget(self.cancelButton)

		QObject.connect(self.exportButton, SIGNAL("clicked()"), self, SLOT("accept()"))
		QObject.connect(self.cancelButton, SIGNAL("clicked()"), self, SLOT("reject()"))
		QObject.connect(self.exportPathButton, SIGNAL("clicked()"), self.slotShowPathDialog)
		QObject.connect(self.sizeCombo, SIGNAL("activated(int)"), self.slotChangeSize)
		QObject.connect(self.sizeRadio, SIGNAL("toggled(bool)"), self.slotRadioToggle)
		QObject.connect(self.customRadio, SIGNAL("toggled(bool)"), self.slotRadioToggle)
		QObject.connect(self.widthEdit, SIGNAL("textChanged(const QString &)"), self.slotSizeEdit)
		QObject.connect(self.heightEdit, SIGNAL("textChanged(const QString &)"), self.slotSizeEdit)
		QObject.connect(self.qualityCombo, SIGNAL("activated(int)"), self.slotChangeSize)
		# init dialog settings
		self.initSizeChoices()
		self.__serialize(True);
	
	def done(self, result):
		if result == QDialog.Accepted:
			if (self.sizeRadio.isChecked()):
				self.size = self.sizes[self.sizeCombo.currentItem()][1]
			else:
				self.size = QSize(int(str(self.widthEdit.text())), int(str(self.heightEdit.text())))
			self.exportDir = str(self.exportEdit.text())
			self.useTitle = self.titleRadio.isChecked()
			
			self.__serialize(False)
		return QDialog.done(self, result)

	def __serialize(self, bRestore):
		# export folder settings
		self.settings.serializeEdit(self.exportEdit, "SelectionExport", "folder", bRestore, os.path.expanduser('~/My Documents'),)
		# size settings
		self.serializeSizeSettings("SelectionExport", bRestore)
		# filenaming settings
		self.settings.serializeRadioGroup([self.titleRadio, self.origRadio], "AlbumExport", "usetitle", bRestore)

	def export(self):
		total = len(self.keys)

		progress = QProgressDialog(i18n("Exporting Selection"),None,total,None,"progress",True)
		progress.setMinimumDuration(0)
		progress.setCaption(i18n("Creating Photo List"))
		progress.setTotalSteps(total)
		progress.setCancelButtonText(i18n("Cancel"))
		progress.setProgress(0)
		
		self.saveKeys(self.keys, self.exportDir, progress)

class LEmailExport(LExportBase):
	def __init__(self, parent, keys):
		LExportBase.__init__(self, parent, keys)
		self.setCaption(i18n("Send Email"))

		r = 0
		gl = QGridLayout(self,10,2,5)

		r = self.buildSizeInGrid(gl, r+1, 0)
		r = self.buildSpacer(gl, r+1, 0, 10)
		r = self.buildInfoLabelsInGrid(gl, r+1, 0)
		r = self.buildSpacer(gl, r+1, 0, 10)
		
		hl = QHBoxLayout()
		gl.addLayout(hl,r+1,1)
		hl.addStretch()
		self.exportButton = QPushButton(i18n("Send Email..."), self)
		hl.addWidget(self.exportButton)
		self.exportButton.setDefault(True)
		hl.addSpacing(5)
		self.cancelButton = QPushButton(i18n("Cancel"), self)
		hl.addWidget(self.cancelButton)
		
		QObject.connect(self.exportButton, SIGNAL("clicked()"), self, SLOT("accept()"))
		QObject.connect(self.cancelButton, SIGNAL("clicked()"), self, SLOT("reject()"))
		QObject.connect(self.sizeCombo, SIGNAL("activated(int)"), self.slotChangeSize)
		QObject.connect(self.sizeRadio, SIGNAL("toggled(bool)"), self.slotRadioToggle)
		QObject.connect(self.qualityCombo, SIGNAL("activated(int)"), self.slotChangeSize)
		QObject.connect(self.customRadio, SIGNAL("toggled(bool)"), self.slotRadioToggle)
		QObject.connect(self.widthEdit, SIGNAL("textChanged(const QString &)"), self.slotSizeEdit)
		QObject.connect(self.heightEdit, SIGNAL("textChanged(const QString &)"), self.slotSizeEdit)

		# init dialog settings
		self.initSizeChoices()
		self.__serialize(True)
		
	def done(self, result):
		if result == QDialog.Accepted:
			self.__serialize(False)
		return QDialog.done(self, result)
		
	def __serialize(self, bRestore):
		# size settings
		self.serializeSizeSettings("EmailExport", bRestore)		
		
	def export(self):
		import urllib
		progress = QProgressDialog(i18n("Create EMail"),None,len(self.keys),None,"progress",True)
		progress.setMinimumDuration(0)
		progress.setCaption(i18n("Creating Photo List"))
		progress.setTotalSteps(len(self.keys))
		progress.setProgress(0)
		files = []
		
		for key in self.keys:
			photo = self.lib.getPhoto(key)
			progress.setLabelText(i18n("Generating %s" % (photo['Caption'])))
			if self.size or self.quality != 100:
				tmpPath = os.path.join(os.environ.get('TMP', '/tmp'), photo.getFilename())
				photo.export(tmpPath, self.size, self.quality, "JPEG")
				files.append(tmpPath)
			else:
				files.append(photo['ImagePath'])
		strFiles = ",".join(["file://"+urllib.quote(x) for x in files])

## when invokeMailer supports mozilla, we can add this back in
## 		app.invokeMailer("","","","", "", "", qsl)
		try:
			mozillaLines = []
			mozillaLines = backtick.backtick("pidof linspire-internet-suite")
		except:
			print "ERROR"
			pass
		if len(mozillaLines):
			print "/usr/lib/mozilla/linspire-internet-suite -remote \"xfeDoCommand(composeMessage, attachment='%s')\" &" % (strFiles)
			os.system("/usr/lib/mozilla/linspire-internet-suite -remote \"xfeDoCommand(composeMessage, attachment='%s')\" &" % (strFiles))
		else:
			print "/usr/lib/mozilla/linspire-internet-suite -compose attachment=\"'%s'\" &" %(strFiles)
			os.system("/usr/lib/mozilla/linspire-internet-suite -compose attachment=\"'%s'\" &" %(strFiles))

class LHtmlExport(LExportBase):
	def __init__(self, parent, albumPath, keys):
		LExportBase.__init__(self, parent, keys)
		self.setCaption(i18n("Create Web Pages"))
		self.albumName = albumPath[-1]
		self.albumPath = albumPath
		
		gl = QGridLayout(self,14,2,5)
		r = 0
		r = self.buildPathInGrid(gl, r, 0)
		r = self.buildSpacer(gl, r+1, 0, 10)
		r = self.buildTemplateInGrid(gl, r+1, 0)
		r = self.buildSpacer(gl, r+1, 0, 10)
		r = self.buildSizeInGrid(gl, r+1, 0)
		r = self.buildSpacer(gl, r+1, 0, 10)
		r = self.buildInfoLabelsInGrid(gl, r+1, 0)	

		r = self.buildSpacer(gl, r+1, 0, 10)
		
		hl = QHBoxLayout()
		gl.addLayout(hl,r+1,1)
		hl.addStretch()
		self.exportButton = QPushButton(i18n("Create"), self)
		hl.addWidget(self.exportButton)
		self.exportButton.setDefault(True)
		hl.addSpacing(5)
		self.cancelButton = QPushButton(i18n("Cancel"), self)
		hl.addWidget(self.cancelButton)

		QObject.connect(self.exportButton, SIGNAL("clicked()"), self, SLOT("accept()"))
		QObject.connect(self.cancelButton, SIGNAL("clicked()"), self, SLOT("reject()"))
		QObject.connect(self.exportPathButton, SIGNAL("clicked()"), self.slotShowPathDialog)
		QObject.connect(self.sizeCombo, SIGNAL("activated(int)"), self.slotChangeSize)
		QObject.connect(self.sizeRadio, SIGNAL("toggled(bool)"), self.slotRadioToggle)
		QObject.connect(self.customRadio, SIGNAL("toggled(bool)"), self.slotRadioToggle)
		QObject.connect(self.widthEdit, SIGNAL("textChanged(const QString &)"), self.slotSizeEdit)
		QObject.connect(self.heightEdit, SIGNAL("textChanged(const QString &)"), self.slotSizeEdit)
		QObject.connect(self.qualityCombo, SIGNAL("activated(int)"), self.slotChangeSize)

		templates = self.__findAvailableTemplates()
		for t in templates:	self.templateCombo.insertItem(t)

		# init dialog settings
		self.initSizeChoices()
		self.__findAvailableTemplates()
		
		self.__serialize(True)
		
	def buildTemplateInGrid(self, grid, r, c):
		l = QLabel(i18n("Template:"), self)
		grid.addWidget(l,r,c)
		hl = QHBoxLayout()
		grid.addLayout(hl,r,c+1)
		self.templateCombo = QComboBox(self)
		hl.addWidget(self.templateCombo)
##~ 		self.templateButton = QPushButton("...", self)
##~ 		hl.addWidget(self.templateButton)
		return r
		
	def slotShowTemplatePathDialog(self):
		path = KFileDialog.getExistingDirectory(self.exportEdit.text(), None, i18n("Select an album template"))
		if path:
			self.templateEdit.setText(path)

	
	def done(self, result):
		if result == QDialog.Accepted:
			if (self.sizeRadio.isChecked()):
				self.size = self.sizes[self.sizeCombo.currentItem()][1]
			else:
				self.size = QSize(int(str(self.widthEdit.text())), int(str(self.heightEdit.text())))
			self.__serialize(False)
			# save export path /my/path/albumname -> /my/path
			
			# save template path
		return QDialog.done(self, result)
		
	def __serialize(self, bRestore):
		self.__serializeNonAlbumSettings(bRestore)
		self.__serializeAlbumSettings(bRestore)
	
	def __serializeAlbumSettings(self,bRestore):
		# export folder settings
		self.lib.serializeAlbumEdit(self.albumPath, self.exportEdit, 
													   "HtmlExport", "folder", 
													   bRestore, 
													   str(os.path.join(os.path.expanduser('~'),"My Documents","web pages", self.albumPath[-1])))
		# size settings
		self.lib.serializeAlbumEdit(self.albumPath, self.widthEdit, "HtmlExport", "width", bRestore)
		self.lib.serializeAlbumEdit(self.albumPath, self.heightEdit, "HtmlExport", "height", bRestore)
		self.lib.serializeAlbumCombo(self.albumPath, self.sizeCombo, "HtmlExport", "sizeIndex", bRestore)
		self.lib.serializeAlbumRadioGroup(self.albumPath, [self.sizeRadio, self.customRadio], "HtmlExport", "usesize", bRestore)
		# template settings
		self.lib.serializeAlbumCombo(self.albumPath, self.templateCombo, "HtmlExport", "template", bRestore, "standard")
			
	def __serializeNonAlbumSettings(self, bRestore):
		# size settings
		self.serializeSizeSettings("HtmlExport", bRestore)
##~ 		self.settings.serializeEdit(self.widthEdit, "HtmlExport", "width", bRestore)
##~ 		self.settings.serializeEdit(self.heightEdit, "HtmlExport", "height", bRestore)
##~ 		self.settings.serializeCombo(self.sizeCombo, "HtmlExport", "sizeIndex", bRestore)
##~ 		self.settings.serializeRadioGroup([self.sizeRadio, self.customRadio], "HtmlExport", "usesize", bRestore)

	def __xslXform(self, xmlString, templatePath, outputPath):
##~ 		libxsltmod.translate_to_file('f', templatePath, 's', xmlString, outputPath, None)
		tmpEnv = os.environ.get('TMP','/tmp')
		tmpPath = os.path.join(tmpEnv, "lphototmp.xml")
		ouf = open(tmpPath, mode="w")
		ouf.write(xmlString)
		ouf.close()
		os.system("xsltproc -o \"%s\" \"%s\" \"%s\"" % (outputPath, templatePath, tmpPath))
		
	def export(self):
		tmpltPath = str(self.templateCombo.currentText())
		exportDir = str(self.exportEdit.text())
		thumbDir = os.path.join(exportDir, "thumbs")
		LUtils.ensureDirectory(thumbDir)
		imageDir = os.path.join(exportDir, "images")
		LUtils.ensureDirectory(imageDir)		
		indexHTML = os.path.join(exportDir, "index.html")
		
		progress = QProgressDialog(i18n("Creating Web Pages"),None,len(self.keys),None,"progress",True)
		progress.setMinimumDuration(0)
		progress.setCaption(i18n("Creating Photo List"))
		progress.setTotalSteps(len(self.keys)+1)
		progress.setCancelButtonText(i18n("Cancel"))
		progress.setProgress(0)

		photos = map(self.lib.getPhoto, self.keys)
		for photo in photos:
			progress.setLabelText(i18n("Exporting %s"%(photo['Caption'])))
			filename = photo.getFilename()
			# generate images
			photo.saveCustom(os.path.join(thumbDir, filename), QSize(180,180), self.quality)
			photo.export(os.path.join(imageDir, filename), self.size, self.quality)
			progress.setProgress(progress.progress()+1)
			if progress.wasCancelled():
				return
				
		progress.setCaption(i18n("Generating Template"))
		progress.setLabelText(i18n("Generating Template"))
		template = __import__("templates/%s/template"%(tmpltPath))
		template.construct(paths.template(tmpltPath), exportDir, photos, self.albumPath[-1])
		progress.setProgress(progress.progress()+1)
			
		# launch mozilla to this page
		os.system("nslauncher \"file://%s\" &" % (indexHTML))
			
	def __findAvailableTemplates(self):
		import glob, re, os
		files = glob.glob(paths.templatePath()+"/*/template.py")
		match = re.compile(r".*/(.*)/template\.py$", re.IGNORECASE)          
		l = []
		
		for f in files:
			mc = match.search(f)
			if mc:
				l.append(mc.group(1))
		return l
