from qt import *
from kdeemul import *

from organizeview import LThumbnail
from utils import * 
from importsession import *
import paths

class LImportPanel(QWidget):
	def __init__(self, parent):
		QWidget.__init__(self, parent)
		hl = QHBoxLayout(self)
		hl.insertSpacing(-1, 8)
		vl = QVBoxLayout(hl)
		self.cameraButton = QPushButton("Camera", self)
		vl.addWidget(self.cameraButton)
		self.cameraButton.setPixmap(QPixmap(paths.art("importcamera.png")))
		self.cameraButton.setSizePolicy(QSizePolicy.Minimum, QSizePolicy.Minimum)
		self.state = "done"
		self.camera = None
		self.cameraButton.setEnabled(False)
		l = QLabel(i18n("Import"), self)
		l.setAlignment(Qt.AlignHCenter)
		vl.addWidget(l)

		hl.insertSpacing(-1, 8)
		vl = QVBoxLayout(hl)
		self.cameraLabel = QLabel(i18n("No camera is selected."), self)
		vl.addWidget(self.cameraLabel)
		self.cameraLabel.setAlignment(Qt.AlignHCenter and Qt.AlignVCenter)
		self.rescanButton = QPushButton(i18n("Rescan"), self)
		vl.addWidget(self.rescanButton)
		
		hl.insertSpacing(-1, 8)
		self.progressBar = QProgressBar(self)
		hl.addWidget(self.progressBar)
		hl.insertSpacing(-1, 8)
		self.thumb = LThumbView(self)
		hl.addWidget(self.thumb)
		hl.insertSpacing(-1, 8)
		QToolTip.add(self.cameraButton, i18n("import all images from the current camera")) 
		QToolTip.add(self.rescanButton, i18n("rescan for new cameras")) 
		
	def setLibrary(self, lib):
		self.lib = lib
		QObject.connect(lib, PYSIGNAL("importPhoto"), self.slotImportPhoto)
		QObject.connect(lib, PYSIGNAL("importComplete"), self.slotImportComplete)
		QObject.connect(self.cameraButton, SIGNAL("clicked()"), self.slotStartImport)
		QObject.connect(self.rescanButton, SIGNAL("clicked()"), self.slotScan)
		
	def slotShowPanel(self):
##		if self.state == "done":
##			print "starting scan"
## 			self.slotScan()
		pass
		
	def slotScan(self):
		self.state = "scan"
		self.cameraButton.setEnabled(False)
		self.cameraLabel.setText("scanning")
		io = LImportSession()
		c = io.findFirstCamera()
		if c:
			self.state = "camera"
			self.cameraLabel.setText(c.getDisplayName())
			self.cameraButton.setEnabled(True)
			self.camera = c
		else:
			self.state="done"
			self.cameraLabel.setText(i18n("No camera is selected."))
			self.cameraButton.setEnabled(False)
			self.camera = None

	def slotStartImport(self):
		if self.camera:
			self.lib.importFromSource(self.camera)
			self.rescanButton.setEnabled(False)
			self.cameraButton.setEnabled(False)
		
	def slotImportPhoto(self, album, key, progress, total):
		self.state="import"
		self.cameraButton.setEnabled(False)
##~ 		print "importpanel import"
		dict = self.lib.getImage(key)
		if dict:
			self.thumb.setImagePath(dict['ThumbPath'])
		self.progressBar.setProgress(progress, total)
##~ 		print "importpanel importend"
		
	def slotImportComplete(self, source):
		self.state = "done"
		print "import complete"
		self.thumb.clearImage()
		self.progressBar.reset()
		self.rescanButton.setEnabled(True)
		self.cameraButton.setEnabled(False)
		self.cameraLabel.setText("import complete")
		self.update()
		source.cleanupImport()
		self.camera = None
		
	def slotStartSourceImport(self, source):
		if self.state == "done":
			self.camera = source
			self.cameraLabel.setText("file import")
			self.slotStartImport()

class LThumbView(QWidget):
	def __init__(self, parent):
		QWidget.__init__(self, parent)
		sp = QSizePolicy()
		sp.setHeightForWidth(True)
		self.setSizePolicy(sp)
		self.setSizePolicy(QSizePolicy.Minimum, QSizePolicy.MinimumExpanding)
		self.setMinimumSize(QSize(100,30))
		self.image = None
			
	def heightForWidth(self, w):
		return (w*4/3)
		
	def setImagePath(self, path):
		i = QImage(path)
		r = LUtils.mapRect(self.rect(), i.rect())
		self.image = i.scale(r.size())
		self.r = r
		self.update()
		
	def clearImage(self):
		self.image = None
		self.update()
		
	def paintEvent(self, pe):
		if self.image:
			p = QPainter(self)
			p.drawImage(self.r.topLeft(), self.image)
		
