//
//  Little cms - profiler construction set
//  Copyright (C) 1998-2001 Marti Maria
//
// THIS SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,
// EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY
// WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
//
// IN NO EVENT SHALL MARTI MARIA BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
// INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
// OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
// WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF
// LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
// OF THIS SOFTWARE.
//
// This file is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// As a special exception to the GNU General Public License, if you
// distribute this file as part of a program that contains a
// configuration script generated by Autoconf, you may include it under
// the same distribution terms that you use for the rest of that program.
//
// Version 1.08a

#include "qtmonitorprofilerdialog.h"
#include "qtlcmswidgets.h"



// Console and Gauger

static QMultiLineEdit*    Console;
static QProgressBar*	  ProgBar;
 


// Primaries table
static struct PrimTag {

               const char *Name;
               double xRed, yRed, xGreen, yGreen, xBlue, yBlue;

               } PrimTable[] = {

{ "ITU-R BT.709 (sRGB) - DEFAULT",   0.640, 0.330, 0.300, 0.600, 0.150, 0.060 },
{ "SMPTE RP145-1994",                0.64,  0.33,  0.29,  0.60,  0.15,  0.06 },
{ "SMPTE-C (CCIR 601-1)",			 0.630, 0.340, 0.310, 0.595, 0.155, 0.070},
{ "EBU Tech.3213-E",                 0.630, 0.340, 0.310, 0.595, 0.155, 0.070 },
{ "EBU [Walker98]",					 0.64,  0.33,  0.30,  0.60,  0.15,  0.06 },
{ "P22",                             0.625, 0.340, 0.280, 0.595, 0.155, 0.070},
{ "NTSC",                            0.67,  0.33,  0.21,  0.71,  0.14,  0.08 },
{ "HDTV",                            0.670, 0.330, 0.210, 0.710, 0.150, 0.060 },
{ "CIE",                             0.7355,0.2645,0.2658,0.7243,0.1669,0.0085},
{ "Dell",                            0.625, 0.340, 0.275, 0.605, 0.150, 0.065},
{ "LCD",							 0.700, 0.300, 0.170, 0.700, 0.130, 0.075},
{ "Samsung TFT",				     0.610, 0.350, 0.315, 0.580, 0.150, 0.140},
{ "Apple RGB",						 0.625, 0.34,  0.28,  0.595, 0.155, 0.07 },
{ "Wide Gamut RGB (700/525/450nm)",  0.7347,0.2653,0.1152,0.8264,0.1566,0.0177},  
{ "Short persistence [Foley96]",     0.61,  0.35,  0.29,  0.59,  0.15,  0.063},
{ "Long persistence  [Foley96]",     0.62,  0.33,  0.21,  0.685, 0.15,  0.063},
{ "Adobe RGB",                       0.64,  0.33,  0.21,  0.71,  0.15,  0.06 },
{ "User defined",                    0.640, 0.330, 0.300, 0.600, 0.150, 0.060 }};

#define NPRIMARIES (int) (sizeof(PrimTable) / sizeof(struct PrimTag))



static struct WhitePntTag {
			const char* Name;
			double xw, yw;
			int TempK;

			} WhitePoints[] = {

				{ "D50 (Warm white)", 0, 0, 5000},
				{ "D65 (daylight)",   0.3127, 0.3291, 0},
				{ "D70",              0, 0, 7000 },
				{ "D75",              0, 0, 7500 },
				{ "D80",              0, 0, 8000 },
				{ "D85",              0, 0, 8500 },
				{ "D90",              0, 0, 9000 },
				{ "D91",              0, 0, 9100 },
				{ "D93 - Cold white", 0, 0, 9300 },
				{ "CIE illuminant A", 0.4476, 0.4074, 0},
				{ "CIE illuminant B", 0.34842, 0.35161, 0},
                { "CIE illuminant C", 0.3101, 0.3162, 0},
				{ "CIE Illuminant E", 0.333, 0.333, 0}, 
				{ "User defined (blackbody locus)", 0, 0, 0}};
                

				
#define NWHITES (int) (sizeof(WhitePoints) / sizeof(struct WhitePntTag))



static
int ConsolePrintf(const char *frm, ...)
{
	char Buffer[1024];
	va_list args;
	
	va_start(args, frm);
	vsprintf(Buffer, frm, args);
	Console -> append(Buffer);		
	va_end(args);	
	return 1;
}


static
int Gauger(const char *Label, int nMin, int nMax, int Pos)
{
        if (nMin < 0 && nMax < 0) {                
                return 1;
                }

        ProgBar -> setTotalSteps(nMax);
        ProgBar -> setProgress(Pos);
		
        return 1;
}


qtMonitorProfilerDialog::qtMonitorProfilerDialog( QWidget* parent, const char* name, bool modal, WFlags f )
	: qtMonitorProfilerDialogBase( parent, name, modal, f )
{

	int i;
#ifdef USE_KDE
	// make KDE compliant filter
	OutputFileEdit->setProperty( "FileMask", tr( "*.icc *.icm|icc profiles (*.icc *.icm)\n*.*|All files (*.*)" ) );
	TargetsSelector->setProperty( "FileMask", tr( "*.it? *.cgs|IT8-CGATS.5 files (*.it? *.cgs)\n*.*|All files (*.*)" ) );

#endif
	Console    = ProgressConsole;
	ProgBar    = ProgressBar;

	TabProfiler -> setTabEnabled(ProgressTab, FALSE);


	cmsxMonitorProfilerInit(&sys);

	sys.hdr.printf = ConsolePrintf;
	sys.hdr.Gauger = Gauger;

	// Take a copy of gamma

	GammaPix = new QPixmap(*(GammaProof -> pixmap()));
	GammaPix -> setOptimization(QPixmap::BestOptim);
	GammaBitmap = *GammaPix;
	Screen      = *GammaPix;

		
	// Fill primaries combo

	QValidator* Chromaticity = new QDoubleValidator(0.0, 2.0, 4, this);

	xRed   -> setValidator(Chromaticity);
	yRed   -> setValidator(Chromaticity);
	xGreen -> setValidator(Chromaticity);
	yGreen -> setValidator(Chromaticity);
	xBlue  -> setValidator(Chromaticity);
	yBlue  -> setValidator(Chromaticity);

	QValidator* Gamma = new QDoubleValidator(0.8, 3.3, 4, this);
	GammaR -> setValidator(Gamma);
	GammaG -> setValidator(Gamma);
	GammaB -> setValidator(Gamma);

	ComboPrimaries->clear();
	for (i=0; i < NPRIMARIES; i++)
		ComboPrimaries -> insertItem(PrimTable[i].Name);

	ComboPrimaries -> setCurrentItem(0);
	slotChangePrimaries();


	ComboBoxWP -> clear();
	for (i=0; i < NWHITES; i++)
		ComboBoxWP -> insertItem(WhitePoints[i].Name);

	ComboBoxWP-> setCurrentItem(1);
	slotChangeWhitePoint();

	SurroundCombo -> setCurrentItem(1);
	ValuesToControls();
	
	slotChangeGamma();
	slotIsAllReady();
	OutputFileEdit -> lForOutput = TRUE;

	MinimumTagsRadio->setChecked(TRUE);

	connect( OutputFileEdit, SIGNAL( valueChanged () ), this, SLOT( slotIsAllReady() ) );


}



void qtMonitorProfilerDialog::ValuesToLabels()
{
		char Buffer[256];
		double Lux;

		Lux = 5 * M_PI * sys.hdr.device.La;
		
		sprintf(Buffer, "Ambient light La=%g (%d Lux) :", sys.hdr.device.La, (int) Lux);		
		LabelLa -> setText(Buffer);
		
		sprintf(Buffer, "Background Luminance Yb=%g :", sys.hdr.device.Yb);		
		LabelYb -> setText(Buffer);
		
		LaScroll -> setValue(sys.hdr.device.La * 10.);
		YbScroll -> setValue(sys.hdr.device.Yb * 10.);
	
}

void qtMonitorProfilerDialog::ValuesToControls()
{

	
	CAMRadio		-> setChecked(sys.hdr.lUseCIECAM97s);
	VonKriesRadio   -> setChecked(!sys.hdr.lUseCIECAM97s);
	
		
	switch (sys.hdr.CLUTPoints) {

		case 10: RB10 -> setChecked(TRUE); break;		
		case 20: RB20 -> setChecked(TRUE); break;
		case 33: RB33 -> setChecked(TRUE); break;

		default: 
		case 16: RB16 -> setChecked(TRUE); 
	}


		switch (sys.hdr.ProfileVerbosityLevel) {

		case 0: MinimumTagsRadio -> setChecked(TRUE); break;      
		case 1: NormalTagsRadio  -> setChecked(TRUE); break;  
		case 2:
		default: VerboseTagsRadio -> setChecked(TRUE); break;  
		}


	SurroundCombo -> setCurrentItem(sys.hdr.device.surround);
	
	ManufacturerEdit->setText(sys.hdr.Manufacturer);
	ModelEdit -> setText(sys.hdr.Model);
	CopyrightEdit -> setText(sys.hdr.Copyright);
	DescriptionEdit -> setText(sys.hdr.Description);

	
	
	ValuesToLabels();
}


void qtMonitorProfilerDialog::SlidersToValues()
{
	sys.hdr.device.La = floor(LaScroll -> value() / 10);
	sys.hdr.device.Yb = floor(YbScroll -> value() / 10);

}

void qtMonitorProfilerDialog::ControlsToValues()
{

	QString cTarget = TargetsSelector -> getFilename();

	if (cTarget != QString::null)
			strcpy(sys.hdr.ReferenceSheet, (const char*) cTarget);
	
	strcpy(sys.hdr.MeasurementSheet,  "");

	strcpy(sys.hdr.OutputProfileFile, (const char *) OutputFileEdit -> getFilename());
	

	sys.hdr.lUseCIECAM97s   = CAMRadio -> isChecked();
		
	sys.hdr.device.surround = SurroundCombo -> currentItem();
		
	if (RB10 -> isChecked())
		sys.hdr.CLUTPoints = 10;
	else 
	if (RB33 -> isChecked())
		sys.hdr.CLUTPoints = 33;
	else
	if (RB20 -> isChecked())
		sys.hdr.CLUTPoints = 20;
	else
		sys.hdr.CLUTPoints = 16;

	sys.hdr.ProfileVerbosityLevel = 0;

	if (NormalTagsRadio -> isChecked())
		sys.hdr.ProfileVerbosityLevel = 1;
	else
	if (VerboseTagsRadio -> isChecked())
			sys.hdr.ProfileVerbosityLevel = 2;

    
	
	strcpy(sys.hdr.Manufacturer, ManufacturerEdit->text());
	strcpy(sys.hdr.Model, ModelEdit -> text());
	strcpy(sys.hdr.Copyright, CopyrightEdit -> text());
	strcpy(sys.hdr.Description, DescriptionEdit -> text());

	SlidersToValues();	
	slotIsAllReady();
}


void qtMonitorProfilerDialog::SetGoButton(const char* Caption, BOOL lEnable)
{

	QToolTip::remove( TheGoButton );
	QToolTip::add( TheGoButton, Caption );
	
	// TheGoButton -> setWhatsThis(Caption);
	TheGoButton -> setEnabled(lEnable);
	TheGoButton -> repaint();

}



void qtMonitorProfilerDialog::DoProfile()
{

	TabProfiler -> setTabEnabled(ProgressTab, TRUE);
	TabProfiler -> showPage(ProgressTab);
	Console -> setText("");

	Gauger("Init...", 0, 100, 0);

	SetGoButton("Profiling... please wait", FALSE);
	ConsolePrintf("Working hard...");

	TabProfiler -> setTabEnabled(ProgressTab, TRUE);
	TabProfiler -> showPage(ProgressTab);

	if (!cmsxMonitorProfilerDo(&sys)) {
		ConsolePrintf("** ERROR: Unable to profile.");
		return;
	}
	else
	{
	    ConsolePrintf("Profile '%s' DONE!", sys.hdr.OutputProfileFile);
	    Gauger("Init...", 0, 100, 99);
               }
	SetGoButton("Ready to GO!", TRUE);

}



// -------------------------------------------------------------------------- Slots

void qtMonitorProfilerDialog::slotIsAllReady()
{

	ValuesToControls();

	
	if (TargetsSelector -> getFilename() == QString::null)
			SetGoButton("You still have to select the sheets", FALSE);
	else
	
	if (OutputFileEdit -> getFilename() == "")
	
		SetGoButton("You need to specify output profile!", FALSE);
	else
	
		
	SetGoButton("Ready to GO!", TRUE);
}


void qtMonitorProfilerDialog::slotUpdateLabels()
{
	SlidersToValues();
	ValuesToLabels(); 
}



void qtMonitorProfilerDialog::slotChangeStrategy()
{
		
		
		SurroundCombo -> setEnabled(CAMRadio -> isChecked());
		
		LabelSurround -> setEnabled(CAMRadio -> isChecked());
	

		LabelLa       -> setEnabled(CAMRadio -> isChecked());

		LaScroll	  -> setEnabled(CAMRadio -> isChecked());		
	
		LabelYb       -> setEnabled(CAMRadio -> isChecked());

		YbScroll      -> setEnabled(CAMRadio -> isChecked());
			
	    CLUTPointsGroup -> setEnabled(CAMRadio -> isChecked());

		NoHardwareLabel->setEnabled(RadioCoarse->isChecked());

		MeasureMonitorButton->setEnabled(RadioCoarse->isChecked());

		TabProfiler -> setTabEnabled(MonitorMeasureTab, RadioCoarse->isChecked());

		TargetsSelector->setEnabled(RadioAccurate->isChecked());
		// PrelinearizationGroup->setEnabled(RadioAccurate->isChecked());

		ControlsToValues();
			
}




static
QString v(double b)
{	
	static char Buffer[128];
	::sprintf(Buffer, "%g", b);
	return (QString) Buffer;

}

void qtMonitorProfilerDialog::slotChangePrimaries()
{
	int nSel = ComboPrimaries -> currentItem();

	BOOL IsUser = (nSel == NPRIMARIES - 1);

	xRed -> setEnabled(IsUser);
	yRed -> setEnabled(IsUser);
	xGreen -> setEnabled(IsUser);
	yGreen -> setEnabled(IsUser);
	xBlue -> setEnabled(IsUser);
	yBlue -> setEnabled(IsUser);

	if (nSel >= 0 && nSel < NPRIMARIES ) {

		sys.hdr.Primaries.Red.x = PrimTable[nSel].xRed;
		sys.hdr.Primaries.Red.y = PrimTable[nSel].yRed;
		sys.hdr.Primaries.Red.Y = 1;

		sys.hdr.Primaries.Green.x = PrimTable[nSel].xGreen;
		sys.hdr.Primaries.Green.y = PrimTable[nSel].yGreen;
		sys.hdr.Primaries.Green.Y = 1;

		sys.hdr.Primaries.Blue.x = PrimTable[nSel].xBlue;
		sys.hdr.Primaries.Blue.y = PrimTable[nSel].yBlue;
		sys.hdr.Primaries.Blue.Y = 1;


		xRed -> setText(v(sys.hdr.Primaries.Red.x));
		yRed -> setText(v(sys.hdr.Primaries.Red.y));
		xGreen -> setText(v(sys.hdr.Primaries.Green.x ));
		yGreen -> setText(v(sys.hdr.Primaries.Green.y ));
		xBlue-> setText(v(sys.hdr.Primaries.Blue.x));
		yBlue-> setText(v(sys.hdr.Primaries.Blue.y));
	}
	else
	{
		sys.hdr.Primaries.Red.x = xRed->text().toDouble();
		sys.hdr.Primaries.Red.y = yRed->text().toDouble();
		sys.hdr.Primaries.Red.Y = 1;

		sys.hdr.Primaries.Green.x = xGreen->text().toDouble();
		sys.hdr.Primaries.Green.y = yGreen->text().toDouble();
		sys.hdr.Primaries.Green.Y = 1;

		sys.hdr.Primaries.Blue.x = xBlue->text().toDouble();
		sys.hdr.Primaries.Blue.y = yBlue->text().toDouble();
		sys.hdr.Primaries.Blue.Y = 1;

	}


}

void qtMonitorProfilerDialog::slotChangeWhitePoint()
{
	cmsCIExyY wp;

	int nSel = ComboBoxWP-> currentItem();


	if (nSel == NWHITES - 1)
			TempWhitePoint -> show();
	else 
			TempWhitePoint -> hide();
			

	if (nSel >= 0 && nSel < NWHITES) {
			
			wp.x = WhitePoints[nSel].xw;
			wp.y = WhitePoints[nSel].yw;
			wp.Y = 1;

			if (wp.x == 0 && wp.y == 0) {

				int Temp = WhitePoints[nSel].TempK;
				if (Temp == 0)
					Temp = TempWhitePoint -> value();

				cmsWhitePointFromTemp(Temp, &wp);
			}
			
	}
	
	cmsxyY2XYZ(&sys.hdr.WhitePoint, &wp);
}


void qtMonitorProfilerDialog::slotChangeGamma()
{
	if (CheckLinkGamma -> isChecked()) {

			AdjustR -> hide();
			AdjustG -> hide();
			AdjustB -> hide();
			GammaR -> setEnabled(TRUE);
			GammaG -> hide();
			GammaB -> hide();


	}
	else {

			AdjustR -> show();
			AdjustG -> show();
			AdjustB -> show();
			GammaG -> show();
			GammaB -> show();

			GammaR -> setEnabled(AdjustR -> isChecked());
			GammaG -> setEnabled(AdjustG -> isChecked());
			GammaB -> setEnabled(AdjustB -> isChecked());
	}

	slotGammaRadio();
	slotGammaSlider();
}



void qtMonitorProfilerDialog::slotGammaRadio()
{
	double v;

	if (AdjustR -> isChecked())
		v = GammaR -> text().toDouble();
	else 
	if (AdjustG -> isChecked())
		v = GammaG -> text().toDouble();
	else
		v = GammaB -> text().toDouble();

	GammaSlider -> setValue(v * 100);

	RenderGamma();
	ProofGamma();
}


void qtMonitorProfilerDialog::slotGammaSlider()
{
	double val = (double) GammaSlider -> value() / 100.0;


	if (CheckLinkGamma -> isChecked()) {

			GammaR -> setText(v(val));

	}
	else {

		if (AdjustR -> isChecked())
			GammaR -> setText(v(val));
		else
		if (AdjustG -> isChecked())
			GammaG -> setText(v(val));
		else
		if (AdjustB -> isChecked())
			GammaB -> setText(v(val));

	}

	RenderGamma();
	ProofGamma();
}



void qtMonitorProfilerDialog::RenderGamma()
{
	
	if (sys.Prelinearization[0])
		cmsFreeGamma(sys.Prelinearization[0]);

	if (sys.Prelinearization[1])
		cmsFreeGamma(sys.Prelinearization[1]);

	if (sys.Prelinearization[2])
		cmsFreeGamma(sys.Prelinearization[2]);


	if (CheckLinkGamma -> isChecked()) {

			double val = GammaR -> text().toDouble(); 

			sys.Prelinearization[0] = cmsBuildGamma(256, val);
			sys.Prelinearization[1] = cmsBuildGamma(256, val);
			sys.Prelinearization[2] = cmsBuildGamma(256, val);

	}
	else {


		sys.Prelinearization[0] = cmsBuildGamma(256, GammaR -> text().toDouble());
		sys.Prelinearization[1] = cmsBuildGamma(256, GammaG -> text().toDouble());
		sys.Prelinearization[2] = cmsBuildGamma(256, GammaB -> text().toDouble());

	}

}


void qtMonitorProfilerDialog::ProofGamma()
{
	LPGAMMATABLE Gamma;
	DWORD dwMask;

	if (CheckLinkGamma -> isChecked()) {
			Gamma = cmsReverseGamma(256, sys.Prelinearization[0]);	
			dwMask = 0x00FFFFFF;
	}
	else
		if (AdjustR -> isChecked()) {
		    Gamma = cmsReverseGamma(256, sys.Prelinearization[0]);	
			dwMask = 0x00FF0000;
		}
	else
		if (AdjustG -> isChecked()) {
			Gamma = cmsReverseGamma(256, sys.Prelinearization[1]);	
			dwMask = 0x0000FF00;
		}
		else {
			Gamma = cmsReverseGamma(256, sys.Prelinearization[2]);	
			dwMask = 0x000000FF;
		}


	L16PARAMS Lut16;
	cmsCalcL16Params(Gamma -> nEntries, &Lut16);


	int height = Screen.height();
	int width  = Screen.width();

	for (int i=0; i < height; i++) {

			LPBYTE ptrSrc  = GammaBitmap.scanLine(i);
			LPBYTE ptrDest = Screen.scanLine(i);			
			
			for (int j=0; j < width; j++) {

				 BYTE In = *ptrSrc;

				 WORD InVal = (In << 8) | In;				 

				 WORD OutVal = cmsLinearInterpLUT16(InVal , Gamma -> GammaTable, &Lut16);

				 DWORD OutByte = (DWORD) (OutVal >> 8);
				 
				 DWORD Out = OutByte;

				 OutByte <<= 8;
				 Out |= OutByte;
				 OutByte <<= 8;
				 Out |= OutByte;
				 				
				 Out &= dwMask;

				 *((DWORD*) ptrDest) = Out;

				ptrSrc  += sizeof(DWORD);
				ptrDest += sizeof(DWORD);
			}
	
	}

	cmsFreeGamma(Gamma);
	ScreenPixmap.convertFromImage(Screen, QPixmap::ColorOnly | QPixmap::ThresholdDither | QPixmap::AvoidDither);
	GammaProof -> setPixmap(ScreenPixmap);

}

        	


void qtMonitorProfilerDialog::slotSelectValuesTab()
{
	TabProfiler -> showPage(MonitorMeasureTab);
}

void qtMonitorProfilerDialog::slotGO()
{	
	ControlsToValues();
	RenderGamma();
	DoProfile();
}
